/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatingClassloader
extends ClassLoader {
    private final Logger log;
    private final Set<String> hideClassesPatterns = new HashSet<String>();
    private final Set<String> redefineClassesPatterns = new HashSet<String>();
    private final Map<String, ClassLoader> delegates = new LinkedHashMap<String, ClassLoader>();
    private final String id;
    private Map<String, Class<?>> loadedClasses = new HashMap();

    public IsolatingClassloader(String name, ClassLoader parent) {
        this(name, null, parent);
    }

    public IsolatingClassloader(String name, Logger aLog, ClassLoader parent) {
        super(parent);
        this.log = aLog != null ? aLog : LoggerFactory.getLogger(this.getClass());
        this.id = name;
    }

    public IsolatingClassloader hiding(Package ... packages) {
        for (Package pack : packages) {
            this.hideClassesPatterns.add(Pattern.quote(pack.getName()) + "\\..*");
        }
        return this;
    }

    public IsolatingClassloader hiding(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.hideClassesPatterns.add(Pattern.quote(clazz.getName()));
        }
        return this;
    }

    public IsolatingClassloader hiding(String ... patterns) {
        this.hideClassesPatterns.addAll(Arrays.asList(patterns));
        return this;
    }

    public IsolatingClassloader redefining(Package ... packages) {
        for (Package pack : packages) {
            this.redefineClassesPatterns.add(Pattern.quote(pack.getName()) + "\\..*");
        }
        return this;
    }

    public IsolatingClassloader redefining(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.redefineClassesPatterns.add(Pattern.quote(clazz.getName()));
        }
        return this;
    }

    public IsolatingClassloader redefining(String ... patterns) {
        this.redefineClassesPatterns.addAll(Arrays.asList(patterns));
        return this;
    }

    public IsolatingClassloader delegating(String pattern, ClassLoader delegate) {
        this.delegates.put(pattern, delegate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.id);
        sb.append(", loaded=");
        sb.append(this.loadedClasses.size());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Optional<ClassLoader> delegate = this.delegates.entrySet().stream().filter(e -> name.matches((String)e.getKey())).map(Map.Entry::getValue).findFirst();
            if (delegate.isPresent()) {
                return delegate.get().loadClass(name);
            }
            if (this.hideClassesPatterns.stream().anyMatch(name::matches)) {
                this.log.debug("[{}] prevented access to hidden class: {}", (Object)this.id, (Object)name);
                throw new ClassNotFoundException(name);
            }
            if (this.redefineClassesPatterns.stream().anyMatch(name::matches)) {
                Class<?> loadedClass = this.loadedClasses.get(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                this.log.debug("[{}] redefining class: {}", (Object)this.id, (Object)name);
                String internalName = name.replace(".", "/") + ".class";
                InputStream is = this.getParent().getResourceAsStream(internalName);
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    int packageSeparator;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    is.transferTo(buffer);
                    byte[] bytes = buffer.toByteArray();
                    Class<?> cls = this.defineClass(name, bytes, 0, bytes.length);
                    if (cls.getPackage() == null && (packageSeparator = name.lastIndexOf(46)) != -1) {
                        String packageName = name.substring(0, packageSeparator);
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                    this.loadedClasses.put(name, cls);
                    return cls;
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
                }
            }
            return super.loadClass(name, resolve);
        }
    }
}

