/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.apache.uima.json.impl.JsonContentHandlerJacksonWrapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JsonCasSerializer {
    private static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    private static final SerializedString CONTEXT_NAME = new SerializedString("_context");
    private static final SerializedString TYPE_SYSTEM_NAME = new SerializedString("_type_system");
    private static final SerializedString TYPES_NAME = new SerializedString("_types");
    private static final SerializedString ID_NAME = new SerializedString("_id");
    private static final SerializedString SUB_TYPES_NAME = new SerializedString("_subtypes");
    private static final SerializedString FEATURE_TYPES_NAME = new SerializedString("_feature_types");
    private static final SerializedString FEATURE_REFS_NAME = new SerializedString("_ref");
    private static final SerializedString FEATURE_ARRAY_NAME = new SerializedString("_array");
    private static final SerializedString FEATURE_BYTE_ARRAY_NAME = new SerializedString("_byte_array");
    private static final SerializedString REFERENCED_FSS_NAME = new SerializedString("_referenced_fss");
    private static final SerializedString VIEWS_NAME = new SerializedString("_views");
    private static final SerializedString TYPE_NAME = new SerializedString("_type");
    private static final SerializedString COLLECTION_NAME = new SerializedString("_collection");
    private static final SerializedString DELTA_CAS_NAME = new SerializedString("_delta_cas");
    private static final SerializedString ADDED_MEMBERS_NAME = new SerializedString("added_members");
    private static final SerializedString DELETED_MEMBERS_NAME = new SerializedString("deleted_members");
    private static final SerializedString REINDEXED_MEMBERS_NAME = new SerializedString("reindexed_members");
    private final CasSerializerSupport css = new CasSerializerSupport();
    private JsonFactory jsonFactory = null;
    private boolean isDynamicEmbedding = true;
    private boolean isWithContext = true;
    private boolean isWithSubtypes = true;
    private boolean isWithExpandedTypeNames = true;
    private boolean isOmit0Values = false;
    private String typeSystemReference;

    CasSerializerSupport getCss() {
        return this.css;
    }

    public static void jsonSerialize(CAS aCAS, Object output) throws IOException {
        JsonCasSerializer.jsonSerialize(aCAS, null, output, false, null, null);
    }

    public static void jsonSerialize(CAS aCAS, TypeSystem aTargetTypeSystem, Object output) throws IOException {
        JsonCasSerializer.jsonSerialize(aCAS, aTargetTypeSystem, output, false, null, null);
    }

    public static void jsonSerialize(CAS aCAS, TypeSystem aTargetTypeSystem, Object output, boolean aPrettyPrint, Marker aMarker, XmiSerializationSharedData sharedData) throws IOException {
        JsonCasSerializer ser = new JsonCasSerializer();
        ser.setFilterTypes((TypeSystemImpl)aTargetTypeSystem);
        ser.setPrettyPrint(aPrettyPrint);
        ser.serialize(aCAS, output, sharedData, aMarker);
    }

    public void serialize(CAS cas, Object output) throws IOException {
        this.serialize(cas, output, null, null);
    }

    public void serialize(CAS cas, Object output, XmiSerializationSharedData sharedData, Marker marker) throws IOException {
        JsonContentHandlerJacksonWrapper jch;
        try {
            jch = new JsonContentHandlerJacksonWrapper(this.jsonFactory, output, this.css.isFormattedOutput);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        this.serialize(cas, jch, sharedData, marker);
    }

    public void serialize(CAS cas, JsonContentHandlerJacksonWrapper jch) throws IOException {
        this.serialize(cas, jch, null, null);
    }

    public void serialize(CAS cas, JsonContentHandlerJacksonWrapper jch, XmiSerializationSharedData sharedData, Marker marker) throws IOException {
        JsonDocSerializer ser = new JsonDocSerializer(jch, ((CASImpl)cas).getBaseCAS(), sharedData, (MarkerImpl)marker);
        try {
            ((JsonDocSerializer)ser).cds.needNameSpaces = false;
            ser.cds.serialize();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public JsonCasSerializer setPrettyPrint(boolean pp) {
        this.css.setPrettyPrint(pp);
        return this;
    }

    public JsonCasSerializer setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
        return this;
    }

    public JsonCasSerializer setFilterTypes(TypeSystemImpl ts) {
        this.css.setFilterTypes(ts);
        return this;
    }

    public JsonCasSerializer setTypeSystemReference(String reference) {
        this.typeSystemReference = reference;
        return this;
    }

    public JsonCasSerializer setErrorHandler(ErrorHandler eh) {
        this.css.setErrorHandler(eh);
        return this;
    }

    public JsonCasSerializer setStaticEmbedding() {
        this.isDynamicEmbedding = false;
        return this;
    }

    public JsonCasSerializer setJsonContext(JsonContextFormat format) {
        switch (format) {
            case omitContext: {
                this.isWithContext = false;
                this.isWithSubtypes = false;
                this.isWithExpandedTypeNames = false;
                break;
            }
            case omitSubtypes: {
                this.isWithSubtypes = false;
                break;
            }
            case omitExpandedTypeNames: {
                this.isWithExpandedTypeNames = false;
            }
        }
        return this;
    }

    public JsonCasSerializer setOmit0Values(boolean omitDefaultValues) {
        this.isOmit0Values = omitDefaultValues;
        return this;
    }

    class JsonDocSerializer
    extends CasSerializerSupport.CasSerializerSupportSerialize {
        private final CasSerializerSupport.CasDocSerializer cds;
        private final JsonContentHandlerJacksonWrapper jch;
        private final JsonGenerator jg;
        private final String typeSystemReference;
        private final Map<String, SerializedString> serializedStrings = new HashMap<String, SerializedString>();
        private final Map<String, XmlElementName> usedTypeName2XmlElementName;
        private final MapType2Subtypes mapType2Subtypes = new MapType2Subtypes();
        private final IntVector parentTypesWithNoInstances = new IntVector();
        private int lastEncodedTypeCode;
        private boolean startedReferencedFSs;
        private final boolean isOmitDefaultValues;
        private final boolean isWithContext;
        private final boolean isWithExpandedTypeNames;
        private final boolean isWithSubtypes;
        private boolean indexId;
        private boolean isEmbedded = false;
        private boolean isEmbeddedFromFsFeature;
        private boolean startedFeatureTypes;

        private JsonDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker) {
            CasSerializerSupport casSerializerSupport = JsonCasSerializer.this.css;
            casSerializerSupport.getClass();
            this.cds = new CasSerializerSupport.CasDocSerializer(casSerializerSupport, ch, cas, sharedData, marker, (CasSerializerSupport.CasSerializerSupportSerialize)this, JsonCasSerializer.this.isDynamicEmbedding);
            this.isOmitDefaultValues = JsonCasSerializer.this.isOmit0Values;
            this.isWithExpandedTypeNames = JsonCasSerializer.this.isWithExpandedTypeNames;
            this.isWithSubtypes = JsonCasSerializer.this.isWithSubtypes;
            this.typeSystemReference = JsonCasSerializer.this.typeSystemReference;
            this.jch = (JsonContentHandlerJacksonWrapper)ch;
            this.jg = this.jch.getJsonGenerator();
            this.isWithContext = JsonCasSerializer.this.isWithContext || this.isWithSubtypes || this.isWithExpandedTypeNames;
            this.usedTypeName2XmlElementName = new HashMap<String, XmlElementName>(this.cds.tsi.getNumberOfTypes());
        }

        protected void initializeNamespaces() {
            if (this.cds.sharedData != null && (null != this.cds.sharedData.getOutOfTypeSystemElements() || this.cds.sharedData.hasOutOfTypeSystemArrayElements())) {
                throw new UnsupportedOperationException("Can't do JSON serialization if there are out-of-type-system elements, because there's no type information available (needed for _context)");
            }
        }

        protected void writeViews() throws Exception {
            if (!this.cds.isDelta) {
                return;
            }
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName((SerializableString)DELTA_CAS_NAME);
            this.jg.writeStartObject();
            this.cds.writeViewsCommons();
            this.jg.writeEndObject();
        }

        protected void writeFeatureStructures(int elementCount) throws Exception {
            this.jch.withoutNl();
            this.jg.writeStartObject();
            if (this.isWithContext) {
                this.serializeJsonLdContext();
            }
            this.jch.writeNlJustBeforeNext();
            this.indexId = false;
            this.jg.writeFieldName((SerializableString)VIEWS_NAME);
            this.jg.writeStartObject();
            Integer[][] byViewByTypeFSs = this.sortByViewType();
            for (int viewNbr = 1; viewNbr <= byViewByTypeFSs.length; ++viewNbr) {
                this.lastEncodedTypeCode = -1;
                Integer[] fssInView = byViewByTypeFSs[viewNbr - 1];
                int sofaAddr = this.cds.getSofaAddr(viewNbr);
                if (sofaAddr == 0 && fssInView.length == 0) continue;
                this.jch.writeNlJustBeforeNext();
                String viewName = 0 == sofaAddr ? "_InitialView" : this.cds.cas.getStringValue(sofaAddr, this.cds.tsi.sofaIdFeatCode);
                this.jg.writeFieldName(viewName);
                this.jg.writeStartObject();
                for (Integer fs : fssInView) {
                    this.cds.encodeFS(fs.intValue());
                }
                if (this.lastEncodedTypeCode != -1) {
                    this.jg.writeEndArray();
                }
                this.jg.writeEndObject();
            }
            this.jg.writeEndObject();
            this.indexId = true;
            this.startedReferencedFSs = false;
            this.cds.encodeQueued();
            if (this.startedReferencedFSs) {
                this.jg.writeEndObject();
            }
        }

        protected void writeEndOfSerialization() throws IOException {
            this.jg.writeEndObject();
            this.jg.flush();
        }

        private Integer[][] sortByViewType() {
            Integer[][] r = new Integer[this.cds.indexedFSs.length][];
            int i = 0;
            for (IntVector fss : this.cds.indexedFSs) {
                int n = i++;
                Integer[] integerArray = null == fss ? EMPTY_INTEGER_ARRAY : new Integer[fss.size()];
                r[n] = integerArray;
                Integer[] viewFSs = integerArray;
                for (int j = 0; j < viewFSs.length; ++j) {
                    viewFSs[j] = fss.get(j);
                }
                Arrays.sort(viewFSs, this.cds.sortFssByType);
            }
            return r;
        }

        protected void writeView(int sofaAddr, int[] members) throws IOException {
            this.jch.writeNlJustBeforeNext();
            String sofaXmiId = 0 == sofaAddr ? "0" : this.cds.getXmiId(sofaAddr);
            this.jg.writeArrayFieldStart(sofaXmiId);
            this.writeViewMembers(members);
            if (this.cds.sharedData != null) {
                List ootsMembers = this.cds.sharedData.getOutOfTypeSystemViewMembers(sofaXmiId);
                this.jch.writeNlJustBeforeNext();
                this.writeViewMembers(ootsMembers);
            }
            this.jg.writeEndArray();
        }

        private void writeViewForDeltas(SerializedString kind, int[] deltaMembers) throws IOException {
            this.jg.writeFieldName((SerializableString)kind);
            this.jg.writeStartArray();
            this.writeViewMembers(deltaMembers);
            this.jg.writeEndArray();
        }

        protected void writeView(int sofaAddr, int[] added, int[] deleted, int[] reindexed) throws IOException {
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName(this.cds.getXmiId(sofaAddr));
            this.jg.writeStartObject();
            this.writeViewForDeltas(ADDED_MEMBERS_NAME, added);
            this.writeViewForDeltas(DELETED_MEMBERS_NAME, deleted);
            this.writeViewForDeltas(REINDEXED_MEMBERS_NAME, reindexed);
            this.jg.writeEndObject();
        }

        private void writeViewMembers(int[] members) throws IOException {
            int nextBreak = CasSerializerSupport.PP_ELEMENTS;
            int i = 0;
            for (int member : members) {
                int xmiId = this.cds.getXmiIdAsInt(member);
                if (xmiId == 0) continue;
                if (i++ > nextBreak) {
                    this.jch.writeNlJustBeforeNext();
                    nextBreak += CasSerializerSupport.PP_ELEMENTS;
                }
                this.jg.writeNumber(xmiId);
            }
        }

        private void writeViewMembers(List<String> members) throws IOException {
            int nextBreak = CasSerializerSupport.PP_ELEMENTS;
            int i = 0;
            for (String xmiId : members) {
                if (null == xmiId || xmiId.length() == 0) continue;
                if (i++ > nextBreak) {
                    this.jch.writeNlJustBeforeNext();
                    nextBreak += CasSerializerSupport.PP_ELEMENTS;
                }
                this.jg.writeNumber(Integer.parseInt(xmiId));
            }
        }

        private void serializeJsonLdContext() throws IOException {
            this.jg.writeFieldName((SerializableString)CONTEXT_NAME);
            this.jg.writeStartObject();
            if (this.typeSystemReference != null) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)TYPE_SYSTEM_NAME);
                this.jg.writeString(this.typeSystemReference);
            }
            this.collectUsedSubtypes();
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName((SerializableString)TYPES_NAME);
            this.jg.writeStartObject();
            for (TypeImpl ti : this.cds.getSortedUsedTypes()) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(ti.getCode()));
                this.jg.writeStartObject();
                if (this.isWithExpandedTypeNames) {
                    this.jg.writeFieldName((SerializableString)ID_NAME);
                    this.jg.writeString(ti.getName());
                }
                this.addJsonFeatContext(ti);
                if (this.isWithSubtypes) {
                    this.addJsonSubtypes(ti);
                }
                this.jg.writeEndObject();
            }
            for (int typeCode : this.parentTypesWithNoInstances.toArray()) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(typeCode));
                this.jg.writeStartObject();
                XmlElementName xe = this.cds.typeCode2namespaceNames[typeCode];
                if (this.isWithExpandedTypeNames) {
                    this.jg.writeFieldName((SerializableString)ID_NAME);
                    this.jg.writeString(xe.nsUri);
                }
                this.addJsonFeatContext(typeCode);
                if (this.isWithSubtypes) {
                    this.addJsonSubtypes(typeCode);
                }
                this.jg.writeEndObject();
            }
            this.jg.writeEndObject();
            this.jg.writeEndObject();
        }

        private void addJsonFeatContext(TypeImpl type) throws IOException {
            this.addJsonFeatContext(type.getCode());
        }

        private void addJsonFeatContext(int typeCode) throws IOException {
            int[] feats = this.cds.tsi.ll_getAppropriateFeatures(typeCode);
            this.startedFeatureTypes = false;
            for (int featCode : feats) {
                int fsClass = this.cds.classifyType(this.cds.tsi.range(featCode));
                SerializedString featKind = this.featureTypeLabel(fsClass, featCode);
                if (null == featKind) continue;
                this.maybeDoStartFeatureTypes();
                this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                this.jg.writeString((SerializableString)featKind);
            }
            if (this.startedFeatureTypes) {
                this.jg.writeEndObject();
            }
        }

        private void maybeDoStartFeatureTypes() throws IOException {
            if (!this.startedFeatureTypes) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)FEATURE_TYPES_NAME);
                this.jg.writeStartObject();
                this.startedFeatureTypes = true;
            }
        }

        private SerializedString getShortFeatureName(int featCode) {
            return this.getSerializedString(this.cds.tsi.ll_getFeatureForCode(featCode).getShortName());
        }

        private void addJsonSubtypes(TypeImpl ti) throws IOException {
            this.addJsonSubtypes(ti.getCode());
        }

        private void addJsonSubtypes(int aTypeCode) throws IOException {
            IntVector iv = (IntVector)this.mapType2Subtypes.get(aTypeCode);
            if (null != iv && iv.size() > 0) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)SUB_TYPES_NAME);
                this.jg.writeStartArray();
                for (int typeCode : iv.toArray()) {
                    this.jg.writeString((SerializableString)this.getSerializedTypeName(typeCode));
                }
                this.jg.writeEndArray();
            }
        }

        private void collectUsedSubtypes() {
            Object[] tiArray;
            block0: for (TypeImpl typeImpl : tiArray = this.cds.getSortedUsedTypes()) {
                int subtypeCode = typeImpl.getCode();
                for (TypeImpl parent = (TypeImpl)typeImpl.getSuperType(); parent != null; parent = (TypeImpl)parent.getSuperType()) {
                    boolean wasAdded;
                    int parentCode = parent.getCode();
                    if (Arrays.binarySearch(tiArray, parent) < 0 && !this.parentTypesWithNoInstances.contains(parentCode)) {
                        this.parentTypesWithNoInstances.add(parentCode);
                    }
                    if (!(wasAdded = this.mapType2Subtypes.addSubtype(parentCode, subtypeCode))) continue block0;
                    subtypeCode = parentCode;
                }
            }
        }

        private SerializedString getSerializedTypeName(int typeCode) {
            XmlElementName xe = this.cds.typeCode2namespaceNames[typeCode];
            if (null == xe) {
                String typeName = this.cds.tsi.ll_getTypeForCode(typeCode).getName();
                this.cds.typeCode2namespaceNames[typeCode] = xe = this.uimaTypeName2XmiElementName(typeName);
            }
            return this.getSerializedString(xe.qName);
        }

        private SerializedString getSerializedString(String s) {
            SerializedString ss = this.serializedStrings.get(s);
            if (ss == null) {
                ss = new SerializedString(s);
                this.serializedStrings.put(s, ss);
            }
            return ss;
        }

        protected void checkForNameCollision(XmlElementName xmlElementName) {
            XmlElementName xel = this.usedTypeName2XmlElementName.get(xmlElementName.localName);
            if (xel != null) {
                if (xel.nsUri.equals(xmlElementName.nsUri)) {
                    return;
                }
                this.addNameSpace(xel);
                this.addNameSpace(xmlElementName);
                return;
            }
            this.usedTypeName2XmlElementName.put(xmlElementName.localName, xmlElementName);
        }

        protected boolean writeFsStart(int addr, int typeCode) throws IOException {
            if (this.isEmbedded) {
                if (!this.isEmbeddedFromFsFeature) {
                    this.jch.writeNlJustBeforeNext();
                }
                this.jg.writeStartObject();
            } else if (this.indexId) {
                if (!this.startedReferencedFSs) {
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeFieldName((SerializableString)REFERENCED_FSS_NAME);
                    this.jg.writeStartObject();
                    this.startedReferencedFSs = true;
                }
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName(this.cds.getXmiId(addr));
                this.jg.writeStartObject();
            } else {
                if (typeCode != this.lastEncodedTypeCode) {
                    if (this.lastEncodedTypeCode != -1) {
                        this.jg.writeEndArray();
                    }
                    this.lastEncodedTypeCode = typeCode;
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(typeCode));
                    this.jg.writeStartArray();
                }
                if (this.cds.multiRefFSs == null || !this.cds.multiRefFSs.contains(addr)) {
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeStartObject();
                }
            }
            return this.indexId;
        }

        protected void writeFsRef(int addr) throws Exception {
            this.jg.writeNumber(this.cds.getXmiIdAsInt(addr));
        }

        private void maybeWriteTypeFeat(int typeCode) throws IOException {
            if (this.indexId || this.isEmbedded) {
                this.jg.writeFieldName((SerializableString)TYPE_NAME);
                this.jg.writeString((SerializableString)this.getSerializedTypeName(typeCode));
            }
        }

        protected void writeFs(int addr, int typeCode) throws IOException {
            this.writeFsOrLists(addr, typeCode, false);
        }

        protected void writeListsAsIndividualFSs(int addr, int typeCode) throws IOException {
            this.writeFsOrLists(addr, typeCode, true);
        }

        private void writeFsOrLists(int addr, int typeCode, boolean isListAsFSs) throws IOException {
            int[] feats = this.cds.tsi.ll_getAppropriateFeatures(typeCode);
            this.maybeWriteTypeFeat(typeCode);
            block9: for (int featCode : feats) {
                String fullFeatName;
                if (this.cds.isFiltering && this.cds.filterTypeSystem.getFeatureByFullName(fullFeatName = this.cds.tsi.ll_getFeatureForCode(featCode).getName()) == null) continue;
                int featAddr = addr + this.cds.cas.getFeatureOffset(featCode);
                int featValRaw = this.cds.cas.getHeapValue(featAddr);
                int featureClass = this.cds.classifyType(this.cds.tsi.range(featCode));
                switch (featureClass) {
                    case 1: 
                    case 10: 
                    case 11: {
                        if (featValRaw == 0 && this.isOmitDefaultValues) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeNumber(featValRaw);
                        continue block9;
                    }
                    case 8: {
                        if (featValRaw == 0) continue block9;
                        this.writeFsOrRef(featValRaw, featCode);
                        continue block9;
                    }
                    case 12: {
                        long longVal = this.cds.cas.ll_getLongValue(featValRaw);
                        if (longVal == 0L && this.isOmitDefaultValues) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeNumber(longVal);
                        continue block9;
                    }
                    case 2: {
                        float floatVal = CASImpl.int2float((int)featValRaw);
                        if (floatVal == 0.0f && this.isOmitDefaultValues) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeNumber(floatVal);
                        continue block9;
                    }
                    case 13: {
                        double doubleVal = this.cds.cas.ll_getDoubleValue(addr, featCode);
                        if (doubleVal == 0.0 && this.isOmitDefaultValues) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeNumber(doubleVal);
                        continue block9;
                    }
                    case 9: {
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeBoolean(this.cds.cas.ll_getBooleanValue(addr, featCode));
                        continue block9;
                    }
                    case 3: {
                        if (featValRaw == 0) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        this.jg.writeString(this.cds.cas.getStringForCode(featValRaw));
                        continue block9;
                    }
                    default: {
                        if (featValRaw == 0) continue block9;
                        this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                        if (featureClass == 4 || featureClass == 5 || featureClass == 14 || featureClass == 15 || featureClass == 16 || featureClass == 17 || featureClass == 18 || featureClass == 6 || featureClass == 7) {
                            if (this.isDynamicOrStaticMultiRef(featCode, featValRaw)) {
                                this.jg.writeNumber(this.cds.getXmiIdAsInt(featValRaw));
                                continue block9;
                            }
                            this.writeJsonArrayValues(featValRaw, featureClass);
                            continue block9;
                        }
                        if (featureClass == 101 || featureClass == 102 || featureClass == 103 || featureClass == 104) {
                            if (this.isDynamicOrStaticMultiRef(featCode, featValRaw, isListAsFSs)) {
                                this.jg.writeNumber(this.cds.getXmiIdAsInt(featValRaw));
                                continue block9;
                            }
                            this.writeJsonListValues(featValRaw);
                            continue block9;
                        }
                        throw new RuntimeException("Invalid State, featureClass was " + featureClass);
                    }
                }
            }
        }

        private void writeFsOrRef(int addr) throws IOException {
            if (addr == 0 || null == this.cds.multiRefFSs || this.cds.multiRefFSs.contains(addr)) {
                this.jg.writeNumber(this.cds.getXmiIdAsInt(addr));
            } else {
                this.isEmbeddedFromFsFeature = false;
                this.writeEmbeddedFs(addr);
            }
        }

        private void writeEmbeddedFs(int addr) throws IOException {
            boolean savedEmbedded = this.isEmbedded;
            try {
                this.isEmbedded = true;
                this.cds.encodeFS(addr);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.isEmbedded = savedEmbedded;
            }
        }

        private void writeFsOrRef(int addr, int featCode) throws IOException {
            if (addr == 0 || null == this.cds.multiRefFSs || this.cds.multiRefFSs.contains(addr)) {
                this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                this.jg.writeNumber(this.cds.getXmiIdAsInt(addr));
            } else {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getShortFeatureName(featCode));
                this.isEmbeddedFromFsFeature = true;
                this.writeEmbeddedFs(addr);
                this.isEmbeddedFromFsFeature = false;
            }
        }

        protected void writeArrays(int addr, int typeCode, int typeClass) throws IOException {
            this.maybeWriteTypeFeat(typeCode);
            this.jg.writeFieldName((SerializableString)COLLECTION_NAME);
            this.writeJsonArrayValues(addr, typeClass);
        }

        protected void writeEndOfIndividualFs() throws IOException {
            this.jg.writeEndObject();
        }

        private void writeJsonArrayValues(int addr, int arrayType) throws IOException {
            if (addr == 0) {
                this.jg.writeNull();
                return;
            }
            this.cds.visited_not_yet_written.remove(addr);
            int array_size = this.cds.cas.ll_getArraySize(addr);
            if (arrayType == 15) {
                ByteArrayFSImpl byteArrayFS = new ByteArrayFSImpl(addr, this.cds.cas);
                int length = byteArrayFS.size();
                byte[] byteArray = new byte[length];
                byteArrayFS.copyToArray(0, byteArray, 0, length);
                this.jg.writeBinary(byteArray);
            } else {
                this.jg.writeStartArray();
                int pos = this.cds.cas.getArrayStartAddress(addr);
                if (arrayType == 7) {
                    List ootsArrayElementsList = this.cds.sharedData == null ? null : this.cds.sharedData.getOutOfTypeSystemArrayElements(addr);
                    int ootsIndex = 0;
                    for (int j = 0; j < array_size; ++j) {
                        String typeName;
                        int heapValue;
                        if ((heapValue = this.cds.cas.getHeapValue(pos++)) == 0) {
                            boolean found = false;
                            if (ootsArrayElementsList != null) {
                                while (ootsIndex < ootsArrayElementsList.size()) {
                                    XmiSerializationSharedData.XmiArrayElement arel = (XmiSerializationSharedData.XmiArrayElement)ootsArrayElementsList.get(ootsIndex++);
                                    if (arel.index != j) continue;
                                    this.jg.writeNumber(Integer.parseInt(arel.xmiId));
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            this.jg.writeNumber(0);
                            continue;
                        }
                        if (this.cds.isFiltering && this.cds.filterTypeSystem.getType(typeName = this.cds.tsi.ll_getTypeForCode(this.cds.cas.getHeapValue(addr)).getName()) == null) {
                            heapValue = 0;
                        }
                        this.writeFsOrRef(heapValue);
                    }
                } else {
                    for (int i = 0; i < array_size; ++i) {
                        if (arrayType == 14) {
                            this.jg.writeBoolean(this.cds.cas.ll_getBooleanArrayValue(addr, i));
                            continue;
                        }
                        if (arrayType == 6) {
                            this.jg.writeString(this.cds.cas.ll_getStringArrayValue(addr, i));
                            continue;
                        }
                        if (arrayType == 16) {
                            this.jg.writeNumber(this.cds.cas.ll_getShortArrayValue(addr, i));
                            continue;
                        }
                        if (arrayType == 4) {
                            this.jg.writeNumber(this.cds.cas.ll_getIntArrayValue(addr, i));
                            continue;
                        }
                        if (arrayType == 17) {
                            this.jg.writeNumber(this.cds.cas.ll_getLongArrayValue(addr, i));
                            continue;
                        }
                        if (arrayType == 5) {
                            this.jg.writeNumber(this.cds.cas.ll_getFloatArrayValue(addr, i));
                            continue;
                        }
                        this.jg.writeNumber(this.cds.cas.ll_getDoubleArrayValue(addr, i));
                    }
                }
                this.jg.writeEndArray();
            }
        }

        private void writeJsonListValues(int curNode) throws IOException {
            if (curNode == 0) {
                throw new RuntimeException("never happen");
            }
            ListUtils listUtils = this.cds.listUtils;
            int startNodeType = this.cds.cas.getHeapValue(curNode);
            int headFeat = listUtils.getHeadFeatCode(startNodeType);
            int tailFeat = listUtils.getTailFeatCode(startNodeType);
            int neListType = listUtils.getNeListType(startNodeType);
            PositiveIntSet_impl visited = new PositiveIntSet_impl();
            this.jg.writeStartArray();
            while (curNode != 0) {
                this.cds.visited_not_yet_written.remove(curNode);
                int curNodeType = this.cds.cas.getHeapValue(curNode);
                if (curNodeType != neListType || !visited.add(curNode)) break;
                int val = this.cds.cas.getHeapValue(curNode + this.cds.cas.getFeatureOffset(headFeat));
                if (curNodeType == listUtils.neStringListType) {
                    this.jg.writeString(this.cds.cas.getStringForCode(val));
                } else if (curNodeType == listUtils.neFloatListType) {
                    this.jg.writeNumber(CASImpl.int2float((int)val));
                } else if (curNodeType == listUtils.neFsListType) {
                    this.writeFsOrRef(val);
                } else {
                    this.jg.writeNumber(val);
                }
                curNode = this.cds.cas.getHeapValue(curNode + this.cds.cas.getFeatureOffset(tailFeat));
            }
            this.jg.writeEndArray();
        }

        private SerializedString featureTypeLabel(int fsClass, int featCode) {
            switch (fsClass) {
                case 7: 
                case 8: 
                case 104: {
                    return FEATURE_REFS_NAME;
                }
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 101: 
                case 102: 
                case 103: {
                    return FEATURE_ARRAY_NAME;
                }
                case 15: {
                    return FEATURE_BYTE_ARRAY_NAME;
                }
            }
            return null;
        }

        protected XmlElementName uimaTypeName2XmiElementName(String uimaTypeName) {
            int lastDotIndex = uimaTypeName.lastIndexOf(46);
            String shortName = lastDotIndex == -1 ? uimaTypeName : uimaTypeName.substring(lastDotIndex + 1);
            shortName = this.cds.getUniqueString(shortName);
            return new XmlElementName(uimaTypeName, shortName, shortName);
        }

        protected void addNameSpace(XmlElementName xmlElementName) {
            if (xmlElementName.qName.equals(xmlElementName.localName)) {
                String uimaTypeName = xmlElementName.nsUri;
                String shortName = xmlElementName.localName;
                int lastDotIndex = uimaTypeName.lastIndexOf(46);
                String prefix = this.cds.getNameSpacePrefix(uimaTypeName, uimaTypeName, lastDotIndex);
                xmlElementName.qName = this.cds.getUniqueString(prefix + ':' + shortName);
            }
        }

        private boolean isDynamicOrStaticMultiRef(int featCode, int addr) {
            return this.cds.multiRefFSs == null ? this.cds.isStaticMultiRef(featCode) : this.cds.multiRefFSs.contains(addr);
        }

        private boolean isDynamicOrStaticMultiRef(int featCode, int addr, boolean isListAsFSs) {
            return this.cds.multiRefFSs == null ? isListAsFSs || this.cds.isStaticMultiRef(featCode) : this.cds.multiRefFSs.contains(addr);
        }
    }

    private static class MapType2Subtypes
    extends RedBlackTree<IntVector> {
        private MapType2Subtypes() {
        }

        boolean addSubtype(int type, int subtype) {
            IntVector iv = (IntVector)this.get(type);
            if (null == iv) {
                iv = new IntVector();
                iv.add(subtype);
                this.put(type, iv);
                return true;
            }
            if (iv.contains(subtype)) {
                return false;
            }
            iv.add(subtype);
            return true;
        }
    }

    public static enum JsonContextFormat {
        omitContext,
        omitSubtypes,
        omitExpandedTypeNames;

    }
}

