/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.examples.PrintAnnotations;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;

public class ExampleApplication {
    public static void main(String[] args) {
        try {
            File taeDescriptor = null;
            File inputDir = null;
            boolean validArgs = false;
            if (args.length == 2) {
                taeDescriptor = new File(args[0]);
                inputDir = new File(args[1]);
                boolean bl = validArgs = taeDescriptor.exists() && !taeDescriptor.isDirectory() && inputDir.isDirectory();
            }
            if (!validArgs) {
                ExampleApplication.printUsageMessage();
            } else {
                XMLInputSource in = new XMLInputSource(taeDescriptor);
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
                CAS cas = ae.newCAS();
                File[] files = inputDir.listFiles();
                if (files == null) {
                    System.out.println("No files to process");
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) continue;
                        ExampleApplication.processFile(files[i], ae, cas);
                    }
                }
                ae.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsageMessage() {
        System.err.println("Usage: java org.apache.uima.example.ExampleApplication <Analysis Engine descriptor or PEAR file name> <input dir>");
    }

    private static void processFile(File aFile, AnalysisEngine aAE, CAS aCAS) throws IOException, AnalysisEngineProcessException {
        System.out.println("Processing file " + aFile.getName());
        String document = FileUtils.file2String((File)aFile);
        document = document.trim();
        aCAS.setDocumentText(document);
        aAE.process(aCAS);
        PrintAnnotations.printAnnotations(aCAS, System.out);
        aCAS.reset();
    }
}

