/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource;

import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource_ImplBase
implements Resource {
    private ResourceMetaData mMetaData;
    private UimaContextAdmin mUimaContextAdmin;
    private boolean mInitialized = false;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        String name = this.getMetaData() != null ? this.getMetaData().getName() : this.getClass().getName();
        if (this.mInitialized) {
            throw new UIMA_IllegalStateException("resource_already_initialized", new Object[]{name});
        }
        if (aAdditionalParams != null) {
            this.mUimaContextAdmin = (UimaContextAdmin)aAdditionalParams.get("UIMA_CONTEXT");
        }
        if (this.mUimaContextAdmin == null) {
            ResourceManager resMgr = null;
            if (aAdditionalParams != null) {
                resMgr = (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
            }
            if (resMgr == null) {
                resMgr = UIMAFramework.newDefaultResourceManager();
            }
            Logger logger = UIMAFramework.getLogger(this.getClass());
            logger.setResourceManager(resMgr);
            ConfigurationManager configMgr = null;
            if (aAdditionalParams != null) {
                configMgr = (ConfigurationManager)aAdditionalParams.get("CONFIG_MANAGER");
            }
            if (configMgr == null) {
                configMgr = UIMAFramework.newConfigurationManager();
            }
            this.mUimaContextAdmin = UIMAFramework.newUimaContext(logger, resMgr, configMgr);
        } else {
            Logger logger = UIMAFramework.getLogger(this.getClass());
            logger.setResourceManager(this.mUimaContextAdmin.getResourceManager());
            this.mUimaContextAdmin.setLogger(logger);
        }
        if (aSpecifier instanceof ResourceCreationSpecifier) {
            ExternalResourceDependency[] resourceDependencies;
            ResourceMetaData metadata = ((ResourceCreationSpecifier)aSpecifier).getMetaData();
            name = metadata.getName();
            try {
                metadata.resolveImports(this.getResourceManager());
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            this.setMetaData(metadata);
            try {
                this.mUimaContextAdmin.getConfigurationManager().createContext(this.mUimaContextAdmin.getQualifiedContextName(), this.getMetaData());
                this.mUimaContextAdmin.getConfigurationManager().setSession(this.mUimaContextAdmin.getSession());
            }
            catch (ResourceConfigurationException e) {
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{name, metadata.getSourceUrlString()}, e);
            }
            ResourceManagerConfiguration resMgrCfg = ((ResourceCreationSpecifier)aSpecifier).getResourceManagerConfiguration();
            if (resMgrCfg != null) {
                try {
                    resMgrCfg.resolveImports(this.getResourceManager());
                }
                catch (InvalidXMLException e) {
                    throw new ResourceInitializationException(e);
                }
                this.mUimaContextAdmin.getResourceManager().initializeExternalResources(resMgrCfg, this.mUimaContextAdmin.getQualifiedContextName(), aAdditionalParams);
            }
            if ((resourceDependencies = ((ResourceCreationSpecifier)aSpecifier).getExternalResourceDependencies()) != null) {
                this.mUimaContextAdmin.getResourceManager().resolveAndValidateResourceDependencies(resourceDependencies, this.mUimaContextAdmin.getQualifiedContextName());
            }
        }
        this.mInitialized = true;
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    protected void setMetaData(ResourceMetaData aMetaData) {
        this.mMetaData = aMetaData;
    }

    @Override
    public Logger getLogger() {
        return this.getUimaContext() == null ? null : this.getUimaContext().getLogger();
    }

    @Override
    public void setLogger(Logger aLogger) {
        if (this.getUimaContext() != null) {
            this.getUimaContextAdmin().setLogger(aLogger);
        }
    }

    @Override
    public ResourceManager getResourceManager() {
        if (this.getUimaContextAdmin() != null) {
            return this.getUimaContextAdmin().getResourceManager();
        }
        return null;
    }

    @Override
    public UimaContext getUimaContext() {
        return this.mUimaContextAdmin;
    }

    @Override
    public UimaContextAdmin getUimaContextAdmin() {
        return this.mUimaContextAdmin;
    }

    public CasManager getCasManager() {
        return this.getResourceManager().getCasManager();
    }
}

