/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.cpm.BaseCPMImpl;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.ProcessControllerAdapter;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.Progress;

public class CollectionProcessingEngine_impl
implements CollectionProcessingEngine {
    private BaseCPMImpl mCPM = null;

    public void initialize(CpeDescription aCpeDescription, Map aAdditionalParams) throws ResourceInitializationException {
        if (this.mCPM != null) {
            throw new UIMA_IllegalStateException("resource_already_initialized", new Object[]{this.getClass().getName()});
        }
        ResourceManager resMgr = aAdditionalParams == null ? null : (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
        Properties perfSettings = aAdditionalParams == null ? null : (Properties)aAdditionalParams.get("PERFORMANCE_TUNING_SETTINGS");
        ProcessControllerAdapter pca = aAdditionalParams == null ? null : (ProcessControllerAdapter)aAdditionalParams.get("ProcessControllerAdapter");
        try {
            this.mCPM = new BaseCPMImpl(aCpeDescription, resMgr, false, perfSettings);
            if (perfSettings != null) {
                this.mCPM.setPerformanceTuningSettings(perfSettings);
            }
            if (pca != null) {
                this.mCPM.setProcessControllerAdapter(pca);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    public void addStatusCallbackListener(StatusCallbackListener aListener) {
        this.mCPM.addStatusCallbackListener(aListener);
    }

    public void removeStatusCallbackListener(StatusCallbackListener aListener) {
        this.mCPM.removeStatusCallbackListener(aListener);
    }

    public void process() throws ResourceInitializationException {
        this.mCPM.process();
    }

    public boolean isProcessing() {
        return this.mCPM.isProcessing();
    }

    public void pause() {
        this.mCPM.pause();
    }

    public boolean isPaused() {
        return this.mCPM.isPaused();
    }

    public void resume() {
        this.mCPM.resume();
    }

    public void stop() {
        this.mCPM.stop();
    }

    public void kill() {
        this.mCPM.kill();
    }

    public void asynchStop() {
        this.mCPM.asynchStop();
    }

    public ProcessTrace getPerformanceReport() {
        return this.mCPM.getPerformanceReport();
    }

    public Progress[] getProgress() {
        return this.mCPM.getProgress();
    }

    protected BaseCPMImpl getCPM() {
        return this.mCPM;
    }

    public CasProcessor[] getCasProcessors() {
        return this.mCPM.getCasProcessors();
    }

    public BaseCollectionReader getCollectionReader() {
        return this.mCPM.getCollectionReader();
    }
}

