/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.vinci;

import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;
import org.apache.uima.cas_data.impl.CasDataToXCas;
import org.apache.uima.cas_data.impl.FeatureStructureImpl;
import org.apache.uima.collection.impl.cpm.utils.ConfigurableFeature;
import org.apache.uima.collection.impl.cpm.utils.FeatureMap;
import org.apache.uima.collection.impl.cpm.utils.Filter;
import org.apache.uima.collection.impl.cpm.vinci.cas_data.VinciPrimitiveValue;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLSerializer;

public class DATACasUtils {
    public static String getXCASasString(CasData aCasData, String[] keysToFilter) throws Exception {
        CasDataToXCas generator = new CasDataToXCas();
        generator.setTypesToFilter(keysToFilter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLSerializer sax2xml = new XMLSerializer(baos);
        generator.setContentHandler(sax2xml.getContentHandler());
        generator.generateXCas(aCasData);
        return new String(baos.toByteArray());
    }

    public static void addFeatureStructure(CasData dataCas, String featureType, String featureName, String featureValue) {
        FeatureStructureImpl vfs = new FeatureStructureImpl();
        vfs.setType(featureType);
        VinciPrimitiveValue pv = new VinciPrimitiveValue(featureValue);
        vfs.setFeatureValue(featureName, pv);
        dataCas.addFeatureStructure(vfs);
    }

    public static boolean isCasEmpty(CasData aDataCas) {
        Iterator<FeatureStructure> it = aDataCas.getFeatureStructures();
        return !it.hasNext();
    }

    public static void addFeature(CasData dataCas, String featureType, String featureName, String featureValue) {
        Iterator<FeatureStructure> it = dataCas.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs = it.next();
            if (!fs.getType().equals(featureType)) continue;
            VinciPrimitiveValue pv = new VinciPrimitiveValue(featureValue);
            fs.setFeatureValue(featureName, pv);
        }
    }

    public static long getByteCount(CasData aDataCas) throws Exception {
        long byteCount = 0L;
        Iterator<FeatureStructure> it = aDataCas.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs = it.next();
            FeatureValue value = null;
            String[] keys = fs.getFeatureNames();
            for (int i = 0; i < keys.length; ++i) {
                value = fs.getFeatureValue(keys[i]);
                if (value == null) continue;
                byteCount += (long)value.toString().length();
            }
        }
        return byteCount;
    }

    public static boolean shouldAnalyzeCAS(CasData aCAS, LinkedList aFilterList) {
        for (int i = 0; aFilterList != null && i < aFilterList.size(); ++i) {
            Filter.Expression filterExpression = (Filter.Expression)aFilterList.get(i);
            String featureValue = DATACasUtils.getFeatureValueByType(aCAS, filterExpression.getLeftPart().get());
            if (!(filterExpression.getRightPart() == null ? filterExpression.getOperand() == null && featureValue == null || featureValue.trim().length() == 0 || "!".equals(filterExpression.getOperand().getOperand()) && featureValue != null : ("=".equals(filterExpression.getOperand().getOperand()) ? !filterExpression.getRightPart().get().equals(featureValue) : "!=".equals(filterExpression.getOperand().getOperand()) && filterExpression.getRightPart().get().equals(featureValue)))) continue;
            return false;
        }
        return true;
    }

    public static boolean dropIt(String aKey, String[] dropKeyList) {
        for (int i = 0; aKey != null && dropKeyList != null && i < dropKeyList.length && dropKeyList[i] != null; ++i) {
            if (!dropKeyList[i].equals(aKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidType(String aKey, String[] typeList) {
        if (aKey.indexOf("-") > -1) {
            aKey = StringUtils.replaceAll(aKey, "-", "_dash_");
        }
        if (aKey.indexOf(":") > -1) {
            aKey = StringUtils.replaceAll(aKey, ":", "_colon_");
        }
        for (int i = 0; aKey != null && typeList != null && i < typeList.length && typeList[i] != null; ++i) {
            if (!typeList[i].equals(aKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeature(CasData aCAS, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureValue fValue;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || (fValue = (fs = object).getFeatureValue(featureName)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeatureStructure(CasData aCAS, String aName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs;
            String type;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !(type = StringUtils.replaceAll((fs = object).getType(), "_colon_", ":")).equals(aName)) continue;
            return true;
        }
        return false;
    }

    public static void dumpFeatures(CasData aCAS) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure)) continue;
            FeatureStructure fs = object;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(DATACasUtils.class).logrb(Level.FINEST, DATACasUtils.class.getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cas_fs_type__FINEST", new Object[]{Thread.currentThread().getName(), fs.getType()});
            }
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                FeatureValue fValue = fs.getFeatureValue(names[i]);
                if (fValue == null || !UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(DATACasUtils.class).logrb(Level.FINEST, DATACasUtils.class.getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cas_fs_value__FINEST", new Object[]{Thread.currentThread().getName(), names[i], fValue.toString()});
            }
        }
    }

    public static String getFeatureValueByType(CasData aCAS, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure)) continue;
            FeatureStructure fs = object;
            if (System.getProperty("SHOWFEATURES") != null) {
                UIMAFramework.getLogger(DATACasUtils.class).logrb(Level.FINEST, DATACasUtils.class.getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_search_cas_by_value__FINEST", new Object[]{Thread.currentThread().getName(), featureName, fs.getType()});
            }
            if (!featureName.equals(fs.getType())) continue;
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                if (System.getProperty("SHOWFEATURES") == null) continue;
                UIMAFramework.getLogger(DATACasUtils.class).logrb(Level.FINEST, DATACasUtils.class.getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_type_value__FINEST", new Object[]{Thread.currentThread().getName(), names[i], fs.getType()});
            }
            if ("uima.cpm.DocumentText".equals(featureName) || "UTF8:UTF8Content".equals(featureName)) {
                FeatureValue fValue = fs.getFeatureValue("value");
                if (fValue == null) {
                    return null;
                }
                return fValue.toString();
            }
            if ("Detag:DetagContent".equals(featureName)) {
                FeatureValue fValue = fs.getFeatureValue("Doc:SpannedText");
                if (fValue == null) {
                    return null;
                }
                return fValue.toString();
            }
            FeatureValue fValue = fs.getFeatureValue(featureName);
            if (fValue == null) continue;
            featureValue = fValue.toString();
            break;
        }
        return featureValue;
    }

    public static String[] getFeatureStructureValues(CasData aCAS, String featureStructureName, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        Vector<String> v = new Vector<String>();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !featureStructureName.equals((fs = object).getType())) continue;
            String[] names = fs.getFeatureNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                FeatureValue fValue;
                if (!names[i].equals(featureName) || (fValue = fs.getFeatureValue(featureName)) == null) continue;
                featureValue = fValue.toString();
                v.add(featureValue);
            }
        }
        Object[] features = new String[v.size()];
        v.copyInto(features);
        return features;
    }

    public static String getFeatureValueByType(CasData aCAS, String aFeatureStructure, String featureName) {
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        while (it.hasNext()) {
            FeatureValue fValue;
            FeatureStructureImpl fs;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructureImpl) || !(fs = (FeatureStructureImpl)object).getType().equals(aFeatureStructure) || (fValue = fs.getFeatureValue(featureName)) == null) continue;
            featureValue = fValue.toString();
            break;
        }
        return featureValue;
    }

    public static void remapFeatureTypes(CasData aDataCas, FeatureMap aFeatureMap) {
        ConfigurableFeature cf = null;
        Iterator<FeatureStructure> it = aDataCas.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs;
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || (cf = aFeatureMap.get((fs = object).getType())) == null) continue;
            fs.setType(cf.getNewFeatureName());
            if (cf.attributeListSize() <= 0) continue;
            String[] featureNameList = fs.getFeatureNames();
            for (int i = 0; featureNameList != null && i < featureNameList.length; ++i) {
                if (cf.getOldAttributeValue(featureNameList[i]) == null) continue;
                FeatureValue fv = fs.getFeatureValue(featureNameList[i]);
                fs.setFeatureValue(cf.getNewAttributeValue(featureNameList[i]), fv);
            }
        }
    }

    public static NameValuePair[] getCasDataFeatures(CasData aCasData, String aFeatureStructureName) {
        NameValuePair[] valuePairSet = null;
        Iterator<FeatureStructure> it = aCasData.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure object = it.next();
            if (!(object instanceof FeatureStructure) || !object.getType().equals(aFeatureStructureName)) continue;
            FeatureStructure fs = object;
            String[] featureNames = fs.getFeatureNames();
            if (featureNames == null) {
                return new NameValuePair[0];
            }
            valuePairSet = new NameValuePair[featureNames.length];
            for (int i = 0; i < featureNames.length; ++i) {
                valuePairSet[i] = new NameValuePair_impl();
                valuePairSet[i].setName(featureNames[i]);
                valuePairSet[i].setValue(fs.getFeatureValue(featureNames[i]).toString());
            }
        }
        return valuePairSet;
    }
}

