/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.Collection;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNode;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNodeList;
import org.apache.uima.caseditor.editor.outline.OutlineContentProviderBase;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModeSensitiveContentProvider
extends OutlineContentProviderBase {
    private AnnotationTreeNodeList mAnnotationNodeList;

    protected ModeSensitiveContentProvider(AnnotationEditor editor, TreeViewer viewer) {
        super(editor, viewer);
        this.viewer = viewer;
    }

    @Override
    public void addedAnnotation(Collection<AnnotationFS> annotations) {
        for (AnnotationFS annotation : annotations) {
            if (!annotation.getType().getName().equals(this.mEditor.getAnnotationMode().getName())) {
                return;
            }
            final AnnotationTreeNode annotationNode = new AnnotationTreeNode(this.mEditor.getDocument(), annotation);
            this.mAnnotationNodeList.add(annotationNode);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ModeSensitiveContentProvider.this.viewer.add(annotationNode.getParent() != null ? annotationNode.getParent() : ModeSensitiveContentProvider.this.mInputDocument, (Object)annotationNode);
                }
            });
        }
    }

    @Override
    public void removedAnnotation(Collection<AnnotationFS> deletedAnnotations) {
        final AnnotationTreeNode[] items = new AnnotationTreeNode[deletedAnnotations.size()];
        int i = 0;
        for (AnnotationFS annotation : deletedAnnotations) {
            items[i] = new AnnotationTreeNode(this.mEditor.getDocument(), annotation);
            this.mAnnotationNodeList.remove(items[i]);
            ++i;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ModeSensitiveContentProvider.this.viewer.remove((Object[])items);
            }
        });
    }

    @Override
    public void viewChanged(String oldViewName, String newViewName) {
        this.changed();
    }

    @Override
    public void changed() {
        Collection<AnnotationFS> annotations = this.mEditor.getDocument().getAnnotations(this.mEditor.getAnnotationMode());
        this.mAnnotationNodeList = annotations != null ? new AnnotationTreeNodeList(this.mEditor.getDocument(), annotations) : null;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ModeSensitiveContentProvider.this.viewer.refresh();
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        if (this.mAnnotationNodeList == null) {
            return new Object[0];
        }
        return this.mAnnotationNodeList.getElements().toArray();
    }

    public Object getParent(Object element) {
        AnnotationTreeNode node = (AnnotationTreeNode)element;
        return node.getParent();
    }

    public boolean hasChildren(Object element) {
        AnnotationTreeNode node = (AnnotationTreeNode)element;
        return node.getChildren().size() > 0;
    }

    public Object[] getChildren(Object parentElement) {
        AnnotationTreeNode node = (AnnotationTreeNode)parentElement;
        return node.getChildren().toArray();
    }
}

