/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.fsview;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.fsview.ITypePaneListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCombo
extends Composite {
    private Set<ITypePaneListener> listeners = new HashSet<ITypePaneListener>();
    private TypeSystem typeSystem;
    private Combo typeCombo;
    private List<String> typeNameList;

    public TypeCombo(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.typeCombo = new Combo((Composite)this, 2060);
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Type newType = TypeCombo.this.getType();
                for (ITypePaneListener listener : TypeCombo.this.listeners) {
                    listener.typeChanged(newType);
                }
            }
        });
    }

    public void setInput(Type superType, TypeSystem typeSystem, Collection<Type> filterTypes) {
        this.typeSystem = typeSystem;
        this.typeNameList = new LinkedList<String>();
        this.typeNameList.add(superType.getName());
        for (Type type : typeSystem.getProperlySubsumedTypes(superType)) {
            if (filterTypes.contains(type)) continue;
            this.typeNameList.add(type.getName());
        }
        this.typeCombo.setItems(this.typeNameList.toArray(new String[this.typeNameList.size()]));
        this.typeCombo.select(0);
    }

    public void setInput(Type superType, TypeSystem typeSystem) {
        this.setInput(superType, typeSystem, Collections.<Type>emptyList());
    }

    public void select(Type type) {
        Integer typeIndex = this.typeNameList.indexOf(type.getName());
        if (typeIndex != null) {
            this.typeCombo.select(typeIndex.intValue());
        }
    }

    public Type getType() {
        return this.typeSystem.getType(this.typeCombo.getText());
    }

    public void addListener(ITypePaneListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITypePaneListener listener) {
        this.listeners.remove(listener);
    }
}

