/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ModelFeatureStructure;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeatureStructureSelectionProvider
implements ISelectionProvider {
    private IStructuredSelection mCurrentSelection = new StructuredSelection();
    private Set<ISelectionChangedListener> mListeners = new HashSet<ISelectionChangedListener>();

    FeatureStructureSelectionProvider() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.mListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.mCurrentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        Assert.isNotNull((Object)selection);
        this.mCurrentSelection = structuredSelection = (IStructuredSelection)selection;
        for (ISelectionChangedListener listener : this.mListeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.mCurrentSelection);
            listener.selectionChanged(event);
        }
    }

    public void setSelection(ICasDocument document, AnnotationFS annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("annotation must not be null!");
        }
        this.setSelection((ISelection)new StructuredSelection((Object)new ModelFeatureStructure(document, (FeatureStructure)annotation)));
    }

    public void setSelection(ICasDocument document, List<AnnotationFS> selection) {
        this.setSelection((ISelection)new StructuredSelection(ModelFeatureStructure.create(document, selection)));
    }

    public void clearSelection() {
        this.setSelection((ISelection)new StructuredSelection());
    }

    public void clearSelectionSilently() {
        this.mCurrentSelection = new StructuredSelection();
    }
}

