/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.AbortCasProcessorException;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasDataConsumer;
import org.apache.uima.collection.base_cpm.CasDataProcessor;
import org.apache.uima.collection.base_cpm.CasDataStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasObjectProcessor;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.base_cpm.SkipCasException;
import org.apache.uima.collection.impl.CasConverter;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.base_cpm.container.KillPipelineException;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.container.CasObjectNetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.NetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.ProcessingContainer_Impl;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPECasPool;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.EOFToken;
import org.apache.uima.collection.impl.cpm.engine.WorkUnit;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.ChunkMetadata;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.vinci.DATACasUtils;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class ProcessingUnit
extends Thread {
    public int threadState = 0;
    protected CPECasPool casPool;
    protected boolean releaseCAS = false;
    protected CPMEngine cpm = null;
    protected BoundedWorkQueue workQueue = null;
    protected BoundedWorkQueue outputQueue = null;
    protected CasConverter mConverter;
    protected ProcessTrace processingUnitProcessTrace;
    protected LinkedList processContainers = new LinkedList();
    protected long numToProcess = 0L;
    protected CAS[] casList;
    protected ArrayList statusCbL = new ArrayList();
    protected boolean notifyListeners = false;
    protected CAS conversionCas = null;
    protected Object[] artifact = null;
    protected CAS[] conversionCasArray;
    protected UimaTimer timer;
    protected String threadId = null;
    protected CpeConfiguration cpeConfiguration = null;
    private CAS[] casCache = null;
    private boolean isCasConsumerPipeline = false;
    private boolean isRunning = false;
    public long timer01 = 0L;
    public long timer02 = 0L;
    public long timer03 = 0L;
    public long timer04 = 0L;
    public long timer05 = 0L;
    public long timer06 = 0L;
    private static final Object[] zeroLengthObjectArray = new Object[0];
    private static final String thisClassName = ProcessingUnit.class.getName();

    public ProcessingUnit() {
        this.conversionCasArray = new CAS[1];
        this.mConverter = new CasConverter();
    }

    public ProcessingUnit(CPMEngine acpm, BoundedWorkQueue aInputQueue, BoundedWorkQueue aOutputQueue) {
        this.cpm = acpm;
        try {
            this.cpeConfiguration = this.cpm.getCpeConfig();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.workQueue = aInputQueue;
        this.conversionCasArray = new CAS[1];
        this.mConverter = new CasConverter();
        this.outputQueue = aOutputQueue;
        this.maybeLogFinestWorkQueue("UIMA_CPM_initialize_pipeline__FINEST", this.workQueue);
    }

    public ProcessingUnit(CPMEngine acpm) {
        this.cpm = acpm;
        try {
            this.cpeConfiguration = this.cpm.getCpeConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conversionCasArray = new CAS[1];
        this.mConverter = new CasConverter();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setCasConsumerPipelineIdentity() {
        this.isCasConsumerPipeline = true;
    }

    public boolean isCasConsumerPipeline() {
        return this.isCasConsumerPipeline;
    }

    public void setInputQueue(BoundedWorkQueue aInputQueue) {
        this.workQueue = aInputQueue;
    }

    public void setOutputQueue(BoundedWorkQueue aOutputQueue) {
        this.outputQueue = aOutputQueue;
    }

    public void setCPMEngine(CPMEngine acpm) {
        this.cpm = acpm;
    }

    public void cleanup() {
        this.casPool = null;
        this.cpm = null;
        this.workQueue = null;
        this.outputQueue = null;
        this.mConverter = null;
        this.processingUnitProcessTrace = null;
        this.processContainers.clear();
        this.processContainers = null;
        this.casList = null;
        this.conversionCas = null;
        this.artifact = null;
        this.statusCbL = null;
        this.conversionCasArray = null;
    }

    public void setNotifyListeners(boolean aDoNotify) {
        this.notifyListeners = aDoNotify;
    }

    public void addStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.statusCbL.add(aListener);
    }

    public ArrayList getCallbackListeners() {
        return this.statusCbL;
    }

    public void removeStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.statusCbL.remove(aListener);
    }

    public void setProcessingUnitProcessTrace(ProcessTrace aProcessingUnitProcessTrace) {
        this.processingUnitProcessTrace = aProcessingUnitProcessTrace;
    }

    public void setUimaTimer(UimaTimer aTimer) {
        this.timer = aTimer;
        this.maybeLogFinest("UIMA_CPM_timer_class__FINEST", this.timer.getClass().getName());
    }

    public void setContainers(LinkedList processorList) {
        this.processContainers = processorList;
    }

    public void disableCasProcessor(int aCasProcessorIndex) {
        if (aCasProcessorIndex < 0 || aCasProcessorIndex > this.processContainers.size()) {
            return;
        }
        ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(aCasProcessorIndex);
        if (pc != null) {
            pc.setStatus(3);
            this.maybeLogFinest("UIMA_CPM_disabled_cp__FINEST", pc);
        }
    }

    public void disableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.processContainers.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            pc.setStatus(3);
            this.maybeLogFinest("UIMA_CPM_disabled_cp__FINEST", pc);
        }
    }

    public void enableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.processContainers.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            this.maybeLogFinest("UIMA_CPM_enabled_cp__FINEST", pc);
            pc.setStatus(2);
        }
    }

    private ProcessTrace getProcessTrace() {
        ProcessTrace_impl pT = null;
        if (this.timer != null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                this.logFinest("UIMA_CPM_use_custom_timer__FINEST", this.timer.getClass().getName());
            }
            pT = new ProcessTrace_impl(this.timer, this.cpm.getPerformanceTuningSettings());
        } else {
            this.maybeLogFinest("UIMA_CPM_use_default_timer__FINEST");
            pT = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
        }
        return pT;
    }

    private void handleEOFToken() throws Exception {
        this.maybeLogFinest("UIMA_CPM_got_eof_token__FINEST");
        if (!this.isCasConsumerPipeline()) {
            if (this.cpm.getThreadCount() > 1) {
                this.workQueue.enqueue(this.artifact);
            }
            if (this.outputQueue != null) {
                this.maybeLogFinest("UIMA_CPM_placed_eof_in_queue__FINEST", this.outputQueue.getName());
            }
            this.cpm.processingUnitShutdown(this);
        }
    }

    private void releaseTimedOutCases(Object[] artifact) {
        for (int j = 0; j < artifact.length; ++j) {
            if (artifact[j] == null) continue;
            this.casPool.releaseCas((CAS)artifact[j]);
            artifact[j] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isCpmPaused() {
        Object object = this.cpm.lockForPause;
        synchronized (object) {
            while (this.cpm.isPaused()) {
                this.threadState = 2016;
                this.maybeLogFinest("UIMA_CPM_pausing_pp__FINEST");
                try {
                    this.cpm.lockForPause.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.maybeLogFinest("UIMA_CPM_resuming_pp__FINEST");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this.cpm.isRunning()) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cpm_not_running__WARNING", new Object[]{Thread.currentThread().getName()});
            return;
        }
        this.maybeLogFinestWorkQueue("UIMA_CPM_start_pp__FINEST", this.workQueue);
        for (int i = 0; i < this.processContainers.size(); ++i) {
            ((ProcessingContainer)this.processContainers.get(i)).setStatus(2);
        }
        boolean run = true;
        int maxWaitTimeForEntity = 0;
        if (this.cpeConfiguration != null && this.cpeConfiguration.getMaxTimeToWait() > 0) {
            maxWaitTimeForEntity = this.cpeConfiguration.getMaxTimeToWait();
        }
        this.isRunning = true;
        while (run) {
            Object var9_10;
            block24: {
                block26: {
                    block25: {
                        this.threadState = 2000;
                        this.isCpmPaused();
                        this.maybeLogFinestWorkQueue("UIMA_CPM_dequeue_artifact__FINEST", this.workQueue);
                        this.artifact = null;
                        Object entity = null;
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            this.logFinest("UIMA_CPM_maxwait_for_artifact__FINEST", String.valueOf(maxWaitTimeForEntity));
                        }
                        this.threadState = 2001;
                        entity = maxWaitTimeForEntity > 0 ? this.workQueue.dequeue(maxWaitTimeForEntity) : this.workQueue.dequeue(0L);
                        if (entity == null) {
                            this.maybeLogFinest("UIMA_CPM_queue_empty__FINEST", this.workQueue.getName());
                            continue;
                        }
                        try {
                            try {
                                if (entity instanceof WorkUnit) {
                                    this.artifact = (Object[])((WorkUnit)entity).get();
                                    if (((WorkUnit)entity).isTimedOut() && this.artifact instanceof CAS[]) {
                                        break block24;
                                    }
                                    if (((WorkUnit)entity).getCas() != null) {
                                        this.casCache = ((WorkUnit)entity).getCas();
                                    }
                                } else {
                                    this.artifact = (Object[])entity;
                                }
                                ProcessTrace pT = this.getProcessTrace();
                                Object[] cases = this.artifact;
                                if (cases.length > 0 && cases[0] instanceof EOFToken) {
                                    this.threadState = 2002;
                                    run = false;
                                    this.handleEOFToken();
                                    break block25;
                                }
                                this.maybeLogFinest("UIMA_CPM_call_processNext__FINEST");
                                this.processNext(this.artifact, pT);
                                if (System.getProperty("DEBUG_EVENTS") != null) {
                                    this.maybeLogFinest("UIMA_CPM_dump_events__FINEST");
                                    CPMUtils.dumpEvents(pT);
                                }
                                ProcessTrace processTrace = this.processingUnitProcessTrace;
                                synchronized (processTrace) {
                                    this.processingUnitProcessTrace.aggregate(pT);
                                    break block26;
                                }
                            }
                            catch (ResourceProcessException e) {
                                this.maybeLogSevereException(e);
                                if (e.getCause() instanceof KillPipelineException) {
                                    this.cpm.pipelineKilled(Thread.currentThread().getName());
                                    this.releaseCAS = true;
                                    var9_10 = null;
                                    if (!this.releaseCAS) break;
                                    this.clearCasCache();
                                    break;
                                }
                                this.threadState = 2003;
                                this.cpm.killIt();
                                var9_10 = null;
                                if (!this.releaseCAS) continue;
                                this.clearCasCache();
                                continue;
                            }
                            catch (Exception e) {
                                this.maybeLogSevereException(e);
                                this.threadState = 2003;
                                this.cpm.killIt();
                                var9_10 = null;
                                if (!this.releaseCAS) continue;
                                this.clearCasCache();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            var9_10 = null;
                            if (this.releaseCAS) {
                                this.clearCasCache();
                            }
                            throw throwable;
                        }
                    }
                    var9_10 = null;
                    if (!this.releaseCAS) break;
                    this.clearCasCache();
                    break;
                }
                var9_10 = null;
                if (!this.releaseCAS) continue;
                this.clearCasCache();
                continue;
            }
            for (int i = 0; i < this.artifact.length && this.artifact[i] != null; ++i) {
                EntityProcessStatusImpl enProcSt;
                ChunkMetadata meta = CPMUtils.getChunkMetadata((CAS)this.artifact[i]);
                if (meta != null) {
                    enProcSt = new EntityProcessStatusImpl(this.processingUnitProcessTrace);
                    enProcSt.addEventStatus("Process", "Failed", new SkipCasException("Dropping CAS due chunk Timeout. Doc Id::" + meta.getDocId() + " Sequence:" + meta.getSequence()));
                    this.doNotifyListeners(this.artifact[i], true, enProcSt);
                } else {
                    enProcSt = new EntityProcessStatusImpl(this.processingUnitProcessTrace);
                    enProcSt.addEventStatus("Process", "Failed", new SkipCasException("Dropping CAS due chunk Timeout. Chunk Metadata is not available."));
                    this.doNotifyListeners(this.artifact[i], true, enProcSt);
                }
                this.releaseTimedOutCases(this.artifact);
            }
            var9_10 = null;
            if (!this.releaseCAS) continue;
            this.clearCasCache();
        }
        this.maybeLogFinestWorkQueue("UIMA_CPM_exit_pp__FINEST", this.workQueue);
        this.clearCasCache();
        this.maybeLogFinest("UIMA_CPM_pp_terminated__FINEST");
        this.isRunning = false;
    }

    private void clearCasCache() {
        if (this.casCache != null) {
            for (int index = 0; index < this.casCache.length; ++index) {
                if (this.casCache[index] == null) continue;
                this.maybeLogFinest("UIMA_CPM_release_cas_from_cache__FINEST");
                this.casPool.releaseCas(this.casCache[index]);
                this.maybeLogFinest("UIMA_CPM_release_cas_from_cache_done__FINEST");
            }
            this.casCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeQueue() {
        block6: {
            Object artifact = null;
            this.maybeLogFinestWorkQueue("UIMA_CPM_dequeue_artifact__FINEST", this.workQueue);
            artifact = this.workQueue.dequeue();
            this.maybeLogFinest("UIMA_CPM_dequeued_artifact__FINEST", this.workQueue.getName());
            if (artifact != null) {
                try {
                    Object[] oList;
                    ProcessTrace_impl pT = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
                    if (!(artifact instanceof Object[]) || (oList = (Object[])artifact)[0] == null || oList[0] instanceof EOFToken) break block6;
                    this.maybeLogFinest("UIMA_CPM_call_processNext__FINEST");
                    this.processNext((Object[])artifact, (ProcessTrace)pT);
                    this.maybeLogFinest("UIMA_CPM_call_processNext_done__FINEST");
                    ProcessTrace processTrace = this.processingUnitProcessTrace;
                    synchronized (processTrace) {
                        this.processingUnitProcessTrace.aggregate((ProcessTrace)pT);
                    }
                    return true;
                }
                catch (Exception e) {
                    this.maybeLogSevereException(e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processNext(Object[] aCasObjectList, ProcessTrace pTrTemp) throws ResourceProcessException, IOException, CollectionException, AbortCPMException, KillPipelineException {
        this.maybeLogFinest("UIMA_CPM_start_analysis__FINEST");
        CasProcessor processor = null;
        boolean doneAlready = false;
        if (aCasObjectList == null || aCasObjectList[0] == null) {
            this.maybeLogFinest("UIMA_CPM_invalid_cas_reference__SEVERE");
            return false;
        }
        Object[] casObjects = null;
        boolean isCasObject = aCasObjectList[0] instanceof CAS;
        this.maybeLogFinest("UIMA_CPM_entering_pipeline__FINEST");
        ProcessingContainer container = null;
        for (int i = 0; this.processContainers != null && i < this.processContainers.size(); ++i) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                this.logFinest("UIMA_CPM_retrieve_container__FINEST", String.valueOf(i));
            }
            ProcessingContainer processingContainer = container = (ProcessingContainer)this.processContainers.get(i);
            synchronized (processingContainer) {
                if (!this.isProcessorReady(container.getStatus())) {
                    boolean breakTheLoop;
                    this.maybeLogFinest("UIMA_CPM_container_not_ready__FINEST", container);
                    boolean bl = breakTheLoop = i == this.processContainers.size() - 1;
                    if (breakTheLoop && isCasObject) {
                        this.releaseCases(aCasObjectList, true, container.getName());
                        break;
                    }
                    continue;
                }
            }
            if (!isCasObject && !container.processCas(aCasObjectList)) {
                this.maybeLogFinest("UIMA_CPM_skip_CAS__FINEST", container);
                container.incrementFilteredCount(aCasObjectList.length);
                container.logAbortedCases(aCasObjectList);
                continue;
            }
            boolean retry = false;
            do {
                block87: {
                    if (System.getProperty("SHOW_MEMORY") != null) {
                        this.maybeLogMemoryFinest();
                    }
                    this.maybeLogFinest("UIMA_CPM_checkout_cp_from_container__FINEST", container);
                    this.threadState = 2004;
                    processor = container.getCasProcessor();
                    if (processor == null) {
                        this.maybeLogSevere("UIMA_CPM_checkout_null_cp_from_container__SEVERE", container.getName());
                        throw new ResourceProcessException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_component_reference__WARNING", new Object[]{Thread.currentThread().getName(), "CasProcessor", "NULL"}), null);
                    }
                    if (!this.isProcessorReady(container.getStatus())) {
                        this.maybeLogFinest("UIMA_CPM_container_not_ready__FINEST", container);
                        if (container.getStatus() != 5) break;
                        container.releaseCasProcessor(processor);
                        return false;
                    }
                    this.maybeLogFinest("UIMA_CPM_checkedout_cp_from_container__FINEST", container, processor);
                    try {
                        if (processor instanceof CasDataProcessor) {
                            this.maybeLogFinest("UIMA_CPM_cas_data_processor__FINEST", container, processor);
                            pTrTemp.startEvent(container.getName(), "Process", "");
                            if (isCasObject) {
                                CasData[] casDataObjects = new CasData[aCasObjectList.length];
                                for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                                    casDataObjects[casIndex] = this.mConverter.casContainerToCasData((CAS)aCasObjectList[casIndex]);
                                    if ((CAS)aCasObjectList[casIndex] == null) continue;
                                    ((CAS)aCasObjectList[casIndex]).reset();
                                }
                                this.casCache = (CAS[])aCasObjectList;
                                aCasObjectList = casDataObjects;
                            }
                            isCasObject = false;
                            long byteCount = 0L;
                            if (!retry) {
                                for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                                    byteCount = this.getBytes(aCasObjectList[casIndex]);
                                    container.addBytesIn(byteCount);
                                }
                            }
                            casObjects = aCasObjectList;
                            long pStart = System.currentTimeMillis();
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                this.logFinest("UIMA_CPM_call_process__FINEST", container, processor);
                                this.logFinest("UIMA_CPM_casObjects_class__FINEST", casObjects.getClass().getName());
                            }
                            if (!(casObjects instanceof CasData[])) {
                                this.maybeLogFinest("UIMA_CPM_expected_casdata__FINEST", casObjects.getClass().getName());
                            }
                            this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
                            casObjects = ((CasDataProcessor)processor).process((CasData[])casObjects);
                            this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
                            long pEnd = System.currentTimeMillis();
                            container.incrementTotalTime(pEnd - pStart);
                            if (casObjects != null) {
                                if (processor instanceof CasDataConsumer) {
                                    container.addBytesOut(byteCount);
                                } else {
                                    aCasObjectList = casObjects;
                                    if (!retry) {
                                        for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                                            byteCount = this.getBytes(aCasObjectList[casIndex]);
                                            container.addBytesOut(byteCount);
                                        }
                                    }
                                }
                            }
                            pTrTemp.endEvent(container.getName(), "Process", "success");
                        } else if (processor instanceof CasObjectProcessor) {
                            this.maybeLogFinest("UIMA_CPM_casobject_processor__FINEST", container, processor);
                            this.maybeLogMemoryFinest();
                            this.casList = new CAS[aCasObjectList.length];
                            for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                                this.maybeLogFinest("UIMA_CPM_initialize_cas__FINEST", container);
                                if (aCasObjectList[casIndex] == null) {
                                    if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break;
                                    this.logSevere("UIMA_CPM_casobjectlist_is_null__SEVERE", container.getName(), String.valueOf(casIndex));
                                    break;
                                }
                                if (!isCasObject) {
                                    if (this.casCache == null || this.casCache[casIndex] == null) {
                                        this.casList[casIndex] = null;
                                        while (this.casList[casIndex] == null) {
                                            this.maybeLogFinest("UIMA_CPM_get_cas_from_pool__FINEST", container);
                                            this.casList[casIndex] = this.casPool.getCas(0L);
                                            this.maybeLogFinest("UIMA_CPM_got_cas_from_pool__FINEST", container);
                                        }
                                        if (this.casList[casIndex] != null) {
                                            this.maybeLogFinest("UIMA_CPM_call_cas_reset__FINEST", container);
                                            this.casList[casIndex].reset();
                                        }
                                    } else {
                                        this.casList[casIndex] = this.casCache[casIndex];
                                        this.casList[casIndex].reset();
                                        this.maybeLogFinest("UIMA_CPM_nullify_cas__FINEST", container);
                                        this.casCache[casIndex] = null;
                                    }
                                    this.mConverter.casDataToCasContainer((CasData)aCasObjectList[casIndex], this.casList[casIndex], true);
                                } else {
                                    this.casList[casIndex] = (CAS)aCasObjectList[casIndex];
                                }
                                isCasObject = true;
                                aCasObjectList = this.casList;
                                if (processor instanceof AnalysisEngine) {
                                    this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
                                    this.threadState = 2005;
                                    pTrTemp.aggregate(((AnalysisEngine)processor).process(this.casList[casIndex]));
                                    this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
                                    continue;
                                }
                                pTrTemp.startEvent(container.getName(), "Process", "");
                                this.threadState = 2006;
                                this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
                                ((CasObjectProcessor)processor).processCas(this.casList[casIndex]);
                                this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
                                pTrTemp.endEvent(container.getName(), "Process", "success");
                            }
                        }
                        if (this.releaseCAS && i == this.processContainers.size() - 1) {
                            doneAlready = true;
                            EntityProcessStatusImpl aEntityProcStatus = new EntityProcessStatusImpl(pTrTemp);
                            this.maybeLogFinest("UIMA_CPM_notify_listeners__FINEST");
                            this.threadState = 2007;
                            this.notifyListeners(aCasObjectList, isCasObject, aEntityProcStatus);
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                this.logFinest("UIMA_CPM_done_notify_listeners__FINEST");
                                this.logFinest("UIMA_CPM_releasing_cases__FINEST", container.getName(), String.valueOf(this.releaseCAS), "true");
                            }
                            if (this.casCache != null) {
                                this.clearCasCache();
                            }
                            if (aCasObjectList instanceof CAS[]) {
                                this.cpm.releaseCASes((CAS[])aCasObjectList);
                            }
                            this.maybeLogFinest("UIMA_CPM_done_releasing_cases__FINEST", container);
                        }
                        this.maybeLogFinest("UIMA_CPM_pipeline_completed__FINEST");
                        retry = false;
                        if (!this.cpm.dropCasOnException()) {
                            container.resetRestartCount();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            this.logSevere("UIMA_CPM_pipeline_exception__SEVERE", container.getName(), e.getMessage());
                            this.maybeLogSevereException(e);
                            this.logFinest("UIMA_CPM_pipeline_exception__FINEST", container.getName(), String.valueOf(container.isPaused()));
                        }
                        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(pTrTemp);
                        enProcSt.addEventStatus("Process", "Failed", e);
                        this.threadState = 2008;
                        this.notifyListeners(aCasObjectList, isCasObject, enProcSt);
                        doneAlready = true;
                        this.threadState = 2009;
                        if (this.cpm.dropCasOnException()) {
                            if (this.casCache != null) {
                                this.clearCasCache();
                            }
                            if (aCasObjectList instanceof CAS[]) {
                                this.cpm.invalidateCASes((CAS[])aCasObjectList);
                            }
                            retry = false;
                            this.maybeLogWarning("UIMA_CPM_drop_cas__WARNING", container.getName(), processor.getClass().getName());
                        } else {
                            retry = true;
                        }
                        if (processor instanceof CasObjectNetworkCasProcessorImpl && container.isPaused()) {
                            this.threadState = 2010;
                            this.maybeLogFinest("UIMA_CPM_container_paused_do_retry__FINEST", container);
                            this.releaseCases(this.casList, i == this.processContainers.size() - 1, container.getName());
                            this.maybeLogFinest("UIMA_CPM_container_paused__FINEST", container);
                            if (processor != null) {
                                container.releaseCasProcessor(processor);
                                this.maybeLogFinest("UIMA_CPM_ok_released_cp__FINEST", container);
                                processor = null;
                            }
                            try {
                                pTrTemp.endEvent(container.getName(), "Process", "failed");
                            }
                            catch (Exception exc) {}
                            continue;
                        }
                        if (this.pauseContainer(container, e, this.threadId)) {
                            this.threadState = 2011;
                            container.pause();
                            this.maybeLogFinest("UIMA_CPM_pausing_container__FINEST", container);
                            this.threadId = Thread.currentThread().getName();
                        }
                        if (processor instanceof CasDataProcessor || processor instanceof CasObjectProcessor && !(processor instanceof AnalysisEngine)) {
                            try {
                                pTrTemp.endEvent(container.getName(), "Process", "failed");
                            }
                            catch (Exception exc) {
                                // empty catch block
                            }
                        }
                        try {
                            container.incrementCasProcessorErrors(e);
                            container.releaseCasProcessor(processor);
                            processor = null;
                            if (this.cpm.dropCasOnException()) {
                                return true;
                            }
                            container.incrementRetryCount(1);
                            continue;
                        }
                        catch (KillPipelineException ex) {
                            try {
                                this.handleKillPipeline(container);
                                processor = null;
                            }
                            catch (Exception innerE) {
                                this.maybeLogWarning("UIMA_CPM_exception_on_pipeline_kill__WARNING", container.getName(), innerE.getMessage());
                            }
                            throw ex;
                        }
                        catch (AbortCPMException ex) {
                            try {
                                this.handleAbortCPM(container, processor);
                            }
                            catch (Exception innerE) {
                                this.maybeLogWarning("UIMA_CPM_exception_on_cpm_kill__WARNING", container.getName(), innerE.getMessage());
                            }
                            throw ex;
                        }
                        catch (AbortCasProcessorException ex) {
                            try {
                                this.handleAbortCasProcessor(container, processor);
                                if (this.cpm.dropCasOnException()) {
                                    return true;
                                }
                                this.releaseCases(this.casList, i == this.processContainers.size() - 1, container.getName());
                                break;
                            }
                            catch (ResourceProcessException rpe) {
                                throw rpe;
                            }
                            catch (Exception rpe) {
                                throw new ResourceProcessException((Throwable)rpe);
                            }
                        }
                        catch (ServiceConnectionException ex) {
                            pTrTemp.startEvent(container.getName(), "Process", "");
                            try {
                                this.threadState = 2012;
                                this.handleServiceException(container, processor, pTrTemp, ex);
                                if (this.cpm.dropCasOnException()) {
                                    return true;
                                }
                                container.incrementRestartCount(1);
                                pTrTemp.endEvent(container.getName(), "Process", "success");
                                continue;
                            }
                            catch (ResourceProcessException rpe) {
                                pTrTemp.endEvent(container.getName(), "Process", "failure");
                                throw rpe;
                            }
                            catch (ResourceConfigurationException rpe) {
                                if (rpe.getCause() != null && rpe.getCause() instanceof KillPipelineException) {
                                    try {
                                        this.handleKillPipeline(container);
                                        processor = null;
                                    }
                                    catch (Exception excep) {
                                        this.maybeLogWarning("UIMA_CPM_exception_on_pipeline_kill__WARNING", container.getName(), excep.getMessage());
                                    }
                                }
                                pTrTemp.endEvent(container.getName(), "Process", "failure");
                                throw new ResourceProcessException(rpe.getCause());
                            }
                            catch (Exception rpe) {
                                pTrTemp.endEvent(container.getName(), "Process", "failure");
                                throw new ResourceProcessException((Throwable)rpe);
                            }
                        }
                        catch (SkipCasException ex) {
                            try {
                                if (processor != null) {
                                    container.releaseCasProcessor(processor);
                                }
                                this.handleSkipCasProcessor(container, aCasObjectList, i == this.processContainers.size() - 1);
                            }
                            catch (Exception sEx) {
                                throw new ResourceProcessException((Throwable)sEx);
                            }
                            processor = null;
                            if (!this.cpm.dropCasOnException()) break;
                            return true;
                        }
                        catch (Exception ex) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                                this.logCPM(Level.FINER, "UIMA_CPM_exception__FINER", new Object[]{ex.getMessage()});
                                ex.printStackTrace();
                            }
                            if (this.cpm.dropCasOnException()) break block87;
                            this.releaseCases(this.casList, i == this.processContainers.size() - 1, container.getName());
                            container.incrementRetryCount(1);
                        }
                    }
                }
                this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                this.doEndOfBatchProcessing(container, processor, pTrTemp, aCasObjectList);
                processor = null;
            } while (retry);
            if (processor == null) continue;
            this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
            container.releaseCasProcessor(processor);
            processor = null;
            this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
        }
        try {
            this.postAnalysis(aCasObjectList, isCasObject, casObjects, pTrTemp, doneAlready);
        }
        catch (ResourceProcessException rpe) {
            throw rpe;
        }
        catch (Exception rpe) {
            throw new ResourceProcessException((Throwable)rpe);
        }
        this.maybeLogFinest("UIMA_CPM_pipeline_completed__FINEST");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postAnalysis(Object[] aCasObjectList, boolean isCasObject, Object[] casObjects, ProcessTrace aProcessTr, boolean doneAlready) throws Exception {
        try {
            this.maybeLogFinest("UIMA_CPM_pipeline_completed__FINEST");
            if (!doneAlready && this.notifyListeners) {
                this.maybeLogFinest("UIMA_CPM_notify_listeners__FINEST");
                this.threadState = 2013;
                EntityProcessStatusImpl aEntityProcStatus = new EntityProcessStatusImpl(aProcessTr);
                this.notifyListeners(aCasObjectList, isCasObject, aEntityProcStatus);
                this.threadState = 2014;
                this.maybeLogFinest("UIMA_CPM_done_notify_listeners__FINEST");
            }
            if (this.outputQueue != null && (this.cpm.isRunning() || !this.cpm.isRunning() && !this.cpm.isHardKilled())) {
                this.maybeLogFinestWorkQueue("UIMA_CPM_add_cas_to_queue__FINEST", this.outputQueue);
                WorkUnit workUnit = new WorkUnit(aCasObjectList);
                if (this.casCache != null && this.casCache[0] != null) {
                    workUnit.setCas(this.casCache);
                }
                this.threadState = 2015;
                this.outputQueue.enqueue(workUnit);
                this.casCache = null;
            }
            Object var8_8 = null;
            if (this.outputQueue != null) return;
            if (casObjects == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (this.outputQueue != null) throw throwable;
            if (casObjects == null) throw throwable;
            if (!(casObjects instanceof CasData[])) throw throwable;
            if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                this.logFinest("UIMA_CPM_done_with_cas__FINEST", String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
            }
            int i = 0;
            while (true) {
                if (i >= casObjects.length) {
                    if (System.getProperty("DEBUG_RELEASE") == null) throw throwable;
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) throw throwable;
                    this.logFinest("UIMA_CPM_show_total_memory__FINEST", String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
                    throw throwable;
                }
                this.maybeLogFinest("UIMA_CPM_show_local_cache__FINEST", this.casCache);
                casObjects[i] = null;
                aCasObjectList[i] = null;
                this.maybeLogFinest("UIMA_CPM_show_local_cache__FINEST", this.casCache);
                ++i;
            }
        }
        if (!(casObjects instanceof CasData[])) return;
        if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest("UIMA_CPM_done_with_cas__FINEST", String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
        }
        for (int i = 0; i < casObjects.length; ++i) {
            this.maybeLogFinest("UIMA_CPM_show_local_cache__FINEST", this.casCache);
            casObjects[i] = null;
            aCasObjectList[i] = null;
            this.maybeLogFinest("UIMA_CPM_show_local_cache__FINEST", this.casCache);
        }
        if (System.getProperty("DEBUG_RELEASE") == null) return;
        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) return;
        this.logFinest("UIMA_CPM_show_total_memory__FINEST", String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEndOfBatchProcessing(ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTr, Object[] aCasObjectList) {
        String cName = aContainer.getName();
        try {
            try {
                aProcessTr.startEvent(aContainer.getName(), "End of Batch", "");
                aContainer.isEndOfBatch(aProcessor, aCasObjectList.length);
                aProcessTr.endEvent(cName, "End of Batch", "success");
                this.maybeLogFinest("UIMA_CPM_end_of_batch_completed__FINEST", aContainer);
            }
            catch (Exception ex) {
                this.maybeLogSevere("UIMA_CPM_end_of_batch_exception__SEVERE", aContainer.getName(), ex.getMessage());
                aProcessTr.endEvent(cName, "End of Batch", "failed");
                Object var8_7 = null;
                if (aProcessor != null) {
                    aContainer.releaseCasProcessor(aProcessor);
                    this.maybeLogFinest("UIMA_CPM_ok_released_cp__FINEST", aContainer);
                }
            }
            Object var8_6 = null;
            if (aProcessor != null) {
                aContainer.releaseCasProcessor(aProcessor);
                this.maybeLogFinest("UIMA_CPM_ok_released_cp__FINEST", aContainer);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (aProcessor != null) {
                aContainer.releaseCasProcessor(aProcessor);
                this.maybeLogFinest("UIMA_CPM_ok_released_cp__FINEST", aContainer);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSkipCasProcessor(ProcessingContainer aContainer, Object[] aCasObjectList, boolean isLastCP) throws Exception {
        this.maybeLogFinest("UIMA_CPM_skipping_cas__FINEST", aContainer);
        if (aContainer.isPaused()) {
            aContainer.resume();
        }
        aContainer.incrementAbortCount(aCasObjectList.length);
        if (this.cpm.dropCasOnException()) return;
        try {
            aContainer.logAbortedCases(aCasObjectList);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                this.releaseCases(this.casList, isLastCP, aContainer.getName());
                throw throwable;
            }
            catch (Exception ex2) {
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) throw throwable;
                this.logSevere("UIMA_CPM_exception_releasing_cas__SEVERE", aContainer.getName());
                this.maybeLogSevereException(ex2);
                throw ex2;
            }
        }
        try {}
        catch (Exception ex2) {
            if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) return;
            this.logSevere("UIMA_CPM_exception_releasing_cas__SEVERE", aContainer.getName());
            this.maybeLogSevereException(ex2);
            throw ex2;
        }
        this.releaseCases(this.casList, isLastCP, aContainer.getName());
    }

    private void handleServiceException(ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTr, Exception ex) throws Exception {
        if (aProcessor instanceof NetworkCasProcessorImpl) {
            ((NetworkCasProcessorImpl)aProcessor).collectionProcessComplete(aProcessTr);
        }
        ((ProcessingContainer_Impl)aContainer).failedCasProcessorList.add(aProcessor);
        if (aContainer.isRemote() && aContainer.isSingleFencedService()) {
            if (Thread.currentThread().getName().equals(this.threadId)) {
                this.maybeLogFinest("UIMA_CPM_service_connection_exception__FINEST", aContainer, aProcessor);
                aProcessTr.startEvent(aContainer.getName(), "Process", "");
                this.maybeLogFinest("UIMA_CPM_redeploy_cp__FINEST", aContainer, aProcessor);
                this.cpm.redeployAnalysisEngine(aContainer);
                aContainer.resume();
                this.threadId = null;
                this.maybeLogFinest("UIMA_CPM_redeploy_cp_done__FINEST", aContainer, aProcessor);
            }
        } else {
            this.maybeLogFinest("UIMA_CPM_service_connection_exception__FINEST", aContainer, aProcessor);
            aProcessTr.startEvent(aContainer.getName(), "Process", "");
            this.maybeLogFinest("UIMA_CPM_redeploy_cp__FINEST", aContainer, aProcessor);
            this.cpm.redeployAnalysisEngine(aContainer);
            this.maybeLogFinest("UIMA_CPM_redeploy_cp_done__FINEST", aContainer, aProcessor);
        }
    }

    private void handleAbortCasProcessor(ProcessingContainer aContainer, CasProcessor aProcessor) throws Exception {
        this.maybeLogFinest("UIMA_CPM_disable_due_to_action__FINEST", aContainer);
        if (aContainer.isPaused()) {
            aContainer.resume();
        }
        aContainer.setStatus(3);
        if (aProcessor != null) {
            aContainer.releaseCasProcessor(aProcessor);
            aProcessor = null;
        }
        this.maybeLogFinest("UIMA_CPM_disabled_cp__FINEST", aContainer);
    }

    private void handleAbortCPM(ProcessingContainer aContainer, CasProcessor aProcessor) throws Exception {
        if (aContainer.isPaused()) {
            aContainer.resume();
        }
        aContainer.setStatus(5);
        this.maybeLogSevere("UIMA_CPM_abort_cpm__SEVERE", aContainer.getName());
        aContainer.releaseCasProcessor(aProcessor);
        if (!this.cpm.dropCasOnException()) {
            try {
                this.releaseCAS = true;
                this.releaseCases(this.casList, true, aContainer.getName());
            }
            catch (Exception exc) {
                this.maybeLogSevere("UIMA_CPM_exception_on_cpm_kill__WARNING", aContainer.getName(), exc.getMessage());
                this.maybeLogSevereException(exc);
            }
        }
        throw new AbortCPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_abort__WARNING", new Object[]{Thread.currentThread().getName(), aContainer.getName()}));
    }

    private void handleKillPipeline(ProcessingContainer aContainer) throws Exception {
        if (aContainer.isPaused()) {
            aContainer.resume();
        }
        aContainer.setStatus(5);
        this.maybeLogFinest("UIMA_CPM_kill_pipeline__FINEST", aContainer);
        this.releaseCAS = true;
        if (this.casCache != null) {
            this.cpm.releaseCASes(this.casCache);
            this.casCache = null;
        }
        this.releaseCases(this.casList, true, aContainer.getName());
    }

    private boolean pauseContainer(ProcessingContainer aContainer, Exception aException, String aThreadId) {
        return aContainer.isRemote() && aContainer.isSingleFencedService() && aException.getCause() instanceof ServiceConnectionException && aThreadId == null;
    }

    private void releaseCases(Object aCasList, boolean lastProcessor, String aName) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest("UIMA_CPM_releasing_cases__FINEST", aName, String.valueOf(this.releaseCAS), String.valueOf(lastProcessor));
        }
        if (aCasList == null) {
            return;
        }
        if (this.releaseCAS && lastProcessor) {
            if (aCasList instanceof CAS[]) {
                if (this.casCache != null) {
                    this.cpm.releaseCASes(this.casCache);
                    this.casCache = null;
                }
                this.cpm.releaseCASes((CAS[])aCasList);
                this.maybeLogFinest("UIMA_CPM_done_releasing_cases__FINEST", aName);
            } else {
                this.maybeLogFinest("UIMA_CPM_casobject_class__FINEST", aName, aCasList.getClass().getName());
            }
        }
    }

    protected void notifyListeners(Object aCas, boolean isCasObject, EntityProcessStatus aEntityProcStatus) {
        if (aCas instanceof Object[]) {
            for (int i = 0; i < ((Object[])aCas).length; ++i) {
                this.doNotifyListeners(((Object[])aCas)[i], isCasObject, aEntityProcStatus);
            }
        } else {
            this.doNotifyListeners(aCas, isCasObject, aEntityProcStatus);
        }
    }

    protected void doNotifyListeners(Object aCas, boolean isCasObject, EntityProcessStatus aEntityProcStatus) {
        Object casObjectCopy = aCas;
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
            if (statCL instanceof CasDataStatusCallbackListener) {
                if (isCasObject) {
                    casObjectCopy = this.mConverter.casContainerToCasData((CAS)casObjectCopy);
                }
                ((CasDataStatusCallbackListener)statCL).entityProcessComplete((CasData)casObjectCopy, aEntityProcStatus);
                continue;
            }
            if (!(statCL instanceof StatusCallbackListener)) continue;
            boolean casFromPool = false;
            if (!isCasObject) {
                this.conversionCas = null;
                if (this.casCache != null && this.casCache[0] != null) {
                    this.conversionCas = this.casCache[0];
                } else {
                    while (this.conversionCas == null) {
                        this.conversionCas = this.casPool.getCas(0L);
                    }
                    casFromPool = true;
                }
                try {
                    this.mConverter.casDataToCasContainer((CasData)casObjectCopy, this.conversionCas, true);
                }
                catch (CollectionException e) {
                    this.logWarning("UIMA_CPM_exception_converting_CAS__WARNING");
                }
                casObjectCopy = this.conversionCas;
            }
            CPMEngine.callEntityProcessCompleteWithCAS((StatusCallbackListener)statCL, (CAS)casObjectCopy, aEntityProcStatus);
            if (this.conversionCas == null) continue;
            if (casFromPool) {
                this.conversionCasArray[0] = this.conversionCas;
                this.cpm.releaseCASes(this.conversionCasArray);
            }
            this.conversionCas = null;
            if (this.casCache == null || this.casCache[0] == null) continue;
            this.casCache[0].reset();
        }
    }

    public void setReleaseCASFlag(boolean aFlag) {
        this.releaseCAS = aFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopCasProcessors(boolean kill) {
        this.maybeLogFinest("UIMA_CPM_stop_containers__FINEST");
        for (int i = 0; this.processContainers != null && i < this.processContainers.size(); ++i) {
            ProcessingContainer container = (ProcessingContainer)this.processContainers.get(i);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                this.logFinest("UIMA_CPM_show_container_time__FINEST", container.getName(), String.valueOf(container.getTotalTime()));
            }
            ProcessingContainer processingContainer = container;
            synchronized (processingContainer) {
                block17: {
                    Object var8_8;
                    if (kill || !this.cpm.isRunning() && this.isProcessorReady(container.getStatus())) {
                        this.maybeLogFinest("UIMA_CPM_kill_cp__FINEST", container);
                        container.setStatus(5);
                    } else if (container.getStatus() != 3) {
                        container.setStatus(4);
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        this.logFinest("UIMA_CPM_container_status__FINEST", container.getName(), String.valueOf(container.getStatus()));
                    }
                    ProcessTrace_impl pTrTemp = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
                    pTrTemp.startEvent(container.getName(), "End of Batch", "");
                    try {
                        try {
                            CasProcessorDeployer deployer = container.getDeployer();
                            if (deployer != null) {
                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                    this.logFinest("UIMA_CPM_undeploy_cp_instances__FINEST", container.getName(), deployer.getClass().getName());
                                }
                                deployer.undeploy();
                            }
                            container.destroy();
                        }
                        catch (Exception e) {
                            this.logWarning("UIMA_CPM_exception_during_cp_stop__WARNING", container.getName(), e.getMessage());
                            var8_8 = null;
                            pTrTemp.endEvent(container.getName(), "End of Batch", "");
                            if (this.processingUnitProcessTrace != null) {
                                this.processingUnitProcessTrace.aggregate((ProcessTrace)pTrTemp);
                            }
                            break block17;
                        }
                        var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        pTrTemp.endEvent(container.getName(), "End of Batch", "");
                        if (this.processingUnitProcessTrace != null) {
                            this.processingUnitProcessTrace.aggregate((ProcessTrace)pTrTemp);
                        }
                        throw throwable;
                    }
                    pTrTemp.endEvent(container.getName(), "End of Batch", "");
                    if (this.processingUnitProcessTrace != null) {
                        this.processingUnitProcessTrace.aggregate((ProcessTrace)pTrTemp);
                    }
                }
                continue;
            }
        }
    }

    protected boolean endOfProcessingReached(long aCount) {
        if (this.numToProcess == -1L) {
            return false;
        }
        if (this.numToProcess == 0L) {
            return true;
        }
        return aCount >= this.numToProcess;
    }

    protected void process(Object anArtifact) {
        if (anArtifact instanceof Object[]) {
            Object[] cases = (Object[])anArtifact;
            this.showMetadata(cases);
        }
    }

    protected void showMetadata(Object[] aCasList) {
    }

    protected boolean isProcessorReady(int aStatus) {
        return aStatus == 1 || aStatus == 2;
    }

    protected long getBytes(Object aCas) {
        try {
            if (aCas instanceof CasData) {
                return DATACasUtils.getByteCount((CasData)aCas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public void setCasPool(CPECasPool aPool) {
        this.casPool = aPool;
    }

    private boolean filterOutTheCAS(ProcessingContainer aContainer, boolean isCasObject, Object[] aCasObjectList) {
        if (!isCasObject && !aContainer.processCas(aCasObjectList)) {
            this.maybeLogFinest("UIMA_CPM_skip_CAS__FINEST", aContainer);
            aContainer.incrementFilteredCount(aCasObjectList.length);
            aContainer.logAbortedCases(aCasObjectList);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containerDisabled(ProcessingContainer aContainer) {
        ProcessingContainer processingContainer = aContainer;
        synchronized (processingContainer) {
            if (!this.isProcessorReady(aContainer.getStatus())) {
                this.maybeLogFinest("UIMA_CPM_container_not_ready__FINEST", aContainer);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean analyze(Object[] aCasObjectList, ProcessTrace pTrTemp) throws Exception {
        long t1 = 0L;
        this.maybeLogFinest("UIMA_CPM_start_analysis__FINEST");
        CasProcessor processor = null;
        boolean doneAlready = false;
        if (aCasObjectList == null || aCasObjectList[0] == null) {
            this.maybeLogSevere("UIMA_CPM_invalid_cas_reference__SEVERE");
            return false;
        }
        Object casObjects = null;
        boolean isCasObject = aCasObjectList[0] instanceof CAS;
        this.maybeLogFinest("UIMA_CPM_entering_pipeline__FINEST");
        ProcessingContainer container = null;
        String containerName = "";
        block4: for (int i = 0; this.processContainers != null && i < this.processContainers.size(); ++i) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                this.logFinest("UIMA_CPM_retrieve_container__FINEST", String.valueOf(i));
            }
            if (this.containerDisabled(container = (ProcessingContainer)this.processContainers.get(i)) || this.filterOutTheCAS(container, isCasObject, aCasObjectList)) continue;
            containerName = container.getName();
            boolean retry = false;
            do {
                Object var16_14;
                block37: {
                    block33: {
                        boolean bl;
                        block35: {
                            block34: {
                                block36: {
                                    try {
                                        try {
                                            if (System.getProperty("SHOW_MEMORY") != null) {
                                                this.maybeLogMemoryFinest();
                                            }
                                            this.maybeLogFinest("UIMA_CPM_checkout_cp_from_container__FINEST", container);
                                            this.threadState = 2004;
                                            t1 = System.currentTimeMillis();
                                            processor = container.getCasProcessor();
                                            this.timer01 += System.currentTimeMillis() - t1;
                                            this.timer06 = ((ProcessingContainer_Impl)container).getFetchTime();
                                            if (processor == null) {
                                                this.maybeLogSevere("UIMA_CPM_checkout_null_cp_from_container__SEVERE", containerName);
                                                throw new ResourceProcessException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_component_reference__WARNING", new Object[]{Thread.currentThread().getName(), "CasProcessor", "NULL"}), null);
                                            }
                                            if (!this.isProcessorReady(container.getStatus())) {
                                                this.maybeLogFinest("UIMA_CPM_container_not_ready__FINEST", container);
                                                if (container.getStatus() != 5) break block33;
                                                container.releaseCasProcessor(processor);
                                                bl = false;
                                                var16_14 = null;
                                                if (retry) break block34;
                                                this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                                                if (!this.isProcessorReady(container.getStatus())) break block35;
                                                break block36;
                                            }
                                            this.maybeLogFinest("UIMA_CPM_checkedout_cp_from_container__FINEST", container, processor);
                                            t1 = System.currentTimeMillis();
                                            if (processor instanceof CasDataProcessor) {
                                                this.invokeCasDataCasProcessor(container, processor, aCasObjectList, pTrTemp, isCasObject, retry);
                                                isCasObject = false;
                                            } else if (processor instanceof CasObjectProcessor) {
                                                this.invokeCasObjectCasProcessor(container, processor, aCasObjectList, pTrTemp, isCasObject);
                                                isCasObject = true;
                                            }
                                            this.timer02 += System.currentTimeMillis() - t1;
                                            this.maybeLogFinest("UIMA_CPM_analysis_successfull__FINEST", container, processor);
                                            retry = false;
                                            if (this.cpm.dropCasOnException()) break block37;
                                            container.resetRestartCount();
                                            break block37;
                                        }
                                        catch (Exception e) {
                                            retry = this.handleErrors(e, container, processor, pTrTemp, aCasObjectList, isCasObject);
                                            if (this.cpm.dropCasOnException()) {
                                                retry = false;
                                                boolean bl2 = false;
                                                var16_14 = null;
                                                if (!retry) {
                                                    this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                                                    if (this.isProcessorReady(container.getStatus())) {
                                                        t1 = System.currentTimeMillis();
                                                        this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                                        this.timer03 += System.currentTimeMillis() - t1;
                                                    }
                                                } else {
                                                    container.incrementRetryCount(1);
                                                }
                                                if (processor != null) {
                                                    this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                                                    t1 = System.currentTimeMillis();
                                                    this.doReleaseCasProcessor(container, processor);
                                                    this.timer04 += System.currentTimeMillis() - t1;
                                                    this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                                                    return bl2;
                                                }
                                                return bl2;
                                            }
                                            var16_14 = null;
                                            if (!retry) {
                                                this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                                                if (this.isProcessorReady(container.getStatus())) {
                                                    t1 = System.currentTimeMillis();
                                                    this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                                    this.timer03 += System.currentTimeMillis() - t1;
                                                }
                                            } else {
                                                container.incrementRetryCount(1);
                                            }
                                            if (processor == null) continue;
                                            this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                                            t1 = System.currentTimeMillis();
                                            this.doReleaseCasProcessor(container, processor);
                                            this.timer04 += System.currentTimeMillis() - t1;
                                            this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                                            processor = null;
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var16_14 = null;
                                        if (!retry) {
                                            this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                                            if (this.isProcessorReady(container.getStatus())) {
                                                t1 = System.currentTimeMillis();
                                                this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                                this.timer03 += System.currentTimeMillis() - t1;
                                            }
                                        } else {
                                            container.incrementRetryCount(1);
                                        }
                                        if (processor != null) {
                                            this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                                            t1 = System.currentTimeMillis();
                                            this.doReleaseCasProcessor(container, processor);
                                            this.timer04 += System.currentTimeMillis() - t1;
                                            this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                                            processor = null;
                                        }
                                        throw throwable;
                                    }
                                }
                                t1 = System.currentTimeMillis();
                                this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                this.timer03 += System.currentTimeMillis() - t1;
                                break block35;
                            }
                            container.incrementRetryCount(1);
                        }
                        if (processor != null) {
                            this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                            t1 = System.currentTimeMillis();
                            this.doReleaseCasProcessor(container, processor);
                            this.timer04 += System.currentTimeMillis() - t1;
                            this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                            return bl;
                        }
                        return bl;
                    }
                    var16_14 = null;
                    if (!retry) {
                        this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                        if (this.isProcessorReady(container.getStatus())) {
                            t1 = System.currentTimeMillis();
                            this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                            this.timer03 += System.currentTimeMillis() - t1;
                        }
                    } else {
                        container.incrementRetryCount(1);
                    }
                    if (processor == null) continue block4;
                    this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                    t1 = System.currentTimeMillis();
                    this.doReleaseCasProcessor(container, processor);
                    this.timer04 += System.currentTimeMillis() - t1;
                    this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                    processor = null;
                    continue block4;
                }
                var16_14 = null;
                if (!retry) {
                    this.maybeLogFinest("UIMA_CPM_end_of_batch__FINEST", container, processor);
                    if (this.isProcessorReady(container.getStatus())) {
                        t1 = System.currentTimeMillis();
                        this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                        this.timer03 += System.currentTimeMillis() - t1;
                    }
                } else {
                    container.incrementRetryCount(1);
                }
                if (processor == null) continue;
                this.maybeLogFinest("UIMA_CPM_release_cp__FINEST", container, processor, this.casCache);
                t1 = System.currentTimeMillis();
                this.doReleaseCasProcessor(container, processor);
                this.timer04 += System.currentTimeMillis() - t1;
                this.maybeLogFinest("UIMA_CPM_ok_release_cp__FINEST", container, processor, this.casCache);
                processor = null;
            } while (retry);
        }
        t1 = System.currentTimeMillis();
        this.postAnalysis(aCasObjectList, isCasObject, casObjects, pTrTemp, doneAlready);
        this.timer05 += System.currentTimeMillis() - t1;
        return true;
    }

    private void doReleaseCasProcessor(ProcessingContainer aContainer, CasProcessor aCasProcessor) {
        if (aCasProcessor != null && aContainer != null) {
            aContainer.releaseCasProcessor(aCasProcessor);
        }
    }

    private void doEndOfBatch(ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTr, int howManyCases) {
        String containerName = aContainer.getName();
        try {
            aContainer.isEndOfBatch(aProcessor, howManyCases);
            this.maybeLogFinest("UIMA_CPM_end_of_batch_completed__FINEST", aContainer);
        }
        catch (Exception ex) {
            this.maybeLogSevere("UIMA_CPM_end_of_batch_exception__SEVERE", containerName, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleErrors(Throwable e, ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTrace, Object[] aCasObjectList, boolean isCasObject) throws Exception {
        boolean retry = true;
        String containerName = aContainer.getName();
        e.printStackTrace();
        this.maybeLogSevereException(e);
        this.maybeLogSevere("UIMA_CPM_handle_exception__SEVERE", containerName, aProcessor.getClass().getName(), e.getMessage());
        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(aProcessTrace);
        enProcSt.addEventStatus("Process", "Failed", e);
        this.threadState = 2008;
        this.notifyListeners(aCasObjectList, isCasObject, enProcSt);
        this.threadState = 2009;
        if (this.cpm.dropCasOnException()) {
            if (this.casCache != null) {
                this.clearCasCache();
            }
            this.logWarning("UIMA_CPM_drop_cas__WARNING", containerName, aProcessor.getClass().getName());
            this.cpm.invalidateCASes((CAS[])aCasObjectList);
            retry = false;
        }
        if (aProcessor instanceof CasObjectNetworkCasProcessorImpl && aContainer.isPaused()) {
            this.threadState = 2010;
            this.maybeLogFinest("UIMA_CPM_container_paused_do_retry__FINEST", aContainer);
            return true;
        }
        if (e instanceof Exception && this.pauseContainer(aContainer, (Exception)e, this.threadId)) {
            this.maybeLogFinest("UIMA_CPM_pausing_container__FINEST", aContainer);
            this.threadState = 2011;
            aContainer.pause();
            this.threadId = Thread.currentThread().getName();
        }
        try {
            aContainer.incrementCasProcessorErrors(e);
            return retry;
        }
        catch (AbortCPMException ex) {
            retry = false;
            if (aContainer.isPaused()) {
                aContainer.resume();
            }
            aContainer.setStatus(5);
            this.maybeLogFinest("UIMA_CPM_EXP_configured_to_abort__WARNING", aProcessor);
            throw new AbortCPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_abort__WARNING", new Object[]{Thread.currentThread().getName(), containerName}));
        }
        catch (AbortCasProcessorException ex) {
            retry = false;
            this.maybeLogFinest("UIMA_CPM_disable_cp__SEVERE", aProcessor);
            if (aContainer.isPaused()) {
                aContainer.resume();
            }
            aContainer.setStatus(3);
            return retry;
        }
        catch (ServiceConnectionException ex) {
            aProcessTrace.startEvent(containerName, "Process", "");
            String status = "failure";
            try {
                try {
                    this.threadState = 2012;
                    this.handleServiceException(aContainer, aProcessor, aProcessTrace, ex);
                    status = "success";
                }
                catch (ResourceProcessException rpe) {
                    throw rpe;
                }
                catch (Exception rpe) {
                    throw new ResourceProcessException((Throwable)rpe);
                }
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                aProcessTrace.endEvent(containerName, "Process", status);
                throw throwable;
            }
            aProcessTrace.endEvent(containerName, "Process", status);
            return retry;
        }
        catch (SkipCasException ex) {
            try {
                this.handleSkipCasProcessor(aContainer, aCasObjectList, false);
                return false;
            }
            catch (Exception sEx) {
                throw new ResourceProcessException((Throwable)sEx);
            }
        }
        catch (Exception ex) {
            this.maybeLogSevereException(ex);
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                this.logSevere("UIMA_CPM_unhandled_error__SEVERE", e.getLocalizedMessage());
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "handleErrors", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unexpected_exception__SEVERE", (Throwable)ex);
            }
            retry = false;
            ex.printStackTrace();
        }
        return retry;
    }

    private void invokeCasObjectCasProcessor(ProcessingContainer container, CasProcessor processor, Object[] aCasObjectList, ProcessTrace pTrTemp, boolean isCasObject) throws Exception {
        this.maybeLogMemoryFinest();
        this.maybeLogFinest("UIMA_CPM_invoke_cp_process__FINEST", container, processor);
        this.casList = new CAS[aCasObjectList.length];
        for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
            this.maybeLogFinest("UIMA_CPM_initialize_cas__FINEST", container);
            if (aCasObjectList[casIndex] == null) {
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casobjectlist_is_null__SEVERE", new Object[]{Thread.currentThread().getName(), container.getName(), String.valueOf(casIndex)});
                break;
            }
            if (!isCasObject) {
                this.convertCasDataToCasObject(casIndex, container.getName(), aCasObjectList);
            } else {
                this.casList[casIndex] = (CAS)aCasObjectList[casIndex];
            }
            if (processor instanceof AnalysisEngine) {
                this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
                this.threadState = 2005;
                pTrTemp.aggregate(((AnalysisEngine)processor).process(this.casList[casIndex]));
                this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
            } else {
                pTrTemp.startEvent(container.getName(), "Process", "");
                this.threadState = 2006;
                this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
                ((CasObjectProcessor)processor).processCas(this.casList[casIndex]);
                this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
            }
            pTrTemp.endEvent(container.getName(), "Process", "success");
        }
        aCasObjectList = this.casList;
    }

    private void convertCasDataToCasObject(int casIndex, String aContainerName, Object[] aCasObjectList) throws Exception {
        if (this.casCache == null || this.casCache[casIndex] == null) {
            this.casList[casIndex] = null;
            while (this.casList[casIndex] == null) {
                this.maybeLogFinest("UIMA_CPM_get_cas_from_pool__FINEST", aContainerName);
                this.casList[casIndex] = this.casPool.getCas(0L);
                this.maybeLogFinest("UIMA_CPM_got_cas_from_pool__FINEST", aContainerName);
            }
            if (this.casList[casIndex] != null) {
                this.maybeLogFinest("UIMA_CPM_call_cas_reset__FINEST", aContainerName);
                this.casList[casIndex].reset();
            }
        } else {
            this.casList[casIndex] = this.casCache[casIndex];
            this.casList[casIndex].reset();
            this.casCache[casIndex] = null;
        }
        this.mConverter.casDataToCasContainer((CasData)aCasObjectList[casIndex], this.casList[casIndex], true);
    }

    private void invokeCasDataCasProcessor(ProcessingContainer container, CasProcessor processor, Object[] aCasObjectList, ProcessTrace pTrTemp, boolean isCasObject, boolean retry) throws Exception {
        this.maybeLogFinest("UIMA_CPM_cas_data_processor__FINEST", container, processor);
        pTrTemp.startEvent(container.getName(), "Process", "");
        if (isCasObject) {
            CasData[] casDataObjects = new CasData[aCasObjectList.length];
            for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                casDataObjects[casIndex] = this.mConverter.casContainerToCasData((CAS)aCasObjectList[casIndex]);
                if ((CAS)aCasObjectList[casIndex] == null) continue;
                ((CAS)aCasObjectList[casIndex]).reset();
            }
            this.casCache = (CAS[])aCasObjectList;
            aCasObjectList = casDataObjects;
        }
        long byteCount = 0L;
        if (!retry) {
            for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                byteCount = this.getBytes(aCasObjectList[casIndex]);
                container.addBytesIn(byteCount);
            }
        }
        Object[] casObjects = aCasObjectList;
        long pStart = System.currentTimeMillis();
        if (!(casObjects instanceof CasData[])) {
            this.maybeLogFinest("UIMA_CPM_expected_casdata__FINEST", casObjects.getClass().getName());
        }
        this.maybeLogFinest("UIMA_CPM_call_process__FINEST", container, processor);
        casObjects = ((CasDataProcessor)processor).process((CasData[])casObjects);
        this.maybeLogFinest("UIMA_CPM_call_process_completed__FINEST", container, processor);
        long pEnd = System.currentTimeMillis();
        container.incrementTotalTime(pEnd - pStart);
        if (casObjects != null) {
            if (processor instanceof CasDataConsumer) {
                container.addBytesOut(byteCount);
            } else {
                aCasObjectList = casObjects;
                if (!retry) {
                    for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                        byteCount = this.getBytes(aCasObjectList[casIndex]);
                        container.addBytesOut(byteCount);
                    }
                }
            }
        }
        pTrTemp.endEvent(container.getName(), "Process", "success");
    }

    private void logCPM(Level level, String msgBundleId, Object[] args) {
        if (null == args) {
            args = zeroLengthObjectArray;
        }
        Object[] aa = new Object[args.length + 1];
        aa[0] = Thread.currentThread().getName();
        System.arraycopy(args, 0, aa, 1, args.length);
        UIMAFramework.getLogger(this.getClass()).logrb(level, thisClassName, "process", "org.apache.uima.collection.impl.cpm.cpm_messages", msgBundleId, aa);
    }

    private void maybeLogFinest(String msgBundleId) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId);
        }
    }

    private void logFinest(String msgBundleId) {
        this.logCPM(Level.FINEST, msgBundleId, null);
    }

    private void maybeLogFinest(String msgBundleId, String arg1) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, arg1);
        }
    }

    private void logFinest(String msgBundleId, String arg1) {
        this.logCPM(Level.FINEST, msgBundleId, new Object[]{arg1});
    }

    private void maybeLogFinest(String msgBundleId, String arg1, String arg2) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, arg1, arg2);
        }
    }

    private void logFinest(String msgBundleId, String arg1, String arg2) {
        this.logCPM(Level.FINEST, msgBundleId, new Object[]{arg1, arg2});
    }

    private void logFinest(String msgBundleId, String arg1, String arg2, String arg3) {
        this.logCPM(Level.FINEST, msgBundleId, new Object[]{arg1, arg2, arg3});
    }

    private void maybeLogFinest(String msgBundleId, ProcessingContainer container, CasProcessor processor) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, container.getName(), processor.getClass().getName());
        }
    }

    private void logFinest(String msgBundleId, ProcessingContainer container, CasProcessor processor) {
        this.logFinest(msgBundleId, container.getName(), processor.getClass().getName());
    }

    private void maybeLogFinest(String msgBundleId, ProcessingContainer container) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, container.getName());
        }
    }

    private void maybeLogFinest(String msgBundleId, CasProcessor processor) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, processor.getClass().getName());
        }
    }

    private void maybeLogFinest(String msgBundleId, ProcessingContainer container, CasProcessor processor, CAS[] casCache) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, container.getName(), processor.getClass().getName(), String.valueOf(casCache == null));
        }
    }

    private void maybeLogFinest(String msgBundleId, CAS[] casCache) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logFinest(msgBundleId, String.valueOf(casCache == null));
        }
    }

    private void maybeLogMemoryFinest() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            this.logMemoryFinest();
        }
    }

    private void logMemoryFinest() {
        this.logFinest("UIMA_CPM_show_memory__FINEST", String.valueOf(Runtime.getRuntime().totalMemory() / 1024L), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
    }

    private void logWarning(String msgBundleId) {
        this.logCPM(Level.WARNING, msgBundleId, null);
    }

    private void maybeLogWarning(String msgBundleId, String arg1, String arg2) {
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            this.logWarning(msgBundleId, arg1, arg2);
        }
    }

    private void logWarning(String msgBundleId, String arg1, String arg2) {
        this.logCPM(Level.WARNING, msgBundleId, new Object[]{arg1, arg2});
    }

    private void maybeLogSevere(String msgBundleId) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            this.logCPM(Level.SEVERE, msgBundleId, null);
        }
    }

    private void maybeLogSevere(String msgBundleId, String arg1) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            this.logSevere(msgBundleId, arg1);
        }
    }

    private void logSevere(String msgBundleId, String arg1) {
        this.logCPM(Level.SEVERE, msgBundleId, new Object[]{arg1});
    }

    private void maybeLogSevere(String msgBundleId, String arg1, String arg2) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            this.logSevere(msgBundleId, arg1, arg2);
        }
    }

    private void logSevere(String msgBundleId, String arg1, String arg2) {
        this.logCPM(Level.SEVERE, msgBundleId, new Object[]{arg1, arg2});
    }

    private void maybeLogSevere(String msgBundleId, String arg1, String arg2, String arg3) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            this.logSevere(msgBundleId, arg1, arg2, arg3);
        }
    }

    private void logSevere(String msgBundleId, String arg1, String arg2, String arg3) {
        this.logCPM(Level.SEVERE, msgBundleId, new Object[]{arg1, arg2, arg3});
    }

    private void maybeLogSevereException(Throwable e) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            String m = "Thread: " + Thread.currentThread().getName() + ", message: " + e.getLocalizedMessage();
            UIMAFramework.getLogger().log(Level.SEVERE, m, e);
        }
    }

    private void maybeLogFinestWorkQueue(String msgBundleId, BoundedWorkQueue workQueue) {
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            this.logFinest(msgBundleId, workQueue.getName(), String.valueOf(workQueue.getCurrentSize()));
        }
    }
}

