/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.Level;

public class DebugControlThread
implements Runnable {
    private static final String NOTFOUND = "NOT-FOUND";
    private String fileName = null;
    private volatile boolean stop = false;
    private int checkpointFrequency = 3000;
    private boolean pause = false;
    private final Object lockForPause = new Object();
    private CPMEngine cpm = null;

    public DebugControlThread(CPMEngine aCpm, String aFilename, int aCheckpointFrequency) {
        this.cpm = aCpm;
        this.fileName = aFilename;
        this.checkpointFrequency = aCheckpointFrequency;
    }

    public void start() throws RuntimeException {
        if (this.fileName == null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint_target_not_defined__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            throw new RuntimeException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_target_checkpoint_not_defined__WARNING", new Object[]{Thread.currentThread().getName()}));
        }
        if (this.cpm == null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_cpm_instance__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            throw new RuntimeException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_cpm__WARNING", new Object[]{Thread.currentThread().getName()}));
        }
        new Thread(this).start();
    }

    public void stop() {
        this.stop = true;
        this.doCheckpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop && this.cpm.isRunning()) {
            Object object = this.lockForPause;
            synchronized (object) {
                if (this.pause) {
                    try {
                        this.lockForPause.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            String command = this.doCheckpoint();
            if (!NOTFOUND.equals(command)) {
                this.interpretAndExecuteCommand(command);
            }
            try {
                Thread.sleep(this.checkpointFrequency);
            }
            catch (Exception exception) {}
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_thread_terminating__FINEST", new Object[]{Thread.currentThread().getName()});
        }
    }

    private void interpretAndExecuteCommand(String aCommand) {
        if (aCommand == null) {
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(aCommand, " ");
            if (st.hasMoreTokens()) {
                String cmd = aCommand.trim().toLowerCase();
                if ("die".equalsIgnoreCase(cmd)) {
                    this.cpm.stopIt();
                    this.deleteCheckpoint();
                } else if ("halt".equalsIgnoreCase(cmd)) {
                    this.cpm.stopIt();
                } else if (aCommand != null && aCommand.trim().startsWith("-D")) {
                    int pos = 0;
                    pos = aCommand.indexOf("=");
                    if (pos > -1) {
                        String key = aCommand.substring(2, pos);
                        String value = aCommand.substring(pos + 1);
                        if (value.trim().equalsIgnoreCase("off") && System.getProperties().containsKey(key)) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disabling_key__FINEST", new Object[]{Thread.currentThread().getName(), key, value});
                            }
                            System.getProperties().remove(key);
                        } else if (value.trim().equalsIgnoreCase("on") && !System.getProperties().containsKey(key)) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enabling_key__FINEST", new Object[]{Thread.currentThread().getName(), key, value});
                            }
                            System.getProperties().put(key, value);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCheckpoint() {
        try {
            File inF = null;
            inF = new File(this.fileName);
            if (inF.exists()) {
                inF.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        this.pause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lockForPause;
        synchronized (object) {
            if (this.pause) {
                try {
                    this.lockForPause.notify();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pause = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String doCheckpoint() {
        File inF = null;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_access_control_file__FINEST", new Object[]{Thread.currentThread().getName(), this.fileName});
        }
        inF = new File(this.fileName);
        String string = FileUtils.file2String((File)inF);
        Object var5_5 = null;
        try {
            inF.delete();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return string;
        catch (FileNotFoundException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_access_control_file_not_found__FINEST", new Object[]{Thread.currentThread().getName(), this.fileName});
            }
            String string2 = NOTFOUND;
            Object var5_6 = null;
            try {
                inF.delete();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var5_7 = null;
            {
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        inF.delete();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                inF.delete();
            }
            catch (Exception e2) {}
        }
        return null;
    }

    public boolean exists() {
        try {
            new File(this.fileName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

