/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.collection.base_cpm.CasDataCollectionReader;
import org.apache.uima.collection.base_cpm.SkipCasException;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPECasPool;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.ConsumerCasUtils;
import org.apache.uima.collection.impl.cpm.engine.EOFToken;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.ChunkMetadata;
import org.apache.uima.collection.impl.cpm.vinci.DATACasUtils;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.Progress;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class ArtifactProducer
extends Thread {
    public int threadState = 0;
    private CPECasPool casPool;
    private BoundedWorkQueue workQueue = null;
    private BaseCollectionReader collectionReader = null;
    private int readerFetchSize = 1;
    private CAS[] casList;
    private long entityCount = 0L;
    private long maxToProcess;
    private CPMEngine cpm = null;
    private Map cpmStatTable = null;
    private String[] lastDocId = new String[]{""};
    private long totalFetchTime = 0L;
    private UimaTimer timer = null;
    private ArrayList callbackListeners = null;
    private Hashtable timedoutDocs = new Hashtable();
    private boolean isRunning = false;
    private ProcessTrace globalSharedProcessTrace = null;

    public ArtifactProducer(CPMEngine acpm) {
        this.cpm = acpm;
        if (this.cpm != null) {
            this.callbackListeners = this.cpm.getCallbackListeners();
        }
    }

    public ArtifactProducer(CPMEngine acpm, CPECasPool aPool) {
        this.cpm = acpm;
        this.casPool = aPool;
        if (this.cpm != null) {
            this.callbackListeners = this.cpm.getCallbackListeners();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setUimaTimer(UimaTimer aTimer) {
        this.timer = aTimer;
    }

    public void setProcessTrace(ProcessTrace aProcTrace) {
        this.globalSharedProcessTrace = aProcTrace;
    }

    public long getCollectionReaderTotalFetchTime() {
        if (this.timer != null && this.totalFetchTime > 0L) {
            return this.totalFetchTime;
        }
        return -1L;
    }

    public void cleanup() {
        this.casPool = null;
        this.workQueue = null;
        this.collectionReader = null;
        this.casList = null;
        this.cpm = null;
        if (this.cpmStatTable != null) {
            this.cpmStatTable.clear();
            this.cpmStatTable = null;
        }
        this.lastDocId = null;
    }

    public void setNumEntitiesToProcess(long aNumToProcess) {
        this.maxToProcess = aNumToProcess;
    }

    public void setCollectionReader(BaseCollectionReader aCollectionReader) {
        this.collectionReader = aCollectionReader;
        if (this.collectionReader.getProcessingResourceMetaData().getConfigurationParameterSettings().getParameterValue("fetchSize") != null) {
            this.readerFetchSize = (Integer)this.collectionReader.getProcessingResourceMetaData().getConfigurationParameterSettings().getParameterValue("fetchSize");
        }
    }

    public void setWorkQueue(BoundedWorkQueue aQueue) {
        this.workQueue = aQueue;
    }

    public void setCPMStatTable(Map aStatTable) {
        this.cpmStatTable = aStatTable;
    }

    private boolean endOfProcessingReached() {
        if (this.maxToProcess == -1L) {
            return false;
        }
        if (this.maxToProcess == 0L) {
            return true;
        }
        return this.entityCount >= this.maxToProcess;
    }

    public void fillQueue() throws Exception {
        Object[] casObjectList = new Object[1];
        long capacity = this.workQueue.getCapacity();
        if (capacity > this.maxToProcess) {
            capacity = this.maxToProcess;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_reset_queue_size__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(capacity)});
            }
        }
        try {
            int i = 0;
            while ((long)i < capacity) {
                if (this.collectionReader.hasNext()) {
                    casObjectList = this.readNext(this.readerFetchSize);
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enqueue_cas_bundle__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(casObjectList.length)});
                    }
                    this.entityCount += (long)casObjectList.length;
                    this.workQueue.enqueue(casObjectList);
                    if (this.entityCount > this.maxToProcess) break;
                }
                ++i;
            }
            if (this.cpmStatTable != null) {
                Progress[] progress = this.collectionReader.getProgress();
                if (progress != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cr_progress__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(progress[0].getCompleted())});
                }
                this.cpmStatTable.put("COLLECTION_READER_PROGRESS", progress);
            }
        }
        catch (Exception e) {
            if (casObjectList == null) {
                this.notifyListeners(null, e);
            } else {
                for (int i = 0; casObjectList != null && i < casObjectList.length; ++i) {
                    if (casObjectList[i] != null && casObjectList[i] instanceof CAS) {
                        this.notifyListeners((CAS)casObjectList[i], e);
                        this.casPool.releaseCas(this.casList[i]);
                        this.casList[i] = null;
                        continue;
                    }
                    this.notifyListeners(null, e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readNext(int fetchSize) throws IOException, CollectionException {
        long start;
        Object[] casObjects;
        block50: {
            ProcessTrace_impl localTrace;
            block53: {
                block51: {
                    boolean success;
                    block52: {
                        localTrace = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
                        success = false;
                        casObjects = null;
                        this.threadState = 1000;
                        start = 0L;
                        if (this.timer != null) {
                            start = this.timer.getTimeInMillis();
                        }
                        boolean eventStarted = false;
                        if (!(this.collectionReader instanceof CollectionReader)) break block52;
                        this.casList = new CAS[fetchSize];
                        for (int i = 0; i < fetchSize; ++i) {
                            ProcessTrace processTrace;
                            Object var16_20;
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cr_fetch_new_cas__FINEST", new Object[]{Thread.currentThread().getName()});
                            }
                            this.threadState = 1001;
                            while (this.cpm.isRunning() && (this.casList[i] = this.casPool.getCas(0L)) == null) {
                            }
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cr_check_cas_for_null__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casList[i] == null)});
                            }
                            if (!this.cpm.isRunning()) {
                                if (this.timer != null) {
                                    this.totalFetchTime += this.timer.getTimeInMillis() - start;
                                }
                                for (int listCounter = 0; this.casList != null && this.casList[i] != null && listCounter < this.casList.length; ++listCounter) {
                                    this.casPool.releaseCas(this.casList[listCounter]);
                                }
                                if (this.cpmStatTable != null) {
                                    Progress[] progress = this.collectionReader.getProgress();
                                    this.cpmStatTable.put("COLLECTION_READER_PROGRESS", progress);
                                    this.cpmStatTable.put("COLLECTION_READER_TIME", this.totalFetchTime);
                                }
                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_in_shutdown_state__FINEST", new Object[]{Thread.currentThread().getName()});
                                }
                                return null;
                            }
                            if (this.casList[i] == null) {
                                return null;
                            }
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_new_cas__FINEST", new Object[]{Thread.currentThread().getName()});
                            }
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cas_reset__FINEST", new Object[]{Thread.currentThread().getName()});
                            }
                            this.casList[i].reset();
                            CasInitializer casIni = ((CollectionReader)this.collectionReader).getCasInitializer();
                            Capability[] capabilities = casIni != null ? casIni.getProcessingResourceMetaData().getCapabilities() : ((CollectionReader)this.collectionReader).getProcessingResourceMetaData().getCapabilities();
                            boolean sofaUnaware = true;
                            for (int j = 0; j < capabilities.length; ++j) {
                                if (capabilities[j].getOutputSofas().length <= 0) continue;
                                sofaUnaware = false;
                                break;
                            }
                            this.threadState = 1003;
                            UimaContextAdmin context = ((CollectionReader)this.collectionReader).getUimaContextAdmin();
                            this.casList[i].setCurrentComponentInfo(context.getComponentInfo());
                            try {
                                if (sofaUnaware) {
                                    String absSofaName = context.getComponentInfo().mapToSofaID("_InitialView");
                                    if (!"_InitialView".equals(absSofaName)) {
                                        this.casList[i].createView("_InitialView");
                                    }
                                    CAS view = this.casList[i].getView("_InitialView");
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                                    }
                                    localTrace.startEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "");
                                    eventStarted = true;
                                    ((CollectionReader)this.collectionReader).getNext(view);
                                    localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "success");
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next_finished__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                                    }
                                } else {
                                    CASImpl baseCas = ((CASImpl)this.casList[i]).getBaseCAS();
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                                    }
                                    localTrace.startEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "");
                                    eventStarted = true;
                                    ((CollectionReader)this.collectionReader).getNext((CAS)baseCas);
                                    localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "success");
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next_finished__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                                    }
                                }
                                success = true;
                                var16_20 = null;
                            }
                            catch (Throwable throwable) {
                                var16_20 = null;
                                this.casList[i].setCurrentComponentInfo(null);
                                if (eventStarted) {
                                    if (!success) {
                                        localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "failure");
                                    }
                                    processTrace = this.globalSharedProcessTrace;
                                    synchronized (processTrace) {
                                        this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                    }
                                }
                                throw throwable;
                            }
                            this.casList[i].setCurrentComponentInfo(null);
                            if (!eventStarted) continue;
                            if (!success) {
                                localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "failure");
                            }
                            processTrace = this.globalSharedProcessTrace;
                            synchronized (processTrace) {
                                this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                continue;
                            }
                        }
                        casObjects = this.casList;
                        if (casObjects != null && casObjects.length > 0) {
                            try {
                                if (((CASImpl)this.casList[0]).isBackwardCompatibleCas()) {
                                    CAS view = this.casList[0].getView("_InitialView");
                                    this.lastDocId[0] = ConsumerCasUtils.getStringFeatValue(view, "uima.cpm.DocumentMetadata", "ID");
                                    break block50;
                                }
                                this.lastDocId[0] = "";
                            }
                            catch (Exception e) {
                                this.lastDocId[0] = "";
                            }
                        }
                        break block50;
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next__FINEST", new Object[]{Thread.currentThread().getName(), "CasData"});
                    }
                    localTrace.startEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "");
                    try {
                        casObjects = ((CasDataCollectionReader)this.collectionReader).getNext(fetchSize);
                        success = true;
                        Object var20_25 = null;
                        if (success) break block51;
                    }
                    catch (Throwable throwable) {
                        Object var20_26 = null;
                        if (!success) {
                            localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "failure");
                        } else {
                            localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "success");
                        }
                        ProcessTrace processTrace = this.globalSharedProcessTrace;
                        synchronized (processTrace) {
                            this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                        }
                        throw throwable;
                    }
                    localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "failure");
                    break block53;
                }
                localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "success");
            }
            ProcessTrace processTrace = this.globalSharedProcessTrace;
            synchronized (processTrace) {
                this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next_finished__FINEST", new Object[]{Thread.currentThread().getName(), "CasData"});
            }
            if (casObjects != null && casObjects.length > 0) {
                this.lastDocId = DATACasUtils.getFeatureStructureValues((CasData)casObjects[0], "uima.cpm.DocumentMetadata", "ID");
            }
        }
        if (this.timer != null) {
            this.totalFetchTime += this.timer.getTimeInMillis() - start;
        }
        if (this.cpmStatTable != null) {
            Progress[] progress = this.collectionReader.getProgress();
            this.cpmStatTable.put("COLLECTION_READER_PROGRESS", progress);
            this.cpmStatTable.put("COLLECTION_READER_TIME", this.totalFetchTime);
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_return_cases_from_cr__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
        }
        return casObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean crEventCompleted = false;
        if (!this.cpm.isRunning()) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cpm_not_running__WARNING", new Object[]{Thread.currentThread().getName()});
            return;
        }
        Object[] casObjectList = null;
        if (this.endOfProcessingReached()) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cr_done_producing__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            this.placeEOFToken();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_eof_marker_enqueued__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            return;
        }
        this.isRunning = true;
        ProcessTrace_impl localTrace = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
        while (this.cpm.isRunning()) {
            block49: {
                ProcessTrace processTrace;
                Object var8_11;
                block47: {
                    block48: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        this.casList = null;
                                        casObjectList = null;
                                        Object object = this.cpm.lockForPause;
                                        synchronized (object) {
                                            if (this.cpm.isPaused()) {
                                                try {
                                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pausing_cr__FINEST", new Object[]{Thread.currentThread().getName()});
                                                    }
                                                    this.cpm.lockForPause.wait();
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                                if (!this.cpm.isRunning()) {
                                                    break;
                                                }
                                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_resume_cr__FINEST", new Object[]{Thread.currentThread().getName()});
                                                }
                                            }
                                        }
                                        try {
                                            try {
                                                block51: {
                                                    block50: {
                                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_hasnext__FINEST", new Object[]{Thread.currentThread().getName()});
                                                        }
                                                        this.threadState = 1004;
                                                        localTrace.startEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "");
                                                        crEventCompleted = false;
                                                        if (!this.collectionReader.hasNext()) break block50;
                                                        localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "success");
                                                        crEventCompleted = true;
                                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_get_cas_from_cr__FINEST", new Object[]{Thread.currentThread().getName()});
                                                        }
                                                        if ((casObjectList = this.readNext(this.readerFetchSize)) != null) {
                                                            if (casObjectList instanceof CAS[]) {
                                                                boolean releasedCas = false;
                                                                for (int i = 0; i < casObjectList.length && casObjectList[i] != null; ++i) {
                                                                    ChunkMetadata meta = CPMUtils.getChunkMetadata((CAS)casObjectList[i]);
                                                                    if (meta == null || !this.timedoutDocs.containsKey(meta.getDocId())) continue;
                                                                    this.notifyListeners(this.casList[i], (Exception)new ResourceProcessException((Throwable)new SkipCasException("Dropping CAS due chunk Timeout. Doc Id::" + meta.getDocId() + " Sequence:" + meta.getSequence())));
                                                                    this.casPool.releaseCas((CAS)casObjectList[i]);
                                                                    releasedCas = true;
                                                                }
                                                                if (releasedCas) {
                                                                    var8_11 = null;
                                                                    processTrace = this.globalSharedProcessTrace;
                                                                    break block43;
                                                                }
                                                            }
                                                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_place_cas_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(casObjectList.length)});
                                                            }
                                                            if (!this.cpm.isRunning() && (this.cpm.isRunning() || this.cpm.isHardKilled())) break block44;
                                                            this.threadState = 1005;
                                                            this.workQueue.enqueue(casObjectList);
                                                            this.threadState = 1006;
                                                            this.entityCount += (long)casObjectList.length;
                                                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_placed_cas_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(casObjectList.length)});
                                                            }
                                                            break block51;
                                                        } else {
                                                            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block45;
                                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_cr_thread__FINEST", new Object[]{Thread.currentThread().getName()});
                                                            break block45;
                                                        }
                                                    }
                                                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block46;
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_processed_all__FINEST", new Object[]{Thread.currentThread().getName()});
                                                    break block46;
                                                }
                                                if (!this.endOfProcessingReached()) break block47;
                                                this.threadState = 1010;
                                                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block48;
                                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_processing__FINEST", new Object[]{Thread.currentThread().getName()});
                                                break block48;
                                            }
                                            catch (Exception e) {
                                                if (!crEventCompleted) {
                                                    localTrace.endEvent(this.collectionReader.getProcessingResourceMetaData().getName(), "Process", "failure");
                                                }
                                                if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                                                    UIMAFramework.getLogger(this.getClass()).log(Level.FINER, e.getMessage(), (Throwable)e);
                                                }
                                                if (this.casList == null) {
                                                    this.notifyListeners(null, e);
                                                } else {
                                                    for (int i = 0; this.casList != null && i < this.casList.length; ++i) {
                                                        if (this.casList[i] != null) {
                                                            this.notifyListeners(this.casList[i], e);
                                                            this.casPool.releaseCas(this.casList[i]);
                                                            this.casList[i] = null;
                                                        } else {
                                                            this.notifyListeners(null, e);
                                                        }
                                                        this.casList = null;
                                                    }
                                                }
                                                var8_11 = null;
                                                processTrace = this.globalSharedProcessTrace;
                                                synchronized (processTrace) {
                                                    this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                                }
                                                localTrace.clear();
                                                break block49;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            var8_11 = null;
                                            processTrace = this.globalSharedProcessTrace;
                                            synchronized (processTrace) {
                                                this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                            }
                                            localTrace.clear();
                                            throw throwable;
                                        }
                                    }
                                    synchronized (processTrace) {
                                        this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                    }
                                    localTrace.clear();
                                    continue;
                                }
                                var8_11 = null;
                                processTrace = this.globalSharedProcessTrace;
                                synchronized (processTrace) {
                                    this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                                }
                                localTrace.clear();
                                break;
                            }
                            var8_11 = null;
                            processTrace = this.globalSharedProcessTrace;
                            synchronized (processTrace) {
                                this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                            }
                            localTrace.clear();
                            break;
                        }
                        var8_11 = null;
                        processTrace = this.globalSharedProcessTrace;
                        synchronized (processTrace) {
                            this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                        }
                        localTrace.clear();
                        break;
                    }
                    var8_11 = null;
                    processTrace = this.globalSharedProcessTrace;
                    synchronized (processTrace) {
                        this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                    }
                    localTrace.clear();
                    break;
                }
                var8_11 = null;
                processTrace = this.globalSharedProcessTrace;
                synchronized (processTrace) {
                    this.globalSharedProcessTrace.aggregate((ProcessTrace)localTrace);
                }
                localTrace.clear();
            }
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cpm_running_status__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.cpm.isRunning())});
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cpm_running_status__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.cpm.isRunning())});
        }
        this.placeEOFToken();
        this.isRunning = false;
        Thread.currentThread().interrupt();
    }

    private void notifyListeners(CAS aCas, Exception anException) {
        for (int i = 0; this.callbackListeners != null && i < this.callbackListeners.size(); ++i) {
            StatusCallbackListener statCL = (StatusCallbackListener)this.callbackListeners.get(i);
            if (statCL == null) continue;
            ProcessTrace_impl prTrace = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
            EntityProcessStatusImpl aEntityProcStatus = new EntityProcessStatusImpl((ProcessTrace)prTrace);
            aEntityProcStatus.addEventStatus("Collection Reader Failure", "failed", anException);
            CPMEngine.callEntityProcessCompleteWithCAS(statCL, aCas, aEntityProcStatus);
        }
    }

    private void placeEOFToken() {
        block4: {
            try {
                Object[] eofToken = new Object[]{new EOFToken()};
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enqueue_eof_token__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.cpm.isRunning())});
                }
                this.workQueue.enqueue(eofToken);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_enqueue_eof_token__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.cpm.isRunning())});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break block4;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "", (Throwable)e);
            }
        }
    }

    public String getLastDocId() {
        if (this.lastDocId != null && this.lastDocId.length > 0) {
            return this.lastDocId[0];
        }
        return "N/A";
    }

    public void invalidate(CAS[] aCasList) {
        for (int i = 0; aCasList != null && i < aCasList.length && aCasList[i] != null; ++i) {
            ChunkMetadata meta = CPMUtils.getChunkMetadata(aCasList[i]);
            if (meta == null || meta.getSequence() <= 0 || this.timedoutDocs.containsKey(meta.getDocId())) continue;
            this.timedoutDocs.put(meta.getDocId(), meta.getDocId());
        }
    }
}

