/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

@Deprecated
public class AnnotationWriter
extends CasConsumer_ImplBase
implements CasConsumer {
    private File outFile;
    private OutputStreamWriter fileWriter;
    private String[] tofs;
    private boolean reconfig = false;
    private static final String featureOnlyKey = "feature";

    public void initialize() throws ResourceInitializationException {
        String oPath = (String)this.getUimaContext().getConfigParameterValue("outputFile");
        if (oPath == null) {
            this.reconfig = true;
        } else {
            this.outFile = new File(oPath);
            if (this.outFile.getParentFile() != null && !this.outFile.getParentFile().exists() && !this.outFile.getParentFile().mkdirs()) {
                throw new ResourceInitializationException("resource_data_not_valid", new Object[]{oPath, "outputFile"});
            }
            try {
                this.fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile, false), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
        this.tofs = (String[])this.getUimaContext().getConfigParameterValue("AnnotationTypes");
        if (this.tofs != null) {
            Arrays.sort(this.tofs);
        }
    }

    private HashMap processTofs(CAS aCAS, String[] someTofs) {
        HashMap types = new HashMap(10);
        for (int i = 0; i < someTofs.length; ++i) {
            Type type = aCAS.getTypeSystem().getType(someTofs[i]);
            if (type == null) {
                Feature fs;
                int index = someTofs[i].indexOf(":");
                if (index == -1) continue;
                String typename = someTofs[i].substring(0, index);
                Type typeKey = aCAS.getTypeSystem().getType(typename);
                Object obj = types.get(typeKey);
                if (obj == null) {
                    ArrayList<String> list = new ArrayList<String>(10);
                    fs = aCAS.getTypeSystem().getFeatureByFullName(someTofs[i]);
                    list.add(0, featureOnlyKey);
                    list.add((String)fs);
                    types.put(typeKey, list);
                    continue;
                }
                ArrayList vec = (ArrayList)obj;
                fs = aCAS.getTypeSystem().getFeatureByFullName(someTofs[i]);
                vec.add(fs);
                continue;
            }
            if (types.containsKey(type)) {
                ArrayList featureList = (ArrayList)types.get(type);
                if (featureList.size() <= 0 || !featureList.get(0).equals(featureOnlyKey)) continue;
                featureList.remove(0);
                continue;
            }
            types.put(type, new ArrayList(10));
        }
        return types;
    }

    public synchronized void processCas(CAS aCAS) throws ResourceProcessException {
        if (this.reconfig) {
            throw new ResourceProcessException("config_setting_absent", new Object[]{"outputFile"});
        }
        LowLevelCAS ll_cas = aCAS.getLowLevelCAS();
        LowLevelTypeSystem ll_typeSystem = ll_cas.ll_getTypeSystem();
        HashMap types = this.processTofs(aCAS, this.tofs);
        try {
            FSIterator typeIterator = aCAS.getAnnotationIndex().iterator();
            typeIterator.moveToFirst();
            while (typeIterator.isValid()) {
                for (Type currentType : types.keySet()) {
                    boolean isFeatureOnly = false;
                    ArrayList featureList = (ArrayList)types.get(currentType);
                    if (featureList.size() > 0 && featureList.get(0).equals(featureOnlyKey)) {
                        featureList.remove(0);
                        isFeatureOnly = true;
                    }
                    Feature[] features = featureList.toArray(new Feature[0]);
                    AnnotationFS annot = (AnnotationFS)typeIterator.get();
                    if (annot.getType().getName() != currentType.getName()) continue;
                    boolean firstFeature = true;
                    String span = annot.getCoveredText();
                    if (!isFeatureOnly) {
                        this.fileWriter.write(annot.getType().getShortName() + "(" + annot.getBegin() + "," + annot.getEnd() + "): " + span);
                    } else {
                        this.fileWriter.write(annot.getType().getShortName() + ": ");
                    }
                    block10: for (int f = 0; f < features.length; ++f) {
                        if (firstFeature) {
                            this.fileWriter.write("  { ");
                            firstFeature = false;
                        } else {
                            this.fileWriter.write(", ");
                        }
                        Feature fs = features[f];
                        int typeClass = ll_cas.ll_getTypeClass(ll_typeSystem.ll_getCodeForType(fs.getRange()));
                        this.fileWriter.write(fs.getShortName() + "=");
                        switch (typeClass) {
                            case 2: {
                                this.fileWriter.write(Float.toString(annot.getFloatValue(fs)));
                                continue block10;
                            }
                            case 1: {
                                this.fileWriter.write(Integer.toString(annot.getIntValue(fs)));
                                continue block10;
                            }
                            case 3: {
                                String value = annot.getStringValue(fs);
                                if (value != null) {
                                    this.fileWriter.write(value);
                                    continue block10;
                                }
                                this.fileWriter.write("null");
                                continue block10;
                            }
                            case 8: {
                                FeatureStructure fStruct = annot.getFeatureValue(fs);
                                if (fStruct != null) {
                                    this.fileWriter.write(fStruct.toString());
                                    continue block10;
                                }
                                this.fileWriter.write("null");
                            }
                        }
                    }
                    if (!firstFeature) {
                        this.fileWriter.write(" }");
                    }
                    this.fileWriter.write(System.getProperty("line.separator"));
                }
                typeIterator.moveToNext();
            }
            this.fileWriter.flush();
        }
        catch (Exception ex) {
            throw new ResourceProcessException((Throwable)ex);
        }
    }

    public void batchProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
    }

    public void collectionProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    public void reconfigure() throws ResourceConfigurationException {
        this.reconfig = false;
        super.reconfigure();
        String oPath = (String)this.getUimaContext().getConfigParameterValue("outputFile");
        File oFile = new File(oPath);
        if (!oFile.equals(this.outFile)) {
            this.outFile = oFile;
            try {
                if (this.fileWriter != null) {
                    this.fileWriter.close();
                }
                if (oFile.getParentFile() != null && !oFile.getParentFile().exists() && !oFile.getParentFile().mkdirs()) {
                    throw new ResourceConfigurationException("resource_data_not_valid", new Object[]{oPath, "outputFile"});
                }
                this.fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(oFile, false), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ResourceConfigurationException();
            }
        }
        this.tofs = (String[])this.getUimaContext().getConfigParameterValue("AnnotationTypes");
        if (this.tofs != null) {
            Arrays.sort(this.tofs);
        }
    }

    public void destroy() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

