/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.test.junit_extension.FileCompare;
import org.apache.uima.test.junit_extension.JUnitExtension;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.junit.Assert;

public class AnnotatorTester {
    private File descFile;
    private AnalysisEngine ae;
    private ResourceManager mgr;

    public AnnotatorTester(String descFilePath) throws Exception {
        this.descFile = new File(descFilePath);
        this.mgr = UIMAFramework.newDefaultResourceManager();
        this.setup();
    }

    public AnnotatorTester(File descFile) throws Exception {
        this.descFile = descFile;
        this.mgr = UIMAFramework.newDefaultResourceManager();
        this.setup();
    }

    public AnnotatorTester(String descFilePath, ResourceManager mgr) throws Exception {
        this.descFile = new File(descFilePath);
        this.mgr = mgr;
        this.setup();
    }

    private void setup() throws Exception {
        this.ae = null;
        XMLInputSource in = new XMLInputSource(this.descFile);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, (ResourceManager)this.mgr, null);
    }

    public void changeParameterSetting(String groupName, String paramName, Object paramValue) throws ResourceConfigurationException {
        if (groupName == null) {
            this.ae.setConfigParameterValue(paramName, paramValue);
        } else {
            this.ae.setConfigParameterValue(groupName, paramName, paramValue);
        }
        this.ae.reconfigure();
    }

    public void changeDelegateParameterSetting(String delegeteKey, String groupName, String paramName, Object paramValue) throws InvalidXMLException, ResourceInitializationException, IOException {
        AnalysisEngineDescription aeSpecifier = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.descFile));
        Map delegates = aeSpecifier.getDelegateAnalysisEngineSpecifiers();
        if (delegates.containsKey(delegeteKey)) {
            AnalysisEngineDescription delegate = (AnalysisEngineDescription)delegates.get(delegeteKey);
            if (groupName == null) {
                delegate.getMetaData().getConfigurationParameterSettings().setParameterValue(paramName, paramValue);
            } else {
                delegate.getMetaData().getConfigurationParameterSettings().setParameterValue(groupName, paramName, paramValue);
            }
        }
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aeSpecifier, (ResourceManager)this.mgr, null);
    }

    public static AnalysisEngine doConfigurationTest(String configDescFilePath) throws Exception {
        AnalysisEngine ae = null;
        XMLInputSource in = new XMLInputSource(configDescFilePath);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, null, null);
        CAS cas = ae.newCAS();
        cas.setDocumentText("This is a simple text to check if the configuration works");
        cas.setDocumentLanguage("en");
        ae.process(cas);
        return ae;
    }

    public CAS createCAS() throws Exception {
        return this.ae.newCAS();
    }

    public CAS performTest(String text, String language) throws Exception {
        CAS cas = this.ae.newCAS();
        cas.setDocumentText(text);
        cas.setDocumentLanguage(language);
        this.ae.process(cas);
        return cas;
    }

    public CAS performTest(CAS cas) throws Exception {
        this.ae.process(cas);
        return cas;
    }

    public static CAS performTest(String descFilePath, String text, String language) throws Exception {
        AnalysisEngine ae = null;
        XMLInputSource in = new XMLInputSource(descFilePath);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, null, null);
        CAS cas = ae.newCAS();
        cas.setDocumentText(text);
        cas.setDocumentLanguage(language);
        ae.process(cas);
        return cas;
    }

    public static CAS getCASfromXCAS(File tsFile, File xcasFile) throws Exception {
        XMLizable tsDescriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(tsFile));
        TypeSystemDescription tsDesc = (TypeSystemDescription)tsDescriptor;
        CAS cas = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
        SAXParser parser = XMLUtils.createSAXParserFactory().newSAXParser();
        XCASDeserializer xcasDeserializer = new XCASDeserializer(cas.getTypeSystem());
        parser.parse(xcasFile, xcasDeserializer.getXCASHandler(cas));
        return cas;
    }

    public static String readFileContent(File file, String encoding) throws Exception {
        return FileUtils.file2String((File)file, (String)encoding);
    }

    public static void checkResult(CAS cas, String[] AnnotationTypes, File refFile, File testFile) throws Exception {
        testFile.delete();
        testFile.createNewFile();
        XMLInputSource in = new XMLInputSource(JUnitExtension.getURL((String)"AnnotationWriter.xml"));
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        CasConsumer consumer = UIMAFramework.produceCasConsumer((ResourceSpecifier)specifier);
        consumer.setConfigParameterValue("AnnotationTypes", (Object)AnnotationTypes);
        consumer.setConfigParameterValue("outputFile", (Object)testFile.getAbsolutePath());
        consumer.reconfigure();
        consumer.processCas(cas);
        consumer.destroy();
        boolean isIdentical = FileCompare.compare((File)refFile, (File)testFile);
        if (isIdentical) {
            testFile.delete();
        }
        Assert.assertTrue((boolean)isIdentical);
    }
}

