/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UimaBootstrap {
    private static boolean suppressClassPathDisplay;
    private static FilenameFilter jarFilter;

    public static void main(String[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MalformedURLException, IOException, URISyntaxException {
        if (args == null || args.length == 0) {
            System.err.println("Usage: specify -Dorg.apache.uima.jarpath=XXXX, where");
            System.err.println("  XXXX is a string of file paths to directories or jar files, separated using the proper path separator character.");
            System.err.println("  For directories, all of the JARs found in these directories will be added to the classpath.");
            System.err.println("  If the directory has no Jars, then it is put in the class path directly.");
            System.err.println("  Normal \"parent-first\" delegation is done.");
            System.err.println("  The first argument is taken to be the name of the class whose \"main\" method will be called and passed the rest of the arguments.");
            System.err.println(" Set -DUimaBootstrapSuppressClassPathDisplay to suppress the display of the resulting classpath");
            System.exit(1);
        }
        suppressClassPathDisplay = System.getProperty("UimaBootstrapSuppressClassPathDisplay") != null;
        URL[] urls = UimaBootstrap.getUrls();
        UimaBootstrap.addUrlsToSystemLoader(urls);
        Class<?> classToLaunch = null;
        try {
            classToLaunch = ClassLoader.getSystemClassLoader().loadClass(args[0]);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find class to launch");
            System.exit(1);
        }
        Method mainMethod = classToLaunch.getMethod("main", String[].class);
        int args2length = args.length - 1;
        String[] args2 = new String[args2length];
        System.arraycopy(args, 1, args2, 0, args2length);
        mainMethod.invoke(null, new Object[]{args2});
    }

    private static URL[] getUrls() throws MalformedURLException, IOException, URISyntaxException {
        String[] jpaths;
        String jps = System.getProperty("org.apache.uima.jarpath");
        if (null == jps) {
            System.err.println("Missing the -Dorg.apache.uima.jarpath=XXXX property");
            System.exit(1);
        }
        if (!suppressClassPathDisplay) {
            System.out.println("UimaBootstrap ClassPath:");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String p : jpaths = jps.split(File.pathSeparator)) {
            UimaBootstrap.addUrlsFromPath(p, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addUrlsFromPath(String p, List<URL> urls) throws MalformedURLException, IOException, URISyntaxException {
        File pf = new File(p);
        if (pf.isDirectory()) {
            File[] jars = pf.listFiles(jarFilter);
            if (jars.length == 0) {
                UimaBootstrap.add(urls, pf);
            } else {
                for (File f : jars) {
                    UimaBootstrap.add(urls, f);
                }
            }
        } else if (p.toLowerCase().endsWith(".jar")) {
            UimaBootstrap.add(urls, pf);
        }
    }

    private static void add(List<URL> urls, File cp) throws MalformedURLException {
        URL url = cp.toURI().toURL();
        if (!suppressClassPathDisplay) {
            System.out.format(" %s%n", url.toString());
        }
        urls.add(url);
    }

    private static void addUrlsToSystemLoader(URL[] urls) throws IOException {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL url : urls) {
                method.invoke((Object)systemClassLoader, url);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    static {
        jarFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                name = name.toLowerCase();
                return name.endsWith(".jar");
            }
        };
    }
}

