/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import java.io.File;
import java.util.Properties;
import org.apache.uima.resourceSpecifier.AnalysisEngineDeploymentDescriptionDocument;
import org.apache.uima.resourceSpecifier.AnalysisEngineDeploymentDescriptionType;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.Deployment;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.UimaASDeploymentDescriptor;
import org.apache.uima.resourceSpecifier.factory.impl.DeploymentImpl;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.util.Assert;

public class UimaASDeploymentDescriptorImpl
implements UimaASDeploymentDescriptor {
    protected AnalysisEngineDeploymentDescriptionDocument dd;
    protected AnalysisEngineDeploymentDescriptionType dt;
    protected Deployment deployment;

    public UimaASDeploymentDescriptorImpl(AnalysisEngineDeploymentDescriptionDocument dd, ServiceContext context, DelegateConfiguration ... delegateConfigurations) {
        this.dd = dd;
        Assert.notNull((Object)dd);
        this.dt = dd.addNewAnalysisEngineDeploymentDescription();
        this.setName(context.getName());
        this.setDescription(context.getDescription());
        this.deployment = new DeploymentImpl(this.dt.addNewDeployment(), context, delegateConfigurations);
    }

    public void setName(String name) {
        Assert.notNull((Object)this.dt);
        this.dt.setName(name);
    }

    public String getName() {
        Assert.notNull((Object)this.dt);
        return this.dt.getName();
    }

    public void setDescription(String description) {
        Assert.notNull((Object)this.dt);
        this.dt.setDescription(description);
    }

    public String getDescription() {
        Assert.notNull((Object)this.dt);
        return this.dt.getDescription();
    }

    public Deployment getDeployment() {
        Assert.notNull((Object)this.deployment);
        return this.deployment;
    }

    public void save(File file) throws Exception {
        Assert.notNull((Object)this.dd);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        opts.setUseDefaultNamespace();
        this.dd.save(file, opts);
    }

    public String toXML() {
        Assert.notNull((Object)this.dd);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        opts.setUseDefaultNamespace();
        return this.dd.xmlText(opts);
    }

    protected static class DeploymentContext {
        private static Properties contextProperties = null;

        protected DeploymentContext() {
        }

        protected static Properties getContext() {
            if (contextProperties == null) {
                contextProperties = new Properties();
            }
            return contextProperties;
        }

        protected static void setContext(Properties props) {
            contextProperties = props;
        }
    }
}

