/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.delegate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.util.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Delegate {
    public static final int OK_STATE = 1;
    public static final int TIMEOUT_STATE = 2;
    public static final int DISABLED_STATE = 3;
    private static final Class CLASS_NAME = Delegate.class;
    protected String delegateKey;
    private int state = 1;
    private List<DelegateEntry> outstandingCasList = new ArrayList<DelegateEntry>();
    private Endpoint endpoint;
    private DelegateTimer timer;
    private DelegateTimer getMetaTimer;
    private Object timerLock = new Object();
    private Object getMetaTimerLock = new Object();
    private long casProcessTimeout = 0L;
    private long getMetaTimeout = 0L;
    private long cpcTimeout = 0L;
    private Object stateMux = new Object();
    protected List<DelegateEntry> pendingDispatchList = new ArrayList<DelegateEntry>();
    private volatile boolean awaitingPingReply;
    private volatile boolean concurrentConsumersOnReplyQueue;
    private Endpoint notificationEndpoint = null;

    public abstract void handleError(Exception var1, ErrorContext var2);

    public abstract String getComponentName();

    public abstract String enrichProcessCASTimeoutMessage(int var1, String var2, long var3, String var5);

    public Endpoint getNotificationEndpoint() {
        return this.notificationEndpoint;
    }

    public void setNotificationEndpoint(Endpoint notificationEndpoint) {
        this.notificationEndpoint = notificationEndpoint;
    }

    public boolean isAwaitingPingReply() {
        return this.awaitingPingReply;
    }

    public void setAwaitingPingReply() {
        this.awaitingPingReply = true;
    }

    public void resetAwaitingPingReply() {
        this.awaitingPingReply = false;
    }

    public String getKey() {
        return this.delegateKey;
    }

    public void setEndpoint(Endpoint anEndpoint) {
        this.endpoint = anEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void cancelTimerForCasOrPurge(String casReferenceId) {
        if (this.timer != null && this.timer.getTimerCasId() != null && this.timer.getTimerCasId().equals(casReferenceId)) {
            this.cancelDelegateTimer();
            this.restartTimerForOldestCasInOutstandingList();
        } else {
            this.removeCasFromOutstandingList(casReferenceId);
            this.removeCasFromPendingDispatchList(casReferenceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTimerForOldestCasInOutstandingList() {
        DelegateEntry entry = null;
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            if (!this.outstandingCasList.isEmpty() && (entry = this.outstandingCasList.get(0)) != null) {
                this.restartTimerForCas(entry);
            }
        }
    }

    private void restartTimerForCas(DelegateEntry entry) {
        if (this.getCasProcessTimeout() > 0L) {
            entry.incrementRetryCount();
            this.startDelegateTimer(entry.getCasReferenceId(), 2000);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "restartTimerForCas", "uimaee_messages", "UIMAEE_restart_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, entry.getCasReferenceId(), this.getCasProcessTimeout()});
            }
            this.dumpPendingReplyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDelegateCasIdsPendingReply() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            String[] casIdsPendingReply = new String[this.outstandingCasList.size()];
            int inx = 0;
            for (DelegateEntry entry : this.outstandingCasList) {
                casIdsPendingReply[inx++] = entry.getCasReferenceId();
            }
            return casIdsPendingReply;
        }
    }

    public List<DelegateEntry> getDelegateCasesPendingDispatch() {
        return this.pendingDispatchList;
    }

    public void addNewCasToOutstandingList(String aCasReferenceId) {
        this.addNewCasToOutstandingList(aCasReferenceId, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewCasToOutstandingList(String aCasReferenceId, boolean isCasGeneratingChildren, int casHashCode) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = null;
            entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry == null) {
                entry = new DelegateEntry(aCasReferenceId);
                entry.setCasHashCode(String.valueOf(casHashCode));
                entry.setCommand(2000);
                if (isCasGeneratingChildren) {
                    entry.setGeneratingChildren(true);
                }
                this.outstandingCasList.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCasToOutstandingList(String aCasReferenceId, int casHashcode) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = null;
            if (!this.outstandingCasList.isEmpty() && (entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList)) != null) {
                this.restartTimerForCas(entry);
            } else {
                entry = new DelegateEntry(aCasReferenceId);
                entry.setCommand(2000);
                entry.setCasHashCode(String.valueOf(casHashcode));
                if (this.outstandingCasList.isEmpty() && this.getCasProcessTimeout() > 0L) {
                    this.startDelegateTimer(aCasReferenceId, 2000);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "addCasToOutstandingList", "uimaee_messages", "UIMAEE_start_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, this.getCasProcessTimeout()});
                    }
                }
                this.outstandingCasList.add(entry);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "addCasToOutstandingList", "uimaee_messages", "UIMAEE_add_cas_to_delegate_pending_reply_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, this.outstandingCasList.size()});
                }
            }
        }
        this.dumpPendingReplyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCasToPendingDispatchList(String aCasReferenceId, long casHashCode) {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            DelegateEntry entry = null;
            entry = new DelegateEntry(aCasReferenceId);
            entry.setCasHashCode(String.valueOf(casHashCode));
            entry.setCommand(2000);
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "addCasToPendingDispatchList", "uimaee_messages", "UIMAEE_add_cas_to_delegate_pending_dispatch_WARNING", new Object[]{this.getComponentName(), aCasReferenceId, String.valueOf(casHashCode), this.delegateKey, this.pendingDispatchList.size()});
            this.pendingDispatchList.add(entry);
            this.dumpDelayedList();
            return this.pendingDispatchList.size();
        }
    }

    protected void dumpDelayedList() {
        StringBuffer sb = new StringBuffer();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            sb.append("Current Pending Dispatch List. Delegate:" + this.delegateKey);
            for (DelegateEntry entry : this.pendingDispatchList) {
                sb.append("\n\t----- CAS:" + entry.getCasReferenceId()).append(" CAS hashCode:" + entry.getCasHashCode());
            }
            sb.append("\n");
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "dumpDelayedList", "uimaee_messages", "UIMAEE_dump_cas_pending_dispatch__INFO", new Object[]{sb.toString()});
        }
    }

    private void dumpPendingReplyList() {
        StringBuffer sb = new StringBuffer();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            sb.append("Current Pending Reply List. Delegate:" + this.delegateKey);
            for (DelegateEntry entry : this.outstandingCasList) {
                sb.append("\n\t----- CAS:" + entry.getCasReferenceId()).append(" CAS hashCode:" + entry.getCasHashCode());
            }
            sb.append("\n");
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "dumpDelayedList", "uimaee_messages", "UIMAEE_dump_cas_pending_reply__INFO", new Object[]{sb.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRetryCount(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                entry.incrementRetryCount();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "incrementRetryCount", "uimaee_messages", "UIMAEE_increment_retry_count_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, entry.getRetryCount()});
                }
            }
        }
    }

    private DelegateEntry lookupEntry(String aCasReferenceId, List<DelegateEntry> list) {
        for (DelegateEntry entry : list) {
            if (!entry.getCasReferenceId().equals(aCasReferenceId)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeOldestFromPendingDispatchList() {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            if (this.pendingDispatchList.size() > 0) {
                String casReferenceId = this.pendingDispatchList.remove(0).getCasReferenceId();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeOldestFromPendingDispatchList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_pending_dispatch_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, casReferenceId, this.pendingDispatchList.size()});
                }
                return casReferenceId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCasFromPendingDispatchList(String aCasReferenceId) {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.pendingDispatchList);
            if (entry != null) {
                this.pendingDispatchList.remove(entry);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromPendingDispatchList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_pending_dispatch_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, entry.getCasReferenceId(), this.pendingDispatchList.size()});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCasFromOutstandingList(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                this.removeCasFromOutstandingList(entry);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCasPendingReply(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeOldestCasFromOutstandingList() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            this.dumpPendingReplyList();
            return this.outstandingCasList.remove(0).getCasReferenceId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldestCasIdFromOutstandingList() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            return this.outstandingCasList.get(0).getCasReferenceId();
        }
    }

    private void removeCasFromOutstandingList(DelegateEntry aDelegateEntry) {
        DelegateEntry oldestEntry = this.outstandingCasList.get(0);
        boolean doStartDelegateTimer = oldestEntry.equals(aDelegateEntry) && this.getCasProcessTimeout() > 0L;
        this.outstandingCasList.remove(aDelegateEntry);
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromOutstandingList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, aDelegateEntry.getCasReferenceId(), this.outstandingCasList.size()});
        }
        if (doStartDelegateTimer) {
            this.cancelDelegateTimer();
            if (!this.outstandingCasList.isEmpty()) {
                DelegateEntry delegateEntry = this.outstandingCasList.get(0);
                this.startDelegateTimer(delegateEntry.getCasReferenceId(), delegateEntry.getCommand());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromOutstandingList", "uimaee_messages", "UIMAEE_restart_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, delegateEntry.getCasReferenceId(), this.getCasProcessTimeout()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.cancelDelegateTimer();
        this.cancelDelegateGetMetaTimer();
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            this.outstandingCasList.clear();
        }
        list = this.pendingDispatchList;
        synchronized (list) {
            this.pendingDispatchList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCasPendingReplyListSize() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            return this.outstandingCasList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCasPendingDispatchListSize() {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            return this.pendingDispatchList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDelegateTimer() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDelegateGetMetaTimer() {
        Object object = this.getMetaTimerLock;
        synchronized (object) {
            if (this.getMetaTimer != null) {
                this.getMetaTimer.cancel();
                this.getMetaTimer.purge();
            }
        }
    }

    private long getTimeoutValueForCommand(int aCommand) {
        switch (aCommand) {
            case 2000: {
                return this.getCasProcessTimeout();
            }
            case 2001: {
                return this.getGetMetaTimeout();
            }
            case 2002: {
                return this.getCpcTimeout();
            }
        }
        return -1L;
    }

    public void startGetMetaRequestTimer() {
        this.startDelegateGetMetaTimer(null, 2001);
    }

    public void startGetMetaRequestTimer(String casReferenceId) {
        this.startDelegateGetMetaTimer(casReferenceId, 2001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDelegateTimer(final String aCasReferenceId, final int aCommand) {
        Object object = this.timerLock;
        synchronized (object) {
            final long timeToWait = this.getTimeoutValueForCommand(aCommand);
            Date timeToRun = new Date(System.currentTimeMillis() + timeToWait);
            this.timer = new DelegateTimer("Controller:" + this.getComponentName() + ":Request TimerThread-Endpoint_impl:" + this.endpoint + ":" + System.nanoTime() + ":Cmd:" + aCommand, true, aCasReferenceId, this);
            final Delegate delegate = this;
            this.timer.schedule(new TimerTask(){

                public void run() {
                    delegate.setState(2);
                    ErrorContext errorContext = new ErrorContext();
                    errorContext.add("Command", aCommand);
                    String enrichedMessage = Delegate.this.enrichProcessCASTimeoutMessage(aCommand, aCasReferenceId, timeToWait, "Delegate Service:" + Delegate.this.delegateKey + " Has Timed Out While Processing CAS:" + aCasReferenceId);
                    MessageTimeoutException cause = new MessageTimeoutException(enrichedMessage);
                    if (2000 == aCommand) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_cas_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait, aCasReferenceId});
                        }
                        errorContext.add("CasReference", aCasReferenceId);
                        errorContext.add("ThrowableError", cause);
                    } else if (2001 == aCommand) {
                        if (aCasReferenceId != null) {
                            errorContext.add("CasReference", aCasReferenceId);
                            errorContext.add("Cause", 5001);
                        }
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_meta_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait});
                        }
                    } else if (2002 == aCommand && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_cpc_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait});
                    }
                    errorContext.add("Endpoint", Delegate.this.getEndpoint());
                    Delegate.this.handleError(cause, errorContext);
                }
            }, timeToRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDelegateGetMetaTimer(final String aCasReferenceId, final int aCommand) {
        Object object = this.getMetaTimerLock;
        synchronized (object) {
            final long timeToWait = this.getTimeoutValueForCommand(aCommand);
            Date timeToRun = new Date(System.currentTimeMillis() + timeToWait);
            this.getMetaTimer = new DelegateTimer("Controller:" + this.getComponentName() + ":GetMeta TimerThread-Endpoint_impl:" + this.endpoint + ":" + System.nanoTime() + ":Cmd:" + aCommand, true, "", this);
            final Delegate delegate = this;
            this.getMetaTimer.schedule(new TimerTask(){

                public void run() {
                    Delegate.this.getMetaTimer.cancel();
                    delegate.setState(2);
                    ErrorContext errorContext = new ErrorContext();
                    errorContext.add("Command", aCommand);
                    String enrichedMessage = Delegate.this.enrichProcessCASTimeoutMessage(aCommand, aCasReferenceId, timeToWait, "Delegate Service:" + Delegate.this.delegateKey + " Has Timed Out While Processing CAS:" + aCasReferenceId);
                    MessageTimeoutException cause = new MessageTimeoutException(enrichedMessage);
                    if (aCasReferenceId != null) {
                        errorContext.add("CasReference", aCasReferenceId);
                        errorContext.add("Cause", 5001);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_meta_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait});
                    }
                    errorContext.add("Endpoint", Delegate.this.getEndpoint());
                    Delegate.this.handleError(cause, errorContext);
                }
            }, timeToRun);
        }
    }

    public long getCasProcessTimeout() {
        return this.casProcessTimeout;
    }

    public void setCasProcessTimeout(long casProcessTimeout) {
        this.casProcessTimeout = casProcessTimeout;
    }

    public long getGetMetaTimeout() {
        return this.getMetaTimeout;
    }

    public void setGetMetaTimeout(long getMetaTimeout) {
        this.getMetaTimeout = getMetaTimeout;
    }

    public long getCpcTimeout() {
        return this.cpcTimeout;
    }

    public void setCpcTimeout(long cpcTimeout) {
        this.cpcTimeout = cpcTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateMux;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int aState) {
        Object object = this.stateMux;
        synchronized (object) {
            if (aState == 2 && this.state != 1) {
                return;
            }
            this.state = aState;
        }
    }

    public void setConcurrentConsumersOnReplyQueue() {
        this.concurrentConsumersOnReplyQueue = true;
    }

    public boolean hasConcurrentConsumersOnReplyQueue() {
        return this.concurrentConsumersOnReplyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratingChildrenFrom(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry == null) {
                return false;
            }
            return entry.isGeneratingChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneratingChildrenFrom(String aCasReferenceId, boolean tOf) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                entry.setGeneratingChildren(tOf);
            }
        }
    }

    protected String getDelayedCASes() {
        StringBuffer sb = new StringBuffer();
        ArrayList<DelegateEntry> copyOfOutstandingCASes = new ArrayList<DelegateEntry>(this.outstandingCasList);
        sb.append("Outstanding CAS count:").append(copyOfOutstandingCASes.size()).append("-->");
        for (DelegateEntry entry : copyOfOutstandingCASes) {
            if (entry == null || entry.getCasReferenceId() == null) continue;
            sb.append("[" + entry.getCasReferenceId() + "]");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ArrayList<DelegateEntry> copyOfOutstandingCASes = new ArrayList<DelegateEntry>(this.outstandingCasList);
        for (DelegateEntry entry : copyOfOutstandingCASes) {
            if (entry == null || entry.getCasReferenceId() == null) continue;
            sb.append("[" + entry.getCasReferenceId() + "]");
        }
        return sb.toString();
    }

    private static class DelegateTimer
    extends Timer {
        String casReferenceId;

        public DelegateTimer(String threadName, boolean isDaemon, String casReferenceId, Delegate delegate) {
            super(threadName, isDaemon);
            this.casReferenceId = casReferenceId;
        }

        public void cancel() {
            super.cancel();
        }

        public String getTimerCasId() {
            return this.casReferenceId;
        }
    }

    public static class DelegateEntry {
        private String casReferenceId;
        private int command;
        private int retryCount = 0;
        private volatile boolean generatingChildren = false;
        private String casHashCode;

        public String getCasHashCode() {
            return this.casHashCode;
        }

        public void setCasHashCode(String casHashCode) {
            this.casHashCode = casHashCode;
        }

        public DelegateEntry(String aCasReferenceId) {
            this.casReferenceId = aCasReferenceId;
        }

        public boolean isGeneratingChildren() {
            return this.generatingChildren;
        }

        public void setGeneratingChildren(boolean tOf) {
            this.generatingChildren = tOf;
        }

        public int getCommand() {
            return this.command;
        }

        public void setCommand(int command) {
            this.command = command;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void incrementRetryCount() {
            ++this.retryCount;
        }

        public void resetRetryCount() {
            this.retryCount = 0;
        }

        public String getCasReferenceId() {
            return this.casReferenceId;
        }
    }
}

