/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.aae.AsynchAECasManager;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.UimaClassFactory;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController_implMBean;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.ControllerLatch;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.Endpoint_impl;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.ControllerDelegate;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.aae.error.UimaEEServiceException;
import org.apache.uima.aae.error.UnknownDestinationException;
import org.apache.uima.aae.jmx.AggregateServiceInfo;
import org.apache.uima.aae.jmx.JmxManagement;
import org.apache.uima.aae.jmx.PrimitiveServiceInfo;
import org.apache.uima.aae.jmx.ServiceErrors;
import org.apache.uima.aae.jmx.ServiceInfo;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.monitor.Monitor;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.aae.spi.transport.UimaTransport;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessage;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.asb.impl.FlowContainer;
import org.apache.uima.analysis_engine.asb.impl.FlowControllerContainer;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.ParallelStep;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.Level;
import org.apache.uima.util.TypeSystemUtil;
import org.apache.uima.util.XMLInputSource;

public class AggregateAnalysisEngineController_impl
extends BaseAnalysisEngineController
implements AggregateAnalysisEngineController,
AggregateAnalysisEngineController_implMBean {
    private static final long serialVersionUID = 1L;
    private static final Class CLASS_NAME = AggregateAnalysisEngineController_impl.class;
    private static final int SERVICE_INFO_INDX = 0;
    private static final int SERVICE_PERF_INDX = 1;
    private static final int SERVICE_ERROR_INDX = 2;
    private ConcurrentHashMap flowMap = new ConcurrentHashMap();
    private ConcurrentHashMap destinationMap;
    private Map destinationToKeyMap;
    private volatile boolean typeSystemsMerged = false;
    private AnalysisEngineMetaData aggregateMetadata;
    private HashMap analysisEngineMetaDataMap = new HashMap();
    private List disabledDelegateList = new ArrayList();
    private List remoteCasMultiplierList = new ArrayList();
    private String descriptor;
    private transient FlowControllerContainer flowControllerContainer;
    private String flowControllerDescriptor;
    private ConcurrentHashMap originMap = new ConcurrentHashMap();
    private String controllerBeanName = null;
    private String serviceEndpointName = null;
    protected volatile boolean initialized = false;
    protected List<AnalysisEngineController> childControllerList = new ArrayList<AnalysisEngineController>();
    private ConcurrentHashMap delegateStats = new ConcurrentHashMap();
    private AggregateServiceInfo serviceInfo = null;
    private int remoteIndex = 1;
    private volatile boolean requestForMetaSentToRemotes = false;
    private ConcurrentHashMap<String, Object[]> delegateStatMap = new ConcurrentHashMap();
    public final Object parallelStepMux = new Object();
    private volatile boolean doSendCpcReply = false;
    private Semaphore flowSemaphore = new Semaphore(1);
    private HashMap<String, Boolean> enableCasLogMap;
    private HashMap<String, String> casLogDirMap;
    private Long initializationTime = System.nanoTime();

    public AggregateAnalysisEngineController_impl(String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap) throws Exception {
        this(null, anEndpointName, aDescriptor, aCasManager, anInProcessCache, aDestinationMap);
    }

    public AggregateAnalysisEngineController_impl(AnalysisEngineController aParentController, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap) throws Exception {
        this(aParentController, anEndpointName, aDescriptor, aCasManager, anInProcessCache, aDestinationMap, null);
    }

    public AggregateAnalysisEngineController_impl(AnalysisEngineController aParentController, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap, JmxManagement aJmxManagement) throws Exception {
        super(aParentController, 0, anEndpointName, aDescriptor, aCasManager, anInProcessCache, aDestinationMap, aJmxManagement);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChildController(AnalysisEngineController aChildController, String aDelegateKey) throws Exception {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "registerChildController", "uimaee_messages", "UIMAEE_register_controller__FINE", new Object[]{this.getComponentName(), aChildController.getComponentName()});
        }
        List<AnalysisEngineController> list = this.childControllerList;
        synchronized (list) {
            this.childControllerList.add(aChildController);
        }
    }

    public void saveStatsFromService(String aServiceEndpointName, Map aServiceStats) {
        String delegateKey = this.lookUpDelegateKey(aServiceEndpointName);
        this.delegateStats.put(delegateKey, aServiceStats);
    }

    public void addMessageOrigin(String aCasReferenceId, Endpoint anEndpoint) {
        if (anEndpoint == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "addMessageOrigin", "uimaee_messages", "UIMAEE_endpoint_null__INFO", new Object[]{this.getComponentName(), aCasReferenceId});
            }
            return;
        }
        this.originMap.put(aCasReferenceId, anEndpoint);
        if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
            Iterator it = this.originMap.keySet().iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                String key = (String)it.next();
                Endpoint e = (Endpoint)this.originMap.get(key);
                if (e == null) continue;
                sb.append("\t\nCAS:" + key + " Origin:" + e.getEndpoint());
            }
        }
    }

    public boolean isDelegateDisabled(String aDelegateKey) {
        if (aDelegateKey == null) {
            return false;
        }
        Iterator it = this.disabledDelegateList.iterator();
        while (it.hasNext()) {
            if (!aDelegateKey.equalsIgnoreCase((String)it.next())) continue;
            return true;
        }
        return false;
    }

    public void setServiceEndpointName(String anEndpointName) {
        this.serviceEndpointName = anEndpointName;
        if (this.isTopLevelComponent()) {
            System.setProperty("ServiceInputQueueName", this.serviceEndpointName);
        }
    }

    public String getServiceEndpointName() {
        return this.serviceEndpointName;
    }

    public void setControllerBeanName(String aBeanName) {
        this.controllerBeanName = aBeanName;
        if (this.isTopLevelComponent()) {
            System.setProperty("Controller", this.controllerBeanName);
        }
    }

    public Endpoint getMessageOrigin(String aCasReferenceId) {
        if (this.originMap.containsKey(aCasReferenceId)) {
            return (Endpoint)this.originMap.get(aCasReferenceId);
        }
        return null;
    }

    public void removeMessageOrigin(String aCasReferenceId) {
        if (this.originMap.containsKey(aCasReferenceId)) {
            this.originMap.remove(aCasReferenceId);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "removeMessageOrigin", "uimaee_messages", "UIMAEE_remove_msg_origin_entry__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
            }
        }
    }

    public void dropCAS(String aCasReferenceId, boolean dropCacheEntry) {
        FlowContainer flow = this.lookupFlow(aCasReferenceId);
        if (flow != null) {
            this.flowMap.remove(aCasReferenceId);
        }
        super.dropCAS(aCasReferenceId, dropCacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropFlow(String aCasReferenceId, boolean abortFlow) {
        FlowContainer flow = this.lookupFlow(aCasReferenceId);
        if (flow != null) {
            if (abortFlow) {
                FlowControllerContainer flowControllerContainer = this.flowControllerContainer;
                synchronized (flowControllerContainer) {
                    flow.aborted();
                }
            }
            this.flowMap.remove(aCasReferenceId);
        }
    }

    public void mapEndpointsToKeys(ConcurrentHashMap aDestinationMap) {
        this.destinationMap = aDestinationMap;
        Set set = this.destinationMap.entrySet();
        for (Map.Entry entry : set) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            if (endpoint == null) continue;
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "mapEndpointsToKeys", "uimaee_messages", "UIMAEE_endpoint_to_key_map__FINE", new Object[]{this.getName(), (String)entry.getKey(), endpoint.getEndpoint()});
            }
            if (this.destinationToKeyMap == null) {
                this.destinationToKeyMap = new HashMap();
            }
            ControllerDelegate delegate = new ControllerDelegate((String)entry.getKey(), this);
            delegate.setCasProcessTimeout(endpoint.getProcessRequestTimeout());
            delegate.setGetMetaTimeout(endpoint.getMetadataRequestTimeout());
            delegate.setEndpoint(endpoint);
            this.delegates.add(delegate);
            endpoint.setDelegateKey((String)entry.getKey());
            this.destinationToKeyMap.put(endpoint.getEndpoint(), (String)entry.getKey());
        }
    }

    private void resetEndpointsCpcStatus() {
        Set set = this.destinationMap.entrySet();
        for (Map.Entry entry : set) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            if (endpoint == null || endpoint.getStatus() != 1) continue;
            endpoint.setCompletedProcessingCollection(false);
        }
    }

    private synchronized boolean allDelegatesCompletedCollection() {
        Set set = this.destinationMap.entrySet();
        for (Map.Entry entry : set) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            if (endpoint == null || endpoint.getStatus() != 1 || endpoint.completedProcessingCollection()) continue;
            return false;
        }
        this.resetEndpointsCpcStatus();
        return true;
    }

    public Map getDelegateStats() {
        return this.delegateStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCollectionCompleteReplyFromDelegate(String aDelegateKey, boolean sendReply) throws AsynchAEException {
        try {
            Endpoint endpoint = (Endpoint)this.destinationMap.get(aDelegateKey);
            String key = this.lookUpDelegateKey(aDelegateKey);
            if (endpoint == null && (endpoint = (Endpoint)this.destinationMap.get(key)) == null) {
                throw new AsynchAEException("Unable to find Endpoint Object Using:" + aDelegateKey);
            }
            endpoint.cancelTimer();
            endpoint.setCompletedProcessingCollection(true);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "processCollectionCompleteReplyFromDelegate", "uimaee_messages", "UIMAEE_recvd_cpc_reply__FINE", new Object[]{key});
            }
            Endpoint cEndpoint = null;
            if (this.flowControllerContainer != null) {
                FlowControllerContainer flowControllerContainer = this.flowControllerContainer;
                synchronized (flowControllerContainer) {
                    if (!this.doSendCpcReply && sendReply && this.allDelegatesCompletedCollection() && (cEndpoint = this.getClientEndpoint()) != null) {
                        this.doSendCpcReply = true;
                        this.flowControllerContainer.collectionProcessComplete();
                    }
                }
            }
            if (this.doSendCpcReply) {
                this.sendCpcReply(cEndpoint);
                this.doSendCpcReply = false;
            }
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private void sendCpcReply(Endpoint aClientEndpoint) throws Exception {
        for (String key : this.destinationMap.keySet()) {
            Endpoint endpoint = (Endpoint)this.destinationMap.get(key);
            if (endpoint != null) {
                endpoint.setCompletedProcessingCollection(false);
            }
            this.logStats(key, this.getDelegateServicePerformance(key));
        }
        this.logStats(this.getComponentName(), this.servicePerformance);
        this.endProcess(2000);
        if (aClientEndpoint == null) {
            aClientEndpoint = this.getClientEndpoint();
        }
        if (!aClientEndpoint.isRemote()) {
            UimaTransport transport = this.getTransport(aClientEndpoint.getEndpoint());
            UimaVmMessage message = transport.produceMessage(2002, 3001, this.getName());
            transport.getUimaMessageDispatcher(aClientEndpoint.getEndpoint()).dispatch(message);
        } else {
            this.getOutputChannel().sendReply(2002, aClientEndpoint, null, false);
        }
        this.clearStats();
    }

    public synchronized void setFlowControllerDescriptor(String aFlowControllerDescriptor) {
        this.flowControllerDescriptor = aFlowControllerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitUntilAllCasesAreProcessed(Endpoint anEndpoint) throws AsynchAEException {
        try {
            boolean cacheNotEmpty = true;
            boolean shownOnce = false;
            Object localMux = new Object();
            while (cacheNotEmpty) {
                InProcessCache cache = this.getInProcessCache();
                if (!shownOnce) {
                    shownOnce = true;
                    cache.dumpContents(this.getComponentName());
                }
                if (cache.isEmpty()) {
                    return;
                }
                Object object = localMux;
                synchronized (object) {
                    localMux.wait(10L);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    public void takeAction(String anAction, String anEndpointName, ErrorContext anErrorContext) {
        block2: {
            try {
                this.handleAction(anAction, anEndpointName, anErrorContext);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "takeAction", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "takeAction", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void collectionProcessComplete(Endpoint anEndpoint) throws AsynchAEException {
        block10: {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_cpc__FINEST", new Object[]{this.getName()});
            }
            this.getInProcessCache().dumpContents(this.getComponentName());
            this.localCache.dumpContents();
            this.cacheClientEndpoint(anEndpoint);
            this.waitUntilAllCasesAreProcessed(anEndpoint);
            anEndpoint.setCommand(2002);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_cpc_all_cases_processed__FINEST", new Object[]{this.getName()});
            }
            if (this.destinationMap.size() == 0) {
                try {
                    this.sendCpcReply(null);
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block10;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            } else {
                Set set = this.destinationMap.entrySet();
                for (Map.Entry entry : set) {
                    Endpoint endpoint = (Endpoint)entry.getValue();
                    if (endpoint == null || endpoint.getStatus() != 1) continue;
                    if (!endpoint.isRemote()) {
                        try {
                            UimaTransport transport = this.getTransport(endpoint.getEndpoint());
                            UimaVmMessage message = transport.produceMessage(2002, 3000, this.getName());
                            transport.getUimaMessageDispatcher(endpoint.getEndpoint()).dispatch(message);
                        }
                        catch (Exception e) {
                            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "collectionProcessComplete", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                        }
                        continue;
                    }
                    this.getOutputChannel().sendRequest(2002, null, endpoint);
                    endpoint.startCollectionProcessCompleteTimer();
                }
            }
        }
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Map getDestinations() {
        return this.destinationMap;
    }

    public void enableDelegates(List aDelegateList) throws AsynchAEException {
    }

    public void handleInitializationError(Exception ex) {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleInitializationError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleInitializationError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
        }
        this.notifyListenersWithInitializationStatus(ex);
        super.stop(true);
    }

    private void stopListener(String key, Endpoint endpoint) throws Exception {
        InputChannel iC = null;
        String destName = null;
        if (endpoint.getDestination() != null) {
            destName = endpoint.getDestination().toString();
            iC = this.getInputChannel(destName);
        } else {
            destName = endpoint.getReplyToEndpoint();
            iC = this.getInputChannel(destName);
        }
        if (iC != null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stopListener", "uimaee_messages", "UIMAEE_stopping_listener__INFO", new Object[]{this.getComponentName(), destName, key});
            }
            iC.destroyListener(destName, key);
        }
    }

    public void disableDelegates(List aDelegateList) throws AsynchAEException {
        this.disableDelegates(aDelegateList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableDelegates(List aDelegateList, String aCasReferenceId) throws AsynchAEException {
        block28: {
            if (aDelegateList == null) {
                throw new AsynchAEException("Controller:" + this.getComponentName() + " Unable To Disable a Delegate. The Delegate List Provided Is Invalid (Null)");
            }
            try {
                for (String key : aDelegateList) {
                    PrimitiveServiceInfo sf;
                    Endpoint endpoint = this.lookUpEndpoint(key, false);
                    if (endpoint != null && endpoint.isRemote()) {
                        Delegate delegate = this.lookupDelegate(key);
                        if (delegate != null) {
                            delegate.cancelDelegateTimer();
                        }
                        this.stopListener(key, endpoint);
                        endpoint.setStatus(3);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "disableDelegates", "uimaee_messages", "UIMAEE_disable_endpoint__INFO", new Object[]{this.getComponentName(), key});
                    }
                    if ((sf = this.getDelegateServiceInfo(key)) != null) {
                        sf.setState(BaseAnalysisEngineController.ServiceState.DISABLED.name());
                    }
                    List list = this.disabledDelegateList;
                    synchronized (list) {
                        this.disabledDelegateList.add(key);
                    }
                }
                if (this.flowControllerContainer != null) {
                    try {
                        String key;
                        key = this.flowControllerContainer;
                        synchronized (key) {
                            this.flowControllerContainer.removeAnalysisEngines((Collection)aDelegateList);
                        }
                    }
                    catch (Exception ex) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "disableDelegates", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "disableDelegates", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                        }
                        if (aCasReferenceId != null) {
                            LocalCache.CasStateEntry parentCasCacheEntry = this.getLocalCache().getTopCasAncestor(aCasReferenceId);
                            if (parentCasCacheEntry != null && aDelegateList.size() > 0) {
                                String delegateKey = (String)aDelegateList.get(0);
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "disableDelegates", "uimaee_messages", "UIMAEE_service_terminating_fc_failure__INFO", new Object[]{this.getComponentName(), delegateKey, parentCasCacheEntry.getCasReferenceId()});
                                }
                                super.terminate(ex, parentCasCacheEntry.getCasReferenceId());
                            } else {
                                this.terminate();
                            }
                        } else {
                            this.terminate();
                        }
                        return;
                    }
                }
                if (this.initialized || !this.allTypeSystemsMerged()) break block28;
                try {
                    this.completeInitialization();
                }
                catch (ResourceInitializationException ex) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "disableDelegates", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "disableDelegates", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                    }
                    this.handleInitializationError((Exception)((Object)ex));
                    return;
                }
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "disableDelegates", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "disableDelegates", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
                throw new AsynchAEException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean continueOnError(String aCasReferenceId, String aDelegateKey, Exception anException) throws AsynchAEException {
        if (aDelegateKey == null || aCasReferenceId == null) {
            return false;
        }
        try {
            FlowContainer flow = this.lookupFlow(aCasReferenceId);
            if (flow == null) {
                return false;
            }
            FlowControllerContainer flowControllerContainer = this.flowControllerContainer;
            synchronized (flowControllerContainer) {
                return flow.continueOnFailure(aDelegateKey, anException);
            }
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private FlowContainer lookupFlow(String aCasReferenceId) {
        if (this.flowMap != null && this.flowMap.containsKey(aCasReferenceId)) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "lookupFlow", "uimaee_messages", "UIMAEE_retrieve_flow_object__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
            }
            return (FlowContainer)this.flowMap.get(aCasReferenceId);
        }
        return null;
    }

    public String getLastDelegateKeyFromFlow(String anInputCasReferenceId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CAS aCAS, String anInputCasReferenceId, String aNewCasReferenceId, String newCASProducedBy) {
        FlowContainer flow = null;
        try {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_lookup_flow__FINE", new Object[]{this.getComponentName(), anInputCasReferenceId});
            }
            try {
                if (this.flowMap.containsKey(anInputCasReferenceId)) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_retrieve_flow_object__FINEST", new Object[]{this.getComponentName(), anInputCasReferenceId});
                    }
                    flow = (FlowContainer)this.flowMap.get(anInputCasReferenceId);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_retrieved_flow_object_ok__FINEST", new Object[]{this.getComponentName(), anInputCasReferenceId});
                    }
                }
                if (flow != null) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_lookup_flow_ok__FINE", new Object[]{this.getComponentName(), aNewCasReferenceId, newCASProducedBy, anInputCasReferenceId});
                    }
                    FlowControllerContainer flowControllerContainer = this.flowControllerContainer;
                    synchronized (flowControllerContainer) {
                        flow = flow.newCasProduced(aCAS, newCASProducedBy);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_new_flow_ok__FINE", new Object[]{this.getComponentName(), aNewCasReferenceId, newCASProducedBy, anInputCasReferenceId});
                    }
                    if (this.localCache.lookupEntry(aNewCasReferenceId) == null) {
                        LocalCache.CasStateEntry casStateEntry = this.localCache.createCasStateEntry(aNewCasReferenceId);
                        casStateEntry.setInputCasReferenceId(anInputCasReferenceId);
                    }
                } else {
                    throw new AsynchAEException("Flow Object Not In Flow Cache. Expected Flow Object in FlowCache for Cas Reference Id:" + anInputCasReferenceId);
                }
                this.flowMap.put(aNewCasReferenceId, flow);
                this.getInProcessCache().getCacheEntryForCAS(aNewCasReferenceId).setNewCas(true, this.getComponentName());
                this.getLocalCache().lookupEntry(anInputCasReferenceId).decrementOutstandingFlowCounter();
            }
            catch (Throwable t) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_exception__WARNING", t);
                }
                this.sendReplyWithShutdownException(anInputCasReferenceId);
                this.handleAction("Terminate", null, null);
                return;
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_executing_step__FINEST", new Object[]{this.getComponentName(), aNewCasReferenceId, newCASProducedBy, anInputCasReferenceId});
            }
            this.executeFlowStep(flow, aNewCasReferenceId, true);
        }
        catch (Exception e) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("Command", 2000);
            this.handleError(map, e);
        }
    }

    private void sendReplyWithShutdownException(String aCasReferenceId) {
        block3: {
            try {
                LocalCache.CasStateEntry casStateEntry = this.localCache.createCasStateEntry(aCasReferenceId);
                InProcessCache.CacheEntry cacheEntry = this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                Endpoint replyEndpoint = this.getReplyEndpoint(cacheEntry, casStateEntry);
                if (replyEndpoint != null) {
                    this.getOutputChannel().sendReply(new ServiceShutdownException(), aCasReferenceId, null, replyEndpoint, 2000);
                }
            }
            catch (Exception ex) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
            }
        }
    }

    private boolean abortProcessingCas(LocalCache.CasStateEntry casStateEntry, InProcessCache.CacheEntry entry) {
        block11: {
            LocalCache.CasStateEntry parentCasStateEntry = null;
            try {
                if (casStateEntry.isSubordinate()) {
                    parentCasStateEntry = this.getLocalCache().lookupEntry(casStateEntry.getInputCasReferenceId());
                    if (parentCasStateEntry.isFailed()) {
                        Delegate delegateCM = this.lookupDelegate(entry.getCasProducerKey());
                        if (delegateCM != null && delegateCM.getEndpoint().isCasMultiplier()) {
                            if (delegateCM.getEndpoint().isRemote()) {
                                parentCasStateEntry.getFreeCasNotificationEndpoint().setCommand(2006);
                                Endpoint fcEndpoint = parentCasStateEntry.getFreeCasNotificationEndpoint();
                                fcEndpoint.setReplyEndpoint(true);
                                fcEndpoint.setIsCasMultiplier(true);
                                fcEndpoint.setFreeCasEndpoint(true);
                                this.getOutputChannel().sendRequest(2005, entry.getCasReferenceId(), fcEndpoint);
                            }
                            if (delegateCM.isGeneratingChildrenFrom(parentCasStateEntry.getCasReferenceId())) {
                                this.stopCasMultiplier(delegateCM, parentCasStateEntry.getCasReferenceId());
                            }
                        }
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "abortProcessingCas", "uimaee_messages", "UIMAEE_forcing_cas_to_finalstep__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
                        }
                        casStateEntry.setReplyReceived();
                        this.finalStep(new FinalStep(), casStateEntry.getCasReferenceId());
                        return true;
                    }
                } else if (casStateEntry.isFailed()) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "abortProcessingCas", "uimaee_messages", "UIMAEE_forcing_cas_to_finalstep__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
                    }
                    casStateEntry.setReplyReceived();
                    this.finalStep(new FinalStep(), casStateEntry.getCasReferenceId());
                    return true;
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block11;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "abortProcessingCas", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "abortProcessingCas", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(CAS aCAS, String aCasReferenceId) {
        LocalCache.CasStateEntry casStateEntry;
        block39: {
            boolean handlingDelayedStep = false;
            if (!this.isStopped()) {
                block38: {
                    block37: {
                        if (this.abortGeneratingCASes(aCasReferenceId)) {
                            super.stopCasMultipliers();
                        }
                        try {
                            try {
                                List delayedSingleStepList;
                                Object object;
                                InProcessCache.CacheEntry entry = this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                                casStateEntry = this.getLocalCache().lookupEntry(aCasReferenceId);
                                if (this.abortProcessingCas(casStateEntry, entry)) {
                                    Object var11_9 = null;
                                    if (!handlingDelayedStep) return;
                                    return;
                                }
                                if (casStateEntry.getLastDelegate() != null) {
                                    Endpoint lastDelegateEndpoint = casStateEntry.getLastDelegate().getEndpoint();
                                    casStateEntry.setReplyReceived();
                                    if (lastDelegateEndpoint.isCasMultiplier()) {
                                        casStateEntry.acquireFlowSemaphore();
                                        casStateEntry.releaseFlowSemaphore();
                                        if (lastDelegateEndpoint.processParentLast()) {
                                            object = this.finalStepMux;
                                            synchronized (object) {
                                                if (casStateEntry.getSubordinateCasInPlayCount() > 0) {
                                                    casStateEntry.setState(1);
                                                    // MONITOREXIT @DISABLED, blocks:[0, 32, 33, 1, 34, 35, 36, 12] lbl25 : MonitorExitStatement: MONITOREXIT : var7_15
                                                    break block37;
                                                }
                                            }
                                        }
                                    }
                                }
                                if ((delayedSingleStepList = entry.getDelayedSingleStepList()) != null && delayedSingleStepList.size() > 0) {
                                    handlingDelayedStep = true;
                                    object = this.parallelStepMux;
                                    synchronized (object) {
                                        if (casStateEntry.getNumberOfParallelDelegates() > 1) {
                                            casStateEntry.setNumberOfParallelDelegates(1);
                                        }
                                    }
                                    Endpoint_impl endpoint = (Endpoint_impl)entry.getDelayedSingleStepList().remove(0);
                                    this.dispatchProcessRequest(entry, endpoint, true);
                                }
                                break block38;
                            }
                            catch (Exception e) {
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                                }
                                Object var11_12 = null;
                                if (handlingDelayedStep) {
                                    return;
                                }
                                break block39;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            if (!handlingDelayedStep) throw throwable;
                            return;
                        }
                    }
                    Object var11_10 = null;
                    if (!handlingDelayedStep) return;
                    return;
                }
                Object var11_11 = null;
                if (handlingDelayedStep) {
                    return;
                }
            }
        }
        FlowContainer flow = null;
        try {
            block40: {
                if (aCasReferenceId == null) return;
                try {
                    if (this.flowMap.containsKey(aCasReferenceId)) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_retrieve_flow_object__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
                        }
                        flow = (FlowContainer)this.flowMap.get(aCasReferenceId);
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_retrieved_flow_object_ok__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
                        }
                        break block40;
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_new_flow_object__FINEST", new Object[]{aCasReferenceId});
                    }
                    casStateEntry = this.flowControllerContainer;
                    synchronized (casStateEntry) {
                        flow = this.flowControllerContainer.computeFlow(aCAS);
                    }
                    this.flowMap.put(aCasReferenceId, flow);
                    if (this.localCache.lookupEntry(aCasReferenceId) == null) {
                        this.localCache.createCasStateEntry(aCasReferenceId);
                    }
                }
                catch (Exception ex) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                    }
                    this.sendReplyWithShutdownException(aCasReferenceId);
                    this.handleAction("Terminate", null, null);
                    return;
                }
            }
            if (this.isStopped()) {
                FlowControllerContainer ex = this.flowControllerContainer;
                synchronized (ex) {
                    flow.aborted();
                    return;
                }
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "process", "uimaee_messages", "UIMAEE_executing_step_input_cas__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
            }
            this.executeFlowStep(flow, aCasReferenceId, false);
            return;
        }
        catch (Exception e) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Command", 2000);
            map.put("CasReference", aCasReferenceId);
            this.handleError(map, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleStep(SimpleStep aStep, String aCasReferenceId) {
        block14: {
            Endpoint endpoint = null;
            try {
                String analysisEngineKey = aStep.getAnalysisEngineKey();
                endpoint = this.lookUpEndpoint(analysisEngineKey, true);
                InProcessCache.CacheEntry cacheEntry = this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                if (endpoint == null) break block14;
                endpoint.setController(this);
                LocalCache.CasStateEntry casStateEntry = this.getLocalCache().lookupEntry(aCasReferenceId);
                casStateEntry.resetReplyReceived();
                if (this.enableCasLogMap != null && this.enableCasLogMap.containsKey(analysisEngineKey)) {
                    CAS cas = cacheEntry.getCas();
                    this.logCasForEndpoint(analysisEngineKey, cas);
                }
                Delegate delegate = this.lookupDelegate(analysisEngineKey);
                casStateEntry.setLastDelegate(delegate);
                if (endpoint.isCasMultiplier()) {
                    delegate.setGeneratingChildrenFrom(aCasReferenceId, true);
                    if (!endpoint.isRemote()) {
                        delegate.addNewCasToOutstandingList(aCasReferenceId, true, cacheEntry.getCas().hashCode());
                    }
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "simpleStep", "uimaee_messages", "UIMAEE_next_step__FINEST", new Object[]{aCasReferenceId, analysisEngineKey});
                }
                Object object = this.parallelStepMux;
                synchronized (object) {
                    if (casStateEntry.getNumberOfParallelDelegates() > 1) {
                        casStateEntry.setNumberOfParallelDelegates(1);
                    }
                }
                if (!this.isStopped()) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "simpleStep", "uimaee_messages", "UIMAEE_next_step_dispatch__FINEST", new Object[]{this.getComponentName(), analysisEngineKey, aCasReferenceId});
                    }
                    this.dispatchProcessRequest(cacheEntry, endpoint, true);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "simpleStep", "uimaee_messages", "UIMAEE_next_step_dispatch_completed__FINEST", new Object[]{this.getComponentName(), analysisEngineKey, aCasReferenceId});
                    }
                }
            }
            catch (Throwable e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Command", 2000);
                map.put("CasReference", aCasReferenceId);
                if (endpoint != null) {
                    map.put("Endpoint", endpoint);
                }
                this.handleError(map, e);
            }
        }
    }

    private void logCasForEndpoint(String analysisEngineKey, CAS cas) throws Exception {
        FileOutputStream os;
        if (!this.enableCasLogMap.get(analysisEngineKey).booleanValue()) {
            boolean status = new File(this.casLogDirMap.get(analysisEngineKey)).mkdir();
            TypeSystemDescription tsd = TypeSystemUtil.typeSystem2TypeSystemDescription((TypeSystem)cas.getTypeSystem());
            File tsd2xml = new File(this.casLogDirMap.get(analysisEngineKey) + "/typesystem.xml");
            os = new FileOutputStream(tsd2xml);
            tsd.toXML((OutputStream)os);
            os.close();
            this.enableCasLogMap.put(analysisEngineKey, true);
        }
        Long now = (System.nanoTime() - this.initializationTime) / 1000L;
        String casName = this.casLogDirMap.get(analysisEngineKey) + "/" + now.toString() + ".xmi";
        if (null != System.getProperty("UIMA_CASLOG_TYPE_NAME") && null != System.getProperty("UIMA_CASLOG_FEATURE_NAME")) {
            String[] uri;
            String typeName = System.getProperty("UIMA_CASLOG_TYPE_NAME");
            String featureName = System.getProperty("UIMA_CASLOG_FEATURE_NAME");
            Type logType = cas.getTypeSystem().getType(typeName);
            Feature logFeature = logType.getFeatureByBaseName(featureName);
            CAS view = cas;
            if (null != System.getProperty("UIMA_CASLOG_VIEW_NAME")) {
                view = cas.getView(System.getProperty("UIMA_CASLOG_VIEW_NAME"));
            }
            FSIterator iter = view.getIndexRepository().getAllIndexedFS(logType);
            FeatureStructure fs = (FeatureStructure)iter.next();
            if (!iter.hasNext() && null != fs.getStringValue(logFeature) && null != (uri = fs.getStringValue(logFeature).split("/"))[uri.length - 1].trim()) {
                casName = this.casLogDirMap.get(analysisEngineKey) + "/" + uri[uri.length - 1].trim() + ".xmi";
            }
        }
        File xmiCas = new File(casName);
        os = new FileOutputStream(xmiCas);
        XmiCasSerializer.serialize((CAS)cas, (OutputStream)os);
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parallelStep(ParallelStep aStep, String aCasReferenceId) throws AsynchAEException {
        block11: {
            try {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "parallelStep", "uimaee_messages", "UIMAEE_parallel_step__FINE", new Object[]{this.getComponentName(), aCasReferenceId});
                }
                Collection keyList = aStep.getAnalysisEngineKeys();
                String[] analysisEngineKeys = new String[keyList.size()];
                keyList.toArray(analysisEngineKeys);
                ArrayList<Endpoint> parallelDelegateList = new ArrayList<Endpoint>();
                ArrayList<Endpoint> singleStepDelegateList = null;
                for (int i = 0; i < analysisEngineKeys.length; ++i) {
                    Endpoint endpoint = this.lookUpEndpoint(analysisEngineKeys[i], true);
                    endpoint.setController(this);
                    if (endpoint.isRemote()) {
                        parallelDelegateList.add(endpoint);
                        continue;
                    }
                    if (singleStepDelegateList == null) {
                        singleStepDelegateList = new ArrayList<Endpoint>();
                    }
                    singleStepDelegateList.add(endpoint);
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINE)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "parallelStep", "uimaee_messages", "UIMAEE_move_to_single_step_list__FINE", new Object[]{this.getComponentName(), analysisEngineKeys[i], aCasReferenceId});
                }
                InProcessCache.CacheEntry cacheEntry = this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                LocalCache.CasStateEntry casStateEntry = this.getLocalCache().lookupEntry(aCasReferenceId);
                if (singleStepDelegateList != null) {
                    cacheEntry.setDelayedSingleStepList(singleStepDelegateList);
                }
                if (parallelDelegateList.size() > 0) {
                    Endpoint[] endpoints = new Endpoint_impl[parallelDelegateList.size()];
                    parallelDelegateList.toArray(endpoints);
                    Object object = this.parallelStepMux;
                    synchronized (object) {
                        casStateEntry.resetDelegateResponded();
                        casStateEntry.setNumberOfParallelDelegates(endpoints.length);
                    }
                    this.dispatchProcessRequest(cacheEntry, endpoints, true);
                    break block11;
                }
                this.process(null, aCasReferenceId);
            }
            catch (Throwable e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Command", 2000);
                map.put("CasReference", aCasReferenceId);
                this.handleError(map, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestForMetadataToRemoteDelegates() throws AsynchAEException {
        List<AnalysisEngineController> list = this.childControllerList;
        synchronized (list) {
            try {
                this.childControllerList.wait(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.childControllerList.size() > 0) {
                for (AnalysisEngineController childController : this.childControllerList) {
                    if (!(childController instanceof AggregateAnalysisEngineController)) continue;
                    ((AggregateAnalysisEngineController)childController).sendRequestForMetadataToRemoteDelegates();
                }
            }
        }
        Endpoint[] delegateEndpoints = new Endpoint[this.destinationMap.size()];
        Set keySet = this.destinationMap.keySet();
        Iterator it = keySet.iterator();
        int indx = 0;
        while (it.hasNext()) {
            delegateEndpoints[indx++] = (Endpoint)this.destinationMap.get((String)it.next());
        }
        for (int i = 0; !this.isStopped() && i < delegateEndpoints.length; ++i) {
            if (delegateEndpoints[i].isRemote()) {
                delegateEndpoints[i].initialize();
                delegateEndpoints[i].setController(this);
                String key = this.lookUpDelegateKey(delegateEndpoints[i].getEndpoint());
                if (key == null || !this.destinationMap.containsKey(key)) continue;
                Endpoint endpoint = (Endpoint)this.destinationMap.get(key);
                if (key != null && endpoint != null) {
                    ServiceInfo serviceInfo = endpoint.getServiceInfo();
                    PrimitiveServiceInfo pServiceInfo = new PrimitiveServiceInfo(endpoint.isCasMultiplier(), null);
                    pServiceInfo.setBrokerURL(serviceInfo.getBrokerURL());
                    pServiceInfo.setInputQueueName(serviceInfo.getInputQueueName());
                    if (endpoint.getDestination() != null) {
                        pServiceInfo.setReplyQueueName(endpoint.getDestination().toString());
                    }
                    pServiceInfo.setServiceKey(key);
                    pServiceInfo.setState(serviceInfo.getState());
                    pServiceInfo.setAnalysisEngineInstanceCount(1);
                    this.registerWithAgent(pServiceInfo, super.getManagementInterface().getJmxDomain() + this.jmxContext + ",r" + this.remoteIndex + "=" + key + " [Remote Uima EE Service],name=" + key + "_" + serviceInfo.getLabel());
                    ServicePerformance servicePerformance = new ServicePerformance();
                    servicePerformance.setRemoteDelegate();
                    servicePerformance.setReplyThreadCount(endpoint.getConcurrentReplyConsumers());
                    this.registerWithAgent(servicePerformance, super.getManagementInterface().getJmxDomain() + this.jmxContext + ",r" + this.remoteIndex + "=" + key + " [Remote Uima EE Service],name=" + key + "_" + servicePerformance.getLabel());
                    ServiceErrors serviceErrors = new ServiceErrors();
                    this.registerWithAgent(serviceErrors, super.getManagementInterface().getJmxDomain() + this.jmxContext + ",r" + this.remoteIndex + "=" + key + " [Remote Uima EE Service],name=" + key + "_" + serviceErrors.getLabel());
                    ++this.remoteIndex;
                    this.serviceErrorMap.put(key, serviceErrors);
                    Object[] delegateStatsArray = new Object[]{pServiceInfo, servicePerformance, serviceErrors};
                    this.delegateStatMap.put(key, delegateStatsArray);
                }
                if (this.isStopped()) {
                    return;
                }
                if (delegateEndpoints[i].getStatus() != 1) continue;
                this.dispatchMetadataRequest(delegateEndpoints[i]);
                continue;
            }
            delegateEndpoints[i].initialize();
            delegateEndpoints[i].setController(this);
            delegateEndpoints[i].setWaitingForResponse(true);
            try {
                UimaVmMessage message = this.getTransport(delegateEndpoints[i].getEndpoint()).produceMessage(2001, 3000, this.getName());
                UimaTransport transport = this.getTransport(delegateEndpoints[i].getEndpoint());
                transport.getUimaMessageDispatcher(delegateEndpoints[i].getEndpoint()).dispatch(message);
                continue;
            }
            catch (Exception e) {
                throw new AsynchAEException(e);
            }
        }
    }

    private LocalCache.CasStateEntry fetchParentCasFromLocalCache(LocalCache.CasStateEntry casStateEntry) throws Exception {
        LocalCache.CasStateEntry parentCasStateEntry = this.localCache.lookupEntry(casStateEntry.getInputCasReferenceId());
        if (parentCasStateEntry == null && UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "fetchParentCasFromLocalCache", "uimaee_messages", "UIMAEE_cas_not_found__INFO", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), "Local Cache"});
        }
        return parentCasStateEntry;
    }

    private InProcessCache.CacheEntry fetchParentCasFromGlobalCache(LocalCache.CasStateEntry casStateEntry) throws Exception {
        InProcessCache.CacheEntry parentCASCacheEntry;
        block2: {
            parentCASCacheEntry = null;
            try {
                parentCASCacheEntry = this.getInProcessCache().getCacheEntryForCAS(casStateEntry.getInputCasReferenceId());
            }
            catch (Exception ex) {
                if (!UIMAFramework.getLogger().isLoggable(Level.INFO)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "fetchParentCasFromGlobalCache", "uimaee_messages", "UIMAEE_cas_not_found__INFO", new Object[]{this.getComponentName(), casStateEntry.getInputCasReferenceId(), "InProcessCache"});
            }
        }
        return parentCASCacheEntry;
    }

    private boolean casHasChildrenInPlay(LocalCache.CasStateEntry casStateEntry) throws Exception {
        if (casStateEntry.getSubordinateCasInPlayCount() > 0) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "casHasChildrenInPlay", "uimaee_messages", "UIMAEE_final_step_parent_cas_child_count__FINEST", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
            }
            casStateEntry.setPendingReply(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalStep(FinalStep aStep, String aCasReferenceId) {
        block48: {
            endpoint = null;
            replySentToClient = false;
            isSubordinate = false;
            cacheEntry = null;
            casStateEntry = null;
            parentCasStateEntry = null;
            freeCasEndpoint = null;
            parentCASCacheEntry = null;
            cEndpoint = null;
            casDropped = false;
            doDecrementChildCount = false;
            this.localCache.dumpContents();
            try {
                cacheEntry = this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                casStateEntry = this.localCache.lookupEntry(aCasReferenceId);
                if (casStateEntry.getState() == 1) break block48;
                casStateEntry.setFinalStep(aStep);
                casStateEntry.setState(1);
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINE, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_cas_in_finalstep__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
                }
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) return;
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                return;
            }
        }
        try {
            endpoint = this.getInProcessCache().getEndpoint(null, aCasReferenceId);
            e = this.finalStepMux;
            synchronized (e) {
                if (this.getInProcessCache().entryExists(aCasReferenceId)) ** break block49
            }
            var19_17 = null;
            if (!replySentToClient) ** GOTO lbl162
            this.removeMessageOrigin(aCasReferenceId);
            ** GOTO lbl161
            {
                if (!this.casHasChildrenInPlay(casStateEntry)) ** break block50
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINE, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_cas_has_children__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
                }
                replySentToClient = false;
            }
            ** GOTO lbl177
            {
                block53: {
                    block51: {
                        block52: {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_parent_cas_no_children__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
                            }
                            v0 = isSubordinate = casStateEntry.getInputCasReferenceId() != null;
                            if (isSubordinate) {
                                freeCasEndpoint = cacheEntry.getFreeCasEndpoint();
                                parentCasStateEntry = this.fetchParentCasFromLocalCache(casStateEntry);
                                parentCASCacheEntry = this.fetchParentCasFromGlobalCache(casStateEntry);
                                doDecrementChildCount = true;
                            }
                            if (!this.forceToDropTheCas(parentCasStateEntry, cacheEntry, aStep)) break block51;
                            if (!casStateEntry.isReplyReceived()) break block52;
                            if (isSubordinate) {
                                this.dropFlow(aCasReferenceId, true);
                                this.dropCAS(aCasReferenceId, true);
                                casDropped = true;
                                this.localCache.dumpContents();
                                if (this.isTopLevelComponent()) {
                                    replySentToClient = true;
                                }
                            }
                            break block53;
                        }
                        doDecrementChildCount = false;
                        break block53;
                    }
                    if (!casStateEntry.isDropped()) {
                        casStateEntry.setWaitingForRelease(true);
                        cEndpoint = this.replyToClient(cacheEntry, casStateEntry);
                        replySentToClient = true;
                        if (cEndpoint.isRemote()) {
                            if (!this.isCasMultiplier()) {
                                this.dropCAS(aCasReferenceId, true);
                            }
                            casDropped = true;
                        } else {
                            try {
                                this.localCache.lookupEntry(aCasReferenceId).setDropped(true);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.localCache.remove(aCasReferenceId);
                        }
                        this.localCache.dumpContents();
                    }
                }
                if (parentCasStateEntry == null && isSubordinate) {
                    parentCasStateEntry = this.localCache.lookupEntry(casStateEntry.getInputCasReferenceId());
                }
                if (doDecrementChildCount && parentCasStateEntry != null) {
                    parentCasStateEntry.decrementSubordinateCasInPlayCount();
                    this.localCache.dumpContents();
                    if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINE, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_cas_decremented_child_count__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), casStateEntry.getSubordinateCasInPlayCount()});
                    }
                }
                v1 = clientIsCollocated = cEndpoint == null || cEndpoint.isRemote() == false;
                if (parentCasStateEntry != null && parentCasStateEntry.getSubordinateCasInPlayCount() == 0 && parentCasStateEntry.isFailed()) {
                    parentCasStateEntry.setReplyReceived();
                }
                if (isSubordinate && this.releaseParentCas(casDropped, clientIsCollocated, parentCasStateEntry)) {
                    lastDelegateEndpoint = parentCasStateEntry.getLastDelegate().getEndpoint();
                    if (lastDelegateEndpoint.processParentLast()) {
                        this.process(parentCASCacheEntry.getCas(), parentCasStateEntry.getCasReferenceId());
                    } else {
                        this.finalStep(parentCasStateEntry.getFinalStep(), parentCasStateEntry.getCasReferenceId());
                    }
                }
                ** if (endpoint == null) goto lbl106
            }
lbl-1000:
            // 1 sources

            {
                this.dropStats(aCasReferenceId, endpoint.getEndpoint());
            }
lbl106:
            // 2 sources

            ** GOTO lbl196
        }
        catch (Exception e) {
            map = new HashMap<String, Object>();
            map.put("Command", 2000);
            map.put("CasReference", aCasReferenceId);
            if (endpoint != null) {
                map.put("Endpoint", endpoint);
            }
            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            this.handleError(map, e);
            var19_20 = null;
            if (replySentToClient) {
                this.removeMessageOrigin(aCasReferenceId);
                this.dropStats(aCasReferenceId, super.getName());
            }
            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_show_internal_stats__FINEST", new Object[]{this.getName(), this.flowMap.size(), this.getInProcessCache().getSize(), this.originMap.size(), this.statsMap.size()});
            }
            if (casDropped == false) return;
            if (freeCasEndpoint == null) return;
            try {
                freeCasEndpoint.setReplyEndpoint(true);
                freeCasEndpoint.setIsCasMultiplier(true);
                freeCasEndpoint.setFreeCasEndpoint(true);
                this.getOutputChannel().sendRequest(2005, aCasReferenceId, freeCasEndpoint);
                return;
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) return;
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                return;
            }
        }
        {
            catch (Throwable var18_31) {
                var19_21 = null;
                if (replySentToClient) {
                    this.removeMessageOrigin(aCasReferenceId);
                    this.dropStats(aCasReferenceId, super.getName());
                }
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_show_internal_stats__FINEST", new Object[]{this.getName(), this.flowMap.size(), this.getInProcessCache().getSize(), this.originMap.size(), this.statsMap.size()});
                }
                if (casDropped == false) throw var18_31;
                if (freeCasEndpoint == null) throw var18_31;
                ** try [egrp 7[TRYBLOCK] [14 : 1187->1229)] { 
lbl151:
                // 1 sources

                freeCasEndpoint.setReplyEndpoint(true);
                freeCasEndpoint.setIsCasMultiplier(true);
                freeCasEndpoint.setFreeCasEndpoint(true);
                this.getOutputChannel().sendRequest(2005, aCasReferenceId, freeCasEndpoint);
                throw var18_31;
lbl156:
                // 1 sources

                catch (Exception e) {
                    if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) throw var18_31;
                    UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
                throw var18_31;
            }
lbl161:
            // 1 sources

            this.dropStats(aCasReferenceId, super.getName());
lbl162:
            // 2 sources

            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_show_internal_stats__FINEST", new Object[]{this.getName(), this.flowMap.size(), this.getInProcessCache().getSize(), this.originMap.size(), this.statsMap.size()});
            }
            if (casDropped == false) return;
            if (freeCasEndpoint == null) return;
            ** try [egrp 7[TRYBLOCK] [14 : 1187->1229)] { 
lbl167:
            // 1 sources

            freeCasEndpoint.setReplyEndpoint(true);
            freeCasEndpoint.setIsCasMultiplier(true);
            freeCasEndpoint.setFreeCasEndpoint(true);
            this.getOutputChannel().sendRequest(2005, aCasReferenceId, freeCasEndpoint);
            return;
lbl172:
            // 1 sources

            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) return;
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            return;
lbl177:
            // 1 sources

            var19_18 = null;
            if (replySentToClient) {
                this.removeMessageOrigin(aCasReferenceId);
                this.dropStats(aCasReferenceId, super.getName());
            }
            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_show_internal_stats__FINEST", new Object[]{this.getName(), this.flowMap.size(), this.getInProcessCache().getSize(), this.originMap.size(), this.statsMap.size()});
            }
            if (casDropped == false) return;
            if (freeCasEndpoint == null) return;
            ** try [egrp 7[TRYBLOCK] [14 : 1187->1229)] { 
lbl186:
            // 1 sources

            freeCasEndpoint.setReplyEndpoint(true);
            freeCasEndpoint.setIsCasMultiplier(true);
            freeCasEndpoint.setFreeCasEndpoint(true);
            this.getOutputChannel().sendRequest(2005, aCasReferenceId, freeCasEndpoint);
            return;
lbl191:
            // 1 sources

            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) return;
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            return;
lbl196:
            // 1 sources

            var19_19 = null;
            if (replySentToClient) {
                this.removeMessageOrigin(aCasReferenceId);
                this.dropStats(aCasReferenceId, super.getName());
            }
            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.FINEST, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_final_step_show_internal_stats__FINEST", new Object[]{this.getName(), this.flowMap.size(), this.getInProcessCache().getSize(), this.originMap.size(), this.statsMap.size()});
            }
            if (casDropped == false) return;
            if (freeCasEndpoint == null) return;
            try {}
            catch (Exception e) {}
            if (UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).isLoggable(Level.WARNING) == false) return;
            UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
            UIMAFramework.getLogger((Class)AggregateAnalysisEngineController_impl.CLASS_NAME).logrb(Level.WARNING, AggregateAnalysisEngineController_impl.CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            return;
            freeCasEndpoint.setReplyEndpoint(true);
            freeCasEndpoint.setIsCasMultiplier(true);
            freeCasEndpoint.setFreeCasEndpoint(true);
            this.getOutputChannel().sendRequest(2005, aCasReferenceId, freeCasEndpoint);
            return;
        }
    }

    public boolean releaseParentCas(boolean casDropped, boolean clientIsCollocated, LocalCache.CasStateEntry parentCasStateEntry) {
        boolean retValue;
        if (parentCasStateEntry == null) {
            return false;
        }
        boolean bl = retValue = (casDropped || clientIsCollocated) && parentCasStateEntry.isReplyReceived() && parentCasStateEntry.getState() == 1 && parentCasStateEntry.getSubordinateCasInPlayCount() == 0;
        if (this.clientEndpoint != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "finalStep", "uimaee_messages", "UIMAEE_show_why_not_releasing_parent__FINEST", new Object[]{this.getComponentName(), parentCasStateEntry.getCasReferenceId(), retValue, casDropped, this.clientEndpoint.isRemote(), parentCasStateEntry.isReplyReceived(), parentCasStateEntry.isPendingReply(), parentCasStateEntry.getState() == 1, parentCasStateEntry.getSubordinateCasInPlayCount(), this.getComponentName()});
        }
        return retValue;
    }

    private boolean forceToDropTheCas(LocalCache.CasStateEntry entry, InProcessCache.CacheEntry cacheEntry, FinalStep aStep) {
        boolean isNewCas;
        String casProducer = cacheEntry.getCasProducerAggregateName();
        boolean bl = isNewCas = cacheEntry.isNewCas() && casProducer != null && this.getComponentName().equals(casProducer);
        if (entry != null && entry.isFailed() && isNewCas) {
            return true;
        }
        return isNewCas && (aStep.getForceCasToBeDropped() || !this.isCasMultiplier());
    }

    private boolean casHasExceptions(LocalCache.CasStateEntry casStateEntry) {
        return casStateEntry.getErrors().size() > 0;
    }

    private void sendReplyWithException(InProcessCache.CacheEntry acacheEntry, LocalCache.CasStateEntry casStateEntry, Endpoint replyEndpoint) throws Exception {
        if (casStateEntry.isSubordinate()) {
            casStateEntry = this.getLocalCache().getTopCasAncestor(casStateEntry.getCasReferenceId());
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReplyWithException", "uimaee_messages", "UIMAEE_returning_exception_to_client__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), replyEndpoint.getEndpoint()});
        }
        if (replyEndpoint.isRemote()) {
            this.getOutputChannel().sendReply(casStateEntry.getErrors().get(0), casStateEntry.getCasReferenceId(), null, replyEndpoint, 2000);
        } else {
            replyEndpoint.setReplyEndpoint(true);
            UimaTransport vmTransport = this.getTransport(replyEndpoint.getEndpoint());
            UimaVmMessage message = vmTransport.produceMessage(2000, 3001, this.getName());
            message.addIntProperty("Payload", 1003);
            message.addStringProperty("CasReference", casStateEntry.getCasReferenceId());
            UimaEEServiceException wrapper = null;
            Throwable cause = casStateEntry.getErrors().get(0);
            if (!(cause instanceof UimaEEServiceException)) {
                wrapper = cause instanceof AsynchAEException && cause.getCause() != null ? new UimaEEServiceException(cause.getCause()) : new UimaEEServiceException(cause);
            }
            if (wrapper == null) {
                message.addObjectProperty("Cargo", cause);
            } else {
                message.addObjectProperty("Cargo", wrapper);
            }
            vmTransport.getUimaMessageDispatcher(replyEndpoint.getEndpoint()).dispatch(message);
            this.dropStats(casStateEntry.getCasReferenceId(), this.getName());
        }
    }

    private boolean sendExceptionToClient(InProcessCache.CacheEntry cacheEntry, LocalCache.CasStateEntry casStateEntry, Endpoint replyEndpoint) throws Exception {
        if (casStateEntry.isSubordinate()) {
            LocalCache.CasStateEntry topAncestorCasStateEntry = this.getLocalCache().getTopCasAncestor(casStateEntry.getInputCasReferenceId());
            if (topAncestorCasStateEntry.isFailed() && this.casHasExceptions(casStateEntry) && topAncestorCasStateEntry.getSubordinateCasInPlayCount() == 0) {
                return true;
            }
            this.cmOutstandingCASes.put(casStateEntry.getCasReferenceId(), casStateEntry.getCasReferenceId());
        } else if (casStateEntry.isFailed() && this.casHasExceptions(casStateEntry)) {
            return true;
        }
        return false;
    }

    private void sendReplyToRemoteClient(InProcessCache.CacheEntry cacheEntry, LocalCache.CasStateEntry casStateEntry, Endpoint replyEndpoint) throws Exception {
        if (replyEndpoint.getDestination() != null && this.isClientDead(replyEndpoint.getDestination().toString())) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReplyToRemoteClient", "uimaee_messages", "UIMAEE_client_dead__FINE", new Object[]{this.getComponentName(), replyEndpoint.getDestination().toString(), casStateEntry.getCasReferenceId()});
            }
            this.dropCAS(casStateEntry.getCasReferenceId(), true);
            if (this.getInProcessCache().isEmpty()) {
                this.endProcess(2000);
            }
            return;
        }
        if (this.sendExceptionToClient(cacheEntry, casStateEntry, replyEndpoint)) {
            this.sendReplyWithException(cacheEntry, casStateEntry, replyEndpoint);
        } else {
            this.getOutputChannel().sendReply(cacheEntry, replyEndpoint);
        }
        if (!casStateEntry.isSubordinate() || casStateEntry.isSubordinate() && this.isCasMultiplier() && casStateEntry.deliveryToClientFailed()) {
            if (this.cmOutstandingCASes.containsKey(casStateEntry.getCasReferenceId())) {
                this.cmOutstandingCASes.remove(casStateEntry.getCasReferenceId());
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReplyToRemoteClient", "uimaee_messages", "UIMAEE_client_dead__FINE", new Object[]{this.getComponentName(), replyEndpoint.getDestination().toString(), casStateEntry.getCasReferenceId()});
            }
            this.dropCAS(casStateEntry.getCasReferenceId(), true);
            if (this.getInProcessCache().isEmpty()) {
                this.endProcess(2000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendReplyToCollocatedClient(InProcessCache.CacheEntry cacheEntry, LocalCache.CasStateEntry casStateEntry, Endpoint replyEndpoint) throws Exception {
        boolean casProducedInThisAggregate = this.getComponentName().equals(cacheEntry.getCasProducerAggregateName());
        boolean isSubordinate = casStateEntry.isSubordinate();
        boolean serviceIsCM = this.isCasMultiplier();
        if (this.sendExceptionToClient(cacheEntry, casStateEntry, replyEndpoint)) {
            try {
                try {
                    this.sendReplyWithException(cacheEntry, casStateEntry, replyEndpoint);
                }
                catch (Exception e) {
                    Object var9_8 = null;
                    if (!casProducedInThisAggregate) return;
                    this.dropCAS(casStateEntry.getCasReferenceId(), true);
                    return;
                }
                Object var9_7 = null;
                if (!casProducedInThisAggregate) return;
                this.dropCAS(casStateEntry.getCasReferenceId(), true);
                return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!casProducedInThisAggregate) throw throwable;
                this.dropCAS(casStateEntry.getCasReferenceId(), true);
                throw throwable;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReplyToCollocatedClient", "uimaee_messages", "UIMAEE_sending_reply_to_client__FINE", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId(), replyEndpoint.getEndpoint()});
            }
            int mType = 3001;
            if (isSubordinate && serviceIsCM && casProducedInThisAggregate) {
                mType = 3000;
                String inputCasId = this.getLocalCache().lookupInputCasReferenceId(casStateEntry);
                if (inputCasId != null) {
                    LocalCache.CasStateEntry parentCasStateEntry;
                    if (!inputCasId.equals(casStateEntry.getInputCasReferenceId())) {
                        casStateEntry.setInputCasReferenceId(inputCasId);
                        cacheEntry.setInputCasReferenceId(inputCasId);
                    }
                    if ((parentCasStateEntry = this.parentController.getLocalCache().lookupEntry(inputCasId)) != null) {
                        parentCasStateEntry.incrementSubordinateCasInPlayCount();
                        parentCasStateEntry.incrementOutstandingFlowCounter();
                    }
                }
            }
            this.sendVMMessage(mType, replyEndpoint, cacheEntry);
        }
    }

    private boolean validEndpoint(Endpoint endpoint, LocalCache.CasStateEntry casStateEntry) {
        if (endpoint == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validEndpoint", "uimaee_messages", "UIMAEE_client_endpoint_not_found__INFO", new Object[]{this.getComponentName(), casStateEntry.getCasReferenceId()});
            }
            return false;
        }
        if (endpoint.getEndpoint() == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validEndpoint", "uimaee_messages", "UIMAEE_no_reply_destination__INFO", new Object[]{casStateEntry.getCasReferenceId()});
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Command", 2000);
            map.put("CasReference", casStateEntry.getCasReferenceId());
            this.handleError(map, new UnknownDestinationException());
            return false;
        }
        return !endpoint.isCasMultiplier();
    }

    private Endpoint replyToClient(InProcessCache.CacheEntry cacheEntry, LocalCache.CasStateEntry casStateEntry) throws Exception {
        Endpoint endpoint = this.getReplyEndpoint(cacheEntry, casStateEntry);
        if (!this.validEndpoint(endpoint, casStateEntry)) {
            return null;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "replyToClient", "uimaee_messages", "UIMAEE_final_step__FINEST", new Object[]{casStateEntry.getCasReferenceId(), (double)(System.nanoTime() - endpoint.getEntryTime()) / 1000000.0});
        }
        endpoint.setFinal(true);
        if (!this.isStopped()) {
            try {
                if (endpoint.isRemote()) {
                    this.sendReplyToRemoteClient(cacheEntry, casStateEntry, endpoint);
                } else {
                    this.sendReplyToCollocatedClient(cacheEntry, casStateEntry, endpoint);
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "replyToClient", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "replyToClient", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        return endpoint;
    }

    private boolean isClientDead(String destination) {
        return this.deadClientDestinationMap.containsKey(destination);
    }

    private void sendVMMessage(int messageType, Endpoint endpoint, InProcessCache.CacheEntry cacheEntry) throws Exception {
        UimaTransport transport = this.getTransport(endpoint.getEndpoint());
        UimaVmMessage message = transport.produceMessage(2000, messageType, this.getName());
        if (cacheEntry.getCasProducerAggregateName() != null && cacheEntry.getCasProducerAggregateName().equals(this.getComponentName())) {
            message.addLongProperty("CasSequence", cacheEntry.getCasSequence());
        }
        message.addStringProperty("CasReference", cacheEntry.getCasReferenceId());
        if (cacheEntry.getInputCasReferenceId() != null) {
            message.addStringProperty("InputCasReference", cacheEntry.getInputCasReferenceId());
        }
        ServicePerformance casStats = this.getCasStatistics(cacheEntry.getCasReferenceId());
        message.addLongProperty("TimeToSerializeCAS", casStats.getRawCasSerializationTime());
        message.addLongProperty("TimeToDeserializeCAS", casStats.getRawCasDeserializationTime());
        message.addLongProperty("TimeInProcessCAS", casStats.getRawAnalysisTime());
        long iT = this.getIdleTimeBetweenProcessCalls(2000);
        message.addLongProperty("IdleTime", iT);
        transport.getUimaMessageDispatcher(endpoint.getEndpoint()).dispatch(message);
        this.dropStats(cacheEntry.getCasReferenceId(), this.getName());
    }

    private Endpoint getReplyEndpoint(InProcessCache.CacheEntry cacheEntry, LocalCache.CasStateEntry casStateEntry) throws Exception {
        Endpoint endpoint = null;
        if (this.isTopLevelComponent()) {
            endpoint = casStateEntry.isSubordinate() ? this.getInProcessCache().getTopAncestorEndpoint(cacheEntry) : this.getInProcessCache().getEndpoint(null, casStateEntry.getCasReferenceId());
        } else {
            endpoint = this.getReplyEndpoint(cacheEntry);
            this.dropFlow(casStateEntry.getCasReferenceId(), false);
        }
        return endpoint;
    }

    private Endpoint getReplyEndpoint(InProcessCache.CacheEntry cacheEntry) throws Exception {
        if (cacheEntry == null) {
            return null;
        }
        Endpoint endpoint = this.getMessageOrigin(cacheEntry.getCasReferenceId());
        if (endpoint == null && cacheEntry.getInputCasReferenceId() != null) {
            endpoint = this.getReplyEndpoint(this.getInProcessCache().getCacheEntryForCAS(cacheEntry.getInputCasReferenceId()));
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFlowStep(FlowContainer aFlow, String aCasReferenceId, boolean newCAS) throws AsynchAEException {
        Step step = null;
        try {
            FlowControllerContainer flowControllerContainer = this.flowControllerContainer;
            synchronized (flowControllerContainer) {
                step = aFlow.next();
            }
        }
        catch (Exception e) {
            block21: {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                try {
                    this.sendReplyWithShutdownException(aCasReferenceId);
                    ErrorContext ec = new ErrorContext();
                    ec.add("ThrowableError", e);
                    ec.add("CasReference", aCasReferenceId);
                    this.handleAction("Terminate", null, ec);
                }
                catch (Exception ex) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block21;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            return;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_step__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
        }
        try {
            if (step instanceof SimpleStep) {
                this.simpleStep((SimpleStep)step, aCasReferenceId);
            } else if (step instanceof ParallelStep) {
                this.parallelStep((ParallelStep)step, aCasReferenceId);
            } else if (step instanceof FinalStep) {
                LocalCache.CasStateEntry casStateEntry;
                if (newCAS && (casStateEntry = this.localCache.lookupEntry(aCasReferenceId)) != null) {
                    casStateEntry.setReplyReceived();
                }
                this.finalStep((FinalStep)step, aCasReferenceId);
            } else {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.SEVERE, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_invalid_step__SEVERE", new Object[]{this.getComponentName(), step, aCasReferenceId});
                throw new UIMARuntimeException((Throwable)new Exception("Invalid Flow Step:" + step + " Object. Check Descriptor For Invalid AE Key"));
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_completed_step__FINEST", new Object[]{this.getComponentName(), aCasReferenceId});
            }
        }
        catch (Exception e) {
            ErrorContext ec = new ErrorContext();
            ec.add("ThrowableError", e);
            ec.add("CasReference", aCasReferenceId);
            try {
                this.handleAction("Terminate", null, ec);
            }
            catch (Exception ex) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "executeFlowStep", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
            }
        }
    }

    private void dispatch(InProcessCache.CacheEntry entry, Endpoint anEndpoint) throws AsynchAEException {
        if (!anEndpoint.isRemote()) {
            try {
                UimaTransport transport = this.getTransport(anEndpoint.getEndpoint());
                UimaVmMessage message = transport.produceMessage(2000, 3000, this.getName());
                message.addStringProperty("CasReference", entry.getCasReferenceId());
                transport.getUimaMessageDispatcher(anEndpoint.getEndpoint()).dispatch(message);
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "dispatch", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "dispatch", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        } else if (!this.delayCasIfDelegateInTimedOutState(entry.getCasReferenceId(), anEndpoint.getDelegateKey(), entry.getCas().hashCode())) {
            this.getOutputChannel().sendRequest(2000, entry.getCasReferenceId(), anEndpoint);
        }
    }

    public boolean delayCasIfDelegateInTimedOutState(String aCasReferenceId, String aDelegateKey, long casHashcode) throws AsynchAEException {
        Delegate delegate = this.lookupDelegate(aDelegateKey);
        if (delegate != null && delegate.getState() == 2) {
            int listSize = delegate.addCasToPendingDispatchList(aCasReferenceId, casHashcode);
            if (listSize == 1) {
                delegate.setAwaitingPingReply();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "delayCasIfDelegateInTimedOutState", "uimaee_messages", "UIMAEE_aggregate_sending_ping__INFO", new Object[]{this.getComponentName(), delegate.getKey()});
                }
                this.retryMetadataRequest(delegate.getEndpoint());
            }
            return true;
        }
        return false;
    }

    private void dispatchProcessRequest(InProcessCache.CacheEntry entry, Endpoint anEndpoint, boolean addEndpointToCache) throws AsynchAEException {
        if (addEndpointToCache) {
            this.getInProcessCache().addEndpoint(anEndpoint, entry.getCasReferenceId());
        }
        anEndpoint.setController(this);
        this.dispatch(entry, anEndpoint);
    }

    public void retryProcessCASRequest(String aCasReferenceId, Endpoint anEndpoint, boolean addEndpointToCache) throws AsynchAEException {
        Endpoint endpoint = null;
        String key = this.lookUpDelegateKey(anEndpoint.getEndpoint());
        endpoint = this.getInProcessCache().getEndpoint(anEndpoint.getEndpoint(), aCasReferenceId);
        if (endpoint != null) {
            Endpoint masterEndpoint = this.lookUpEndpoint(key, true);
            if (masterEndpoint.getDestination() != null && !masterEndpoint.getDestination().toString().equals(endpoint.getDestination().toString())) {
                endpoint.setDestination(masterEndpoint.getDestination());
            }
        } else {
            endpoint = anEndpoint;
            endpoint = this.lookUpEndpoint(key, true);
            this.getInProcessCache().addEndpoint(endpoint, aCasReferenceId);
        }
        if (this.getInProcessCache().entryExists(aCasReferenceId)) {
            this.dispatchProcessRequest(this.getInProcessCache().getCacheEntryForCAS(aCasReferenceId), endpoint, addEndpointToCache);
        }
    }

    private void dispatchProcessRequest(InProcessCache.CacheEntry entry, Endpoint[] anEndpointList, boolean addEndpointToCache) throws AsynchAEException {
        ArrayList<Endpoint> endpointList = new ArrayList<Endpoint>();
        for (int i = 0; i < anEndpointList.length; ++i) {
            if (this.delayCasIfDelegateInTimedOutState(entry.getCasReferenceId(), anEndpointList[i].getEndpoint(), entry.getCas().hashCode())) continue;
            endpointList.add(anEndpointList[i]);
            if (!addEndpointToCache) continue;
            this.getInProcessCache().addEndpoint(anEndpointList[i], entry.getCasReferenceId());
        }
        Endpoint[] endpoints = new Endpoint[endpointList.size()];
        endpointList.toArray(endpoints);
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.isRemote()) continue;
            endpoint.setSerializer("xmi");
            this.getOutputChannel().sendRequest(2000, entry.getCasReferenceId(), endpoint);
        }
    }

    public boolean isDelegateKeyValid(String aDelegateKey) {
        return this.destinationMap.containsKey(aDelegateKey);
    }

    public String lookUpDelegateKey(String anEndpointName) {
        return this.lookUpDelegateKey(anEndpointName, null);
    }

    public String lookUpDelegateKey(String anEndpointName, String server) {
        String key2 = null;
        if (this.destinationToKeyMap.containsKey(anEndpointName)) {
            Set keys = this.destinationMap.keySet();
            for (String key2 : keys) {
                Endpoint_impl endp = (Endpoint_impl)this.destinationMap.get(key2);
                if (endp != null && endp.getEndpoint().equalsIgnoreCase(anEndpointName)) {
                    if (server == null || endp.getServerURI() != null && endp.getServerURI().equalsIgnoreCase(server)) break;
                    key2 = null;
                    continue;
                }
                key2 = null;
            }
        }
        return key2;
    }

    public Endpoint lookUpEndpoint(String anAnalysisEngineKey, boolean clone) throws AsynchAEException {
        Endpoint endpoint = (Endpoint)this.destinationMap.get(anAnalysisEngineKey);
        if (endpoint != null && clone) {
            return (Endpoint)((Endpoint_impl)endpoint).clone();
        }
        return endpoint;
    }

    public PrimitiveServiceInfo getDelegateServiceInfo(String aDelegateKey) {
        if (this.delegateStatMap == null || aDelegateKey == null || !this.delegateStatMap.containsKey(aDelegateKey)) {
            return null;
        }
        Object[] delegateStats = this.delegateStatMap.get(aDelegateKey);
        if (delegateStats != null) {
            return (PrimitiveServiceInfo)delegateStats[0];
        }
        return null;
    }

    public ServicePerformance getDelegateServicePerformance(String aDelegateKey) {
        Object[] delegateStats = this.delegateStatMap.get(aDelegateKey);
        if (delegateStats != null) {
            return (ServicePerformance)delegateStats[1];
        }
        return null;
    }

    public ServiceErrors getDelegateServiceErrors(String aDelegateKey) {
        Object[] delegateStats = this.delegateStatMap.get(aDelegateKey);
        if (delegateStats != null) {
            return (ServiceErrors)delegateStats[2];
        }
        return null;
    }

    public void mergeTypeSystem(String aTypeSystem, String fromDestination) throws AsynchAEException {
        this.mergeTypeSystem(aTypeSystem, fromDestination, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeTypeSystem(String aTypeSystem, String fromDestination, String fromServer) throws AsynchAEException {
        block23: {
            try {
                Object bis;
                Endpoint_impl endpoint = null;
                String key = this.lookUpDelegateKey(fromDestination, fromServer);
                if (key != null) {
                    endpoint = (Endpoint_impl)this.destinationMap.get(key);
                }
                if (endpoint == null) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "mergeTypeSystem", "uimaee_messages", "UIMAEE_metadata_recvd_from_invalid_delegate__INFO", new Object[]{this.getName(), fromDestination});
                    }
                    break block23;
                }
                if (!endpoint.isWaitingForResponse()) break block23;
                endpoint.setWaitingForResponse(false);
                endpoint.cancelTimer();
                boolean collocatedAggregate = false;
                if (endpoint.getServiceInfo() != null) {
                    endpoint.getServiceInfo().setState(BaseAnalysisEngineController.ServiceState.RUNNING.name());
                }
                ResourceMetaData resource = null;
                PrimitiveServiceInfo remoteDelegateServiceInfo = null;
                if (aTypeSystem.trim().length() > 0) {
                    if (endpoint.isRemote() && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "mergeTypeSystem", "uimaee_messages", "UIMAEE_remote_delegate_ready__CONFIG", new Object[]{this.getComponentName(), fromDestination});
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "mergeTypeSystem", "uimaee_messages", "UIMAEE_merge_ts_from_delegate__CONFIG", new Object[]{fromDestination});
                    }
                    bis = new ByteArrayInputStream(aTypeSystem.getBytes());
                    XMLInputSource in1 = new XMLInputSource((InputStream)bis, null);
                    resource = UIMAFramework.getXMLParser().parseResourceMetaData(in1);
                    if (this.isStopped()) {
                        return;
                    }
                    this.getCasManagerWrapper().addMetadata((ProcessingResourceMetaData)resource);
                    this.analysisEngineMetaDataMap.put(key, (ProcessingResourceMetaData)resource);
                    if (((ProcessingResourceMetaData)resource).getOperationalProperties().getOutputsNewCASes()) {
                        endpoint.setIsCasMultiplier(true);
                        this.remoteCasMultiplierList.add(key);
                    }
                    if (endpoint.isRemote()) {
                        Object o = null;
                        remoteDelegateServiceInfo = this.getDelegateServiceInfo(key);
                        if (remoteDelegateServiceInfo != null && (o = ((ProcessingResourceMetaData)resource).getConfigurationParameterSettings().getParameterValue("AEInstanceCount")) != null) {
                            remoteDelegateServiceInfo.setAnalysisEngineInstanceCount((Integer)o);
                        }
                    }
                } else {
                    collocatedAggregate = true;
                }
                endpoint.setInitialized(true);
                bis = this.unregisteredDelegateList;
                synchronized (bis) {
                    if (!this.requestForMetaSentToRemotes && !this.allDelegatesAreRemote) {
                        String unregisteredDelegateKey = null;
                        for (int i = 0; i < this.unregisteredDelegateList.size(); ++i) {
                            unregisteredDelegateKey = (String)this.unregisteredDelegateList.get(i);
                            if (!unregisteredDelegateKey.equals(key)) continue;
                            this.unregisteredDelegateList.remove(i);
                        }
                    }
                }
                if (!collocatedAggregate && !(resource instanceof ProcessingResourceMetaData) || !this.allTypeSystemsMerged()) break block23;
                for (int i = 0; i < this.remoteCasMultiplierList.size(); ++i) {
                    Endpoint endpt = (Endpoint)this.destinationMap.get((String)this.remoteCasMultiplierList.get(i));
                    if (endpt == null || !endpt.isCasMultiplier() || !endpt.isRemote()) continue;
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "mergeTypeSystem", "uimaee_messages", "UIMAEE_shadow_caspool_set__INFO", new Object[]{this.getComponentName(), endpt.getShadowPoolSize(), (String)this.remoteCasMultiplierList.get(i)});
                    }
                    this.getCasManagerWrapper().initialize(endpt.getShadowPoolSize(), (String)this.remoteCasMultiplierList.get(i));
                    if (remoteDelegateServiceInfo == null) continue;
                    remoteDelegateServiceInfo.setCASMultiplier();
                }
                if (this.isStopped()) break block23;
                try {
                    this.completeInitialization();
                }
                catch (ResourceInitializationException ex) {
                    this.handleInitializationError((Exception)((Object)ex));
                    return;
                }
            }
            catch (Exception e) {
                throw new AsynchAEException(e);
            }
        }
    }

    private synchronized void completeInitialization() throws Exception {
        if (this.initialized) {
            return;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "completeInitialization", "uimaee_messages", "UIMAEE_all_ts_merged__CONFIG");
        }
        if (this.errorHandlerChain == null) {
            this.plugInDefaultErrorHandlerChain();
        }
        AnalysisEngineDescription specifier = (AnalysisEngineDescription)super.getResourceSpecifier();
        this.aggregateMetadata = specifier.getAnalysisEngineMetaData();
        this.flowControllerContainer = UimaClassFactory.produceAggregateFlowControllerContainer(specifier, this.flowControllerDescriptor, this.analysisEngineMetaDataMap, this.getUimaContextAdmin(), ((AnalysisEngineDescription)this.getResourceSpecifier()).getSofaMappings(), super.getManagementInterface());
        if (this.isTopLevelComponent()) {
            this.getCasManagerWrapper().addMetadata((ProcessingResourceMetaData)this.flowControllerContainer.getMetaData());
            this.getCasManagerWrapper().initialize("AggregateContext");
            this.aggregateMetadata.setTypeSystem(this.getCasManagerWrapper().getMetadata().getTypeSystem());
            this.aggregateMetadata.setTypePriorities(this.getCasManagerWrapper().getMetadata().getTypePriorities());
            this.aggregateMetadata.setFsIndexCollection(this.getCasManagerWrapper().getMetadata().getFsIndexCollection());
        }
        if (this.disabledDelegateList.size() > 0) {
            this.flowControllerContainer.removeAnalysisEngines((Collection)this.disabledDelegateList);
        }
        if (this.isTopLevelComponent()) {
            this.onInitialize();
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "completeInitialization", "uimaee_messages", "UIMAEE_initialized_controller__INFO", new Object[]{this.getComponentName()});
        }
        this.latch.openLatch(this.getName(), this.isTopLevelComponent(), true);
        this.initialized = true;
        this.notifyListenersWithInitializationStatus(null);
        if (!this.isTopLevelComponent()) {
            this.changeState(BaseAnalysisEngineController.ServiceState.RUNNING);
        }
    }

    private String findKeyForValue(String fromDestination) {
        Set set = this.destinationMap.entrySet();
        for (Map.Entry entry : set) {
            String value;
            Endpoint endpoint = (Endpoint)entry.getValue();
            if (endpoint == null || !(value = endpoint.getEndpoint()).equals(fromDestination)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private boolean allTypeSystemsMerged() {
        Map.Entry entry;
        Endpoint endpoint;
        if (this.typeSystemsMerged) {
            return true;
        }
        Set set = this.destinationMap.entrySet();
        int delegateCount = 0;
        Iterator it = set.iterator();
        while (it.hasNext() && ((endpoint = (Endpoint)(entry = it.next()).getValue()) == null || endpoint.getStatus() == 3 || endpoint.isInitialized())) {
            ++delegateCount;
        }
        return delegateCount == this.destinationMap.size();
    }

    public void initialize() throws AsynchAEException {
        LongNumericStatistic statistic = null;
        statistic = this.getMonitor().getLongNumericStatistic("", "ProcessCount");
        if (statistic == null) {
            statistic = new LongNumericStatistic("ProcessCount");
            this.getMonitor().addStatistic("", statistic);
        }
        if ((statistic = this.getMonitor().getLongNumericStatistic("", "ProcessErrorCount")) == null) {
            statistic = new LongNumericStatistic("ProcessErrorCount");
            this.getMonitor().addStatistic("", statistic);
        }
        if ((statistic = this.getMonitor().getLongNumericStatistic("", "ProcessErrorRetryCount")) == null) {
            statistic = new LongNumericStatistic("ProcessErrorRetryCount");
            this.getMonitor().addStatistic("", statistic);
        }
    }

    public void dispatchMetadataRequest(Endpoint anEndpoint) throws AsynchAEException {
        if (this.isStopped()) {
            return;
        }
        if (anEndpoint == null) {
            throw new AsynchAEException("Controller:" + this.getComponentName() + " Unable To Dispatch GetMeta Request. Provided Endpoint is Invalid (NULL)");
        }
        anEndpoint.setController(this);
        anEndpoint.setWaitingForResponse(true);
        String key = this.lookUpDelegateKey(anEndpoint.getEndpoint());
        if (key != null && !this.delegateStatMap.containsKey(key) && key != null) {
            ServiceInfo serviceInfo = anEndpoint.getServiceInfo();
            PrimitiveServiceInfo pServiceInfo = new PrimitiveServiceInfo(serviceInfo.isCASMultiplier(), null);
            pServiceInfo.setBrokerURL(serviceInfo.getBrokerURL());
            pServiceInfo.setInputQueueName(serviceInfo.getInputQueueName());
            pServiceInfo.setState(serviceInfo.getState());
            pServiceInfo.setAnalysisEngineInstanceCount(1);
            ServicePerformance servicePerformance = new ServicePerformance();
            if (anEndpoint.isRemote()) {
                servicePerformance.setRemoteDelegate();
            }
            ServiceErrors serviceErrors = new ServiceErrors();
            this.serviceErrorMap.put(key, serviceErrors);
            Object[] delegateStatsArray = new Object[]{pServiceInfo, servicePerformance, serviceErrors};
            this.delegateStatMap.put(key, delegateStatsArray);
        }
        this.getOutputChannel().sendRequest(2001, null, anEndpoint);
    }

    public void retryMetadataRequest(Endpoint anEndpoint) throws AsynchAEException {
        this.dispatchMetadataRequest(anEndpoint);
    }

    public void sendMetadata(Endpoint anEndpoint) {
        super.sendMetadata(anEndpoint, this.aggregateMetadata);
    }

    public ControllerLatch getControllerLatch() {
        return this.latch;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelegateLifeCycleEvent(String anEndpoint, int aDelegateCount) {
        Endpoint endpoint = null;
        if (this.destinationMap.containsKey(anEndpoint)) {
            endpoint = (Endpoint)this.destinationMap.get(anEndpoint);
        }
        if (aDelegateCount == 0) {
            endpoint.setNoConsumers(true);
            InProcessCache.CacheEntry[] cachedEntries = this.getInProcessCache().getCacheEntriesForEndpoint(anEndpoint);
            for (int i = 0; cachedEntries != null && i < cachedEntries.length; ++i) {
                Object var11_11;
                String parentCasReferenceId;
                String casReferenceId;
                block13: {
                    casReferenceId = cachedEntries[i].getCasReferenceId();
                    parentCasReferenceId = null;
                    try {
                        LocalCache.CasStateEntry parentEntry = this.getLocalCache().getTopCasAncestor(casReferenceId);
                        if (parentEntry != null) {
                            parentCasReferenceId = parentEntry.getCasReferenceId();
                        }
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block13;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleDelegateLifeCycleEvent", "uimaee_messages", "UIMAEE_parent_cas_notin_cache__INFO", new Object[]{this.getComponentName(), casReferenceId});
                    }
                }
                this.getInProcessCache().getEndpoint(anEndpoint, casReferenceId).cancelTimer();
                Endpoint requestOrigin = cachedEntries[i].getMessageOrigin();
                try {
                    try {
                        this.getOutputChannel().sendReply(new UimaEEServiceException("Delegates Not Found To Process CAS on Endpoint:" + anEndpoint), casReferenceId, parentCasReferenceId, requestOrigin, 2000);
                    }
                    catch (Exception e) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleDelegateLifeCycleEvent", "uimaee_messages", "UIMAEE_no_consumers__INFO", new Object[]{casReferenceId, anEndpoint});
                        }
                        var11_11 = null;
                        this.getInProcessCache().remove(casReferenceId);
                        continue;
                    }
                    var11_11 = null;
                    this.getInProcessCache().remove(casReferenceId);
                    continue;
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    this.getInProcessCache().remove(casReferenceId);
                    throw throwable;
                }
            }
        } else if (endpoint != null && endpoint.hasNoConsumers()) {
            endpoint.setNoConsumers(false);
        }
    }

    public void retryLastCommand(int aCommand, Endpoint anEndpoint, String aCasReferenceId) {
        try {
            this.getOutputChannel().sendRequest(aCommand, aCasReferenceId, anEndpoint);
        }
        catch (AsynchAEException e) {
            // empty catch block
        }
    }

    public ServiceErrors getServiceErrors(String aDelegateKey) {
        if (!this.serviceErrorMap.containsKey(aDelegateKey)) {
            return null;
        }
        return (ServiceErrors)this.serviceErrorMap.get(aDelegateKey);
    }

    public AggregateServiceInfo getServiceInfo() {
        if (this.serviceInfo == null) {
            this.serviceInfo = new AggregateServiceInfo(this.isCasMultiplier(), this);
            if (this.isTopLevelComponent() && this.getInputChannel() != null) {
                this.serviceInfo.setInputQueueName(this.getInputChannel().getName());
                this.serviceInfo.setBrokerURL(super.getBrokerURL());
            } else {
                this.serviceInfo.setInputQueueName(this.getName());
                this.serviceInfo.setBrokerURL("vm://localhost");
            }
            this.serviceInfo.setDeploymentDescriptorPath(this.aeDescriptor);
        }
        return this.serviceInfo;
    }

    public ServicePerformance getServicePerformance(String aDelegateKey) {
        return this.getDelegateServicePerformance(aDelegateKey);
    }

    public synchronized void incrementAnalysisTime(long anAnalysisTime) {
        this.servicePerformance.incrementAnalysisTime(anAnalysisTime);
    }

    public void stopTimers() {
        Set set = this.destinationMap.entrySet();
        for (Map.Entry entry : set) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            if (endpoint == null) continue;
            endpoint.cancelTimer();
        }
    }

    public boolean requestForMetaSentToRemotes() {
        return this.requestForMetaSentToRemotes;
    }

    public void setRequestForMetaSentToRemotes() {
        this.requestForMetaSentToRemotes = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        FlowControllerContainer flowControllerContainer;
        if (this.flowMap != null) {
            this.flowMap.clear();
        }
        if (this.destinationMap != null) {
            this.destinationMap.clear();
        }
        if (this.destinationToKeyMap != null) {
            this.destinationToKeyMap.clear();
        }
        if (this.analysisEngineMetaDataMap != null) {
            this.analysisEngineMetaDataMap.clear();
        }
        if (this.remoteCasMultiplierList != null) {
            this.remoteCasMultiplierList.clear();
        }
        if (this.originMap != null) {
            this.originMap.clear();
        }
        if (this.childControllerList != null) {
            flowControllerContainer = this.childControllerList;
            synchronized (flowControllerContainer) {
                this.childControllerList.clear();
            }
        }
        if (this.delegateStats != null) {
            this.delegateStats.clear();
        }
        if (this.flowControllerContainer != null) {
            flowControllerContainer = this.flowControllerContainer;
            synchronized (flowControllerContainer) {
                this.flowControllerContainer.destroy();
            }
        }
        this.perCasStatistics.clear();
        if (this.disabledDelegateList != null) {
            this.disabledDelegateList.clear();
        }
        if (this.delegateStatMap != null) {
            this.delegateStatMap.clear();
        }
    }

    public void stop() {
        super.stop(true);
        this.cleanUp();
    }

    public List getChildControllerList() {
        return this.childControllerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialize() {
        List<AnalysisEngineController> list = this.childControllerList;
        synchronized (list) {
            if (this.childControllerList.size() > 0) {
                for (AnalysisEngineController childController : this.childControllerList) {
                    childController.onInitialize();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCollocatedDelegateState(String delegateKey, BaseAnalysisEngineController.ServiceState state) throws Exception {
        if (delegateKey != null && state != null) {
            List<AnalysisEngineController> list = this.childControllerList;
            synchronized (list) {
                if (this.childControllerList.size() > 0) {
                    for (AnalysisEngineController childController : this.childControllerList) {
                        if (!delegateKey.equals(childController.getKey())) continue;
                        childController.changeState(state);
                    }
                }
            }
        } else {
            throw new Exception("Controller:" + this.getComponentName() + " Unable to change state of colocated delegate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpState(StringBuffer buffer, String lbl1) {
        StringBuffer delegates = new StringBuffer();
        if (buffer.length() == 0) {
            delegates.append("\n" + lbl1 + this.getComponentName() + " Delegates:");
        }
        Set set = this.destinationMap.entrySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            delegates.append("\n");
            Map.Entry entry = it.next();
            Endpoint endpoint = (Endpoint)entry.getValue();
            BaseAnalysisEngineController.ServiceState state = BaseAnalysisEngineController.ServiceState.INITIALIZING;
            if (endpoint.isRemote()) {
                if (endpoint.isInitialized()) {
                    state = BaseAnalysisEngineController.ServiceState.RUNNING;
                }
                delegates.append(lbl1 + lbl1 + "Remote Delegate:" + endpoint.getDelegateKey() + " State: " + state.toString());
                continue;
            }
            if (endpoint.isInitialized()) {
                state = BaseAnalysisEngineController.ServiceState.RUNNING;
            }
            delegates.append(lbl1 + lbl1 + "Co-located Delegate:" + endpoint.getDelegateKey() + " State: " + state.toString());
            List<AnalysisEngineController> list = this.childControllerList;
            synchronized (list) {
                if (this.childControllerList.size() > 0) {
                    for (AnalysisEngineController childController : this.childControllerList) {
                        if (!endpoint.getDelegateKey().equals(childController.getKey()) || childController.isPrimitive()) continue;
                        buffer.append(delegates.toString());
                        childController.dumpState(buffer, lbl1 + lbl1);
                        delegates.setLength(0);
                    }
                }
            }
        }
        buffer.append(delegates.toString());
    }

    public LocalCache getLocalCache() {
        return this.localCache;
    }

    public Delegate lookupDelegate(String aDelegateKey) {
        for (Delegate delegate : this.delegates) {
            if (!delegate.getKey().equals(aDelegateKey)) continue;
            return delegate;
        }
        return null;
    }

    public void setCasLoggingDirectory(String key, String directory) {
        String baseDir = System.getProperty("user.dir");
        if (null != System.getProperty("UIMA_CASLOG_BASE_DIRECTORY")) {
            baseDir = System.getProperty("UIMA_CASLOG_BASE_DIRECTORY");
            boolean status = new File(baseDir).mkdir();
        }
        directory = directory.replace('/', '-');
        if (this.casLogDirMap == null) {
            this.casLogDirMap = new HashMap();
        }
        this.casLogDirMap.put(key, baseDir + "/" + directory);
        if (this.enableCasLogMap == null) {
            this.enableCasLogMap = new HashMap();
        }
        this.enableCasLogMap.put(key, false);
        this.initializationTime = System.nanoTime();
    }
}

