/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController_impl;
import org.apache.uima.util.Level;

public class UimaAsThreadFactory
implements ThreadFactory {
    private static final Class CLASS_NAME = UimaAsThreadFactory.class;
    private static final String THREAD_POOL = "[UIMA AS ThreadPool ";
    private PrimitiveAnalysisEngineController controller;
    private ThreadGroup theThreadGroup;
    private String threadNamePrefix = null;
    private boolean isDaemon = false;
    public static AtomicInteger poolIdGenerator = new AtomicInteger();
    private final int poolId = poolIdGenerator.incrementAndGet();
    private CountDownLatch latchToCountNumberOfTerminatedThreads;

    public UimaAsThreadFactory(ThreadGroup tGroup) {
        this(tGroup, null);
    }

    public UimaAsThreadFactory(ThreadGroup tGroup, PrimitiveAnalysisEngineController aController) {
        this(tGroup, aController, null);
    }

    public UimaAsThreadFactory(ThreadGroup tGroup, PrimitiveAnalysisEngineController aController, CountDownLatch latchToCountNumberOfTerminatedThreads) {
        this.controller = aController;
        this.theThreadGroup = tGroup;
        this.latchToCountNumberOfTerminatedThreads = latchToCountNumberOfTerminatedThreads;
    }

    public void setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
    }

    public void setThreadGroup(ThreadGroup tGroup) {
        this.theThreadGroup = tGroup;
    }

    public void setDaemon(boolean daemon) {
    }

    public void stop() {
    }

    public Thread newThread(final Runnable r) {
        Thread newThread;
        block4: {
            newThread = null;
            try {
                newThread = new Thread(this.theThreadGroup, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        if (UimaAsThreadFactory.this.threadNamePrefix == null) {
                            if (UimaAsThreadFactory.this.controller != null) {
                                UimaAsThreadFactory.this.threadNamePrefix = UimaAsThreadFactory.THREAD_POOL + UimaAsThreadFactory.this.poolId + "] " + UimaAsThreadFactory.this.controller.getComponentName() + " Process Thread";
                            } else {
                                UimaAsThreadFactory.this.threadNamePrefix = UimaAsThreadFactory.THREAD_POOL + UimaAsThreadFactory.this.poolId + "] ";
                            }
                        }
                        Thread.currentThread().setName(UimaAsThreadFactory.this.threadNamePrefix + " - " + Thread.currentThread().getId());
                        try {
                            try {
                                if (UimaAsThreadFactory.this.controller != null && !UimaAsThreadFactory.this.controller.threadAssignedToAE()) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_calling_ae_initialize__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                                    UimaAsThreadFactory.this.controller.initializeAnalysisEngine();
                                }
                                r.run();
                            }
                            catch (Throwable e) {
                                if (!(e instanceof Exception)) {
                                    try {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_exception__WARNING", e);
                                        System.out.println(">>>>>>>>>>>>>>>>>>Exiting UIMA AS Process Due to Uncaught Exception");
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    System.exit(-1);
                                }
                                Object var4_2 = null;
                                if (!(UimaAsThreadFactory.this.controller instanceof PrimitiveAnalysisEngineController_impl)) return;
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_process_thread_exiting__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                                ((PrimitiveAnalysisEngineController_impl)UimaAsThreadFactory.this.controller).destroyAE();
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_ae_instance_destroy_called__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                                if (UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads == null) return;
                                CountDownLatch countDownLatch = UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads;
                                synchronized (countDownLatch) {
                                    UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.countDown();
                                    System.out.println(".................... Thread:" + Thread.currentThread().getId() + " CountDownLatch Value:" + UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.getCount());
                                    System.out.flush();
                                    return;
                                }
                            }
                            Object var4_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            if (!(UimaAsThreadFactory.this.controller instanceof PrimitiveAnalysisEngineController_impl)) throw throwable;
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_process_thread_exiting__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                            ((PrimitiveAnalysisEngineController_impl)UimaAsThreadFactory.this.controller).destroyAE();
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_ae_instance_destroy_called__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                            if (UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads == null) throw throwable;
                            CountDownLatch countDownLatch = UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads;
                            synchronized (countDownLatch) {
                                UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.countDown();
                                System.out.println(".................... Thread:" + Thread.currentThread().getId() + " CountDownLatch Value:" + UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.getCount());
                                System.out.flush();
                                throw throwable;
                            }
                        }
                        if (!(UimaAsThreadFactory.this.controller instanceof PrimitiveAnalysisEngineController_impl)) return;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_process_thread_exiting__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                        ((PrimitiveAnalysisEngineController_impl)UimaAsThreadFactory.this.controller).destroyAE();
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "UimaAsThreadFactory.run()", "uimaee_messages", "UIMAEE_ae_instance_destroy_called__INFO", new Object[]{UimaAsThreadFactory.this.controller.getComponentName(), Thread.currentThread().getId()});
                        if (UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads == null) return;
                        CountDownLatch countDownLatch = UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads;
                        synchronized (countDownLatch) {
                            UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.countDown();
                            System.out.println(".................... Thread:" + Thread.currentThread().getId() + " CountDownLatch Value:" + UimaAsThreadFactory.this.latchToCountNumberOfTerminatedThreads.getCount());
                            System.out.flush();
                            return;
                        }
                    }
                });
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                if (this.controller != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        if (newThread != null) {
            newThread.setDaemon(this.isDaemon);
        }
        return newThread;
    }
}

