/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.aae.AsynchAECasManager_impl;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.client.UimaASStatusCallbackListener;
import org.apache.uima.aae.client.UimaAsynchronousEngine;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.ControllerLifecycle;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.UimacppServiceController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.UimaASMetaRequestTimeout;
import org.apache.uima.aae.jmx.JmxManager;
import org.apache.uima.adapter.jms.activemq.SpringContainerDeployer;
import org.apache.uima.adapter.jms.activemq.UimaEEAdminSpringContext;
import org.apache.uima.adapter.jms.client.ActiveMQConnectionValidator;
import org.apache.uima.adapter.jms.client.ActiveMQMessageSender;
import org.apache.uima.adapter.jms.client.BaseMessageSender;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.ClientServiceDelegate;
import org.apache.uima.adapter.jms.client.InvalidContainerException;
import org.apache.uima.adapter.jms.client.MessageSender;
import org.apache.uima.adapter.jms.service.Dd2spring;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.internal.util.UUIDGenerator;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class BaseUIMAAsynchronousEngine_impl
extends BaseUIMAAsynchronousEngineCommon_impl
implements UimaAsynchronousEngine,
MessageListener,
ControllerCallbackListener {
    private static final Class CLASS_NAME = BaseUIMAAsynchronousEngine_impl.class;
    private MessageSender sender = null;
    private MessageProducer producer;
    private String brokerURI = null;
    private Session session = null;
    private Session consumerSession = null;
    private volatile boolean serviceInitializationException;
    private volatile boolean serviceInitializationCompleted;
    private Semaphore serviceSemaphore = new Semaphore(1);
    private Queue consumerDestination = null;
    private Session producerSession = null;
    private JmxManager jmxManager = null;
    private String applicationName = "UimaASClient";
    protected static Semaphore sharedConnectionSemaphore = new Semaphore(1);
    private Object connectionMux = new Object();
    protected InitialContext jndiContext;
    private ObjectName clientJmxObjectName = null;

    public BaseUIMAAsynchronousEngine_impl() {
        UIMAFramework.getLogger((Class)CLASS_NAME).log(Level.INFO, "UIMA-AS version " + UIMAFramework.getVersionString());
    }

    protected TextMessage createTextMessage() throws ResourceInitializationException {
        return new ActiveMQTextMessage();
    }

    protected BytesMessage createBytesMessage() throws ResourceInitializationException {
        return new ActiveMQBytesMessage();
    }

    protected void cleanup() throws Exception {
    }

    public String getEndPointName() throws ResourceProcessException {
        try {
            return this.clientSideJmxStats.getEndpointName();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setMetaRequestMessage(Message msg) throws Exception {
        msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2001);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (msg instanceof TextMessage) {
            ((ActiveMQTextMessage)msg).setText("");
        }
    }

    protected void setCASMessage(String aCasReferenceId, CAS aCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, "xmi");
            ((TextMessage)msg).setText(this.serializeCAS(aCAS));
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCASMessage(String aCasReferenceId, String aSerializedCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, "xmi");
            ((TextMessage)msg).setText(aSerializedCAS);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCASMessage(String aCasReferenceId, byte[] aSerializedCAS, Message msg) throws ResourceProcessException {
        try {
            this.setCommonProperties(aCasReferenceId, msg, "binary");
            ((BytesMessage)msg).writeBytes(aSerializedCAS);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    protected void setCommonProperties(String aCasReferenceId, Message msg, String aSerializationStrategy) throws ResourceProcessException {
        try {
            msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
            msg.setStringProperty("ServerURI", this.brokerURI);
            msg.setIntProperty("MessageType", 3000);
            msg.setIntProperty("Command", 2000);
            msg.setStringProperty("CasReference", aCasReferenceId);
            if (aSerializationStrategy.equals("binary")) {
                msg.setIntProperty("Payload", 1006);
            } else if (aSerializationStrategy.equals("xmi")) {
                msg.setIntProperty("Payload", 1000);
            }
            msg.setBooleanProperty("AcceptsDeltaCas", true);
            msg.setJMSReplyTo((Destination)this.consumerDestination);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    private void stopConnection() {
        if (sharedConnection != null) {
            sharedConnection.unregisterClient(this);
            if (sharedConnection.destroy()) {
                sharedConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.connectionMux;
        synchronized (object) {
            block19: {
                super.doStop();
                if (!this.running) {
                    return;
                }
                this.running = false;
                if (this.serviceDelegate != null) {
                    this.serviceDelegate.cleanup();
                }
                if (this.sender != null) {
                    this.sender.doStop();
                }
                if (this.initialized) {
                    try {
                        this.consumerSession.close();
                        ((ActiveMQMessageConsumer)this.consumer).stop();
                        this.consumer.close();
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                }
                try {
                    try {
                        try {
                            sharedConnectionSemaphore.acquire();
                            this.stopConnection();
                        }
                        catch (InterruptedException ex) {
                            this.stopConnection();
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_client_interrupted_while_acquiring_semaphore__WARNING");
                            }
                            Object var4_6 = null;
                            sharedConnectionSemaphore.release();
                        }
                        Object var4_5 = null;
                        sharedConnectionSemaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        sharedConnectionSemaphore.release();
                        throw throwable;
                    }
                    this.undeploy();
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_undeployed_containers__INFO");
                    }
                    if (this.jmxManager != null) {
                        this.jmxManager.unregisterMBean(this.clientJmxObjectName);
                        this.jmxManager.destroy();
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block19;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    public void setCPCMessage(Message msg) throws Exception {
        msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2002);
        msg.setIntProperty("Payload", 1005);
        msg.setBooleanProperty("RemoveEndpoint", true);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
        if (msg instanceof TextMessage) {
            ((TextMessage)msg).setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionClosedOrInvalid() {
        Object object = this.connectionMux;
        synchronized (object) {
            if (sharedConnection == null || sharedConnection.getConnection() == null || ((ActiveMQConnection)sharedConnection.getConnection()).isClosed() || ((ActiveMQConnection)sharedConnection.getConnection()).isClosing() || ((ActiveMQConnection)sharedConnection.getConnection()).isTransportFailed()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSharedConnection(String aBrokerURI) throws Exception {
        Object object = this.connectionMux;
        synchronized (object) {
            try {
                block10: {
                    sharedConnectionSemaphore.acquire();
                    if (!this.connectionClosedOrInvalid()) break block10;
                    if (sharedConnection != null && sharedConnection.getConnection() != null) {
                        try {
                            sharedConnection.getConnection().close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ActiveMQConnectionValidator connectionValidator = new ActiveMQConnectionValidator();
                    sharedConnection = new BaseUIMAAsynchronousEngineCommon_impl.SharedConnection((ConnectionFactory)new ActiveMQConnectionFactory(aBrokerURI), aBrokerURI);
                    sharedConnection.setConnectionValidator(connectionValidator);
                    sharedConnection.create();
                    this.addPrefetch((ActiveMQConnection)sharedConnection.getConnection());
                    sharedConnection.start();
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block10;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "setupConnection", "jms_adapter_messages", "UIMAJMS_client_connection_setup_INFO", new Object[]{aBrokerURI});
                }
                Object var5_6 = null;
                sharedConnectionSemaphore.release();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                sharedConnectionSemaphore.release();
                throw throwable;
            }
        }
    }

    private void addPrefetch(ActiveMQConnection aConnection) {
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(5);
        aConnection.setPrefetchPolicy(prefetchPolicy);
    }

    private void validateConnection(String aBrokerURI) throws Exception {
        this.createSharedConnection(aBrokerURI);
    }

    protected Session getSession(String aBrokerURI) throws Exception {
        this.validateConnection(aBrokerURI);
        return this.getSession(sharedConnection.getConnection());
    }

    protected Session getSession(Connection aConnection) throws Exception {
        this.session = aConnection.createSession(false, 1);
        return this.session;
    }

    protected MessageProducer lookupProducerForEndpoint(Endpoint anEndpoint) throws Exception {
        if (sharedConnection == null || this.producerSession == null) {
            throw new ResourceInitializationException();
        }
        Queue dest = this.producerSession.createQueue(anEndpoint.getEndpoint());
        return this.producerSession.createProducer((Destination)dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeProducer(String aBrokerURI, String aQueueName) throws Exception {
        this.createSharedConnection(aBrokerURI);
        Object object = this.connectionMux;
        synchronized (object) {
            this.initializeProducer(aBrokerURI, aQueueName, sharedConnection.getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeProducer(String aBrokerURI, String aQueueName, Connection aConnection) throws Exception {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeProducer", "jms_adapter_messages", "UIMAJMS_init_jms_producer_INFO", new Object[]{aBrokerURI, aQueueName});
        }
        this.brokerURI = aBrokerURI;
        this.sender = new ActiveMQMessageSender(aConnection, aQueueName, this);
        this.producerInitialized = false;
        Thread t = new Thread((BaseMessageSender)this.sender);
        t.start();
        try {
            try {
                this.producerSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                Object var7_6 = null;
                this.producerSemaphore.release();
            }
            Object var7_5 = null;
            this.producerSemaphore.release();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.producerSemaphore.release();
            throw throwable;
        }
        if (this.sender.failed()) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initializeProducer", "jms_adapter_messages", "UIMAJMS_worker_thread_failed_to_initialize__WARNING", new Object[]{this.sender.getReasonForFailure()});
            }
            this.stop();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConsumer(String aBrokerURI) throws Exception {
        this.createSharedConnection(aBrokerURI);
        Object object = this.connectionMux;
        synchronized (object) {
            this.initializeConsumer(aBrokerURI, sharedConnection.getConnection());
        }
    }

    protected void initializeConsumer(String aBrokerURI, Connection connection) throws Exception {
        if (this.consumerSession != null) {
            try {
                this.consumer.close();
                this.consumerSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.consumerSession = this.getSession(connection);
        this.consumerDestination = this.consumerSession.createTemporaryQueue();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeConsumer", "jms_adapter_messages", "UIMAJMS_init_jms_consumer_INFO", new Object[]{aBrokerURI, this.consumerDestination.getQueueName()});
        }
        this.consumer = this.consumerSession.createConsumer((Destination)this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    private String replacePlaceholder(String aPlaceholder) throws ResourceInitializationException {
        int endPos;
        int startPos = aPlaceholder.indexOf("{");
        String placeholder = aPlaceholder.substring(startPos + 1, endPos = aPlaceholder.indexOf("}"));
        String url = System.getProperty(placeholder);
        if (url == null) {
            throw new ResourceInitializationException((Throwable)new Exception("UIMA AS Client Initialization Exception. Value for placeholder:" + placeholder + " is not defined in the environment. Set System property:" + placeholder + " to the broker URL."));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(Map anApplicationContext) throws ResourceInitializationException {
        this.shutdownHookThread = new Thread(new BaseUIMAAsynchronousEngineCommon_impl.UimaASShutdownHook(this));
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        if (!UimaAsVersion.getUimajFullVersionString().equals(UimaVersion.getFullVersionString())) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initialize", "uimaee_messages", "UIMAEE_incompatible_version_WARNING", new Object[]{"UIMA AS Client", UimaAsVersion.getUimajFullVersionString(), UimaVersion.getFullVersionString()});
            throw new ResourceInitializationException((Throwable)new AsynchAEException("Version of UIMA-AS is Incompatible with a Version of UIMA Core. UIMA-AS Version is built to depend on Core UIMA version:" + UimaAsVersion.getUimajFullVersionString() + " but is running with version:" + UimaVersion.getFullVersionString()));
        }
        if (this.running) {
            throw new ResourceInitializationException((Throwable)new UIMA_IllegalStateException());
        }
        this.reset();
        Properties performanceTuningSettings = null;
        if (!anApplicationContext.containsKey("ServerURI")) {
            throw new ResourceInitializationException();
        }
        if (!anApplicationContext.containsKey("Endpoint")) {
            throw new ResourceInitializationException();
        }
        ResourceManager rm = null;
        rm = anApplicationContext.containsKey("RESOURCE_MANAGER") ? (ResourceManager)anApplicationContext.get("RESOURCE_MANAGER") : UIMAFramework.newDefaultResourceManager();
        performanceTuningSettings = new Properties();
        if (anApplicationContext.containsKey("cas_initial_heap_size")) {
            String cas_initial_heap_size = (String)anApplicationContext.get("cas_initial_heap_size");
            performanceTuningSettings.put("cas_initial_heap_size", cas_initial_heap_size);
        }
        this.asynchManager = new AsynchAECasManager_impl(rm);
        this.brokerURI = (String)anApplicationContext.get("ServerURI");
        if (this.brokerURI.startsWith("${")) {
            this.brokerURI = this.replacePlaceholder(this.brokerURI);
        }
        String endpoint = (String)anApplicationContext.get("Endpoint");
        this.clientSideJmxStats.setEndpointName(endpoint);
        int casPoolSize = 1;
        if (anApplicationContext.containsKey("CasPoolSize")) {
            casPoolSize = (Integer)anApplicationContext.get("CasPoolSize");
            this.clientSideJmxStats.setCasPoolSize(casPoolSize);
        }
        if (anApplicationContext.containsKey("Timeout")) {
            this.processTimeout = (Integer)anApplicationContext.get("Timeout");
        }
        if (anApplicationContext.containsKey("GetMetaTimeout")) {
            this.metadataTimeout = (Integer)anApplicationContext.get("GetMetaTimeout");
        }
        if (anApplicationContext.containsKey("CpcTimeout")) {
            this.cpcTimeout = (Integer)anApplicationContext.get("CpcTimeout");
        }
        if (anApplicationContext.containsKey("ApplicationName")) {
            this.applicationName = (String)anApplicationContext.get("ApplicationName");
        }
        if (anApplicationContext.containsKey("SerializationStrategy")) {
            this.serializationStrategy = (String)anApplicationContext.get("SerializationStrategy");
            this.clientSideJmxStats.setSerialization(this.serializationStrategy);
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_init_uimaee_client__CONFIG", new Object[]{this.brokerURI, 0, casPoolSize, this.processTimeout, this.metadataTimeout, this.cpcTimeout});
        }
        this.serviceDelegate = new ClientServiceDelegate(endpoint, this.applicationName, this);
        this.serviceDelegate.setCasProcessTimeout(this.processTimeout);
        this.serviceDelegate.setGetMetaTimeout(this.metadataTimeout);
        try {
            block32: {
                String uuid = UUIDGenerator.generate();
                uuid = uuid.replaceAll(":", "_");
                uuid = uuid.replaceAll("-", "_");
                this.applicationName = this.applicationName + "_" + uuid;
                this.jmxManager = new JmxManager("org.apache.uima");
                this.clientSideJmxStats.setApplicationName(this.applicationName);
                this.clientJmxObjectName = new ObjectName("org.apache.uima:name=" + this.applicationName);
                this.jmxManager.registerMBean(this.clientSideJmxStats, this.clientJmxObjectName);
                Properties props = new Properties();
                props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
                props.setProperty("java.naming.provider.url", this.brokerURI);
                this.jndiContext = new InitialContext(props);
                this.createSharedConnection(this.brokerURI);
                Object object = this.connectionMux;
                synchronized (object) {
                    if (sharedConnection != null) {
                        this.initializeProducer(this.brokerURI, endpoint, sharedConnection.getConnection());
                        this.initializeConsumer(this.brokerURI, sharedConnection.getConnection());
                    } else {
                        this.initializeProducer(this.brokerURI, endpoint);
                        this.initializeConsumer(this.brokerURI);
                    }
                    if (sharedConnection != null) {
                        sharedConnection.registerClient(this);
                    }
                }
                this.running = true;
                try {
                    this.getMetaSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block32;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_client_interrupted_while_acquiring_getmeta_semaphore__WARNING");
                }
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.sendMetaRequest();
            this.waitForMetadataReply();
            if (this.abort || !this.running) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_aborting_as_WARNING", new Object[]{"Metadata Timeout"});
                }
                throw new ResourceInitializationException((Throwable)new UimaASMetaRequestTimeout());
            }
            if (this.collectionReader != null) {
                this.asynchManager.addMetadata(this.collectionReader.getProcessingResourceMetaData());
            }
            this.asynchManager.initialize(casPoolSize, "ApplicationCasPoolContext", performanceTuningSettings);
            if (this.resourceMetadata != null && this.resourceMetadata instanceof AnalysisEngineMetaData && ((AnalysisEngineMetaData)this.resourceMetadata).getOperationalProperties().getOutputsNewCASes()) {
                this.asynchManager.initialize(1, "ShadowCasPool", performanceTuningSettings);
            }
            this.initialized = true;
            this.remoteService = true;
            for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
                ((UimaASStatusCallbackListener)this.listeners.get(i)).initializationComplete(null);
            }
        }
        catch (ResourceInitializationException e) {
            this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.FAILED;
            this.notifyOnInitializationFailure((Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.FAILED;
            this.notifyOnInitializationFailure(e);
            throw new ResourceInitializationException((Throwable)e);
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_as_initialized__INFO", new Object[]{this.serializationStrategy});
        }
        super.acquireCpcReadySemaphore();
        this.state = BaseUIMAAsynchronousEngineCommon_impl.ClientState.RUNNING;
    }

    public String deploy(String aDeploymentDescriptor, Map anApplicationContext) throws Exception {
        String springContext = this.generateSpringContext(aDeploymentDescriptor, anApplicationContext);
        SpringContainerDeployer springDeployer = new SpringContainerDeployer(this.springContainerRegistry);
        try {
            String id = springDeployer.deploy(springContext);
            if (springDeployer.isInitialized()) {
                springDeployer.startListeners();
            }
            return id;
        }
        catch (ResourceInitializationException e) {
            this.running = true;
            throw e;
        }
    }

    public String deploy(String[] aDeploymentDescriptorList, Map anApplicationContext) throws Exception {
        if (aDeploymentDescriptorList == null) {
            throw new ResourceConfigurationException("illegal_argument", new Object[]{"Null", "DeploymentDescriptorList", "deploy()"});
        }
        if (aDeploymentDescriptorList.length == 0) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"DeploymentDescriptorList"});
        }
        String[] springContextFiles = new String[aDeploymentDescriptorList.length];
        for (int i = 0; i < aDeploymentDescriptorList.length; ++i) {
            springContextFiles[i] = this.generateSpringContext(aDeploymentDescriptorList[i], anApplicationContext);
        }
        SpringContainerDeployer springDeployer = new SpringContainerDeployer(this.springContainerRegistry);
        try {
            String id = springDeployer.deploy(springContextFiles);
            if (springDeployer.isInitialized()) {
                springDeployer.startListeners();
            }
            return id;
        }
        catch (ResourceInitializationException e) {
            this.running = true;
            throw e;
        }
    }

    public void undeploy() throws Exception {
        for (String containerId : this.springContainerRegistry.keySet()) {
            this.undeploy(containerId);
        }
    }

    public void undeploy(String aSpringContainerId) throws Exception {
        this.undeploy(aSpringContainerId, 1001);
    }

    public void undeploy(String aSpringContainerId, int stop_level) throws Exception {
        if (aSpringContainerId == null) {
            return;
        }
        UimaEEAdminSpringContext adminContext = null;
        if (!this.springContainerRegistry.containsKey(aSpringContainerId)) {
            return;
        }
        adminContext = (UimaEEAdminSpringContext)this.springContainerRegistry.get(aSpringContainerId);
        if (adminContext == null) {
            throw new InvalidContainerException("Spring Container Does Not Contain Valid UimaEEAdminSpringContext Object");
        }
        ApplicationContext ctx = adminContext.getSpringContainer();
        String[] asyncServiceList = ctx.getBeanNamesForType(ControllerLifecycle.class);
        if (asyncServiceList != null && asyncServiceList.length > 0) {
            boolean topLevelController = false;
            ControllerLifecycle ctrer = null;
            int indx = 0;
            while (!topLevelController) {
                if (!((ctrer = (ControllerLifecycle)ctx.getBean(asyncServiceList[indx++])) instanceof UimacppServiceController) && !((AnalysisEngineController)ctrer).isTopLevelComponent()) continue;
                topLevelController = true;
            }
            if (ctrer != null) {
                if (ctrer instanceof AnalysisEngineController) {
                    ((AnalysisEngineController)ctrer).getControllerLatch().release();
                }
                switch (stop_level) {
                    case 1000: {
                        ((AnalysisEngineController)ctrer).quiesceAndStop();
                        break;
                    }
                    case 1001: {
                        ((AnalysisEngineController)ctrer).terminate();
                    }
                }
            }
        }
        if (ctx instanceof FileSystemXmlApplicationContext) {
            ((FileSystemXmlApplicationContext)ctx).destroy();
        }
        this.springContainerRegistry.remove(aSpringContainerId);
    }

    private String generateSpringContext(String aDeploymentDescriptor, Map anApplicationContext) throws Exception {
        String dd2SpringXsltFilePath = null;
        String saxonClasspath = null;
        if (!anApplicationContext.containsKey("DD2SpringXsltFilePath")) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"Xslt File Path"});
        }
        dd2SpringXsltFilePath = (String)anApplicationContext.get("DD2SpringXsltFilePath");
        if (!anApplicationContext.containsKey("SaxonClasspath")) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"Saxon Classpath"});
        }
        saxonClasspath = (String)anApplicationContext.get("SaxonClasspath");
        Dd2spring dd2Spring = new Dd2spring();
        File springContextFile = dd2Spring.convertDd2Spring(aDeploymentDescriptor, dd2SpringXsltFilePath, saxonClasspath, (String)anApplicationContext.get("-uimaEeDebug"));
        return springContextFile.getAbsolutePath();
    }

    protected String deploySpringContainer(String[] springContextFiles) throws ResourceInitializationException {
        SpringContainerDeployer springDeployer = new SpringContainerDeployer();
        try {
            return springDeployer.deploy(springContextFiles);
        }
        catch (ResourceInitializationException e) {
            this.running = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForServiceNotification() throws Exception {
        while (!this.serviceInitializationCompleted) {
            Object var3_2;
            if (this.serviceInitializationException) {
                throw new ResourceInitializationException();
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "waitForServiceNotification", "jms_adapter_messages", "UIMAJMS_awaiting_container_init__INFO", new Object[0]);
            }
            try {
                try {
                    this.serviceSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    var3_2 = null;
                    this.serviceSemaphore.release();
                }
                var3_2 = null;
                this.serviceSemaphore.release();
            }
            catch (Throwable throwable) {
                var3_2 = null;
                this.serviceSemaphore.release();
                throw throwable;
            }
            if (!this.serviceInitializationException) continue;
            throw new ResourceInitializationException();
        }
    }

    protected void deployEmbeddedBroker() throws Exception {
    }

    public static void main(String[] args) {
        block2: {
            try {
                BaseUIMAAsynchronousEngine_impl uimaee = new BaseUIMAAsynchronousEngine_impl();
                HashMap<String, String> appContext = new HashMap<String, String>();
                appContext.put("DD2SpringXsltFilePath", args[1]);
                appContext.put("SaxonClasspath", args[2]);
                String containerId = uimaee.deploy(args[0], appContext);
                uimaee.undeploy(containerId);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "main", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void setReleaseCASMessage(TextMessage msg, String aCasReferenceId) throws Exception {
        msg.setIntProperty("Payload", 1005);
        msg.setStringProperty("CasReference", aCasReferenceId);
        msg.setIntProperty("MessageType", 3000);
        msg.setIntProperty("Command", 2005);
        msg.setStringProperty("ServerURI", this.brokerURI);
        msg.setJMSReplyTo((Destination)this.consumerDestination);
    }

    public void notifyOnInitializationFailure(Exception e) {
        this.notifyOnInitializationFailure(null, e);
    }

    public void notifyOnInitializationSuccess() {
        this.notifyOnInitializationSuccess(null);
    }

    public void notifyOnInitializationFailure(AnalysisEngineController aController, Exception e) {
        this.serviceInitializationException = true;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnInitializationFailure", "jms_adapter_messages", "UIMAJMS_container_init_exception__WARNING", (Throwable)e);
        }
        this.serviceSemaphore.release();
    }

    public void notifyOnInitializationSuccess(AnalysisEngineController aController) {
        this.serviceInitializationCompleted = true;
        this.serviceSemaphore.release();
    }

    public void notifyOnTermination(String aServiceName) {
        this.notifyOnTermination(aServiceName, null, null);
    }

    public void notifyOnTermination(String aServiceName, String aCasReferenceId, Exception cause) {
    }

    protected MessageProducer getMessageProducer(Destination destination) throws Exception {
        return this.sender.getMessageProducer(destination);
    }

    public void stopProducingCases() {
        List<Delegate.DelegateEntry> outstandingCasList = this.serviceDelegate.getDelegateCasesPendingReply();
        for (Delegate.DelegateEntry entry : outstandingCasList) {
            BaseUIMAAsynchronousEngineCommon_impl.ClientRequest clientCachedRequest = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.clientCache.get(entry.getCasReferenceId());
            if (clientCachedRequest == null || clientCachedRequest.isMetaRequest() || clientCachedRequest.getCasReferenceId() == null) continue;
            this.stopProducingCases(clientCachedRequest);
        }
    }

    public void stopProducingCases(String aCasReferenceId) {
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest clientCachedRequest = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.clientCache.get(aCasReferenceId);
        if (clientCachedRequest != null) {
            this.stopProducingCases(clientCachedRequest);
        }
    }

    private void stopProducingCases(BaseUIMAAsynchronousEngineCommon_impl.ClientRequest clientCachedRequest) {
        block9: {
            try {
                if (clientCachedRequest.getFreeCasNotificationQueue() == null) break block9;
                TextMessage msg = this.createTextMessage();
                msg.setText("");
                msg.setIntProperty("Payload", 1005);
                msg.setStringProperty("CasReference", clientCachedRequest.getCasReferenceId());
                msg.setIntProperty("MessageType", 3000);
                msg.setIntProperty("Command", 2006);
                msg.setStringProperty("ServerURI", this.brokerURI);
                try {
                    MessageProducer msgProducer = this.getMessageProducer(clientCachedRequest.getFreeCasNotificationQueue());
                    if (msgProducer != null) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_client_sending_stop_to_service__INFO", new Object[]{clientCachedRequest.getCasReferenceId(), clientCachedRequest.getFreeCasNotificationQueue()});
                        }
                        msgProducer.send((Message)msg);
                    } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_client_unable_to_send_stop_to_cm__WARNING");
                    }
                }
                catch (Exception ex) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                    }
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block9;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopProducingCases", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    protected MessageSender getDispatcher() {
        return this.sender;
    }

    public void notifyOnReconnecting(String aMessage) {
    }

    public void notifyOnReconnectionSuccess() {
    }
}

