/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.springframework.jmx.JmxException;

public class RemoteJMXServer {
    private static final Class CLASS_NAME = RemoteJMXServer.class;
    private MBeanServerConnection brokerMBeanServer = null;
    private ConcurrentHashMap<String, QueueViewMBean> queueMBeanMap = new ConcurrentHashMap();
    private String brokerName;
    private JMXConnector jmxc = null;
    private volatile boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(String jmxDomain, String remoteJMXServerHostname, String remoteJMXServerPort) throws Exception {
        String remoteJmxUrl = "service:jmx:rmi:///jndi/rmi://" + remoteJMXServerHostname + ":" + remoteJMXServerPort + "/jmxrmi";
        JMXServiceURL url = new JMXServiceURL(remoteJmxUrl);
        this.jmxc = JMXConnectorFactory.connect(url, null);
        this.brokerMBeanServer = this.jmxc.getMBeanServerConnection();
        Set<ObjectName> queueSet = this.brokerMBeanServer.queryNames(new ObjectName(jmxDomain + ":*,Type=Queue"), null);
        if (queueSet.isEmpty()) {
            throw new JmxException("ActiveMQ Broker Not Configured With JMX Support");
        }
        for (ObjectName nameObject : this.brokerMBeanServer.queryNames(new ObjectName(jmxDomain + ":*,Type=Broker"), null)) {
            ObjectName brokerObjectName = nameObject;
            if (!brokerObjectName.getCanonicalName().endsWith("Type=Broker")) continue;
            this.brokerName = brokerObjectName.getCanonicalName().substring(0, brokerObjectName.getCanonicalName().indexOf(","));
            this.initialized = true;
            break;
        }
    }

    public void disconnect() {
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
                this.brokerMBeanServer = null;
                this.queueMBeanMap.clear();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isServerAvailable() {
        try {
            this.brokerMBeanServer.getMBeanCount();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void attachToTempQueue(String tempQueueName) throws Exception {
        ObjectName uimaServiceTempReplyQueuePattern;
        QueueViewMBean replyQueueMBean;
        if (!this.queueMBeanMap.containsKey(tempQueueName) && (replyQueueMBean = this.getQueueMBean(tempQueueName, uimaServiceTempReplyQueuePattern = this.composeObjectName("TempQueue", tempQueueName))) != null) {
            this.queueMBeanMap.put(tempQueueName, replyQueueMBean);
        }
    }

    private ObjectName composeObjectName(String queueType, String queueName) throws Exception {
        ObjectName n = new ObjectName(this.brokerName + ",Type=" + queueType + ",Destination=" + queueName);
        return n;
    }

    public boolean isClientReplyQueueAvailable(String queueName) {
        try {
            ObjectName uimaServiceTempReplyQueuePattern = this.composeObjectName("TempQueue", queueName);
            if (this.isServerAvailable() && this.getQueueMBean(queueName, uimaServiceTempReplyQueuePattern) == null) {
                return false;
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "isClientReplyQueueAvailable", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
        }
        return true;
    }

    private QueueViewMBean getQueueMBean(String key, ObjectName matchPattern) throws Exception {
        HashSet<ObjectName> queues = new HashSet<ObjectName>(this.brokerMBeanServer.queryNames(matchPattern, null));
        Iterator i$ = queues.iterator();
        if (i$.hasNext()) {
            ObjectName name = (ObjectName)i$.next();
            return MBeanServerInvocationHandler.newProxyInstance(this.brokerMBeanServer, name, QueueViewMBean.class, true);
        }
        return null;
    }

    public String normalize(String destinationName) {
        String qN = destinationName.substring(destinationName.indexOf("ID"));
        return qN.replaceAll(":", "_");
    }

    public static void main(String[] args) {
        try {
            RemoteJMXServer broker = new RemoteJMXServer();
            broker.initialize("org.apache.activemq", args[0], args[1]);
            if (broker.isClientReplyQueueAvailable(args[2])) {
                System.out.println("TempQueue:" + args[2] + " Exists");
            } else {
                System.out.println("TempQueue:" + args[2] + " Does not Exist");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

