/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

class LoggerHandler
implements Runnable {
    Socket socket;
    BufferedReader in;
    Logger logger;

    public LoggerHandler(Socket sock, Logger uimaLogger) throws IOException {
        this.socket = sock;
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.logger = uimaLogger;
    }

    public void logMessage(String logMessage) {
        Level level = Level.INFO;
        if (logMessage.startsWith("0")) {
            level = Level.INFO;
        } else if (logMessage.startsWith("1")) {
            level = Level.WARNING;
        } else if (logMessage.startsWith("2")) {
            level = Level.SEVERE;
        }
        logMessage = logMessage.trim();
        this.logger.log(level, logMessage);
    }

    public void run() {
        try {
            StringBuilder sb = new StringBuilder();
            int c = this.in.read();
            while (c >= 0) {
                sb.append((char)c);
                if (c == 10) {
                    this.logMessage(sb.toString());
                    sb.delete(0, sb.length());
                }
                c = this.in.read();
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage());
        }
    }
}

