/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.AsynchAECasManager;
import org.apache.uima.aae.EECasManager_impl;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;

public class AsynchAECasManager_impl
implements AsynchAECasManager {
    private static final Class CLASS_NAME = AsynchAECasManager_impl.class;
    private String contextName;
    private CasManager casManager;
    private int casPoolSize = 1;
    private volatile boolean initialized;
    private Map descriptorMap;
    private Map processingResourceMap = new HashMap();
    private ResourceManager resourceManager;
    private long initialHeapSize = 0L;

    public AsynchAECasManager_impl(ResourceManager aResourceManager, Map aDescriptorMap) {
        this(aResourceManager);
        this.descriptorMap = aDescriptorMap;
    }

    public AsynchAECasManager_impl(ResourceManager aResourceManager) {
        this.casManager = new EECasManager_impl(aResourceManager);
        aResourceManager.setCasManager(this.casManager);
        this.resourceManager = aResourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void initialize(String aContextName) throws Exception {
        this.initialize(this.getCasPoolSize(), aContextName);
    }

    public void initialize(int aCasPoolSize, String aContextName) throws Exception {
        this.initialize(aCasPoolSize, aContextName, new Properties());
    }

    public synchronized void initialize(int aCasPoolSize, String aContextName, Properties aPerformanceTuningSettings) throws Exception {
        if (this.initialHeapSize > 0L && !aPerformanceTuningSettings.containsKey("cas_initial_heap_size")) {
            aPerformanceTuningSettings.setProperty("cas_initial_heap_size", Integer.valueOf((int)this.initialHeapSize).toString());
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "uimaee_messages", "UIMAEE_primary_cas_pool_init__CONFIG", new Object[]{aCasPoolSize, aContextName, aPerformanceTuningSettings.get("cas_initial_heap_size")});
        }
        this.casManager.defineCasPool(aContextName, aCasPoolSize, aPerformanceTuningSettings);
        this.contextName = aContextName;
        this.setInitialized(true);
    }

    public int getCasPoolSize() {
        return this.casPoolSize;
    }

    public void setCasPoolSize(int casPoolSize) {
        this.casPoolSize = casPoolSize;
        this.setInitialized(true);
    }

    public String getCasManagerContext() {
        return this.contextName;
    }

    public CasManager getInternalCasManager() {
        return this.casManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void addMetadata(ProcessingResourceMetaData meta) {
        this.casManager.addMetaData(meta);
    }

    public void setMetadata(ProcessingResourceMetaData meta) {
        this.addMetadata(meta);
    }

    public ProcessingResourceMetaData getMetadata() throws ResourceInitializationException {
        CasDefinition casDefinition = this.casManager.getCasDefinition();
        ProcessingResourceMetaData md = UIMAFramework.getResourceSpecifierFactory().createProcessingResourceMetaData();
        md.setTypeSystem(casDefinition.getTypeSystemDescription());
        md.setTypePriorities(casDefinition.getTypePriorities());
        FsIndexCollection indColl = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
        indColl.setFsIndexes(casDefinition.getFsIndexDescriptions());
        md.setFsIndexCollection(indColl);
        return md;
    }

    public Map getMetadataAsMap() throws ResourceInitializationException {
        return this.processingResourceMap;
    }

    public void setMetadata(String aDescriptorName) throws Exception {
        AnalysisEngineDescription specifier = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(new File(aDescriptorName)));
        AnalysisEngineMetaData meta = specifier.getAnalysisEngineMetaData();
        this.addMetadata((ProcessingResourceMetaData)meta);
    }

    private void addProcessingResourceMetadata(String mapkey, String aDescriptorName) throws Exception {
        AnalysisEngineDescription specifier = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(new File(aDescriptorName)));
        AnalysisEngineMetaData meta = specifier.getAnalysisEngineMetaData();
        this.addMetadata((ProcessingResourceMetaData)meta);
        this.processingResourceMap.put(mapkey, meta);
    }

    public CAS getNewCas() {
        return this.casManager.getCas(this.contextName);
    }

    public CAS getNewCas(String aContext) {
        return this.casManager.getCas(aContext);
    }

    public void setInitialFsHeapSize(long aSizeInBytes) {
        this.initialHeapSize = aSizeInBytes / 4L;
    }

    public long getInitialFsHeapSize() {
        return this.initialHeapSize;
    }
}

