/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.service;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public class Dd2spring {
    private static final Class[] mainArg = new Class[]{String[].class};
    private static final Class THIS_CLASS = Dd2spring.class;
    private ClassLoader saxonClassLoader;

    public static void main(String[] args) {
        new Dd2spring().convertDd2Spring(args[0], args[1], args[2], args[3]);
    }

    public File convertDd2Spring(String ddFilePath, String dd2SpringXsltFilePath, String saxonClasspath, String uimaAsDebug) {
        File tempFile;
        URL urlForSaxonClassPath;
        try {
            urlForSaxonClassPath = new URL(saxonClasspath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_Cannot_convert_saxon_classpath_to_a_URL_SEVERE", new Object[]{saxonClasspath});
            return null;
        }
        try {
            tempFile = File.createTempFile("UIMAdd2springOutput", ".xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_cant_create_temp_output_file_SEVERE");
            return null;
        }
        this.convertDd2Spring(tempFile, ddFilePath, dd2SpringXsltFilePath, urlForSaxonClassPath);
        if (null == uimaAsDebug || uimaAsDebug.equals("")) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    public void convertDd2Spring(File tempFile, String ddFilePath, String dd2SpringXsltFilePath, URL saxonClasspathURL) {
        if (null == this.saxonClassLoader) {
            URL[] classLoaderUrls = new URL[]{saxonClasspathURL};
            this.saxonClassLoader = new URLClassLoader(classLoaderUrls, Object.class.getClassLoader());
        }
        Class<?> mainStartClass = null;
        try {
            mainStartClass = Class.forName("net.sf.saxon.Transform", true, this.saxonClassLoader);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error - can't load Saxon jar from " + saxonClasspathURL + " for dd2spring transformation.");
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_saxon_missing_SEVERE");
            return;
        }
        ArrayList<String> argsForSaxon = new ArrayList<String>();
        argsForSaxon.add("-l");
        argsForSaxon.add("-s");
        argsForSaxon.add(ddFilePath);
        argsForSaxon.add("-o");
        argsForSaxon.add(tempFile.getAbsolutePath());
        argsForSaxon.add(dd2SpringXsltFilePath);
        if (null != System.getProperty("uima-as.dd2spring.noTempQueues")) {
            argsForSaxon.add("noTempQueues=true");
        }
        Method mainMethod = null;
        try {
            mainMethod = mainStartClass.getMethod("main", mainArg);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_security_exception_calling_saxon");
            return;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
            return;
        }
        try {
            mainMethod.invoke(null, new Object[]{argsForSaxon.toArray(new String[argsForSaxon.size()])});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            UIMAFramework.getLogger((Class)THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
            return;
        }
    }
}

