/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaASProcessStatusImpl;
import org.apache.uima.aae.message.UimaMessageValidator;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.MessageSender;
import org.apache.uima.adapter.jms.message.PendingMessage;
import org.apache.uima.jms.error.handler.BrokerConnectionException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTrace_impl;

public abstract class BaseMessageSender
implements Runnable,
MessageSender {
    private static final Class CLASS_NAME = BaseMessageSender.class;
    protected BlockingQueue<PendingMessage> messageQueue = new LinkedBlockingQueue<PendingMessage>();
    protected volatile boolean done;
    protected BaseUIMAAsynchronousEngineCommon_impl engine;
    protected volatile boolean workerThreadFailed;
    protected Exception exception;
    private MessageProducer producer = null;

    public abstract MessageProducer getMessageProducer();

    protected abstract void initializeProducer() throws Exception;

    protected abstract void cleanup() throws Exception;

    protected abstract String getDestinationEndpoint() throws Exception;

    public abstract void setConnection(Connection var1);

    public BaseMessageSender(BaseUIMAAsynchronousEngineCommon_impl anEngine) {
        this.messageQueue = anEngine.pendingMessageQueue;
        this.engine = anEngine;
        try {
            this.engine.producerSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doStop() {
        this.done = true;
        PendingMessage emptyMessage = new PendingMessage(0);
        this.messageQueue.add(emptyMessage);
    }

    public Exception getReasonForFailure() {
        return this.exception;
    }

    public boolean failed() {
        return this.workerThreadFailed;
    }

    private boolean reject(PendingMessage pm) {
        return this.reject(pm, new BrokerConnectionException("Unable To Deliver Message To Destination. Connection To Broker " + BaseUIMAAsynchronousEngineCommon_impl.sharedConnection.getBroker() + " Has Been Lost"));
    }

    private boolean reject(PendingMessage pm, Exception e) {
        boolean rejectRequest;
        block16: {
            rejectRequest = false;
            if (!BaseUIMAAsynchronousEngineCommon_impl.sharedConnection.isConnectionValid()) {
                String messageKind = "";
                if (pm.getMessageType() == 2001) {
                    messageKind = "GetMeta";
                } else if (pm.getMessageType() == 2000) {
                    messageKind = "Process";
                } else if (pm.getMessageType() == 2002) {
                    messageKind = "CollectionProcessComplete";
                }
                rejectRequest = true;
                try {
                    if (pm.getMessageType() == 2000) {
                        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cacheEntry = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.engine.getCache().get(pm.get("CasReference"));
                        if (cacheEntry != null) {
                            boolean notifyListener;
                            cacheEntry.setProcessException();
                            boolean bl = notifyListener = !cacheEntry.isSynchronousInvocation();
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "reject", "jms_adapter_messages", "UIMAJMS_client_rejected_process_request_broker_down__INFO", new Object[]{messageKind});
                            }
                            this.engine.serviceDelegate.setState(2);
                            this.engine.handleException(e, cacheEntry.getCasReferenceId(), null, cacheEntry, notifyListener, false);
                        }
                    } else if (!this.engine.serviceDelegate.isAwaitingPingReply()) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "reject", "jms_adapter_messages", "UIMAJMS_client_rejected_nonprocess_request_broker_down__INFO", new Object[]{messageKind});
                        }
                        this.engine.handleNonProcessException(e);
                    } else if (pm.getMessageType() == 2001) {
                        rejectRequest = false;
                    }
                }
                catch (Exception ex) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block16;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "reject", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                }
            }
        }
        return rejectRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String destination = null;
        boolean addTimeToLive = true;
        if (System.getProperty("NoTTL") != null) {
            addTimeToLive = false;
        }
        try {
            this.initializeProducer();
            destination = this.getDestinationEndpoint();
            if (destination == null) {
                throw new InvalidDestinationException("Unable to determine the destination");
            }
        }
        catch (Exception e) {
            this.workerThreadFailed = true;
            this.exception = e;
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "run", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            return;
        }
        finally {
            this.engine.producerSemaphore.release();
        }
        this.engine.onProducerInitialized();
        PendingMessage pm = null;
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cacheEntry = null;
        while (!this.done) {
            try {
                pm = this.messageQueue.take();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.done) break;
            boolean rejectRequest = this.reject(pm);
            this.engine.recoverSharedConnectionIfClosed();
            this.producer = this.getMessageProducer();
            if (rejectRequest || !this.engine.running) continue;
            if (this.engine.serviceDelegate.isAwaitingPingReply() && pm.getMessageType() == 2001 && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "run", "jms_adapter_messages", "UIMAJMS_client_dispatching_getmeta_ping__INFO", new Object[0]);
            }
            try {
                Object message = null;
                boolean casProcessRequest = this.isProcessRequest(pm);
                message = casProcessRequest && this.engine.getSerializationStrategy().equals("binary") ? this.createBytesMessage() : this.createTextMessage();
                this.initializeMessage(pm, (Message)message);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_sending_msg_to_endpoint__FINE", new Object[]{UimaMessageValidator.decodeIntToString((String)"Command", (int)message.getIntProperty("Command")), UimaMessageValidator.decodeIntToString((String)"MessageType", (int)message.getIntProperty("MessageType")), destination});
                }
                if (casProcessRequest && (cacheEntry = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)this.engine.getCache().get(pm.get("CasReference"))) != null) {
                    long timeoutValue = cacheEntry.getProcessTimeout();
                    if (timeoutValue > 0L && addTimeToLive) {
                        message.setJMSExpiration(10L * timeoutValue);
                    }
                    if (pm.getMessageType() == 2000) {
                        cacheEntry.setCASDepartureTime(System.nanoTime());
                    }
                    cacheEntry.setCASDepartureTime(System.nanoTime());
                    UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)new ProcessTrace_impl(), cacheEntry.getCasReferenceId());
                    this.engine.onBeforeMessageSend((UimaASProcessStatus)status);
                }
                if (casProcessRequest) {
                    this.engine.serviceDelegate.addCasToOutstandingList(cacheEntry.getCasReferenceId());
                } else if (pm.getMessageType() == 2001 && this.engine.serviceDelegate.getGetMetaTimeout() > 0L && !this.engine.serviceDelegate.isAwaitingPingReply()) {
                    this.engine.serviceDelegate.startGetMetaRequestTimer();
                }
                this.producer.send((Message)message);
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "run", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
                this.reject(pm, e);
            }
        }
        try {
            this.cleanup();
        }
        catch (Exception e) {
            this.handleException(e, destination);
        }
    }

    private void initializeMessage(PendingMessage aPm, Message anOutgoingMessage) throws Exception {
        switch (aPm.getMessageType()) {
            case 2001: {
                this.engine.setMetaRequestMessage(anOutgoingMessage);
                break;
            }
            case 2000: {
                String casReferenceId = (String)aPm.get("CasReference");
                if (this.engine.getSerializationStrategy().equals("xmi")) {
                    String serializedCAS = (String)aPm.get("CAS");
                    this.engine.setCASMessage(casReferenceId, serializedCAS, anOutgoingMessage);
                    break;
                }
                byte[] serializedCAS = (byte[])aPm.get("CAS");
                this.engine.setCASMessage(casReferenceId, serializedCAS, anOutgoingMessage);
                break;
            }
            case 2002: {
                this.engine.setCPCMessage(anOutgoingMessage);
            }
        }
    }

    private boolean isProcessRequest(PendingMessage pm) {
        return pm.getMessageType() == 2000;
    }

    private void handleException(Exception e, String aDestination) {
        this.workerThreadFailed = true;
        this.exception = e;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleException", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
        }
        this.engine.recoverSharedConnectionIfClosed();
        this.engine.onException(e, aDestination);
    }

    public MessageProducer getMessageProducer(Destination destination) throws Exception {
        return null;
    }
}

