/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaASApplicationExitEvent;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.jmx.monitor.BasicUimaJmxMonitorListener;
import org.apache.uima.aae.jmx.monitor.JmxMonitor;
import org.apache.uima.aae.jmx.monitor.JmxMonitorListener;
import org.apache.uima.adapter.jms.activemq.SpringContainerDeployer;
import org.apache.uima.adapter.jms.service.Dd2spring;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class UIMA_Service
implements ApplicationListener {
    private static final Class CLASS_NAME = UIMA_Service.class;
    protected boolean serviceInitializationCompleted;
    protected boolean serviceInitializationException;
    protected Object serviceMonitor = new Object();
    private JmxMonitor monitor = null;
    private Thread monitorThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] initialize(String[] args) throws Exception {
        String[] springConfigFileArray;
        UIMAFramework.getLogger((Class)CLASS_NAME).log(Level.INFO, "UIMA-AS version " + UimaAsVersion.getFullVersionString());
        int nbrOfArgs = args.length;
        String[] deploymentDescriptors = UIMA_Service.getMultipleArg("-d", args);
        if (deploymentDescriptors.length == 0) {
            deploymentDescriptors = UIMA_Service.getMultipleArg2("-dd", args);
        }
        String saxonURL = UIMA_Service.getArg("-saxonURL", args);
        String xslTransform = UIMA_Service.getArg("-xslt", args);
        String uimaAsDebug = UIMA_Service.getArg("-uimaEeDebug", args);
        if (nbrOfArgs < 1 || args[0].startsWith("-") && (deploymentDescriptors.length == 0 || saxonURL.equals("") || xslTransform.equals(""))) {
            UIMA_Service.printUsageMessage();
            return null;
        }
        String brokerURL = UIMA_Service.getArg("-brokerURL", args);
        if (brokerURL != "") {
            System.setProperty("defaultBrokerURL", brokerURL);
            System.out.println(">>> Setting defaultBrokerURL to:" + brokerURL);
        } else if (System.getProperty("defaultBrokerURL") == null) {
            System.setProperty("defaultBrokerURL", "tcp://localhost:61616");
        }
        if (System.getProperty("SessionTimeoutOverride") != null) {
            System.out.println(">>> Setting Inactivity Timeout To: " + System.getProperty("SessionTimeoutOverride"));
        }
        if (deploymentDescriptors.length == 0) {
            springConfigFileArray = args;
        } else {
            springConfigFileArray = new String[deploymentDescriptors.length];
            Dd2spring aDd2Spring = new Dd2spring();
            for (int dd = 0; dd < deploymentDescriptors.length; ++dd) {
                String deploymentDescriptor = deploymentDescriptors[dd];
                File springConfigFile = aDd2Spring.convertDd2Spring(deploymentDescriptor, xslTransform, saxonURL, uimaAsDebug);
                if (null == springConfigFile) {
                    return null;
                }
                springConfigFileArray[dd] = springConfigFile.getAbsolutePath();
                String deployDescriptor = "";
                File afile = null;
                FileInputStream fis = null;
                try {
                    afile = new File(deploymentDescriptor);
                    fis = new FileInputStream(afile);
                    byte[] bytes = new byte[(int)afile.length()];
                    fis.read(bytes);
                    deployDescriptor = new String(bytes);
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "main", "jms_adapter_messages", "UIMAJMS_deploy_desc__FINEST", new Object[]{deployDescriptor});
                    continue;
                }
                catch (IOException e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return springConfigFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringContainerDeployer deploy(String[] springContextFiles, ApplicationListener<ApplicationEvent> listener) throws Exception {
        SpringContainerDeployer springDeployer = listener == null ? new SpringContainerDeployer(this) : new SpringContainerDeployer(listener);
        springDeployer.deploy(springContextFiles);
        while (!springDeployer.isInitialized()) {
            if (springDeployer.initializationFailed()) {
                throw new ResourceInitializationException();
            }
            SpringContainerDeployer springContainerDeployer = springDeployer;
            synchronized (springContainerDeployer) {
                springDeployer.wait(100L);
            }
        }
        FileSystemXmlApplicationContext context = springDeployer.getSpringContext();
        context.addApplicationListener((ApplicationListener)this);
        springDeployer.startListeners();
        return springDeployer;
    }

    public SpringContainerDeployer deploy(String[] springContextFiles) throws Exception {
        return this.deploy(springContextFiles, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startMonitor(long samplingFrequency) throws Exception {
        this.monitor = new JmxMonitor();
        String jmxServerPort = null;
        jmxServerPort = System.getProperty("com.sun.management.jmxremote.port");
        if (System.getProperty("verbose") != null) {
            this.monitor.setVerbose();
        }
        if (jmxServerPort != null) {
            String jmxServerURI = "service:jmx:rmi:///jndi/rmi://localhost:" + jmxServerPort + "/jmxrmi";
            this.monitor.initialize(jmxServerURI, samplingFrequency);
            BasicUimaJmxMonitorListener listener = null;
            String formatterListenerClass = null;
            formatterListenerClass = System.getProperty("uima.jmx.monitor.formatter");
            if (formatterListenerClass != null) {
                Object object = null;
                try {
                    Class<?> formatterClass = Class.forName(formatterListenerClass);
                    object = formatterClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    System.out.println("Class Not Found:" + formatterListenerClass + ". Provide a Formatter Class Which Implements:org.apache.uima.aae.jmx.monitor.JmxMonitorListener");
                    throw e;
                }
                if (!(object instanceof JmxMonitorListener)) throw new InvalidClassException("Invalid Monitor Formatter Class:" + formatterListenerClass + ".The Monitor Requires a Formatter Which Implements:org.apache.uima.aae.jmx.monitor.JmxMonitorListener");
                listener = object;
            } else {
                listener = new BasicUimaJmxMonitorListener(this.monitor.getMaxServiceNameLength());
            }
            this.monitor.addJmxMonitorListener((JmxMonitorListener)listener);
            this.monitorThread = new Thread(this.monitor);
            this.monitorThread.start();
            System.out.println(">>> Started JMX Monitor.\n\t>>> MBean Server Port:" + jmxServerPort + "\n\t>>> Monitor Sampling Interval:" + samplingFrequency + "\n\t>>> Monitor Formatter Class:" + listener.getClass().getName());
            return;
        }
        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) return;
        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "startMonitor", "jms_adapter_messages", "UIMAJMS_no_jmx_port__WARNING", new Object[0]);
        System.exit(0);
    }

    public void stopMonitor() throws Exception {
        if (this.monitor != null) {
            this.monitor.doStop();
        }
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
    }

    private static String getArg(String id, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            return i + 1 < args.length ? args[i + 1] : "";
        }
        return "";
    }

    private static String[] getMultipleArg(String id, String[] args) {
        String[] retr = new String[]{};
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            String[] temp = new String[retr.length + 1];
            for (int s = 0; s < retr.length; ++s) {
                temp[s] = retr[s];
            }
            retr = temp;
            retr[retr.length - 1] = i + 1 < args.length ? args[i + 1] : null;
        }
        return retr;
    }

    private static String[] getMultipleArg2(String id, String[] args) {
        String[] retr = new String[]{};
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            int j = 0;
            while (i + 1 + j < args.length && !args[i + 1 + j].startsWith("-")) {
                String[] temp = new String[retr.length + 1];
                for (int s = 0; s < retr.length; ++s) {
                    temp[s] = retr[s];
                }
                retr = temp;
                retr[retr.length - 1] = args[i + 1 + j++];
            }
            return retr;
        }
        return retr;
    }

    protected void finalize() {
        System.err.println(this + " finalized");
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \n-d path-to-UIMA-Deployment-Descriptor [-d path-to-UIMA-Deployment-Descriptor ...] \n-saxon path-to-saxon.jar \n-xslt path-to-dd2spring-xslt\n   or\npath to Spring XML Configuration File which is the output of running dd2spring\n-defaultBrokerURL the default broker URL to use for the service and all its delegates");
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent && this.monitor != null && this.monitor.isRunning()) {
            System.out.println("Stopping Monitor");
            this.monitor.doStop();
        } else if (event instanceof UimaASApplicationExitEvent) {
            System.out.println("Service Wrapper Received UimaASApplicationEvent. Message:" + event.getSource());
        } else if (event instanceof ContextStoppedEvent) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        block16: {
            try {
                UIMA_Service service = new UIMA_Service();
                String[] contextFiles = service.initialize(args);
                if (contextFiles == null) {
                    return;
                }
                SpringContainerDeployer serviceDeployer = service.deploy(contextFiles);
                if (serviceDeployer == null) {
                    System.out.println(">>> Failed to Deploy UIMA Service. Check Logs for Details");
                    System.exit(0);
                }
                for (String contextFile : contextFiles) {
                    File file = new File(contextFile);
                    if (!file.exists()) continue;
                    file.delete();
                }
                ServiceShutdownHook shutdownHook = new ServiceShutdownHook(serviceDeployer);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                String monitorCheckpointFrequency = System.getProperty("uima.jmx.monitor.interval");
                if (monitorCheckpointFrequency != null) {
                    service.startMonitor(Long.parseLong(monitorCheckpointFrequency));
                }
                AnalysisEngineController topLevelControllor = serviceDeployer.getTopLevelController();
                String prompt = "Press 'q'+'Enter' to quiesce and stop the service or 's'+'Enter' to stop it now.\nNote: selected option is not echoed on the console.";
                if (topLevelControllor != null) {
                    System.out.println(prompt);
                    while (!topLevelControllor.isStopped()) {
                        if (System.in.available() > 0) {
                            int c = System.in.read();
                            if (c == 115) {
                                service.stopMonitor();
                                serviceDeployer.undeploy(1001);
                                System.exit(0);
                            } else if (c == 113) {
                                service.stopMonitor();
                                serviceDeployer.undeploy(1000);
                                System.exit(0);
                            } else if (Character.isLetter(c) || Character.isDigit(c)) {
                                System.out.println(prompt);
                            }
                        }
                        try {
                            if (topLevelControllor.isStopped()) continue;
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block16;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "main", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    static class ServiceShutdownHook
    extends Thread {
        public SpringContainerDeployer serviceDeployer;

        public ServiceShutdownHook(SpringContainerDeployer serviceDeployer) {
            this.serviceDeployer = serviceDeployer;
        }

        @Override
        public void run() {
            block3: {
                try {
                    AnalysisEngineController topLevelController = this.serviceDeployer.getTopLevelController();
                    if (topLevelController != null && !topLevelController.isStopped()) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_caught_signal__INFO", new Object[]{topLevelController.getComponentName()});
                        this.serviceDeployer.undeploy(1000);
                        Runtime.getRuntime().halt(0);
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
        }
    }
}

