/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.as;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.aae.client.UimaAsynchronousEngine;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.XMLInputSource;

public class RunRemoteAsyncAE {
    private String brokerUrl = null;
    private String endpoint = null;
    private File collectionReaderDescriptor = null;
    private int casPoolSize = 2;
    private int fsHeapSize = 2000000;
    private File outputDir = null;
    private int timeout = 0;
    private int getmeta_timeout = 60;
    private int cpc_timeout = 0;
    private boolean ignoreErrors = false;
    private boolean logCas = false;
    private static long mStartTime = System.nanoTime() / 1000000L;
    private UimaAsynchronousEngine uimaEEEngine = null;
    Map<String, Object> appCtx;
    private ConcurrentHashMap casMap = new ConcurrentHashMap();
    private String springContainerId = null;

    public RunRemoteAsyncAE(String[] args) throws Exception {
        this.appCtx = new HashMap<String, Object>();
        this.appCtx.put("DD2SpringXsltFilePath", System.getenv("UIMA_HOME") + "/bin/dd2spring.xsl");
        this.appCtx.put("SaxonClasspath", "file:" + System.getenv("UIMA_HOME") + "/saxon/saxon8.jar");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-log")) {
                    this.logCas = true;
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.appCtx.put("SerializationStrategy", "binary");
                    continue;
                }
                if (args[i].equals("-i")) {
                    this.ignoreErrors = true;
                    continue;
                }
                if (i + 1 >= args.length) {
                    RunRemoteAsyncAE.printUsageAndExit();
                }
                if (args[i].equals("-c")) {
                    this.collectionReaderDescriptor = new File(args[++i]);
                    if (this.collectionReaderDescriptor.exists()) continue;
                    System.err.println("Collection Reader Descriptor file " + this.collectionReaderDescriptor.getPath() + " does not exist.");
                    RunRemoteAsyncAE.printUsageAndExit();
                    continue;
                }
                if (args[i].equals("-p")) {
                    this.casPoolSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-f")) {
                    this.fsHeapSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-o")) {
                    this.outputDir = new File(args[++i]);
                    if (this.outputDir.exists()) {
                        if (this.outputDir.isDirectory()) continue;
                        System.err.println(this.outputDir.getPath() + " is not a directory.");
                        RunRemoteAsyncAE.printUsageAndExit();
                        continue;
                    }
                    if (this.outputDir.mkdirs()) continue;
                    System.err.println("Could not create directory " + this.outputDir.getPath());
                    RunRemoteAsyncAE.printUsageAndExit();
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (this.uimaEEEngine == null) {
                        this.uimaEEEngine = new BaseUIMAAsynchronousEngine_impl();
                    }
                    String service = args[++i];
                    System.out.println("Attempting to deploy " + service + " ...");
                    this.springContainerId = this.uimaEEEngine.deploy(service, this.appCtx);
                    continue;
                }
                if (args[i].equals("-t")) {
                    this.timeout = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-it")) {
                    this.getmeta_timeout = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-cpct")) {
                    this.cpc_timeout = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-uimaEeDebug")) {
                    this.appCtx.put("-uimaEeDebug", args[++i]);
                    continue;
                }
                System.err.println("Unknown switch " + args[i]);
                RunRemoteAsyncAE.printUsageAndExit();
                continue;
            }
            if (this.brokerUrl == null) {
                this.brokerUrl = args[i];
                System.setProperty("defaultBrokerURL", this.brokerUrl);
                continue;
            }
            if (this.endpoint == null) {
                this.endpoint = args[i];
                continue;
            }
            RunRemoteAsyncAE.printUsageAndExit();
        }
        if (this.brokerUrl == null || this.endpoint == null) {
            RunRemoteAsyncAE.printUsageAndExit();
        }
    }

    public void run() throws Exception {
        if (this.uimaEEEngine == null) {
            this.uimaEEEngine = new BaseUIMAAsynchronousEngine_impl();
        }
        if (this.collectionReaderDescriptor != null) {
            CollectionReaderDescription collectionReaderDescription = UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(this.collectionReaderDescriptor));
            CollectionReader collectionReader = UIMAFramework.produceCollectionReader((ResourceSpecifier)collectionReaderDescription);
            this.uimaEEEngine.setCollectionReader(collectionReader);
        }
        this.uimaEEEngine.addStatusCallbackListener((UimaAsBaseCallbackListener)new StatusCallbackListenerImpl());
        this.appCtx.put("ServerURI", this.brokerUrl);
        this.appCtx.put("Endpoint", this.endpoint);
        this.appCtx.put("Timeout", this.timeout * 1000);
        this.appCtx.put("GetMetaTimeout", this.getmeta_timeout * 1000);
        this.appCtx.put("CpcTimeout", this.cpc_timeout * 1000);
        this.appCtx.put("CasPoolSize", this.casPoolSize);
        this.appCtx.put("cas_initial_heap_size", Integer.valueOf(this.fsHeapSize / 4).toString());
        this.uimaEEEngine.initialize(this.appCtx);
        if (this.logCas) {
            System.out.println("\nService-IPaddr\tSent\tDuration");
        }
        try {
            if (this.collectionReaderDescriptor != null) {
                this.uimaEEEngine.process();
            } else {
                CAS cas = this.uimaEEEngine.getCAS();
                this.uimaEEEngine.sendCAS(cas);
                this.uimaEEEngine.collectionProcessingComplete();
            }
            if (this.springContainerId != null) {
                this.uimaEEEngine.undeploy(this.springContainerId);
            }
            this.uimaEEEngine.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            Runtime.getRuntime().halt(-1);
        }
        System.exit(0);
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: runRemoteAsyncAE brokerUrl endpoint [options]\n\nThis connects to a remote AE at specified brokerUrl and endpoint (which must match what is in the service's\ndeployment descriptor.\n\nThe following optional arguments are accepted:\n-d  Specifies a deployment descriptor. The specified service will be deployed before processing begins. Multiple -d entries can be given.\n-c  Specifies a CollectionReader descriptor.  The client will read CASes from the CollectionReader and send them to the service for processing.  If this option is omitted, one empty CAS will be sent to the service (useful for services containing a CAS Multiplier acting as a collection reader).\n-b  Use binary serialization (default is xmi)\n-p  Specifies CAS pool size, which determines the maximum number of requests that can be outstanding.\n-f  Specifies the initial FS heap size in bytes of each CAS in the pool.\n-o  Specifies an Output Directory.  All CASes received by the client's CallbackListener will be serialized to XMI in the specified OutputDir.  If omitted, no XMI files will be output.\n-t  Specifies a timeout period in seconds.  If a CAS does not return within this time period it is considered an error.  By default there is no timeout, so the client will wait forever.\n-it  Specifies a timeout period in seconds.  If the initialization request does not return within this time period it is considered an error.  By default the timeout is 60 seconds.\n-cpct  Specifies a timeout period in seconds.  When all CAS requests are completed, a collection process complete command is sent.  By default there is no timeout for CPC, so the client will wait forever.\n-log Output details on each process request: IP address of service that handled the request,\n     time in ms the CAS was sent, duration in ms from sendCas to receipt.\n-i  Causes the client to ignore errors returned from the service.  If not specified, the client terminates on the first error (including a timeout if the -t option is specified.\n-uimaEeDebug true    This is optional. Leave it out for normal operation. If specified, causes additional debugging things to happen, including *not* deleting the generated Spring xml file generated from running dd2spring.  It only affects deployments specified using the -d parameter that follow it on the command line");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        RunRemoteAsyncAE runner = new RunRemoteAsyncAE(args);
        runner.run();
    }

    class StatusCallbackListenerImpl
    extends UimaAsBaseCallbackListener {
        int entityCount = 0;
        long size = 0L;

        StatusCallbackListenerImpl() {
        }

        public void initializationComplete(EntityProcessStatus aStatus) {
            if (aStatus != null && aStatus.isException()) {
                System.err.println("Error on getMeta call to remote service:");
                List exceptions = aStatus.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    ((Throwable)exceptions.get(i)).printStackTrace();
                }
                System.err.println("Terminating Client...");
                this.stop();
            }
            System.out.println("UIMA AS Service Initialization Complete");
        }

        private void stop() {
            try {
                RunRemoteAsyncAE.this.uimaEEEngine.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }

        public void collectionProcessComplete(EntityProcessStatus aStatus) {
            if (aStatus != null && aStatus.isException()) {
                System.err.println("Error on collection process complete call to remote service:");
                List exceptions = aStatus.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    ((Throwable)exceptions.get(i)).printStackTrace();
                }
                System.err.println("Terminating Client...");
                this.stop();
            }
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.nanoTime() / 1000000L - mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
            String perfReport = RunRemoteAsyncAE.this.uimaEEEngine.getPerformanceReport();
            if (perfReport != null) {
                System.out.println("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
                System.out.println(RunRemoteAsyncAE.this.uimaEEEngine.getPerformanceReport());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus != null) {
                if (aStatus.isException()) {
                    System.err.println("Error on process CAS call to remote service:");
                    List exceptions = aStatus.getExceptions();
                    for (int i = 0; i < exceptions.size(); ++i) {
                        ((Throwable)exceptions.get(i)).printStackTrace();
                    }
                    if (!RunRemoteAsyncAE.this.ignoreErrors) {
                        System.err.println("Terminating Client...");
                        this.stop();
                    }
                }
                if (RunRemoteAsyncAE.this.logCas) {
                    String ip = "no IP";
                    List eList = aStatus.getProcessTrace().getEventsByComponentName("UimaEE", false);
                    for (int e = 0; e < eList.size(); ++e) {
                        ProcessTraceEvent event = (ProcessTraceEvent)eList.get(e);
                        if (!event.getDescription().equals("Service IP")) continue;
                        ip = event.getResultMessage();
                    }
                    String casId = ((UimaASProcessStatus)aStatus).getCasReferenceId();
                    if (casId != null) {
                        Object value;
                        long current = System.nanoTime() / 1000000L - mStartTime;
                        if (RunRemoteAsyncAE.this.casMap.containsKey(casId) && (value = RunRemoteAsyncAE.this.casMap.get(casId)) != null && value instanceof Long) {
                            long start = (Long)value;
                            System.out.println(ip + "\t" + start + "\t" + (current - start));
                        }
                    }
                } else {
                    System.out.print(".");
                    if (0 == (this.entityCount + 1) % 50) {
                        System.out.print(this.entityCount + 1 + " processed\n");
                    }
                }
            }
            if (RunRemoteAsyncAE.this.outputDir != null) {
                FSIterator it;
                File outFile = null;
                Type srcDocInfoType = aCas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
                if (srcDocInfoType != null && (it = aCas.getIndexRepository().getAllIndexedFS(srcDocInfoType)).hasNext()) {
                    FeatureStructure srcDocInfoFs = it.get();
                    Feature uriFeat = srcDocInfoType.getFeatureByBaseName("uri");
                    Feature offsetInSourceFeat = srcDocInfoType.getFeatureByBaseName("offsetInSource");
                    String uri = srcDocInfoFs.getStringValue(uriFeat);
                    int offsetInSource = srcDocInfoFs.getIntValue(offsetInSourceFeat);
                    try {
                        File inFile = new File(new URL(uri).getPath());
                        String outFileName = inFile.getName();
                        if (offsetInSource > 0) {
                            outFileName = outFileName + "_" + offsetInSource;
                        }
                        outFileName = outFileName + ".xmi";
                        outFile = new File(RunRemoteAsyncAE.this.outputDir, outFileName);
                    }
                    catch (MalformedURLException e1) {
                        // empty catch block
                    }
                }
                if (outFile == null) {
                    outFile = new File(RunRemoteAsyncAE.this.outputDir, "doc" + this.entityCount);
                }
                try {
                    FileOutputStream outStream = new FileOutputStream(outFile);
                    try {
                        XmiCasSerializer.serialize((CAS)aCas, (OutputStream)outStream);
                        Object var14_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        outStream.close();
                        throw throwable;
                    }
                    outStream.close();
                    {
                    }
                }
                catch (Exception e) {
                    System.err.println("Could not save CAS to XMI file");
                    e.printStackTrace();
                }
            }
            ++this.entityCount;
            String docText = aCas.getDocumentText();
            if (docText != null) {
                this.size += (long)docText.length();
            }
        }

        public void onBeforeMessageSend(UimaASProcessStatus status) {
            long current = System.nanoTime() / 1000000L - mStartTime;
            RunRemoteAsyncAE.this.casMap.put(status.getCasReferenceId(), current);
        }

        public void onBeforeProcessCAS(UimaASProcessStatus status, String nodeIP, String pid) {
        }
    }
}

