/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jms_adapter;

import java.util.HashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.aae.client.UimaAsynchronousEngine;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.analysis_engine.AnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;

public class JmsAnalysisEngineServiceStub
extends UimaAsBaseCallbackListener
implements AnalysisEngineServiceStub {
    private static final Class CLASS_NAME = JmsAnalysisEngineServiceStub.class;
    public static final String PARAM_BROKER_URL = "brokerUrl";
    public static final String PARAM_ENDPOINT = "endpoint";
    public static final String PARAM_TIMEOUT = "timeout";
    public static final String PARAM_GETMETA_TIMEOUT = "getmetatimeout";
    public static final String PARAM_CPC_TIMEOUT = "cpctimeout";
    public static final String PARAM_RETRY = "retry";
    public static final String PARAM_BIN_SERIALIZTION = "binary_serialization";
    public static final String PARAM_IGNORE_PROCESS_ERRORS = "ignore_process_errors";
    private Object mux = new Object();
    private boolean cpcReceived;
    private boolean ignoreErrors = false;
    private int retry = 0;
    private UimaAsynchronousEngine uimaEEEngine;

    public JmsAnalysisEngineServiceStub(Resource owner, Parameter[] parameters) throws ResourceInitializationException {
        String brokerUrl = null;
        String endpoint = null;
        int timeout = 0;
        int getMetaTimeout = 0;
        int cpcTimeout = 0;
        String binary_serialization = null;
        for (int i = 0; i < parameters.length; ++i) {
            if (PARAM_BROKER_URL.equalsIgnoreCase(parameters[i].getName())) {
                brokerUrl = parameters[i].getValue();
                continue;
            }
            if (PARAM_ENDPOINT.equalsIgnoreCase(parameters[i].getName())) {
                endpoint = parameters[i].getValue();
                continue;
            }
            if (PARAM_TIMEOUT.equalsIgnoreCase(parameters[i].getName())) {
                timeout = Integer.parseInt(parameters[i].getValue());
                continue;
            }
            if (PARAM_BIN_SERIALIZTION.equalsIgnoreCase(parameters[i].getName())) {
                binary_serialization = parameters[i].getValue();
                continue;
            }
            if (PARAM_GETMETA_TIMEOUT.equalsIgnoreCase(parameters[i].getName())) {
                getMetaTimeout = Integer.parseInt(parameters[i].getValue());
                continue;
            }
            if (PARAM_CPC_TIMEOUT.equalsIgnoreCase(parameters[i].getName())) {
                cpcTimeout = Integer.parseInt(parameters[i].getValue());
                continue;
            }
            if (PARAM_RETRY.equalsIgnoreCase(parameters[i].getName())) {
                this.retry = Integer.parseInt(parameters[i].getValue());
                this.retry = this.retry < 0 ? 0 : this.retry;
                continue;
            }
            if (!PARAM_IGNORE_PROCESS_ERRORS.equalsIgnoreCase(parameters[i].getName())) continue;
            this.ignoreErrors = parameters[i].getValue().equalsIgnoreCase("true");
        }
        HashMap<String, Object> appCtxt = new HashMap<String, Object>();
        appCtxt.put("ServerURI", brokerUrl);
        appCtxt.put("Endpoint", endpoint);
        appCtxt.put("CasPoolSize", 0);
        if (timeout > 0) {
            appCtxt.put("Timeout", timeout);
        }
        if (getMetaTimeout > 0) {
            appCtxt.put("GetMetaTimeout", getMetaTimeout);
        }
        if (cpcTimeout > 0) {
            appCtxt.put("CpcTimeout", cpcTimeout);
        }
        if (binary_serialization != null && binary_serialization.equalsIgnoreCase("true")) {
            appCtxt.put("SerializationStrategy", "binary");
        }
        this.uimaEEEngine = new BaseUIMAAsynchronousEngine_impl();
        this.uimaEEEngine.addStatusCallbackListener((UimaAsBaseCallbackListener)this);
        this.uimaEEEngine.initialize(appCtxt);
    }

    public ResourceMetaData callGetMetaData() throws ResourceServiceException {
        try {
            ProcessingResourceMetaData rmd = this.uimaEEEngine.getMetaData();
            if (rmd != null) {
                rmd.getOperationalProperties().setMultipleDeploymentAllowed(true);
                return rmd;
            }
        }
        catch (ResourceInitializationException e) {
            throw new ResourceServiceException((Throwable)e);
        }
        throw new ResourceServiceException((Throwable)new Exception("Uima AS getMetaData() call failed."));
    }

    public AnalysisEngineMetaData callGetAnalysisEngineMetaData() throws ResourceServiceException {
        return (AnalysisEngineMetaData)this.callGetMetaData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callProcess(CAS aCAS) throws ResourceServiceException {
        int tries = this.retry;
        while (true) {
            try {
                this.uimaEEEngine.sendAndReceiveCAS(aCAS);
                return;
            }
            catch (Throwable e) {
                if (tries-- > 0) {
                    UIMAFramework.getLogger().log(Level.INFO, "Retrying callProcess on remote AS service...");
                    continue;
                }
                if (!this.ignoreErrors) throw new ResourceServiceException(e);
                continue;
            }
            break;
        }
    }

    public void callProcessCas(CAS aCAS) throws ResourceServiceException {
        this.callProcess(aCAS);
    }

    public void destroy() {
        block2: {
            try {
                this.uimaEEEngine.stop();
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger().isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger().log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
        }
    }

    public void callBatchProcessComplete() throws ResourceServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callCollectionProcessComplete() throws ResourceServiceException {
        try {
            this.cpcReceived = false;
            this.uimaEEEngine.collectionProcessingComplete();
            Object object = this.mux;
            synchronized (object) {
                while (!this.cpcReceived) {
                    try {
                        this.mux.wait();
                    }
                    catch (InterruptedException e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "callCollectionProcessComplete", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }
        catch (ResourceProcessException e) {
            throw new ResourceServiceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionProcessComplete(EntityProcessStatus aStatus) {
        Object object = this.mux;
        synchronized (object) {
            this.cpcReceived = true;
            this.mux.notifyAll();
        }
    }

    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
    }

    public void initializationComplete(EntityProcessStatus aStatus) {
    }
}

