/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaEEAdminContext;
import org.apache.uima.adapter.jms.activemq.UimaDefaultMessageListenerContainer;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class UimaEEAdminSpringContext
implements UimaEEAdminContext,
ApplicationListener {
    private static final Class CLASS_NAME = UimaEEAdminSpringContext.class;
    private FileSystemXmlApplicationContext springContainer = null;
    private BrokerService service;
    private boolean isShutdown;
    private ConcurrentHashMap<String, ListenerEntry> listenerMap = new ConcurrentHashMap();

    public UimaEEAdminSpringContext(FileSystemXmlApplicationContext aSpringContainer) {
        this.springContainer = aSpringContainer;
        String[] beanNames = this.springContainer.getBeanNamesForType(UimaDefaultMessageListenerContainer.class);
        for (int i = 0; beanNames != null && i < beanNames.length; ++i) {
            try {
                UimaDefaultMessageListenerContainer listenerContainer = (UimaDefaultMessageListenerContainer)((Object)this.springContainer.getBean(beanNames[i]));
                ListenerEntry listenerEntry = new ListenerEntry();
                listenerEntry.setListenerContainer(listenerContainer);
                this.listenerMap.put(listenerContainer.getDestinationName(), listenerEntry);
                continue;
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "UimaEEAdminSpringContext", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void setBroker(BrokerService aBrokerService) {
        this.service = aBrokerService;
    }

    public ApplicationContext getSpringContainer() {
        return this.springContainer;
    }

    public int getConcurrentConsumerCount(String anEndpointName) {
        try {
            if (anEndpointName != null && anEndpointName.trim().length() > 0 && this.springContainer.isActive() && this.listenerMap.containsKey(anEndpointName)) {
                ListenerEntry listenerEntry = null;
                listenerEntry = this.listenerMap.get(anEndpointName);
                if (listenerEntry != null && !listenerEntry.isStopped()) {
                    UimaDefaultMessageListenerContainer listenerContainer = listenerEntry.getListenerContainer();
                    return listenerContainer.getConcurrentConsumers();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public synchronized void stopListener(String anEndpointName) {
        try {
            if (anEndpointName != null && anEndpointName.trim().length() > 0 && this.springContainer.isActive() && this.listenerMap.containsKey(anEndpointName)) {
                ListenerEntry listenerEntry = null;
                listenerEntry = this.listenerMap.get(anEndpointName);
                if (listenerEntry != null && !listenerEntry.isStopped()) {
                    ListenerEntry entry;
                    listenerEntry.setStopped(true);
                    if (this.listenerMap.get(anEndpointName) != null && (entry = this.listenerMap.get(anEndpointName)) != null) {
                        UimaDefaultMessageListenerContainer listenerContainer = entry.getListenerContainer();
                        this.spinThreadForListenerShutdown(listenerContainer);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void spinThreadForListenerShutdown(final UimaDefaultMessageListenerContainer listenerContainer) {
        new Thread(){

            public void run() {
                block3: {
                    try {
                        listenerContainer.setAutoStartup(false);
                        listenerContainer.setRecoveryInterval(0L);
                        listenerContainer.shutdown();
                        listenerContainer.destroy();
                        String eName = listenerContainer.getEndpointName();
                        if (eName != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "spinThreadForListenerShutdown.run()", "jms_adapter_messages", "UIMAJMS_stop_listener__INFO", new Object[]{eName});
                        }
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    public void onApplicationEvent(ApplicationEvent anEvent) {
        this.shutdown();
    }

    public void shutdown() {
        if (this.springContainer.isActive()) {
            this.isShutdown = true;
            new Thread("Spring Container Shutdown Thread"){

                public void run() {
                    block2: {
                        try {
                            UimaEEAdminSpringContext.this.springContainer.destroy();
                            UimaEEAdminSpringContext.this.springContainer = null;
                        }
                        catch (Exception e) {
                            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "shutdown", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                        }
                    }
                }
            }.start();
        }
        this.listenerMap.clear();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    protected static class ListenerEntry {
        private boolean stopped = false;
        private UimaDefaultMessageListenerContainer listenerContainer = null;

        protected ListenerEntry() {
        }

        protected UimaDefaultMessageListenerContainer getListenerContainer() {
            return this.listenerContainer;
        }

        protected void setListenerContainer(UimaDefaultMessageListenerContainer listenerContainer) {
            this.listenerContainer = listenerContainer;
        }

        protected boolean isStopped() {
            return this.stopped;
        }

        protected void setStopped(boolean stopped) {
            this.stopped = stopped;
        }
    }
}

