/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class BrokerDeployer
implements ApplicationListener {
    private static final Class CLASS_NAME = BrokerDeployer.class;
    private static final int BASE_JMX_PORT = 1200;
    private static final int MAX_PORT_THRESHOLD = 200;
    private static BrokerService service = new BrokerService();
    private Object semaphore = new Object();
    private long maxBrokerMemory = 0L;
    private String brokerURI;
    private TransportConnector tcpConnector = null;
    private TransportConnector httpConnector = null;
    private Object brokerInstanceMux = new Object();

    public BrokerDeployer(long maxMemoryinBytes) throws Exception {
        this.maxBrokerMemory = maxMemoryinBytes;
        this.startInternalBroker();
    }

    public BrokerDeployer() throws Exception {
        this.startInternalBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerService getBroker() {
        Object object = this.brokerInstanceMux;
        synchronized (object) {
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInternalBroker() throws Exception {
        TransportConnector connector = null;
        Object object = this.brokerInstanceMux;
        synchronized (object) {
            String[] connectors;
            if (this.maxBrokerMemory > 0L) {
                System.out.println("Configuring Internal Broker With Max Memory Of:" + this.maxBrokerMemory);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_broker_memory__CONFIG", new Object[]{this.maxBrokerMemory});
                }
            }
            if ((connectors = service.getNetworkConnectorURIs()) != null) {
                for (int i = 0; i < connectors.length; ++i) {
                    System.out.println("ActiveMQ Broker Started With Connector:" + connectors[i]);
                }
                this.brokerURI = service.getMasterConnectorURI();
            } else {
                String connectorList = "";
                service.setPersistent(false);
                int startPort = 1200;
                if (System.getProperties().containsKey("com.sun.management.jmxremote.port")) {
                    startPort = Integer.parseInt(System.getProperty("com.sun.management.jmxremote.port"));
                }
                while (startPort < 200 && !this.openPort(startPort)) {
                    ++startPort;
                }
                if (startPort < startPort + 200) {
                    service.getManagementContext().setConnectorPort(startPort);
                    service.setUseJmx(true);
                    System.setProperty("com.sun.management.jmxremote.port", String.valueOf(startPort));
                    System.out.println("JMX Console connect URI:  service:jmx:rmi:///jndi/rmi://localhost:" + startPort + "/jmxrmi");
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_jmx_uri__CONFIG", new Object[]{"service:jmx:rmi:///jndi/rmi://localhost:" + startPort + "/jmxrmi"});
                    }
                }
                this.brokerURI = this.generateInternalURI("tcp", 18810, true, false);
                int timeBetweenRetries = 1000;
                boolean tcpConnectorAcquiredValidPort = false;
                while (!tcpConnectorAcquiredValidPort) {
                    try {
                        this.tcpConnector = service.addConnector(this.brokerURI);
                        tcpConnectorAcquiredValidPort = true;
                    }
                    catch (Exception e) {
                        BrokerDeployer brokerDeployer = this;
                        synchronized (brokerDeployer) {
                            this.wait(timeBetweenRetries);
                        }
                    }
                }
                System.out.println("Adding TCP Connector:" + this.tcpConnector.getConnectUri());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_adding_connector__CONFIG", new Object[]{"Adding TCP Connector", this.tcpConnector.getConnectUri()});
                }
                connectorList = this.tcpConnector.getName();
                if (System.getProperty("StompSupport") != null) {
                    String stompURI = this.generateInternalURI("stomp", 61613, false, false);
                    connector = service.addConnector(stompURI);
                    System.out.println("Adding STOMP Connector:" + connector.getConnectUri());
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_adding_connector__CONFIG", new Object[]{"Adding STOMP Connector", connector.getConnectUri()});
                    }
                    connectorList = connectorList + "," + connector.getName();
                }
                if (System.getProperty("HTTP") != null) {
                    String stringPort = System.getProperty("HTTP");
                    int p = Integer.parseInt(stringPort);
                    String httpURI = this.generateInternalURI("http", p, false, true);
                    this.httpConnector = service.addConnector(httpURI);
                    System.out.println("Adding HTTP Connector:" + this.httpConnector.getConnectUri());
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_adding_connector__CONFIG", new Object[]{"Adding HTTP Connector", this.httpConnector.getConnectUri()});
                    }
                    connectorList = connectorList + "," + this.httpConnector.getName();
                }
                service.start();
                System.setProperty("ActiveMQConnectors", connectorList);
                System.out.println("Broker Service Started - URL:" + service.getVmConnectorURI());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "startInternalBroker", "jms_adapter_messages", "UIMAJMS_broker_started__CONFIG", new Object[]{service.getVmConnectorURI()});
                }
            }
        }
        object = this.semaphore;
        synchronized (object) {
            this.semaphore.wait(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openPort(int aPort) {
        ServerSocket ssocket = null;
        try {
            ssocket = new ServerSocket(aPort);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ssocket != null) {
                    ssocket.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateInternalURI(String aProtocol, int aDefaultPort, boolean cacheURL, boolean oneTry) throws Exception {
        boolean success = false;
        int openPort = aDefaultPort;
        ServerSocket ssocket = null;
        while (!success) {
            try {
                ssocket = new ServerSocket(openPort);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "generateInternalURI", "jms_adapter_messages", "UIMAJMS_port_available__CONFIG", new Object[]{openPort});
                }
                StringBuilder stringBuilder = new StringBuilder().append(aProtocol).append("://");
                ssocket.getInetAddress();
                String uri = stringBuilder.append(InetAddress.getLocalHost().getCanonicalHostName()).append(":").append(openPort).toString();
                success = true;
                if (cacheURL) {
                    System.setProperty("BrokerURI", uri);
                }
                String string = uri;
                return string;
            }
            catch (BindException e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "generateInternalURI", "jms_adapter_messages", "UIMAJMS_port_not_available__CONFIG", new Object[]{openPort});
                }
                if (oneTry) {
                    System.out.println("Given port:" + openPort + " is not available for " + aProtocol);
                    throw e;
                }
                ++openPort;
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "generateInternalURI", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
                if (!oneTry) continue;
                throw e;
            }
            finally {
                try {
                    if (ssocket == null) continue;
                    ssocket.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object monitor = new Object();
        Object object = this.brokerInstanceMux;
        synchronized (object) {
            block14: {
                if (service != null) {
                    try {
                        if (this.tcpConnector != null) {
                            this.tcpConnector.stop();
                            System.out.println("Broker Connector:" + this.tcpConnector.getUri().toString() + " is stopped");
                        }
                        if (this.httpConnector != null) {
                            System.out.println("Broker Stopping HTTP Connector:" + this.httpConnector.getUri().toString());
                            this.httpConnector.stop();
                            System.out.println("Broker Connector:" + this.httpConnector.getUri().toString() + " is stopped");
                        }
                        service.getManagementContext().stop();
                        service.stop();
                        Broker broker = service.getBroker();
                        while (!broker.isStopped()) {
                            Object object2 = monitor;
                            synchronized (object2) {
                                try {
                                    monitor.wait(20L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        System.out.println("Broker is stopped");
                        broker = null;
                        service = null;
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block14;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent anEvent) {
        if (anEvent instanceof ContextClosedEvent) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "onApplicationEvent", "jms_adapter_messages", "UIMAJMS_container_terminated__INFO", new Object[]{((ContextClosedEvent)anEvent).getApplicationContext().getDisplayName()});
            }
            this.stop();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "onApplicationEvent", "jms_adapter_messages", "UIMAJMS_broker_stopped__INFO", new Object[]{this.brokerURI});
            }
        }
    }
}

