/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.validation.ValidationException;
import org.apache.uima.fit.validation.ValidationResult;
import org.apache.uima.fit.validation.ValidationSummary;
import org.apache.uima.fit.validation.Validator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public final class ManagedJCas
implements TestWatcher,
AfterTestExecutionCallback,
AfterAllCallback {
    private final ThreadLocal<JCas> casHolder;
    private final Set<JCas> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Validator defaultValidator = new Validator.Builder().build();
    private Validator validator = null;

    public ManagedJCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas();
                this.managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                return (JCas)Assertions.fail((String)"Unable to initialize managed JCas", (Throwable)e);
            }
        });
    }

    public ManagedJCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas((TypeSystemDescription)aTypeSystemDescription);
                this.managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                return (JCas)Assertions.fail((String)"Unable to initialize managed JCas", (Throwable)e);
            }
        });
    }

    public JCas get() {
        return this.casHolder.get();
    }

    public void afterAll(ExtensionContext aContext) throws Exception {
        this.casHolder.remove();
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        try {
            this.managedCases.forEach(this::assertValid);
            this.managedCases.forEach(JCas::reset);
        }
        finally {
            this.validator = null;
        }
    }

    public ManagedJCas skipValidation() {
        this.validator = new Validator.Builder().withoutAutoDetectedChecks().build();
        return this;
    }

    public ManagedJCas withoutDefaultValidator() {
        this.defaultValidator = new Validator.Builder().withoutAutoDetectedChecks().build();
        return this;
    }

    public ManagedJCas withDefaultValidator(Validator aValidator) {
        this.defaultValidator = aValidator;
        return this;
    }

    public ManagedJCas withValidator(Validator aValidator) {
        this.validator = aValidator;
        return this;
    }

    private Validator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        return this.defaultValidator;
    }

    private void assertValid(JCas aJCas) {
        Validator activeValidator = this.getValidator();
        if (this.getValidator() == null) {
            return;
        }
        try {
            ValidationSummary summary = activeValidator.check(aJCas);
            String messageBuffer = summary.getResults().stream().filter(r -> r.getSeverity().isEquallyOrMoreSevereThan(ValidationResult.Severity.ERROR)).map(r -> String.format("[%s] %s", r.getSource(), r.getMessage())).collect(Collectors.joining("\n"));
            if (messageBuffer.length() > 0) {
                Assertions.fail((String)messageBuffer);
            }
        }
        catch (ValidationException e) {
            Assertions.fail((String)"Unable to validate CAS", (Throwable)e);
        }
    }

    static {
        try {
            CasCreationUtils.createCas();
        }
        catch (Exception e) {
            Assertions.fail((String)"Unable to initialize UIMA");
        }
    }
}

