/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.tutorial.ex6;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.examples.tutorial.ex6.StringMapResource;
import org.apache.uima.fit.examples.tutorial.ex6.StringMapResource_impl;
import org.apache.uima.fit.examples.tutorial.ex6.UimaAcronymAnnotator;
import org.apache.uima.fit.examples.tutorial.type.Meeting;
import org.apache.uima.fit.examples.tutorial.type.UimaMeeting;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ExternalResourceDescription;

@TypeCapability(inputs={"org.apache.uima.tutorial.Meeting"}, outputs={"org.apache.uima.tutorial.UimaMeeting"})
public class UimaMeetingAnnotator
extends JCasAnnotator_ImplBase {
    static final String RES_UIMA_TERM_TABLE = "uimaTermTable";
    @ExternalResource(key="uimaTermTable")
    private StringMapResource uimaTermTable;

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String text = aJCas.getDocumentText();
        ArrayList<UimaMeeting> uimaMeetings = new ArrayList<UimaMeeting>();
        block0: for (Meeting meeting : JCasUtil.select((JCas)aJCas, Meeting.class)) {
            int begin = meeting.getBegin() - 50;
            int end = meeting.getEnd() + 50;
            if (begin < 0) {
                begin = 0;
            }
            if (end > text.length()) {
                end = text.length();
            }
            String window = text.substring(begin, end);
            StringTokenizer tokenizer = new StringTokenizer(window, " \t\n\r.<.>/?\";:[{]}\\|=+()!");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (this.uimaTermTable.get(token) == null) continue;
                UimaMeeting annot = new UimaMeeting(aJCas, meeting.getBegin(), meeting.getEnd());
                annot.setRoom(meeting.getRoom());
                annot.setDate(meeting.getDate());
                annot.setStartTime(meeting.getStartTime());
                annot.setEndTime(meeting.getEndTime());
                uimaMeetings.add(annot);
                continue block0;
            }
        }
        for (UimaMeeting uimaMeeting : uimaMeetings) {
            uimaMeeting.addToIndexes();
        }
    }

    public static void main(String[] args) throws Exception {
        File outputDirectory = new File("target/examples/tutorial/ex6/");
        outputDirectory.mkdirs();
        ExternalResourceDescription resource = ExternalResourceFactory.createExternalResourceDescription(StringMapResource_impl.class, (String)"file:org/apache/uima/fit/examples/tutorial/ex6/uimaAcronyms.txt", (Object[])new Object[0]);
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(UimaAcronymAnnotator.class, (Object[])new Object[]{"acronymTable", resource}), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(UimaMeetingAnnotator.class, (Object[])new Object[]{RES_UIMA_TERM_TABLE, resource}), new String[0]);
        AnalysisEngineDescription aggregate = builder.createAggregateDescription();
        aggregate.toXML((OutputStream)new FileOutputStream(new File(outputDirectory, "UimaMeetingDetectorTAE.xml")));
    }
}

