/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.tutorial.ex2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.examples.tutorial.type.RoomNumber;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;

@TypeCapability(outputs={"org.apache.uima.tutorial.RoomNumber", "org.apache.uima.tutorial.RoomNumber:building"})
public class RoomNumberAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="Patterns")
    private Pattern[] mPatterns;
    @ConfigurationParameter(name="Locations")
    private String[] mLocations;

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String docText = aJCas.getDocumentText();
        for (int i = 0; i < this.mPatterns.length; ++i) {
            Matcher matcher = this.mPatterns[i].matcher(docText);
            while (matcher.find()) {
                RoomNumber annotation = new RoomNumber(aJCas, matcher.start(), matcher.end());
                annotation.setBuilding(this.mLocations[i]);
                annotation.addToIndexes();
                this.getContext().getLogger().log(Level.FINEST, "Found: " + (Object)((Object)annotation));
            }
        }
    }
}

