/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.experiment.pos;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.ViewTextCopierAnnotator;
import org.apache.uima.fit.examples.experiment.pos.BaselineTagger;
import org.apache.uima.fit.examples.experiment.pos.Evaluator;
import org.apache.uima.fit.examples.experiment.pos.GoldTagger;
import org.apache.uima.fit.examples.experiment.pos.LineReader;
import org.apache.uima.fit.examples.experiment.pos.SentenceAndTokenCopier;
import org.apache.uima.fit.examples.experiment.pos.XmiWriter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;

public class RunExperiment {
    public static void main(String[] args) throws UIMAException, IOException {
        String samplePosFileName = new File("src/main/resources").exists() ? "src/main/resources/org/apache/uima/fit/examples/pos/sample-gold.txt" : "src/org/apache/uima/fit/examples/pos/sample-gold.txt";
        CollectionReader lineReader = CollectionReaderFactory.createReader(LineReader.class, (Object[])new Object[]{"inputFile", samplePosFileName});
        AggregateBuilder builder = new AggregateBuilder();
        AnalysisEngineDescription goldTagger = AnalysisEngineFactory.createEngineDescription(GoldTagger.class, (Object[])new Object[0]);
        builder.add(goldTagger, new String[0]);
        AnalysisEngineDescription textCopier = AnalysisEngineFactory.createEngineDescription(ViewTextCopierAnnotator.class, (Object[])new Object[]{"sourceViewName", "GOLD_VIEW", "destinationViewName", "SYSTEM_VIEW"});
        builder.add(textCopier, new String[0]);
        AnalysisEngineDescription sentenceAndTokenCopier = AnalysisEngineFactory.createEngineDescription(SentenceAndTokenCopier.class, (Object[])new Object[0]);
        builder.add(sentenceAndTokenCopier, new String[]{"VIEW1", "GOLD_VIEW", "VIEW2", "SYSTEM_VIEW"});
        AnalysisEngineDescription baselineTagger = AnalysisEngineFactory.createEngineDescription(BaselineTagger.class, (Object[])new Object[0]);
        builder.add(baselineTagger, new String[]{"_InitialView", "SYSTEM_VIEW"});
        AnalysisEngineDescription evaluator = AnalysisEngineFactory.createEngineDescription(Evaluator.class, (Object[])new Object[0]);
        builder.add(evaluator, new String[0]);
        AnalysisEngineDescription xWriter = AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"outputDirectory", "target/examples/pos/xmi"});
        builder.add(xWriter, new String[0]);
        SimplePipeline.runPipeline((CollectionReader)lineReader, (AnalysisEngine[])new AnalysisEngine[]{builder.createAggregate()});
    }
}

