/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.cpe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.xml.sax.SAXException;

public final class CpePipeline {
    private CpePipeline() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(CollectionReaderDescription readerDesc, AnalysisEngineDescription ... descs) throws UIMAException, SAXException, CpeDescriptorException, IOException {
        AnalysisEngineDescription aaeDesc = AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])descs);
        CpeBuilder builder = new CpeBuilder();
        builder.setReader(readerDesc);
        builder.setAnalysisEngine(aaeDesc);
        StatusCallbackListenerImpl status = new StatusCallbackListenerImpl();
        CollectionProcessingEngine engine = builder.createCpe(status);
        engine.process();
        try {
            StatusCallbackListenerImpl statusCallbackListenerImpl = status;
            synchronized (statusCallbackListenerImpl) {
                while (status.isProcessing) {
                    status.wait();
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (status.exceptions.size() > 0) {
            throw new AnalysisEngineProcessException((Throwable)status.exceptions.get(0));
        }
    }

    private static class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        private final List<Exception> exceptions = new ArrayList<Exception>();
        private boolean isProcessing = true;

        private StatusCallbackListenerImpl() {
        }

        public void entityProcessComplete(CAS arg0, EntityProcessStatus arg1) {
            if (arg1.isException()) {
                for (Exception e : arg1.getExceptions()) {
                    this.exceptions.add(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aborted() {
            StatusCallbackListenerImpl statusCallbackListenerImpl = this;
            synchronized (statusCallbackListenerImpl) {
                if (this.isProcessing) {
                    this.isProcessing = false;
                    this.notify();
                }
            }
        }

        public void batchProcessComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void collectionProcessComplete() {
            StatusCallbackListenerImpl statusCallbackListenerImpl = this;
            synchronized (statusCallbackListenerImpl) {
                if (this.isProcessing) {
                    this.isProcessing = false;
                    this.notify();
                }
            }
        }

        public void initializationComplete() {
        }

        public void paused() {
        }

        public void resumed() {
        }
    }
}

