/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.sort;

import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class JobDetailsProcesses
implements Comparable<JobDetailsProcesses> {
    private IDuccProcess _process = null;

    public JobDetailsProcesses(IDuccProcess process) {
        this._process = process;
    }

    public IDuccProcess getProcess() {
        return this._process;
    }

    private boolean isRunning() {
        boolean retVal = false;
        try {
            IProcessState.ProcessState processState = this.getProcess().getProcessState();
            switch (processState) {
                case Running: {
                    retVal = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private boolean isInitializing() {
        boolean retVal = false;
        try {
            IProcessState.ProcessState processState = this.getProcess().getProcessState();
            switch (processState) {
                case Initializing: {
                    retVal = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private boolean isStarting() {
        boolean retVal = false;
        try {
            IProcessState.ProcessState processState = this.getProcess().getProcessState();
            switch (processState) {
                case Starting: 
                case Started: {
                    retVal = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private boolean isStopping() {
        boolean retVal = false;
        try {
            IProcessState.ProcessState processState = this.getProcess().getProcessState();
            switch (processState) {
                case Stopping: {
                    retVal = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private boolean isFailed() {
        boolean retVal = true;
        try {
            IDuccProcess process = this.getProcess();
            String agentReason = process.getReasonForStoppingProcess();
            if (agentReason.equalsIgnoreCase(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString())) {
                retVal = false;
            } else if (agentReason.equalsIgnoreCase(IDuccProcess.ReasonForStoppingProcess.Other.toString())) {
                retVal = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private long workItemErrors() {
        long retVal = 0L;
        try {
            retVal = this.getProcess().getProcessWorkItems().getCountError();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private long workItemDone() {
        long retVal = 0L;
        try {
            retVal = this.getProcess().getProcessWorkItems().getCountDone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public int compareTo(JobDetailsProcesses jdp) {
        int retVal = 0;
        try {
            JobDetailsProcesses j1 = this;
            JobDetailsProcesses j2 = jdp;
            IDuccProcess p1 = j1.getProcess();
            IDuccProcess p2 = j2.getProcess();
            long f1 = p1.getDuccId().getFriendly();
            long f2 = p2.getDuccId().getFriendly();
            if (f1 != f2) {
                if (!j1.isRunning() && j2.isRunning()) {
                    retVal = 1;
                } else if (j1.isRunning() && !j2.isRunning()) {
                    retVal = -1;
                } else if (!j1.isInitializing() && j2.isInitializing()) {
                    retVal = 1;
                } else if (j1.isInitializing() && !j2.isInitializing()) {
                    retVal = -1;
                } else if (!j1.isStarting() && j2.isStarting()) {
                    retVal = 1;
                } else if (j1.isStarting() && !j2.isStarting()) {
                    retVal = -1;
                } else if (!j1.isStopping() && j2.isStopping()) {
                    retVal = 1;
                } else if (j1.isStopping() && !j2.isStopping()) {
                    retVal = -1;
                } else if (!j1.isFailed() && j2.isFailed()) {
                    retVal = 1;
                } else if (j1.isFailed() && !j2.isFailed()) {
                    retVal = -1;
                } else if (j1.workItemErrors() < j2.workItemErrors()) {
                    retVal = 1;
                } else if (j1.workItemErrors() > j2.workItemErrors()) {
                    retVal = -1;
                } else if (j1.workItemDone() < j2.workItemDone()) {
                    retVal = 1;
                } else if (j1.workItemDone() > j2.workItemDone()) {
                    retVal = -1;
                } else if (f1 > f2) {
                    retVal = -1;
                } else if (f1 < f2) {
                    retVal = 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean equals(Object object) {
        boolean retVal = false;
        if (object != null) {
            try {
                JobDetailsProcesses j1 = this;
                JobDetailsProcesses j2 = (JobDetailsProcesses)object;
                IDuccProcess p1 = j1.getProcess();
                IDuccProcess p2 = j2.getProcess();
                String s1 = p1.getDuccId().toString();
                String s2 = p2.getDuccId().toString();
                retVal = s1.equals(s2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retVal;
    }

    public int hashCode() {
        JobDetailsProcesses j1 = this;
        IDuccProcess p1 = j1.getProcess();
        String s1 = p1.getDuccId().toString();
        return s1.hashCode();
    }
}

