/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.ws.DuccBoot;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.PagingInfo;
import org.apache.uima.ducc.ws.PagingObserver;
import org.apache.uima.ducc.ws.ReservationInfo;

public class DuccData {
    private static DuccLogger logger = DuccLogger.getLogger(DuccData.class);
    private static DuccId jobid = null;
    private static IDuccWorkMap duccWorkMap = new DuccWorkMap();
    private static IDuccWorkMap duccWorkLive = new DuccWorkMap();
    private static ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<DuccId, JobInfo> keyMapJobs = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<ReservationInfo, ReservationInfo> sortedReservations = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<DuccId, ReservationInfo> keyMapReservations = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<JobInfo, JobInfo> sortedServices = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<DuccId, JobInfo> keyMapServices = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<DuccId, Info> keyMapCombinedReservations = new ConcurrentSkipListMap();
    private static PagingObserver pagingObserver = PagingObserver.getInstance();
    private static DuccData duccData = new DuccData();
    private static long slack = 100L;
    private volatile String published = null;
    private IHistoryPersistenceManager hpm = HistoryFactory.getInstance((String)this.getClass().getName());
    private boolean merge = false;

    public static DuccData getInstance() {
        return duccData;
    }

    public boolean isPublished() {
        return this.published != null;
    }

    public void setPublished() {
        this.published = TimeStamp.getCurrentMillis();
    }

    public String getPublished() {
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfNotPresent(IDuccWork duccWork) {
        DuccData duccData = this;
        synchronized (duccData) {
            DuccId duccId = duccWork.getDuccId();
            if (duccWorkMap.findDuccWork(duccId) == null) {
                duccWorkMap.addDuccWork(duccWork);
                this.updateSortedMaps(duccWork);
            }
        }
    }

    private void mergeHistory(IDuccWorkMap map) {
        String methodName = "mergeHistory";
        if (this.merge) {
            for (DuccId duccId : duccWorkLive.keySet()) {
                IDuccWork duccWork = duccWorkLive.findDuccWork(duccId);
                IDuccWorkJob history = null;
                try {
                    switch (duccWork.getDuccType()) {
                        case Job: {
                            history = this.hpm.restoreJob(duccId.getFriendly());
                            break;
                        }
                        case Reservation: {
                            history = this.hpm.restoreReservation(duccId.getFriendly());
                            break;
                        }
                        case Service: {
                            history = this.hpm.restoreService(duccId.getFriendly());
                            break;
                        }
                    }
                    if (history == null) continue;
                    map.put((Object)duccId, (Object)history);
                }
                catch (Exception e) {
                    logger.warn(methodName, duccId, new Object[]{"Cannot recover", duccWork.getDuccType(), "from history."});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IDuccWorkMap map) {
        String location = "put";
        DuccData duccData = this;
        synchronized (duccData) {
            IDuccWorkMap mapCopy = map.deepCopy();
            this.mergeHistory(map);
            duccWorkLive = mapCopy;
            for (DuccId duccId : map.keySet()) {
                IDuccWork duccWork = map.findDuccWork(duccId);
                duccWorkMap.addDuccWork(duccWork);
                this.updateSortedMaps(duccWork);
                pagingObserver.put(duccWork);
                long dataTotal = 0L;
                long diffTotal = 0L;
                PagingInfo pi = pagingObserver.getData(duccId);
                if (pi != null) {
                    dataTotal = pi.total;
                }
                if ((pi = pagingObserver.getDiff(duccId)) != null) {
                    diffTotal = pi.total;
                }
                logger.debug(location, duccId, new Object[]{"dataTotal:" + dataTotal + " diffTotal:" + diffTotal});
            }
        }
        this.prune();
        this.setPublished();
    }

    private int pruneJobs() {
        String location = "pruneJobs";
        int pruned = 0;
        if ((long)sortedJobs.size() > DuccBoot.maxJobs + slack) {
            int count = 0;
            for (JobInfo jobInfo : sortedJobs.keySet()) {
                if (jobInfo.isOperational() || (long)(++count) <= DuccBoot.maxJobs) continue;
                DuccId duccId = jobInfo.getJob().getDuccId();
                sortedJobs.remove(jobInfo);
                keyMapJobs.remove(duccId);
                pagingObserver.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + sortedJobs.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneReservations() {
        String location = "pruneReservations";
        int pruned = 0;
        if ((long)sortedReservations.size() > DuccBoot.maxReservations + slack) {
            int count = 0;
            for (ReservationInfo reservationInfo : sortedReservations.keySet()) {
                if (reservationInfo.isOperational() || (long)(++count) <= DuccBoot.maxReservations) continue;
                DuccId duccId = reservationInfo.getReservation().getDuccId();
                sortedReservations.remove(reservationInfo);
                keyMapReservations.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + sortedReservations.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneServices() {
        String location = "pruneServices";
        int pruned = 0;
        if ((long)sortedServices.size() > DuccBoot.maxServices + slack) {
            int count = 0;
            for (JobInfo jobInfo : sortedServices.keySet()) {
                if (jobInfo.isOperational() || (long)(++count) <= DuccBoot.maxServices) continue;
                DuccId duccId = jobInfo.getJob().getDuccId();
                sortedServices.remove(jobInfo);
                keyMapServices.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + sortedServices.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneCombinedReservations() {
        String location = "pruneCombinedReservations";
        int pruned = 0;
        if ((long)sortedCombinedReservations.size() > DuccBoot.maxReservations + slack) {
            int count = 0;
            for (Info info : sortedCombinedReservations.keySet()) {
                if (info.isOperational() || (long)(++count) <= DuccBoot.maxReservations) continue;
                DuccId duccId = info.getDuccWork().getDuccId();
                sortedCombinedReservations.remove(info);
                keyMapCombinedReservations.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + sortedCombinedReservations.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    public void report() {
        String location = "report";
        int jc = sortedJobs.size();
        int rc = sortedReservations.size();
        int sc = sortedServices.size();
        int cc = sortedCombinedReservations.size();
        logger.info(location, jobid, new Object[]{"" + jc + ":" + rc + ":" + sc + ":" + cc});
    }

    private void prune() {
        String location = "prune";
        int jc = this.pruneJobs();
        int rc = this.pruneReservations();
        int sc = this.pruneServices();
        int cc = this.pruneCombinedReservations();
        logger.debug(location, jobid, new Object[]{"" + jc + ":" + rc + ":" + sc + ":" + cc});
    }

    public IDuccWorkMap get() {
        return duccWorkMap;
    }

    public IDuccWorkMap getLive() {
        return duccWorkLive;
    }

    public int getJobDriverNodes() {
        String location = "getJobDriverNodes";
        int retVal = 0;
        try {
            retVal = duccWorkLive.getJobCount();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void updateJobs(IDuccWork duccWork) {
        String location = "updateJobs";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkJob job = (DuccWorkJob)duccWork;
        if (keyMapJobs.containsKey(duccId)) {
            sortedJobs.remove(keyMapJobs.get(duccId));
            keyMapJobs.remove(duccId);
        }
        JobInfo jobInfo = new JobInfo(job);
        sortedJobs.put(jobInfo, jobInfo);
        if (!duccWork.isCompleted()) {
            keyMapJobs.put(duccId, jobInfo);
            logger.debug(location, duccId, new Object[]{"put job"});
        }
    }

    private void updateReservations(IDuccWork duccWork) {
        String location = "updateReservations";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkReservation reservation = (DuccWorkReservation)duccWork;
        if (keyMapReservations.containsKey(duccId)) {
            sortedReservations.remove(keyMapReservations.get(duccId));
            keyMapReservations.remove(duccId);
        }
        ReservationInfo reservationInfo = new ReservationInfo(reservation);
        sortedReservations.put(reservationInfo, reservationInfo);
        if (!duccWork.isCompleted()) {
            keyMapReservations.put(duccId, reservationInfo);
            logger.debug(location, duccId, new Object[]{"put reservation"});
        }
        if (keyMapCombinedReservations.containsKey(duccId)) {
            sortedCombinedReservations.remove(keyMapCombinedReservations.get(duccId));
            keyMapCombinedReservations.remove(duccId);
        }
        Info rInfo = new Info(reservation);
        sortedCombinedReservations.put(rInfo, rInfo);
        if (!duccWork.isCompleted()) {
            keyMapCombinedReservations.put(duccId, rInfo);
            logger.debug(location, duccId, new Object[]{"put combined"});
        }
    }

    private void updateServices(IDuccWork duccWork) {
        IDuccWorkService.ServiceDeploymentType sdt;
        String location = "updateServices";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkJob service = (DuccWorkJob)duccWork;
        if (keyMapServices.containsKey(duccId)) {
            sortedServices.remove(keyMapServices.get(duccId));
            keyMapServices.remove(duccId);
        }
        JobInfo serviceInfo = new JobInfo(service);
        sortedServices.put(serviceInfo, serviceInfo);
        if (!duccWork.isCompleted()) {
            keyMapServices.put(duccId, serviceInfo);
            logger.debug(location, duccId, new Object[]{"put service"});
        }
        if ((sdt = service.getServiceDeploymentType()) != null) {
            switch (sdt) {
                case other: {
                    if (keyMapCombinedReservations.containsKey(duccId)) {
                        sortedCombinedReservations.remove(keyMapCombinedReservations.get(duccId));
                        keyMapCombinedReservations.remove(duccId);
                    }
                    Info sInfo = new Info(service);
                    sortedCombinedReservations.put(sInfo, sInfo);
                    if (duccWork.isCompleted()) break;
                    keyMapCombinedReservations.put(duccId, sInfo);
                    logger.debug(location, duccId, new Object[]{"put combined"});
                    break;
                }
            }
        }
    }

    private void updateSortedMaps(IDuccWork duccWork) {
        IDuccTypes.DuccType duccType;
        if (duccWork != null && (duccType = duccWork.getDuccType()) != null) {
            switch (duccWork.getDuccType()) {
                case Job: {
                    this.updateJobs(duccWork);
                    break;
                }
                case Reservation: {
                    this.updateReservations(duccWork);
                    break;
                }
                case Service: {
                    this.updateServices(duccWork);
                    break;
                }
            }
        }
    }

    public IDuccWorkJob getJob(DuccId duccId) {
        DuccWorkJob retVal = null;
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = this.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                if (job.getDuccId().getFriendly() != duccId.getFriendly()) continue;
                retVal = job;
                break;
            }
        }
        return retVal;
    }

    public IDuccWork getReservation(DuccId duccId) {
        IDuccWork retVal = null;
        ConcurrentSkipListMap<Info, Info> sortedReservations = this.getSortedCombinedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<Info, Info>> iterator = sortedReservations.entrySet().iterator();
            while (iterator.hasNext()) {
                Info info = iterator.next().getValue();
                IDuccWork dw = info.getDuccWork();
                if (dw.getDuccId().getFriendly() != duccId.getFriendly()) continue;
                retVal = dw;
                break;
            }
        }
        return retVal;
    }

    private boolean isEqual(DuccId duccId, String id) {
        boolean retVal = false;
        if (duccId != null) {
            String v2;
            String v1 = duccId.getFriendly() + "";
            if (id != null && v1.equalsIgnoreCase(v2 = id)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public IDuccWork getReservation(String id) {
        IDuccWork retVal = null;
        ConcurrentSkipListMap<Info, Info> sortedReservations = this.getSortedCombinedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<Info, Info>> iterator = sortedReservations.entrySet().iterator();
            while (iterator.hasNext()) {
                Info info = iterator.next().getValue();
                IDuccWork dw = info.getDuccWork();
                if (!this.isEqual(dw.getDuccId(), id)) continue;
                retVal = dw;
                break;
            }
        }
        return retVal;
    }

    public ConcurrentSkipListMap<JobInfo, JobInfo> getSortedJobs() {
        return sortedJobs;
    }

    public ConcurrentSkipListMap<ReservationInfo, ReservationInfo> getSortedReservations() {
        return sortedReservations;
    }

    public ConcurrentSkipListMap<JobInfo, JobInfo> getSortedServices() {
        return sortedServices;
    }

    public ConcurrentSkipListMap<Info, Info> getSortedCombinedReservations() {
        return sortedCombinedReservations;
    }

    public boolean isLive(DuccId duccId) {
        return duccWorkLive.containsKey((Object)duccId);
    }
}

