/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;

public class Distiller {
    private static DuccLogger logger = DuccLogger.getLogger(Distiller.class);
    private static DuccId jobid = null;
    private static volatile Map<String, Long> map = new HashMap<String, Long>();

    public static Map<String, Long> getMap() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        retVal.putAll(map);
        return retVal;
    }

    public static Map<String, Long> deriveMachineMemoryInUse(OrchestratorStateDuccEvent duccEvent) {
        String location = "getMachineMemoryInUse";
        HashMap<String, Long> revisedMap = new HashMap<String, Long>();
        try {
            IDuccWorkMap dwm;
            if (duccEvent != null && (dwm = duccEvent.getWorkMap()) != null) {
                Distiller.jobs(revisedMap, dwm);
                Distiller.reservations(revisedMap, dwm);
                Distiller.managedReservations(revisedMap, dwm);
                Distiller.services(revisedMap, dwm);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        map = revisedMap;
        return map;
    }

    private static void jobs(Map<String, Long> map, IDuccWorkMap dwm) {
        String location = "jobs";
        try {
            if (map != null && dwm != null) {
                Set keys = dwm.getJobKeySet();
                for (DuccId key : keys) {
                    IDuccWork dw = dwm.findDuccWork(key);
                    IDuccWorkJob dwj = (IDuccWorkJob)dw;
                    if (dwj == null || !dwj.isOperational()) continue;
                    long bytes = dwj.getSchedulingInfo().getMemorySizeAllocatedInBytes();
                    IDuccProcessMap processMap = dwj.getProcessMap();
                    if (processMap == null) continue;
                    for (IDuccProcess process : processMap.values()) {
                        String name;
                        NodeIdentity ni;
                        if (process.isDeallocated() || (ni = process.getNodeIdentity()) == null || (name = ni.getName()) == null) continue;
                        Distiller.add(map, name, bytes);
                        SizeBytes sb = new SizeBytes(SizeBytes.Type.Bytes, bytes);
                        String text = location + ": " + name + "=" + sb.getGBytes();
                        logger.trace(location, dw.getDuccId(), new Object[]{text});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void reservations(Map<String, Long> map, IDuccWorkMap dwm) {
        String location = "reservations";
        try {
            if (map != null && dwm != null) {
                Set keys = dwm.getReservationKeySet();
                for (DuccId key : keys) {
                    IDuccWork dw = dwm.findDuccWork(key);
                    IDuccWorkReservation dwr = (IDuccWorkReservation)dw;
                    if (dwr == null || !dwr.isOperational()) continue;
                    IDuccReservationMap reservationMap = dwr.getReservationMap();
                    for (IDuccReservation reservation : reservationMap.values()) {
                        String name;
                        NodeIdentity ni = reservation.getNodeIdentity();
                        if (ni == null || (name = ni.getName()) == null) continue;
                        SizeBytes sb = new SizeBytes(SizeBytes.Type.Bytes, dw.getSchedulingInfo().getMemorySizeAllocatedInBytes());
                        long bytes = sb.getBytes();
                        Distiller.add(map, name, bytes);
                        String text = location + ": " + name + "=" + sb.getGBytes();
                        logger.trace(location, dw.getDuccId(), new Object[]{text});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void managedReservations(Map<String, Long> map, IDuccWorkMap dwm) {
    }

    private static void services(Map<String, Long> map, IDuccWorkMap dwm) {
        String location = "services";
        try {
            if (map != null && dwm != null) {
                Set keys = dwm.getServiceKeySet();
                for (DuccId key : keys) {
                    IDuccWork dw = dwm.findDuccWork(key);
                    IDuccWorkJob dws = (IDuccWorkJob)dw;
                    if (dws == null || !dws.isOperational()) continue;
                    long bytes = dws.getSchedulingInfo().getMemorySizeAllocatedInBytes();
                    IDuccProcessMap processMap = dws.getProcessMap();
                    if (processMap == null) continue;
                    for (IDuccProcess process : processMap.values()) {
                        String name;
                        NodeIdentity ni;
                        if (process.isDeallocated() || (ni = process.getNodeIdentity()) == null || (name = ni.getName()) == null) continue;
                        Distiller.add(map, name, bytes);
                        SizeBytes sb = new SizeBytes(SizeBytes.Type.Bytes, bytes);
                        String text = location + ": " + name + "=" + sb.getGBytes();
                        logger.trace(location, dw.getDuccId(), new Object[]{text});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void add(Map<String, Long> map, String name, long bytes) {
        Long value = new Long(0L);
        if (!map.containsKey(name)) {
            map.put(name, value);
        }
        value = map.get(name) + bytes;
        map.put(name, value);
    }
}

