/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.Map;
import org.apache.uima.ducc.common.ConvertSafely;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.DuccMachinesDataHelper;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.types.NodeId;

public class Helper {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)Helper.class.getName());
    private static DuccId jobid = null;

    public static SizeBytes getSummaryReserve() {
        String methodName = "getSummaryReserve";
        long sumReserve = 0L;
        DuccMachinesData instance = DuccMachinesData.getInstance();
        Map<MachineInfo, NodeId> machines = instance.getMachines();
        if (!machines.isEmpty()) {
            for (Map.Entry<MachineInfo, NodeId> entry : machines.entrySet()) {
                MachineInfo machineInfo = entry.getKey();
                if (!DuccMachinesDataHelper.isUp(machineInfo)) continue;
                try {
                    sumReserve += ConvertSafely.String2Long((String)machineInfo.getMemReserve());
                }
                catch (Exception e) {
                    duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
                }
            }
        }
        SizeBytes retVal = new SizeBytes(SizeBytes.Type.GBytes, sumReserve);
        return retVal;
    }
}

