/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DaemonDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.DuccJobsStateEvent;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.PmStateDuccEvent;
import org.apache.uima.ducc.transport.event.RmStateDuccEvent;
import org.apache.uima.ducc.transport.event.SmStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.ws.Distiller;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.DuccPlugins;
import org.apache.uima.ducc.ws.IWebServer;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.self.message.WebServerStateDuccEvent;
import org.apache.uima.ducc.ws.server.DuccListeners;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.utils.DatedNodeMetricsUpdateDuccEvent;

public class WebServerComponent
extends AbstractDuccComponent
implements IWebServer {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)WebServerComponent.class.getName());
    private static DuccId jobid = null;
    private DuccWebServer duccWebServer = null;
    private Messages duccMsg = Messages.getInstance();
    private static AtomicInteger jobCount = new AtomicInteger(0);
    private static AtomicInteger serviceCount = new AtomicInteger(0);
    private static AtomicInteger reservationCount = new AtomicInteger(0);
    private static AtomicLong updateLast = new AtomicLong(System.currentTimeMillis());
    public static long updateIntervalSecondsInitial = 5L;
    public static long updateIntervalSecondsNormal = 60L;
    public static AtomicLong updateIntervalCount = new AtomicLong(0L);
    public static long updateIntervalLimit = 12L;
    private DuccEventDispatcher eventDispatcher;
    private String stateChangeEndpoint;

    public WebServerComponent(CamelContext context, CommonConfiguration common) {
        super("WebServer", context);
        String[] propertyNames;
        String methodName = "WebServerComponent";
        duccLogger.info(methodName, jobid, new Object[]{"##### boot #####"});
        String cp = System.getProperty("java.class.path");
        String[] cpArray = cp.split(":");
        int lc = 0;
        for (String line : cpArray) {
            duccLogger.trace(methodName, jobid, new Object[]{"cp." + lc + " " + line});
            ++lc;
        }
        for (String property : propertyNames = new String[]{"ducc.broker.url"}) {
            duccLogger.info(methodName, jobid, new Object[]{property + "=" + System.getProperty(property)});
        }
        duccLogger.info(methodName, jobid, new Object[]{System.getProperty("ducc.broker.url")});
        this.duccWebServer = new DuccWebServer(common);
        this.init();
    }

    private void stateChange(DuccEvent.EventType eventType) {
        String methodName = "stateChange";
        try {
            IDuccLoggerComponents.Daemon daemon = IDuccLoggerComponents.Daemon.WebServer;
            NodeIdentity nodeIdentity = new NodeIdentity();
            DaemonDuccEvent ev = new DaemonDuccEvent(daemon, eventType, nodeIdentity);
            this.eventDispatcher.dispatch(this.stateChangeEndpoint, (DuccEvent)ev, "");
            duccLogger.info(methodName, null, new Object[]{this.stateChangeEndpoint, eventType.name(), nodeIdentity.getName()});
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    public void start(DuccService service, String[] args) throws Exception {
        super.start(service, args);
        DuccDaemonRuntimeProperties.getInstance().boot(DuccDaemonRuntimeProperties.DaemonName.Webserver, this.getProcessJmxUrl());
        this.stateChange(DuccEvent.EventType.BOOT);
    }

    public void stop() throws Exception {
        this.stateChange(DuccEvent.EventType.SHUTDOWN);
        super.stop();
    }

    public void setDuccEventDispatcher(DuccEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void setstateChangeEndpoint(String stateChangeEndpoint) {
        this.stateChangeEndpoint = stateChangeEndpoint;
    }

    public DuccLogger getLogger() {
        return duccLogger;
    }

    public void webServerStart() {
        String methodName = "webServerStart";
        try {
            this.duccWebServer.start();
            duccLogger.info(methodName, jobid, new Object[]{"webserver started"});
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    public void webServerStop() {
        String methodName = "webServerStop";
        try {
            this.duccWebServer.stop();
            duccLogger.info(methodName, jobid, new Object[]{"webserver stopped"});
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void init() {
        String methodName = "init";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        File file = new File(IDuccEnv.DUCC_LOGS_WEBSERVER_DIR);
        file.mkdirs();
        this.webServerStart();
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(OrchestratorStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "OrchestratorStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        IDuccWorkMap wm = duccEvent.getWorkMap();
        boolean change = false;
        int count = wm.getJobCount();
        if (count != jobCount.get()) {
            jobCount.set(count);
            change = true;
        }
        if ((count = wm.getReservationCount()) != reservationCount.get()) {
            reservationCount.set(count);
            change = true;
        }
        if ((count = wm.getServiceCount()) != serviceCount.get()) {
            serviceCount.set(count);
            change = true;
        }
        if (change) {
            duccLogger.info(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("jobs") + jobCount.get() + " " + this.duccMsg.fetchLabel("reservations") + reservationCount.get() + " " + this.duccMsg.fetchLabel("services") + serviceCount.get()});
        }
        DuccData.getInstance().put(wm);
        DuccPlugins.getInstance().update(wm);
        DuccListeners.getInstance().update(duccEvent);
        Map<String, Long> map = Distiller.deriveMachineMemoryInUse(duccEvent);
        this.report(map);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    private void report(Map<String, Long> map) {
        String location = "report";
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            duccLogger.trace(location, jobid, new Object[]{entry.getKey() + "=" + entry.getValue()});
        }
    }

    private void sortMachines() {
        String methodName = "sortMachines";
        long last = updateLast.get();
        long updateIntervalMilliSeconds = updateIntervalSecondsNormal * 1000L;
        if (updateIntervalCount.get() < updateIntervalLimit) {
            updateIntervalMilliSeconds = updateIntervalSecondsInitial * 1000L;
        }
        long deadline = last + updateIntervalMilliSeconds;
        long now = System.currentTimeMillis();
        if (now > deadline) {
            boolean success = updateLast.compareAndSet(last, now);
            if (success) {
                DuccMachinesData.getInstance().updateSortedMachines();
                updateIntervalCount.incrementAndGet();
                duccLogger.trace(methodName, jobid, new Object[]{"count: " + updateIntervalCount.get()});
            } else {
                duccLogger.trace(methodName, jobid, new Object[]{"missed: last=" + last + " " + "now=" + now});
            }
        } else {
            duccLogger.trace(methodName, jobid, new Object[]{"togo: " + (deadline - now) / 1000L});
        }
    }

    @Override
    public void update(NodeMetricsUpdateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "NodeMetricsUpdateDuccEvent"});
        DuccMachinesData dmd = DuccMachinesData.getInstance();
        DatedNodeMetricsUpdateDuccEvent datedEvent = new DatedNodeMetricsUpdateDuccEvent(duccEvent);
        dmd.put(datedEvent);
        this.sortMachines();
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(RmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "RmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(SmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "SmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        ServicesRegistry.getInstance().update();
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(DuccJobsStateEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "DuccJobsStateEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(PmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "PmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(WebServerStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "WebServerStateDuccEvent (broker is alive)"});
        DuccDaemonsData.getInstance().put(duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }
}

