/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.HashSet;
import java.util.List;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccPlugins;

public class DuccBoot
extends Thread {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccBoot.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccPlugins duccPlugins = DuccPlugins.getInstance();
    private static DuccId jobid = null;
    public static long maxJobs = 4096L;
    public static long maxReservations = 4096L;
    public static long maxServices = 4096L;
    private HashSet<String> experimentsFound;

    public static void boot(CommonConfiguration commonConfiguration) {
        DuccBoot duccBoot = new DuccBoot();
        duccBoot.initialize(commonConfiguration);
        duccBoot.start();
    }

    @Override
    public void run() {
        String location = "run";
        try {
            logger.info(location, jobid, new Object[]{"booting..."});
            this.restore();
            logger.info(location, jobid, new Object[]{"ready."});
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    private static long getLimit() {
        long limit = 0L;
        try {
            String p_limit = DuccPropertiesResolver.getInstance().getProperty("ducc.ws.max.history.entries");
            if (p_limit != null && !(p_limit = p_limit.trim()).equals("unlimited")) {
                limit = Long.parseLong(p_limit);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return limit;
    }

    private void restoreReservations(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreReservations";
        List duccWorkReservations = null;
        try {
            duccWorkReservations = hpm.restoreReservations(maxReservations);
        }
        catch (Exception e) {
            logger.warn(location, null, (Throwable)e, new Object[0]);
            return;
        }
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of Reservations fetched from history"), duccWorkReservations.size()});
        int restored = 0;
        int nExperiments = 0;
        for (IDuccWorkReservation duccWorkReservation : duccWorkReservations) {
            try {
                logger.debug(location, duccWorkReservation.getDuccId(), new Object[]{messages.fetchLabel("restore")});
                duccData.putIfNotPresent((IDuccWork)duccWorkReservation);
                String directory = duccWorkReservation.getStandardInfo().getLogDirectory();
                if (this.experimentsFound.add(directory)) {
                    duccPlugins.restore(duccWorkReservation);
                    ++nExperiments;
                }
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, duccWorkReservation.getDuccId(), t, new Object[0]);
            }
        }
        logger.info(location, null, new Object[]{messages.fetch("Reservations restored: " + restored)});
        if (nExperiments > 0) {
            logger.info(location, null, new Object[]{messages.fetch("Experiments found: " + nExperiments)});
        }
    }

    private void restoreJobs(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreJobs";
        List duccWorkJobs = null;
        try {
            duccWorkJobs = hpm.restoreJobs(maxJobs);
        }
        catch (Exception e) {
            logger.warn(location, null, (Throwable)e, new Object[0]);
            return;
        }
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of Jobs fetched from history"), duccWorkJobs.size()});
        int restored = 0;
        int nExperiments = 0;
        for (IDuccWorkJob duccWorkJob : duccWorkJobs) {
            try {
                logger.debug(location, duccWorkJob.getDuccId(), new Object[]{messages.fetchLabel("restore")});
                duccData.putIfNotPresent((IDuccWork)duccWorkJob);
                String directory = duccWorkJob.getStandardInfo().getLogDirectory();
                if (this.experimentsFound.add(directory)) {
                    duccPlugins.restore(duccWorkJob);
                    ++nExperiments;
                }
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, duccWorkJob.getDuccId(), t, new Object[0]);
            }
        }
        logger.info(location, null, new Object[]{messages.fetch("Jobs restored: " + restored)});
        if (nExperiments > 0) {
            logger.info(location, null, new Object[]{messages.fetch("Experiments found: " + nExperiments)});
        }
    }

    private void restoreServices(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreServices";
        List duccWorkServices = null;
        try {
            duccWorkServices = hpm.restoreServices(maxServices);
        }
        catch (Exception e) {
            logger.warn(location, null, (Throwable)e, new Object[0]);
            return;
        }
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of services fetched from history"), duccWorkServices.size()});
        int restored = 0;
        int nExperiments = 0;
        for (IDuccWorkService duccWorkService : duccWorkServices) {
            try {
                logger.debug(location, duccWorkService.getDuccId(), new Object[]{messages.fetchLabel("restore")});
                duccData.putIfNotPresent((IDuccWork)duccWorkService);
                String directory = duccWorkService.getStandardInfo().getLogDirectory();
                if (this.experimentsFound.add(directory)) {
                    duccPlugins.restore(duccWorkService);
                    ++nExperiments;
                }
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, duccWorkService.getDuccId(), t, new Object[0]);
            }
        }
        logger.info(location, null, new Object[]{messages.fetch("Services restored: " + restored)});
        if (nExperiments > 0) {
            logger.info(location, null, new Object[]{messages.fetch("Experiments found: " + nExperiments)});
        }
    }

    private void initialize(CommonConfiguration commonConfiguration) {
        String location = "initialize";
        long limit = DuccBoot.getLimit();
        if (limit > 0L) {
            logger.info(location, jobid, new Object[]{messages.fetchLabel("max history limit") + limit});
            maxJobs = limit;
            maxReservations = limit;
            maxServices = limit;
        }
    }

    private void restore() {
        String location = "restore";
        logger.info(location, jobid, new Object[]{messages.fetchLabel("History directory") + IDuccEnv.DUCC_HISTORY_DIR});
        IHistoryPersistenceManager hpm = HistoryFactory.getInstance((String)this.getClass().getName());
        DuccData duccData = DuccData.getInstance();
        this.experimentsFound = new HashSet();
        this.restoreReservations(hpm, duccData);
        this.restoreJobs(hpm, duccData);
        this.restoreServices(hpm, duccData);
        this.experimentsFound = null;
        duccData.report();
    }
}

