/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.authentication.IAuthenticationManager;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.authentication.DuccAuthenticator;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebSessionManager;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.eclipse.jetty.server.Request;

public class DuccHandlerUserAuthentication
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerUserAuthentication.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    public final String userLogout = "/ducc-servlet/user-logout";
    public final String userLogin = "/ducc-servlet/user-login";
    public final String userAuthenticationStatus = "/ducc-servlet/user-authentication-status";
    private DuccAuthenticator duccAuthenticator = DuccAuthenticator.getInstance();
    private DuccWebSessionManager duccWebSessionManager = DuccWebSessionManager.getInstance();

    @Override
    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "isAuthenticated";
        boolean retVal = false;
        try {
            retVal = this.duccWebSessionManager.isAuthentic(request);
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void handleDuccServletAuthenticationStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletStatus";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        boolean userAuth = this.isAuthenticated(request, response);
        if (userAuth) {
            sb.append("<span class=\"status_on\">");
            sb.append("logged in");
            sb.append("<span>");
        } else {
            sb.append("<span class=\"status_off\">");
            sb.append("logged out");
            sb.append("<span>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletLogout(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletLogout";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        String userId = null;
        StringBuffer sb = new StringBuffer();
        try {
            userId = this.duccWebSessionManager.getUserId(request);
            boolean result = this.duccWebSessionManager.logout(request);
            if (result) {
                duccLogger.info(methodName, jobid, new Object[]{messages.fetch("logout ") + userId + " " + messages.fetch("success")});
                sb.append("success");
            } else {
                duccLogger.info(methodName, jobid, new Object[]{messages.fetch("logout ") + userId + " " + messages.fetch("failed")});
                sb.append("failure");
            }
        }
        catch (Throwable t) {
            sb.append("failure " + t.getMessage());
            duccLogger.error(methodName, jobid, new Object[]{"userid=" + userId});
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletLogin(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletLogin";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String userId = request.getParameter("userid");
        String password = request.getParameter("password");
        try {
            String ducc_runmode_pw;
            Properties properties = DuccWebProperties.get();
            String ducc_runmode = properties.getProperty("ducc.runmode", "Production");
            if (ducc_runmode.equalsIgnoreCase("Test") && (ducc_runmode_pw = properties.getProperty("ducc.runmode.pw", "")).length() > 0 && password != null && password.equals(ducc_runmode_pw)) {
                this.duccWebSessionManager.login(request, userId);
                sb.append("success");
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        if (sb.length() == 0) {
            try {
                if (userId == null || userId.trim().length() == 0) {
                    duccLogger.info(methodName, jobid, new Object[]{messages.fetch("login ") + userId + " " + messages.fetch("failed")});
                    sb.append("failure");
                } else if (this.duccAuthenticator.isPasswordChecked() && (password == null || password.trim().length() == 0)) {
                    duccLogger.info(methodName, jobid, new Object[]{messages.fetch("login ") + userId + " " + messages.fetch("failed")});
                    sb.append("failure");
                } else {
                    IAuthenticationManager.Role role = IAuthenticationManager.Role.User;
                    String domain = null;
                    if (userId != null && userId.contains("@")) {
                        String[] parts = userId.split("@", 2);
                        userId = parts[0];
                        domain = parts[1];
                    }
                    duccLogger.debug(methodName, jobid, new Object[]{messages.fetchLabel("version") + this.duccAuthenticator.getVersion()});
                    IAuthenticationResult result1 = this.duccAuthenticator.isAuthenticate(userId, domain, password);
                    IAuthenticationResult result2 = this.duccAuthenticator.isGroupMember(userId, domain, role);
                    duccLogger.debug(methodName, jobid, new Object[]{messages.fetch("login ") + userId + " " + "group reason: " + result2.getReason()});
                    if (result1.isSuccess() && result2.isSuccess()) {
                        this.duccWebSessionManager.login(request, userId);
                        duccLogger.info(methodName, jobid, new Object[]{messages.fetch("login ") + userId + " " + messages.fetch("success")});
                        sb.append("success");
                    } else {
                        IAuthenticationResult result = !result1.isSuccess() ? result1 : result2;
                        int code = result.getCode();
                        String reason = result.getReason();
                        Exception exception = result.getException();
                        StringBuffer text = new StringBuffer();
                        text.append("code:" + code);
                        if (reason != null) {
                            text.append(", reason:" + reason);
                        }
                        sb.append("failure " + text);
                        if (exception != null) {
                            text.append(", exception:" + exception);
                        }
                        duccLogger.info(methodName, jobid, new Object[]{messages.fetch("login ") + userId + " " + messages.fetch("failed") + " " + text});
                    }
                }
            }
            catch (Throwable t) {
                sb.append("failure " + t.getMessage());
                duccLogger.error(methodName, jobid, new Object[]{"userid=" + userId});
            }
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/user-authentication-status")) {
            this.handleDuccServletAuthenticationStatus(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/user-logout")) {
            duccLogger.info(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            this.handleDuccServletLogout(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/user-login")) {
            duccLogger.info(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            this.handleDuccServletLogin(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/user")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

