/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.ws.DuccDataHelper;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.JobProcessInfo;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccWebMonitor;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebSessionManager;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.apache.uima.ducc.ws.utils.HandlersHelper;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class DuccAbstractHandler
extends AbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccAbstractHandler.class.getName());
    private static Messages messages = Messages.getInstance();
    private DuccId jobid = null;
    public static DuccWebAdministrators duccWebAdministrators = DuccWebAdministrators.getInstance();
    public static DuccWebSessionManager duccWebSessionManager = DuccWebSessionManager.getInstance();
    public final String version110 = "1.1.0";
    public final String duccUimaInitializationReport = "uima-initialization-report.html";
    public final String duccContext = "/ducc-servlet";
    public final String duccLogData = "/ducc-servlet/log-data";
    public final String duccFilePager = "/file.pager.html";
    public final String duccJpInitSummary = "/ducc-servlet/uima-initialization-report-summary";
    public final String duccJpInitData = "/ducc-servlet/uima-initialization-report-data";
    public final String duccContextJsonFormat = "/ducc-servlet/json-format";
    public final String duccContextUser = "/ducc-servlet/user";
    public final String duccContextClassic = "/ducc-servlet/classic";
    public final String duccContextProxy = "/ducc-servlet/proxy";
    public final String duccContextViz = "/ducc-servlet/viz";
    public final String duccjConsoleLink = "/ducc-servlet/jconsole-link.jnlp";
    public final int maximumRecordsJobs = 4096;
    public final int defaultRecordsJobs = 16;
    public final int maximumRecordsReservations = 4096;
    public final int defaultRecordsReservations = 8;
    public final int maximumRecordsServices = 4096;
    public final int defaultRecordsServices = 12;
    public String dir_home = Utils.findDuccHome();
    public String dir_resources = "resources";
    protected boolean terminateEnabled = true;
    protected boolean buttonsEnabled = true;
    public static final String valueStateTypeAll = "all";
    public static final String valueStateTypeActive = "active";
    public static final String valueStateTypeInactive = "inactive";
    public static final String valueStateTypeDefault = "all";
    protected String root_dir = null;
    protected String jconsole_wrapper_signed_jar = null;
    protected DuccWebServer duccWebServer = null;
    public static final RequestStateType requestStateTypeDefault = RequestStateType.All;

    public void init(DuccWebServer duccWebServer) {
        this.duccWebServer = duccWebServer;
        this.root_dir = duccWebServer.getRootDir();
        this.jconsole_wrapper_signed_jar = this.root_dir + File.separator + "lib" + File.separator + "webstart" + File.separator + "jconsole-wrapper-signed.jar";
    }

    public DuccWebServer getDuccWebServer() {
        return this.duccWebServer;
    }

    public boolean isIgnorable(Throwable t) {
        boolean retVal = false;
        try {
            String rcm = ExceptionUtils.getMessage((Throwable)t).trim();
            if (rcm.endsWith("java.io.IOException: Broken pipe")) {
                retVal = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public String quote(String string) {
        return "\"" + string + "\"";
    }

    public String normalize(DuccId duccId) {
        return duccId.getFriendly() + "";
    }

    public String stringNormalize(String value, String defaultValue) {
        String methodName = "stringNormalize";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String retVal = value == null ? defaultValue : value;
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public String getShortDescription(String description) {
        int index;
        String retVal = null;
        if (description != null && (index = description.lastIndexOf(47)) > 0) {
            retVal = description.substring(index);
        }
        return retVal;
    }

    public String getTimeStamp(DuccCookies.DateStyle dateStyle, String date) {
        String location = "getTimeStamp";
        StringBuffer sb = new StringBuffer();
        if (date != null) {
            sb.append(date);
            if (date.trim().length() > 0) {
                try {
                    switch (dateStyle) {
                        case Long: {
                            break;
                        }
                        case Medium: {
                            String day = sb.substring(sb.length() - 4);
                            sb.delete(0, 5);
                            sb.delete(sb.lastIndexOf(":"), sb.length());
                            sb.append(day);
                            break;
                        }
                        case Short: {
                            sb.delete(0, 5);
                            sb.delete(sb.lastIndexOf(":"), sb.length());
                        }
                    }
                }
                catch (Exception e) {
                    duccLogger.error(location, this.jobid, new Object[]{dateStyle, date, e});
                }
            }
        }
        return sb.toString();
    }

    public String getDuration(DuccId jobId, String millisV2, String millisV1, FormatHelper.Precision precision) {
        String methodName = "getDuration";
        String retVal = "";
        try {
            long d2 = Long.parseLong(millisV2);
            long d1 = Long.parseLong(millisV1);
            long diff = d2 - d1;
            if (diff < 0L) {
                diff = 0L;
            }
            retVal = FormatHelper.duration(diff, precision);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public String getTimeStamp(HttpServletRequest request, DuccId jobId, String millis) {
        return this.getTimeStamp(DuccCookies.getDateStyle(request), this.getTimeStamp(jobId, millis));
    }

    private String getTimeStamp(DuccId jobId, String millis) {
        String methodName = "getTimeStamp";
        String retVal = "";
        try {
            retVal = TimeStamp.simpleFormat((String)millis);
        }
        catch (Throwable t) {
            duccLogger.debug(methodName, jobId, new Object[]{"millis:" + millis});
        }
        return retVal;
    }

    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "isAuthenticated";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        boolean authenticated = false;
        try {
            authenticated = duccWebSessionManager.isAuthentic(request);
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return authenticated;
    }

    protected boolean isAdministrator(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "isAdministrator";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        boolean administrator = false;
        try {
            DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
            switch (requestRole) {
                case Administrator: {
                    administrator = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return administrator;
    }

    public boolean isIncludeUser(List<String> users, String user) {
        boolean retVal = true;
        if (users != null && user != null && !users.isEmpty() && !user.contains(user)) {
            retVal = false;
        }
        return retVal;
    }

    private ArrayList<String> getUsers(String usersString) {
        ArrayList<String> userRecords = new ArrayList<String>();
        try {
            String[] users = usersString.split("\\s+");
            if (users != null) {
                for (String user : users) {
                    if ((user = user.trim()).length() <= 0 || userRecords.contains(user)) continue;
                    userRecords.add(user);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userRecords;
    }

    public ArrayList<String> getJobsUsers(HttpServletRequest request) {
        String cookie = DuccCookies.getCookie(request, "ducc:jobsusers");
        return this.getUsers(cookie);
    }

    public ArrayList<String> getReservationsUsers(HttpServletRequest request) {
        String cookie = DuccCookies.getCookie(request, "ducc:reservationsusers");
        return this.getUsers(cookie);
    }

    public ArrayList<String> getServicesUsers(HttpServletRequest request) {
        String cookie = DuccCookies.getCookie(request, "ducc:servicesusers");
        return this.getUsers(cookie);
    }

    public String getProcessMemorySize(DuccId id, String type, String size, IDuccUnits.MemoryUnits units) {
        String methodName = "getProcessMemorySize";
        String retVal = "?";
        double multiplier = 1.0;
        switch (units) {
            case KB: {
                multiplier = Math.pow(10.0, -6.0);
                break;
            }
            case MB: {
                multiplier = Math.pow(10.0, -3.0);
                break;
            }
            case GB: {
                multiplier = Math.pow(10.0, 0.0);
                break;
            }
            case TB: {
                multiplier = Math.pow(10.0, 3.0);
            }
        }
        try {
            double dSize = Double.parseDouble(size) * multiplier;
            DecimalFormat formatter = new DecimalFormat("###0");
            retVal = formatter.format(dSize);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, id, new Object[]{messages.fetchLabel("type") + type + " " + messages.fetchLabel("size") + size, e});
        }
        return retVal;
    }

    public RequestStateType getStateTypeParameter(HttpServletRequest request) {
        RequestStateType requestStateType = requestStateTypeDefault;
        try {
            String stateType = request.getParameter("stateType");
            if (stateType != null) {
                if ((stateType = stateType.trim()).equals("all")) {
                    requestStateType = RequestStateType.All;
                } else if (stateType.equals(valueStateTypeActive)) {
                    requestStateType = RequestStateType.Active;
                } else if (stateType.equals(valueStateTypeInactive)) {
                    requestStateType = RequestStateType.Inactive;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestStateType;
    }

    public int getReservationsMaxRecordsParameter(HttpServletRequest request) {
        int maxRecords = 8;
        try {
            String sMaxRecords = request.getParameter("maxRecords");
            int iMaxRecords = Integer.parseInt(sMaxRecords);
            if (iMaxRecords <= 4096 && iMaxRecords > 0) {
                maxRecords = iMaxRecords;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxRecords;
    }

    public long getMillisMIA(DuccDaemonRuntimeProperties.DaemonName daemonName) {
        String methodName = "getMillisMIA";
        long secondsMIA = -1L;
        Properties properties = DuccWebProperties.get();
        switch (daemonName) {
            case Orchestrator: {
                String or_rate = properties.getProperty("ducc.orchestrator.state.publish.rate");
                String or_ratio = "1";
                try {
                    long rate = Long.parseLong(or_rate.trim());
                    long ratio = Long.parseLong(or_ratio.trim());
                    secondsMIA = 3L * rate * ratio;
                }
                catch (Throwable t) {
                    duccLogger.debug(methodName, null, t, new Object[0]);
                }
                break;
            }
            case DbManager: {
                String db_rate = properties.getProperty("ducc.db.state.publish.rate");
                String db_ratio = "1";
                try {
                    long rate = Long.parseLong(db_rate.trim());
                    long ratio = Long.parseLong(db_ratio.trim());
                    secondsMIA = 3L * rate * ratio;
                }
                catch (Throwable t) {
                    duccLogger.debug(methodName, null, t, new Object[0]);
                }
                break;
            }
            case ResourceManager: {
                String rm_rate = properties.getProperty("ducc.orchestrator.state.publish.rate");
                String rm_ratio = "1";
                try {
                    String ratio = properties.getProperty("ducc.rm.state.publish.ratio");
                    if (ratio != null) {
                        rm_ratio = ratio;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    long rate = Long.parseLong(rm_rate.trim());
                    long ratio = Long.parseLong(rm_ratio.trim());
                    secondsMIA = 3L * rate * ratio;
                }
                catch (Throwable t) {
                    duccLogger.debug(methodName, null, t, new Object[0]);
                }
                break;
            }
            case ServiceManager: {
                String sm_rate = properties.getProperty("ducc.orchestrator.state.publish.rate");
                String sm_ratio = "1";
                try {
                    long rate = Long.parseLong(sm_rate.trim());
                    long ratio = Long.parseLong(sm_ratio.trim());
                    secondsMIA = 3L * rate * ratio;
                }
                catch (Throwable t) {
                    duccLogger.debug(methodName, null, t, new Object[0]);
                }
                break;
            }
            case ProcessManager: {
                String pm_rate = properties.getProperty("ducc.pm.state.publish.rate");
                String pm_ratio = "1";
                try {
                    long rate = Long.parseLong(pm_rate.trim());
                    long ratio = Long.parseLong(pm_ratio.trim());
                    secondsMIA = 3L * rate * ratio;
                    break;
                }
                catch (Throwable t) {
                    duccLogger.debug(methodName, null, t, new Object[0]);
                }
            }
        }
        return secondsMIA;
    }

    public String getPropertiesValue(Properties properties, String key, String defaultValue) {
        String value;
        String retVal = defaultValue;
        if (properties != null && (value = properties.getProperty(key)) != null) {
            retVal = properties.getProperty(key);
        }
        return retVal;
    }

    public int getJobsMax(HttpServletRequest request) {
        int maxRecords = 16;
        try {
            String cookie = DuccCookies.getCookie(request, "ducc:jobsmax");
            int reqRecords = Integer.parseInt(cookie);
            if (reqRecords <= 4096 && reqRecords > 0) {
                maxRecords = reqRecords;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxRecords;
    }

    public int getReservationsMax(HttpServletRequest request) {
        int maxRecords = 8;
        try {
            String cookie = DuccCookies.getCookie(request, "ducc:reservationsmax");
            int reqRecords = Integer.parseInt(cookie);
            if (reqRecords <= 4096 && reqRecords > 0) {
                maxRecords = reqRecords;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxRecords;
    }

    public int getServicesMax(HttpServletRequest request) {
        int maxRecords = 12;
        try {
            String cookie = DuccCookies.getCookie(request, "ducc:servicesmax");
            int reqRecords = Integer.parseInt(cookie);
            if (reqRecords <= 4096 && reqRecords > 0) {
                maxRecords = reqRecords;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxRecords;
    }

    public String getValue(Properties properties, String key, String defaultValue) {
        String retVal = defaultValue;
        if (properties != null && key != null) {
            retVal = properties.getProperty(key, defaultValue);
        }
        return retVal.trim();
    }

    public String getDeployments(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        String deployments = "0";
        if (propertiesMeta != null && propertiesMeta.containsKey("implementors")) {
            String value = propertiesMeta.getProperty("implementors");
            String[] implementors = servicesRegistry.getList(value);
            deployments = "" + implementors.length;
        }
        return deployments;
    }

    public ArrayList<String> getSwappingMachines(IDuccWorkJob job) {
        ArrayList<String> retVal = new ArrayList<String>();
        DuccMachinesData.getInstance();
        IDuccProcessMap map = job.getProcessMap();
        for (DuccId duccId : map.keySet()) {
            IDuccProcess jp = (IDuccProcess)map.get((Object)duccId);
            switch (jp.getProcessState()) {
                case Starting: 
                case Initializing: 
                case Running: {
                    NodeIdentity nodeId = jp.getNodeIdentity();
                    if (nodeId == null) break;
                    String ip = nodeId.getIp();
                    if (!DuccMachinesData.getInstance().isMachineSwapping(ip) || retVal.contains(nodeId.getName())) break;
                    retVal.add(nodeId.getName());
                }
            }
        }
        return retVal;
    }

    public String getCompletion(HttpServletRequest request, IDuccWorkJob job) {
        String methodName = "getCompletion";
        String retVal = "";
        try {
            String tVal = job.getStandardInfo().getDateOfCompletion();
            duccLogger.trace(methodName, null, new Object[]{tVal});
            retVal = this.getTimeStamp(request, job.getDuccId(), tVal);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public String getCompletion(HttpServletRequest request, IDuccWorkReservation reservation) {
        String methodName = "getCompletion";
        String retVal = "";
        try {
            String tVal = reservation.getStandardInfo().getDateOfCompletion();
            duccLogger.trace(methodName, null, new Object[]{tVal});
            retVal = this.getTimeStamp(request, reservation.getDuccId(), tVal);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public String getDuration(HttpServletRequest request, IDuccWork dw, FormatHelper.Precision precision) {
        String methodName = "getDuration";
        String retVal = "";
        try {
            String v2 = dw.getStandardInfo().getDateOfCompletion();
            String v1 = dw.getStandardInfo().getDateOfSubmission();
            duccLogger.trace(methodName, null, new Object[]{"v2:" + v2 + " v1:" + v1});
            retVal = this.getDuration(dw.getDuccId(), v2, v1, precision);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public String getDuration(HttpServletRequest request, IDuccWork dw, long now, FormatHelper.Precision precision) {
        String methodName = "getDuration";
        String retVal = "";
        try {
            String v2 = "" + now;
            String v1 = dw.getStandardInfo().getDateOfSubmission();
            duccLogger.trace(methodName, null, new Object[]{"v2:" + v2 + " v1:" + v1});
            retVal = this.getDuration(dw.getDuccId(), v2, v1, precision);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public String getProjection(HttpServletRequest request, IDuccWorkJob job, FormatHelper.Precision precision) {
        String methodName = "getProjection";
        String retVal = "";
        try {
            int usableProcessCount;
            int error;
            int completed;
            IDuccSchedulingInfo schedulingInfo = job.getSchedulingInfo();
            IDuccPerWorkItemStatistics perWorkItemStatistics = schedulingInfo.getPerWorkItemStatistics();
            if (perWorkItemStatistics == null) {
                return "";
            }
            int total = schedulingInfo.getIntWorkItemsTotal();
            int remainingWorkItems = total - ((completed = schedulingInfo.getIntWorkItemsCompleted()) + (error = schedulingInfo.getIntWorkItemsError()));
            if (remainingWorkItems > 0 && (usableProcessCount = job.getProcessMap().getUsableProcessCount()) > 0 && completed > 0) {
                int threadsPerProcess = schedulingInfo.getIntThreadsPerShare();
                int totalThreads = usableProcessCount * threadsPerProcess;
                double remainingIterations = remainingWorkItems / totalThreads;
                double avgMillis = perWorkItemStatistics.getMean();
                double leastOperatingMillis = job.getWiMillisOperatingLeast();
                double mostCompletedMillis = job.getWiMillisCompletedMost();
                double projectedTime = avgMillis * remainingIterations + (mostCompletedMillis - leastOperatingMillis);
                duccLogger.trace(methodName, job.getDuccId(), new Object[]{"avgMillis:" + avgMillis + " " + "remainingIterations:" + remainingIterations + " " + "mostCompleteMillis:" + mostCompletedMillis + " " + "leastOperatingMillis:" + leastOperatingMillis});
                if (projectedTime > 0.0) {
                    long millis = Math.round(projectedTime);
                    if (millis > 1000L) {
                        String projection = FormatHelper.duration(millis, precision);
                        String health = "class=\"health_yellow\"";
                        String title = "title=\"Time (ddd:hh:mm:ss) until projected completion\"";
                        retVal = "+<span " + health + " " + title + "><i>" + projection + "</i></span>";
                        retVal = " {" + retVal + "}";
                    }
                } else {
                    long millis = Math.round(0.0 - projectedTime);
                    if (millis > 1000L) {
                        String projection = FormatHelper.duration(millis, precision);
                        String health = "class=\"health_purple\"";
                        String title = "title=\"Time (ddd:hh:mm:ss) past-due projected completion\"";
                        retVal = "-<span " + health + " " + title + "><i>" + projection + "</i></span>";
                        retVal = " {" + retVal + "}";
                    }
                }
            }
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, t, new Object[0]);
        }
        return retVal;
    }

    public double getAvgMillisPerWorkItem(HttpServletRequest request, IDuccWorkJob job) {
        double avgMillis = 0.0;
        IDuccSchedulingInfo schedulingInfo = job.getSchedulingInfo();
        IDuccPerWorkItemStatistics perWorkItemStatistics = schedulingInfo.getPerWorkItemStatistics();
        if (perWorkItemStatistics != null) {
            avgMillis = perWorkItemStatistics.getMean();
        }
        return avgMillis;
    }

    public String decorateDuration(HttpServletRequest request, IDuccWorkJob job, String duration, FormatHelper.Precision precision) {
        String location = "decorateDuration";
        String retVal = duration;
        DuccId duccId = job.getDuccId();
        try {
            String cVal;
            int iAvgMillisPerWorkItem;
            StringBuffer title = new StringBuffer();
            double avgMillisPerWorkItem = this.getAvgMillisPerWorkItem(request, job);
            if (avgMillisPerWorkItem > 0.0 && avgMillisPerWorkItem < 500.0) {
                avgMillisPerWorkItem = 500.0;
            }
            if ((iAvgMillisPerWorkItem = (int)avgMillisPerWorkItem) > 0) {
                if (title.length() > 0) {
                    title.append("; ");
                }
                title.append("Time (ddd:hh:mm:ss) elapsed for job, average processing time per work item=" + FormatHelper.duration(iAvgMillisPerWorkItem, precision));
            }
            if ((cVal = this.getCompletion(request, job)) != null && cVal.length() > 0) {
                if (title.length() > 0) {
                    title.append("; ");
                }
                title.append("End=" + cVal);
            }
            if (title.length() > 0) {
                retVal = "<span title=\"" + title + "\"" + ">" + duration + "</span>";
            }
        }
        catch (Exception e) {
            duccLogger.error(location, duccId, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String decorateDuration(HttpServletRequest request, IDuccWorkReservation reservation, String duration) {
        String retVal = duration;
        String cVal = this.getCompletion(request, reservation);
        if (cVal != null && cVal.length() > 0) {
            String title = "title=\"End=" + cVal + "\"";
            retVal = "<span " + title + ">" + duration + "</span>";
        }
        return retVal;
    }

    public String getDisabledWithHover(HttpServletRequest request, IDuccWork duccWork) {
        String resourceOwnerUserId = duccWork.getStandardInfo().getUser();
        return this.getDisabledWithHover(request, resourceOwnerUserId);
    }

    public String getDisabledWithHover(HttpServletRequest request, String resourceOwnerUserId) {
        String disabled = "disabled=\"disabled\"";
        String hover = "";
        HandlersHelper.AuthorizationStatus authorizationStatus = HandlersHelper.getAuthorizationStatus(request, resourceOwnerUserId);
        switch (authorizationStatus) {
            case LoggedInOwner: {
                disabled = "";
                break;
            }
            case LoggedInAdministrator: {
                disabled = "";
                break;
            }
            case LoggedInNotOwner: {
                hover = " title=\"Hint: use Preferences -> Role [Administrator] to activate button\"";
                break;
            }
            case LoggedInNotAdministrator: {
                hover = " title=\"Hint: Login user is not an Administrator\"";
                break;
            }
            case NotLoggedIn: {
                hover = " title=\"Hint: use Login to activate button\"";
                break;
            }
        }
        return disabled + hover;
    }

    public String buildjConsoleLink(String service) {
        File file;
        String location = "buildjConsoleLink";
        String retVal = service;
        if (this.jconsole_wrapper_signed_jar != null && (file = new File(this.jconsole_wrapper_signed_jar)).exists()) {
            retVal = "<a href=\"/ducc-servlet/jconsole-link.jnlp?service=" + service + "\" onclick=\"var newWin = window.open(this.href,'child','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + service + "</a>";
        }
        duccLogger.trace(location, null, new Object[]{retVal});
        return retVal;
    }

    public String buildErrorLink(IDuccWorkJob job) {
        return this.buildErrorLink(job, null);
    }

    public String buildErrorLink(IDuccWorkJob job, String name) {
        String retVal = job.getSchedulingInfo().getWorkItemsError();
        if (!retVal.equals("0")) {
            String href;
            String errorCount = retVal;
            if (name == null) {
                name = errorCount;
            }
            String logsjobdir = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
            String logfile = "jd.err.log";
            retVal = href = "<a href=\"/file.pager.html?fname=" + logsjobdir + logfile + "\" onclick=\"var newWin = window.open(this.href,'child','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + name + "</a>";
        }
        return retVal;
    }

    public String buildInitializeFailuresLink(IDuccWorkJob job) {
        StringBuffer sb = new StringBuffer();
        IDuccProcessMap processMap = job.getProcessMap();
        ArrayList list = processMap.getFailedInitialization();
        int count = list.size();
        if (count > 0) {
            String href = "/ducc-servlet/job-initialization-fail-data?id=" + job.getDuccId();
            String anchor = "<a class=\"logfileLink\" title=\"" + job.getDuccId() + " init fails" + "\" href=\"" + href + "\" rel=\"" + href + "\">" + count + "</a>";
            sb.append(anchor);
        } else {
            sb.append(count);
        }
        String retVal = sb.toString();
        return retVal;
    }

    public String buildRuntimeFailuresLink(IDuccWorkJob job) {
        StringBuffer sb = new StringBuffer();
        IDuccProcessMap processMap = job.getProcessMap();
        ArrayList list = processMap.getFailedNotInitialization();
        int count = list.size();
        if (count > 0) {
            String href = "/ducc-servlet/job-runtime-fail-data?id=" + job.getDuccId();
            String anchor = "<a class=\"logfileLink\" title=\"" + job.getDuccId() + " run fails" + "\" href=\"" + href + "\" rel=\"" + href + "\">" + count + "</a>";
            sb.append(anchor);
        } else {
            sb.append(count);
        }
        String retVal = sb.toString();
        return retVal;
    }

    public String trGet(int counter) {
        if (counter % 2 > 0) {
            return "<tr class=\"ducc-row-odd\">";
        }
        return "<tr class=\"ducc-row-even\">";
    }

    public String evaluateServices(IDuccWorkJob job, ServicesRegistry servicesRegistry) {
        StringBuffer sb = new StringBuffer();
        String[] serviceDependencies = job.getServiceDependencies();
        if (serviceDependencies == null) {
            sb.append("<span class=\"health_neutral\" >");
            sb.append("0");
            sb.append("</span>");
        } else if (job.isCompleted()) {
            sb.append("<span class=\"health_neutral\" >");
            sb.append(serviceDependencies.length);
            sb.append("</span>");
        } else {
            StringBuffer down = new StringBuffer();
            StringBuffer title = new StringBuffer();
            for (String serviceName : serviceDependencies) {
                String status;
                if (title.length() > 0) {
                    title.append(",");
                }
                title.append(serviceName);
                if (job.isFinished() || (status = servicesRegistry.getServiceState(serviceName)).equalsIgnoreCase("OK")) continue;
                if (down.length() != 0) {
                    down.append("<br>");
                }
                down.append("<span class=\"health_red\" >");
                down.append(serviceName);
                down.append("=");
                down.append(status);
                down.append("</span>");
            }
            if (down.length() != 0) {
                sb.append(down);
            } else if (title.length() > 0) {
                sb.append("<span class=\"health_green\" title=\"" + title + "\">");
                sb.append(serviceDependencies.length);
                sb.append("</span>");
            } else {
                sb.append("<span class=\"health_green\" >");
                sb.append(serviceDependencies.length);
                sb.append("</span>");
            }
        }
        return sb.toString();
    }

    public String formatClasspath(String classpath) {
        String[] cpList;
        String retVal = classpath;
        if (classpath != null && (cpList = classpath.split(":")) != null) {
            StringBuffer vb = new StringBuffer();
            vb.append("<br>");
            vb.append("<div>");
            StringBuffer sb = new StringBuffer();
            for (String item : cpList) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(item);
            }
            vb.append(sb);
            vb.append("</div>");
            retVal = vb.toString();
        }
        return retVal;
    }

    protected String getMonitor(DuccId duccId, IDuccTypes.DuccType type, boolean multi) {
        StringBuffer sb = new StringBuffer();
        DuccWebMonitor duccWebMonitor = DuccWebMonitor.getInstance();
        Long expiry = duccWebMonitor.getExpiry(type, duccId);
        if (!duccWebMonitor.isAutoCancelEnabled()) {
            if (expiry != null) {
                String text = "webserver not primary";
                sb.append("<span class=\"health_neutral\" title=\"" + text + "\">");
                sb.append("MonitorRequested");
                sb.append("</span>");
            }
        } else if (expiry != null) {
            String key;
            if (multi) {
                sb.append(" ");
            }
            String t2 = " left until auto-cancel, unless renewed";
            String t1 = expiry == 0L ? "less than 1 minute" : expiry + "+ minutes";
            String text = t1 + t2;
            long expiryWarnTime = 3L;
            Properties properties = DuccWebProperties.get();
            if (properties.containsKey(key = "ducc.ws.job.automatic.cancel.minutes")) {
                String value = properties.getProperty(key);
                try {
                    long time = Long.parseLong(value) / 2L;
                    if (time > 0L) {
                        expiryWarnTime = time;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (expiry > expiryWarnTime) {
                sb.append("<span class=\"health_green\" title=\"" + text + "\">");
                sb.append("MonitorActive");
            } else {
                sb.append("<span class=\"health_red\" title=\"" + text + "\">");
                sb.append("MonitorWarning");
            }
            sb.append("</span>");
        } else if (duccWebMonitor.isCanceled(IDuccTypes.DuccType.Job, duccId)) {
            sb.append("<span class=\"health_red\" >");
            sb.append("CancelPending...");
            sb.append("</span>");
        }
        return sb.toString();
    }

    protected StringBuffer getReason(IDuccWorkJob job, IDuccTypes.DuccType type) {
        StringBuffer sb;
        block15: {
            sb = new StringBuffer();
            try {
                if (job == null) break block15;
                DuccId duccId = job.getDuccId();
                sb = new StringBuffer();
                if (job.isOperational()) {
                    boolean multi = false;
                    String monitor = this.getMonitor(duccId, type, multi);
                    if (monitor.length() > 0) {
                        if (multi) {
                            sb.append(" ");
                        }
                        multi = true;
                        sb.append(monitor);
                    }
                    break block15;
                }
                if (!job.isCompleted()) break block15;
                IDuccCompletionType.JobCompletionType jobCompletionType = job.getCompletionType();
                switch (jobCompletionType) {
                    case EndOfJob: {
                        try {
                            if (job.getDriver().getProcessMap().getAbnormalDeallocationCount() > 0) {
                                jobCompletionType = IDuccCompletionType.JobCompletionType.DriverProcessFailed;
                            } else {
                                int error;
                                int done;
                                int total = job.getSchedulingInfo().getIntWorkItemsTotal();
                                if (total != (done = job.getSchedulingInfo().getIntWorkItemsCompleted()) + (error = job.getSchedulingInfo().getIntWorkItemsError())) {
                                    jobCompletionType = IDuccCompletionType.JobCompletionType.Premature;
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        sb.append("<span>");
                        break;
                    }
                    case Undefined: {
                        sb.append("<span>");
                        break;
                    }
                    default: {
                        IRationale rationale = job.getCompletionRationale();
                        if (rationale != null) {
                            sb.append("<span title=" + rationale.getTextQuoted() + ">");
                            break;
                        }
                        sb.append("<span>");
                    }
                }
                sb.append(jobCompletionType);
                sb.append("</span>");
            }
            catch (Exception e) {
                sb.append(e.getMessage());
            }
        }
        return sb;
    }

    private boolean isAtLeastOneJobProcessStuck(MachineFactsList factsList) {
        boolean retVal = false;
        if (factsList.size() > 0) {
            ListIterator listIterator = factsList.listIterator();
            while (listIterator.hasNext()) {
                ArrayList<JobProcessInfo> list;
                MachineFacts facts = (MachineFacts)listIterator.next();
                String nodeStatus = facts.status;
                if (nodeStatus.equals("up") || (list = DuccDataHelper.getInstance().getJobProcessInfoList(facts.name)).isEmpty()) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public String buildReleaseAll(HttpServletRequest request, MachineFactsList factsList) {
        String retVal = "";
        if (this.isAtLeastOneJobProcessStuck(factsList)) {
            String hover = this.getDisabledWithHover(request, "");
            String node = "'*'";
            String type = "'jobs'";
            if (node != null) {
                retVal = "<input type=\"button\" onclick=\"ducc_confirm_release_shares(" + node + "," + type + ")\" value=\"Release *ALL* Stuck Job Shares\" " + hover + "/>";
            }
        }
        return retVal;
    }

    public String buildReleaseMachine(HttpServletRequest request, MachineFacts facts) {
        String retVal = "";
        String nodeStatus = facts.status;
        if (!nodeStatus.equals("up")) {
            ArrayList<JobProcessInfo> list = DuccDataHelper.getInstance().getJobProcessInfoList(facts.name);
            if (this.terminateEnabled && !list.isEmpty()) {
                String hover = this.getDisabledWithHover(request, "");
                String node = "'" + facts.name + "'";
                String type = "'jobs'";
                if (node != null) {
                    retVal = "<input type=\"button\" onclick=\"ducc_confirm_release_shares(" + node + "," + type + ")\" value=\"Release Machine Stuck Job Shares\" " + hover + "/>";
                }
            }
        }
        return retVal;
    }

    public static enum RequestStateType {
        Active,
        Inactive,
        All;

    }
}

