/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;

public class AlienTextFile
extends AlienAbstract {
    private static DuccLogger duccLogger = DuccLogger.getLogger((String)AlienTextFile.class.getName(), null);
    private static String command_du = "/usr/bin/du";
    private static String flag_dash_b = "-b";
    private static String double_dash = "--";
    private static String command_dd = "/bin/dd";
    private static String arg_if = "if=";
    private static String arg_skip = "skip=";
    private static String arg_count = "count=";
    private static int sizeBlockDd = 512;
    private static int sizeDefault = 0;
    private String file_name;
    private int page_bytes = 262144;

    public AlienTextFile(String user, String file_name) {
        this.init(user, file_name);
    }

    private void init(String user, String file_name) {
        String location = "init";
        this.set_user(user);
        this.set_file_name(file_name);
        this.set_ducc_ling(Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties()));
        this.init_page_bytes();
        duccLogger.debug(location, this.duccId, new Object[]{"bytes:" + this.get_page_bytes()});
    }

    private void init_page_bytes() {
        String location = "init_page_bytes";
        try {
            int value;
            String bytes_per_page = DuccPropertiesResolver.getInstance().getProperty("ducc.ws.bytes.per.page");
            if (bytes_per_page != null && (value = Integer.parseInt(bytes_per_page = bytes_per_page.trim())) > 0) {
                this.set_page_bytes(value);
                duccLogger.debug(location, this.duccId, new Object[]{value});
            }
        }
        catch (Exception e) {
            duccLogger.error(location, this.duccId, (Throwable)e, new Object[0]);
        }
    }

    protected void set_file_name(String value) {
        this.file_name = value;
    }

    protected String get_file_name() {
        return this.file_name;
    }

    protected void set_page_bytes(int value) {
        this.page_bytes = value;
    }

    protected int get_page_bytes() {
        return this.page_bytes;
    }

    private void trace(String text) {
        String location = "trace";
        duccLogger.debug(location, this.duccId, new Object[]{text});
    }

    private void trace(String[] textArray) {
        String location = "trace";
        StringBuffer sb = new StringBuffer();
        if (textArray != null) {
            for (String s : textArray) {
                if (s == null) continue;
                sb.append(s + " ");
            }
        }
        duccLogger.debug(location, this.duccId, new Object[]{sb});
    }

    private String getResult(String[] command) {
        String location = "getResult";
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            this.trace(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            int exitValue = process.waitFor();
            duccLogger.debug(location, this.duccId, new Object[]{exitValue});
        }
        catch (Exception e) {
            duccLogger.error(location, this.duccId, (Throwable)e, new Object[0]);
        }
        String retVal = sb.toString();
        return retVal;
    }

    private String[] buildCommandDu() {
        String[] command_ducc_ling_yes = new String[]{this.ducc_ling, this.q_parameter, this.u_parameter, this.user, double_dash, command_du, flag_dash_b, this.file_name};
        String[] command_ducc_ling_no = new String[]{command_du, flag_dash_b, this.file_name};
        String[] command = command_ducc_ling_yes;
        if (this.ducc_ling == null) {
            command = command_ducc_ling_no;
        } else if (this.user == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private String getDu() throws Throwable {
        String methodName = "getDu";
        String data = "";
        try {
            String[] command = this.buildCommandDu();
            data = this.getResult(command);
            this.trace("data size:" + data.length());
        }
        catch (Throwable t) {
            duccLogger.warn(methodName, this.duccId, t, new Object[0]);
        }
        return data;
    }

    private int convertToInt(String value, int otherwise) {
        String methodName = "convertToInt";
        int retVal = otherwise;
        try {
            retVal = Integer.parseInt(value);
        }
        catch (Throwable t) {
            duccLogger.debug(methodName, this.duccId, t, new Object[0]);
        }
        return retVal;
    }

    public int getByteSize() {
        String methodName = "getByteSize";
        int retVal = sizeDefault;
        try {
            String text = this.getDu();
            if (text != null) {
                String[] tokens = (text = text.trim()).split("\\s+");
                if (tokens.length > 0) {
                    duccLogger.debug(methodName, this.duccId, new Object[]{tokens[0]});
                    retVal = this.convertToInt(tokens[0], sizeDefault);
                } else {
                    duccLogger.debug(methodName, this.duccId, new Object[]{"empty"});
                }
            }
        }
        catch (Throwable t) {
            duccLogger.warn(methodName, this.duccId, t, new Object[0]);
        }
        return retVal;
    }

    private String[] buildCommandDd(int skip, int count) {
        String[] command_ducc_ling_yes = new String[]{this.ducc_ling, this.q_parameter, this.u_parameter, this.user, double_dash, command_dd, arg_if + this.file_name, arg_skip + skip, arg_count + count};
        String[] command_ducc_ling_no = new String[]{command_dd, arg_if + this.file_name, arg_skip + skip, arg_count + count};
        String[] command = command_ducc_ling_yes;
        if (this.ducc_ling == null) {
            command = command_ducc_ling_no;
        } else if (this.user == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private String getDd(int skip, int count) throws Throwable {
        String methodName = "getDd";
        String data = "";
        try {
            String[] command = this.buildCommandDd(skip, count);
            data = this.getResult(command);
            this.trace("data size:" + data.length());
        }
        catch (Throwable t) {
            duccLogger.warn(methodName, this.duccId, t, new Object[0]);
        }
        return data;
    }

    public String getChunk(int byteStart, int byteCount) {
        String methodName = "getChunk";
        String retVal = "";
        try {
            int skip = (int)Math.ceil((double)byteStart / (1.0 * (double)sizeBlockDd));
            int count = (int)Math.ceil((double)byteCount / (1.0 * (double)sizeBlockDd));
            retVal = this.getDd(skip, count);
        }
        catch (Throwable t) {
            duccLogger.warn(methodName, this.duccId, t, new Object[0]);
        }
        return retVal;
    }

    public int getPageCount() {
        int retVal = 0;
        int pageSize = this.get_page_bytes();
        int fileBytes = this.getByteSize();
        retVal = (int)Math.ceil((double)fileBytes / (1.0 * (double)pageSize));
        return retVal;
    }

    public String getPage(int pageNo) {
        String retVal = "";
        int pageSize = this.get_page_bytes();
        retVal = this.getChunk(pageNo * pageSize, pageSize);
        return retVal;
    }

    public String getPageFirst() {
        String retVal = "";
        int pageSize = this.get_page_bytes();
        retVal = this.getChunk(0, pageSize);
        return retVal;
    }

    public String getPageLast() {
        String retVal = "";
        int pageSize = this.get_page_bytes();
        int fileBytes = this.getByteSize();
        if (fileBytes > pageSize) {
            int byteStart = fileBytes - pageSize + 1;
            int byteCount = pageSize;
            retVal = this.getChunk(byteStart, byteCount);
        } else {
            retVal = this.getPageFirst();
        }
        return retVal;
    }

    public static void main(String[] args) throws Throwable {
        String arg_user = args[0];
        String arg_file = args[1];
        AlienTextFile alienTextFile = new AlienTextFile(arg_user, arg_file);
        if (args.length > 2) {
            alienTextFile.set_ducc_ling(args[2]);
        }
        int bytes = alienTextFile.getByteSize();
        System.out.println("--- file bytes ---");
        System.out.println(bytes);
        String data = alienTextFile.getPageFirst();
        System.out.println("--- first ---");
        System.out.println(data);
        data = alienTextFile.getPageLast();
        System.out.println("--- last ---");
        System.out.println(data);
        int count = alienTextFile.getPageCount();
        System.out.println("--- page count ---");
        System.out.println(count);
        for (int i = 0; i < count; ++i) {
            data = alienTextFile.getPage(i);
            System.out.println("--- page " + i + " ---");
            System.out.println(data);
        }
    }
}

