/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.cli.ws.json.NodePidList;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccNodes;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.MachineSummaryInfo;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.types.Ip;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.DatedNodeMetricsUpdateDuccEvent;

public class DuccMachinesData {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccMachinesData.class.getName());
    private static DuccId jobid = null;
    private static ConcurrentSkipListMap<MachineInfo, String> sortedMachines = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, MachineInfo> unsortedMachines = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, MachineSummaryInfo> summaryMachines = new ConcurrentSkipListMap();
    private static AtomicLong memoryTotal = new AtomicLong(0L);
    private static AtomicLong swapInuse = new AtomicLong(0L);
    private static AtomicLong swapFree = new AtomicLong(0L);
    private static AtomicLong sharesTotal = new AtomicLong(0L);
    private static AtomicLong sharesInuse = new AtomicLong(0L);
    private int shareSize = 15;
    private String domain = "";
    private static DuccMachinesData duccMachinesData = new DuccMachinesData();
    private static ConcurrentSkipListMap<String, String> ipToNameMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, String> nameToIpMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, String> isSwapping = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, TreeMap<String, NodeUsersInfo>> ipToNodeUsersInfoMap = new ConcurrentSkipListMap();
    private volatile String published = null;

    public static DuccMachinesData getInstance() {
        return duccMachinesData;
    }

    public boolean isMachineSwapping(String ip) {
        return isSwapping.containsKey(ip);
    }

    public ConcurrentSkipListMap<String, MachineInfo> getMachines() {
        return unsortedMachines;
    }

    public ConcurrentSkipListMap<MachineInfo, String> getSortedMachines() {
        ConcurrentSkipListMap<MachineInfo, String> retVal = sortedMachines;
        return retVal;
    }

    public void updateSortedMachines() {
        String location = "updateSortedMachines";
        logger.debug(location, jobid, new Object[]{"start"});
        try {
            ConcurrentSkipListMap<MachineInfo, String> map = new ConcurrentSkipListMap<MachineInfo, String>();
            for (Map.Entry<String, MachineInfo> entry : unsortedMachines.entrySet()) {
                String value = entry.getKey();
                MachineInfo key = entry.getValue();
                map.put(key, value);
                logger.debug(location, jobid, new Object[]{"put: " + value});
            }
            sortedMachines = map;
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        logger.debug(location, jobid, new Object[]{"end"});
    }

    private DuccMachinesData() {
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        try {
            String fileName = "ducc.nodes";
            String dirResources = IDuccEnv.DUCC_RESOURCES_DIR;
            ArrayList<String> nodes = DuccNodes.getInstance().get(dirResources, fileName);
            for (String nodeName : nodes) {
                String memTotal = "";
                String memFree = "";
                String swapInuse = "";
                String swapFree = "";
                MachineInfo machineInfo = new MachineInfo(IDuccEnv.DUCC_NODES_FILE_PATH, "", nodeName, memTotal, memFree, swapInuse, swapFree, null, "", "", -1L, 0L);
                unsortedMachines.put(machineInfo.getName(), machineInfo);
            }
            this.updateSortedMachines();
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        try {
            this.shareSize = Integer.parseInt(DuccWebProperties.getProperty(DuccWebProperties.key_ducc_rm_share_quantum, DuccWebProperties.val_ducc_rm_share_quantum));
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String chn = ia.getCanonicalHostName();
            int index = chn.indexOf(".");
            if (index > 0) {
                this.domain = chn.substring(index);
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
    }

    public boolean isPublished() {
        return this.published != null;
    }

    public void setPublished() {
        this.published = TimeStamp.getCurrentMillis();
    }

    public MachineSummaryInfo getTotals() {
        MachineSummaryInfo totals = new MachineSummaryInfo();
        totals.memoryTotal = memoryTotal.get();
        totals.swapInuse = swapInuse.get();
        totals.swapFree = swapFree.get();
        totals.sharesTotal = sharesTotal.get();
        totals.sharesInuse = sharesInuse.get();
        return totals;
    }

    private void updateTotals(Ip ip, MachineSummaryInfo newInfo) {
        if (summaryMachines.containsKey(ip.toString())) {
            MachineSummaryInfo oldInfo = summaryMachines.get(ip.toString());
            summaryMachines.put(ip.toString(), newInfo);
            memoryTotal.addAndGet(newInfo.memoryTotal - oldInfo.memoryTotal);
            swapInuse.addAndGet(newInfo.swapInuse - oldInfo.swapInuse);
            swapFree.addAndGet(newInfo.swapFree - oldInfo.swapFree);
            sharesTotal.addAndGet(newInfo.sharesTotal - oldInfo.sharesTotal);
            sharesInuse.addAndGet(newInfo.sharesInuse - oldInfo.sharesInuse);
        } else {
            summaryMachines.put(ip.toString(), newInfo);
            memoryTotal.addAndGet(newInfo.memoryTotal);
            swapInuse.addAndGet(newInfo.swapInuse);
            swapFree.addAndGet(newInfo.swapFree);
            sharesTotal.addAndGet(newInfo.sharesTotal);
            sharesInuse.addAndGet(newInfo.sharesInuse);
        }
    }

    private String normalizeMachineName(String machineName) {
        String retVal = machineName;
        try {
            if (!unsortedMachines.containsKey(machineName)) {
                if (machineName.contains(".")) {
                    int index = machineName.indexOf(".");
                    String domainlessMachineName = machineName.substring(0, index);
                    if (unsortedMachines.containsKey(domainlessMachineName)) {
                        retVal = domainlessMachineName;
                    }
                } else {
                    String domainfullMachineName = machineName + this.domain;
                    if (unsortedMachines.containsKey(domainfullMachineName)) {
                        retVal = domainfullMachineName;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public void put(DatedNodeMetricsUpdateDuccEvent duccEvent) {
        long lvalMemTotal;
        String location = "put";
        MachineSummaryInfo msi = new MachineSummaryInfo();
        NodeMetricsUpdateDuccEvent nodeMetrics = duccEvent.getNodeMetricsUpdateDuccEvent();
        Ip ip = new Ip(nodeMetrics.getNodeIdentity().getIp().trim());
        TreeMap map = nodeMetrics.getNodeUsersMap();
        if (map != null) {
            ipToNodeUsersInfoMap.put(ip.toString(), map);
        }
        String machineName = nodeMetrics.getNodeIdentity().getName().trim();
        ipToNameMap.put(ip.toString(), machineName);
        nameToIpMap.put(machineName, ip.toString());
        long nodeMemTotal = nodeMetrics.getNodeMemory().getMemTotal();
        logger.debug(location, jobid, new Object[]{"node: " + machineName + " " + "memTotal: " + nodeMemTotal});
        msi.memoryTotal = lvalMemTotal = (long)(1.0 * (double)nodeMemTotal / 1048576.0 + 0.5);
        String memTotal = "" + lvalMemTotal;
        long nodeMemFree = nodeMetrics.getNodeMemory().getMemFree();
        logger.debug(location, jobid, new Object[]{"node: " + machineName + " " + "memFree: " + nodeMemFree});
        long lvalMemFree = (long)(1.0 * (double)nodeMemFree / 1048576.0 + 0.5);
        String memFree = "" + lvalMemFree;
        msi.sharesTotal = lvalMemFree / (long)this.shareSize;
        String sharesTotal = "" + lvalMemFree / (long)this.shareSize;
        double dvalSwapTotal = nodeMetrics.getNodeMemory().getSwapTotal();
        long lvalSwapTotal = (long)(dvalSwapTotal / 1048576.0 + 0.5);
        double dvalSwapFree = nodeMetrics.getNodeMemory().getSwapFree();
        long lvalSwapFree = (long)(dvalSwapFree / 1048576.0 + 0.5);
        long lvalSwapInuse = lvalSwapTotal - lvalSwapFree;
        String swapInuse = "" + lvalSwapInuse;
        msi.swapInuse = lvalSwapInuse;
        String swapKey = ip.toString();
        String swapVal = swapInuse;
        if (msi.swapInuse > 0L) {
            isSwapping.put(swapKey, swapVal);
        } else {
            isSwapping.remove(swapKey);
        }
        msi.swapFree = lvalSwapFree;
        String swapFree = "" + lvalSwapFree;
        String sharesInuse = "0";
        Properties shareMap = this.getShareMap(this.shareSize);
        try {
            if (shareMap.containsKey(ip.toString())) {
                msi.sharesInuse += (long)((Integer)shareMap.get(ip.toString())).intValue();
                sharesInuse = "" + msi.sharesInuse;
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        List alienPids = nodeMetrics.getRogueProcessInfoList();
        MachineInfo current = new MachineInfo("", ip.toString(), machineName, memTotal, memFree, "" + swapInuse, "" + swapFree, alienPids, sharesTotal, sharesInuse, duccEvent.getMillis(), duccEvent.getEventSize());
        String key = this.normalizeMachineName(machineName);
        MachineInfo previous = unsortedMachines.get(key);
        if (previous != null) {
            try {
                long swapPrev = Long.parseLong(previous.getSwapInuse());
                long swapCurr = Long.parseLong(current.getSwapInuse());
                long swapDelta = swapCurr - swapPrev;
                current.setSwapDelta(swapDelta);
            }
            catch (Exception e) {
                // empty catch block
            }
            long pHbMax = previous.getHeartbeatMax();
            long tod = previous.getHeartbeatMaxTOD();
            long pHbElapsed = previous.getElapsedSeconds();
            if (pHbElapsed > pHbMax) {
                pHbMax = pHbElapsed;
                tod = previous.getHeartbeat();
            }
            current.setHeartbeatMax(pHbMax);
            current.setHeartbeatMaxTOD(tod);
            long pubSizeMax = previous.getPubSizeMax();
            long pubSize = current.getPubSize();
            if (pubSize > pubSizeMax) {
                pubSizeMax = pubSize;
            }
            current.setPubSizeMax(pubSizeMax);
        }
        unsortedMachines.put(key, current);
        this.updateTotals(ip, msi);
        this.setPublished();
    }

    public List<String> getPids(Ip ip, UserId user) {
        String location = "getPids";
        ArrayList<String> retVal = new ArrayList<String>();
        if (ip != null && ip.toString() != null && user != null && user.toString() != null) {
            try {
                NodeUsersInfo nodeUsersInfo;
                TreeMap<String, NodeUsersInfo> map = ipToNodeUsersInfoMap.get(ip.toString());
                if (map != null && (nodeUsersInfo = map.get(user.toString())) != null) {
                    for (NodeUsersInfo.NodeProcess process : nodeUsersInfo.getReserveProcesses()) {
                        retVal.add(process.getPid());
                    }
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    public List<String> getPids(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPids(ip, user);
    }

    public List<NodePidList> getUserProcesses(List<String> nodeList, String user) {
        ArrayList<NodePidList> nodePidListList = new ArrayList<NodePidList>();
        for (String node : nodeList) {
            List<String> pids = this.getPids(new NodeId(node), new UserId(user));
            NodePidList nodePidList = new NodePidList(node, pids);
            nodePidListList.add(nodePidList);
        }
        return nodePidListList;
    }

    public int getPidCount(Ip ip, UserId user) {
        int retVal = 0;
        try {
            List<String> pidList = this.getPids(ip, user);
            if (pidList != null) {
                return pidList.size();
            }
        }
        catch (Exception e) {
            retVal = -1;
        }
        return retVal;
    }

    public int getPidCount(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPidCount(ip, user);
    }

    public String getNameForIp(String ip) {
        String retVal = null;
        try {
            retVal = ipToNameMap.get(ip);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public String getIpForName(String name) {
        String retVal = null;
        try {
            retVal = nameToIpMap.get(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    private int toInt(String s, int deflt) {
        int retVal;
        try {
            retVal = Integer.parseInt(s);
        }
        catch (Throwable t) {
            retVal = deflt;
        }
        return retVal;
    }

    private Properties getShareMapJobs(Properties properties, int shareSize) {
        String location = "getShareMapJobs";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId jobid : duccWorkMap.getJobKeySet()) {
                IDuccWorkJob job = (IDuccWorkJob)duccWorkMap.findDuccWork(jobid);
                if (!job.isOperational()) continue;
                int pMemSize = this.toInt(job.getSchedulingInfo().getShareMemorySize(), 1 * shareSize);
                long pShareSize = pMemSize / shareSize;
                if (pShareSize <= 0L) {
                    pShareSize = 1L;
                }
                IDuccProcessMap processMap = job.getProcessMap();
                for (DuccId jpid : processMap.keySet()) {
                    IDuccProcess jp = (IDuccProcess)processMap.get((Object)jpid);
                    IProcessState.ProcessState processState = jp.getProcessState();
                    switch (processState) {
                        case Starting: 
                        case Initializing: 
                        case Running: {
                            NodeIdentity nodeIdentity = jp.getNodeIdentity();
                            String key = nodeIdentity.getIp().trim();
                            Integer value = new Integer(0);
                            if (!properties.containsKey(key)) {
                                properties.put(key, value);
                            }
                            value = (Integer)properties.get(key) + (int)pShareSize;
                            properties.put(key, value);
                            break;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMapServices(Properties properties, int shareSize) {
        String location = "getShareMapServices";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId jobid : duccWorkMap.getServiceKeySet()) {
                IDuccWorkJob service = (IDuccWorkJob)duccWorkMap.findDuccWork(jobid);
                if (!service.isOperational()) continue;
                int pMemSize = this.toInt(service.getSchedulingInfo().getShareMemorySize(), 1 * shareSize);
                long pShareSize = pMemSize / shareSize;
                if (pShareSize <= 0L) {
                    pShareSize = 1L;
                }
                IDuccProcessMap processMap = service.getProcessMap();
                for (DuccId jpid : processMap.keySet()) {
                    IDuccProcess jp = (IDuccProcess)processMap.get((Object)jpid);
                    IProcessState.ProcessState processState = jp.getProcessState();
                    switch (processState) {
                        case Starting: 
                        case Initializing: 
                        case Running: {
                            NodeIdentity nodeIdentity = jp.getNodeIdentity();
                            String key = nodeIdentity.getIp().trim();
                            Integer value = new Integer(0);
                            if (!properties.containsKey(key)) {
                                properties.put(key, value);
                            }
                            value = (Integer)properties.get(key) + (int)pShareSize;
                            properties.put(key, value);
                            break;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMapReservations(Properties properties, int shareSize) {
        String location = "getShareMapReservations";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId reservationId : duccWorkMap.getReservationKeySet()) {
                IDuccWorkReservation reservation = (IDuccWorkReservation)duccWorkMap.findDuccWork(reservationId);
                if (!reservation.isOperational()) continue;
                IDuccReservationMap reservationMap = reservation.getReservationMap();
                for (DuccId spid : reservationMap.keySet()) {
                    IDuccReservation rs = (IDuccReservation)reservationMap.get((Object)spid);
                    NodeIdentity nodeIdentity = rs.getNodeIdentity();
                    String key = nodeIdentity.getIp().trim();
                    Integer value = new Integer(0);
                    if (!properties.containsKey(key)) {
                        properties.put(key, value);
                    }
                    int shares = rs.getShares();
                    value = (Integer)properties.get(key) + shares;
                    properties.put(key, value);
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMap(int shareSize) {
        Properties properties = new Properties();
        properties = this.getShareMapJobs(properties, shareSize);
        properties = this.getShareMapServices(properties, shareSize);
        properties = this.getShareMapReservations(properties, shareSize);
        return properties;
    }

    private String getReserveSize(MachineInfo machineInfo) {
        long size = 0L;
        String reserveSize = "-";
        try {
            long sharesTotal = Long.parseLong(machineInfo.getSharesTotal());
            String ducc_rm_share_quantum = DuccPropertiesResolver.getInstance().getFileProperty("ducc.rm.share.quantum");
            if (ducc_rm_share_quantum != null && (ducc_rm_share_quantum = ducc_rm_share_quantum.trim()).length() > 0) {
                size = Long.parseLong(ducc_rm_share_quantum) * sharesTotal;
                reserveSize = "" + size;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return reserveSize;
    }

    public MachineFactsList getMachineFactsList() {
        MachineFactsList factsList = new MachineFactsList();
        ConcurrentSkipListMap<MachineInfo, String> sortedMachines = this.getSortedMachines();
        for (MachineInfo machineInfo : sortedMachines.keySet()) {
            String status = machineInfo.getStatus();
            String ip = machineInfo.getIp();
            String name = machineInfo.getName();
            String reserve = this.getReserveSize(machineInfo);
            String memory = machineInfo.getMemTotal();
            String swapInuse = machineInfo.getSwapInuse();
            String swapDelta = "" + machineInfo.getSwapDelta();
            String swapFree = machineInfo.getSwapFree();
            List<String> aliens = machineInfo.getAliens();
            String sharesTotal = machineInfo.getSharesTotal();
            String sharesInuse = machineInfo.getSharesInuse();
            String heartbeat = "" + machineInfo.getElapsed();
            MachineFacts facts = new MachineFacts(status, ip, name, reserve, memory, swapInuse, swapDelta, swapFree, aliens, sharesTotal, sharesInuse, heartbeat);
            factsList.add((Object)facts);
        }
        return factsList;
    }
}

