/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.ComponentHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccDataHelper;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMap;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccHandlerUtils;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.eclipse.jetty.server.Request;

public class DuccHandlerClassic
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerClassic.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    public final String classicJobs = "/ducc-servlet/classic-jobs-data";
    public final String classicReservations = "/ducc-servlet/classic-reservations-data";
    public final String classicServices = "/ducc-servlet/classic-services-data";
    public final String classicSystemClasses = "/ducc-servlet/classic-system-classes-data";
    public final String classicSystemDaemons = "/ducc-servlet/classic-system-daemons-data";
    public final String classicSystemMachines = "/ducc-servlet/classic-system-machines-data";

    public DuccHandlerClassic(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    public String getFileName() {
        return this.dir_home + File.separator + this.dir_resources + File.separator + this.getDuccWebServer().getClassDefinitionFile();
    }

    private void buildJobsListEntry(HttpServletRequest request, StringBuffer sb, DuccId duccId, IDuccWorkJob job, DuccData duccData, long now, ServicesRegistry servicesRegistry) {
        String decoratedDuration;
        String duration;
        String type = "Job";
        String id = this.normalize(duccId);
        sb.append("<td valign=\"bottom\" class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !job.isFinished()) {
            sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_job(" + id + ")\" value=\"Terminate\" " + this.getDisabledWithHover(request, (IDuccWork)job) + "/>");
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        sb.append("<a href=\"job.details.html?id=" + id + "\">" + id + "</a>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, job.getDuccId(), job.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        if (job.isCompleted()) {
            duration = this.getDuration(request, (IDuccWork)job);
            decoratedDuration = this.decorateDuration(request, job, duration);
            sb.append("<span>");
            sb.append(decoratedDuration);
            sb.append("</span>");
        } else {
            duration = this.getDuration(request, (IDuccWork)job, now);
            decoratedDuration = this.decorateDuration(request, job, duration);
            sb.append("<span class=\"health_green\">");
            sb.append(decoratedDuration);
            sb.append("</span>");
            String projection = this.getProjection(request, job);
            sb.append(projection);
        }
        sb.append("</td>");
        String title = "";
        String submitter = job.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\" ";
        }
        sb.append("<td " + title + "valign=\"bottom\">");
        sb.append(job.getStandardInfo().getUser());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        String schedulingClass = this.stringNormalize(job.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"));
        long debugPortDriver = job.getDebugPortDriver();
        long debugPortProcess = job.getDebugPortProcess();
        title = "debug ports:";
        if (debugPortDriver >= 0L) {
            title = title + " driver=" + debugPortDriver;
        }
        if (debugPortProcess >= 0L) {
            title = title + " process=" + debugPortProcess;
        }
        switch (DuccCookies.getDisplayStyle(request)) {
            default: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\">DEBUG</div>");
                sb.append("</span>");
                break;
            }
            case Visual: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\"><img src=\"./opensources/images/Delena-cancerides-huntsman-spider.jpg\"></div>");
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        if (duccData.isLive(duccId)) {
            if (job.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
        } else {
            sb.append("<span class=\"historic_state\">");
        }
        sb.append(job.getStateObject().toString());
        if (duccData.isLive(duccId)) {
            sb.append("</span>");
        }
        sb.append("</td>");
        String reason = this.getReason(job, IDuccTypes.DuccType.Job).toString();
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(reason);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.evaluateServices(job, servicesRegistry));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        if (duccData.isLive(duccId)) {
            sb.append(job.getProcessMap().getAliveProcessCount());
        } else {
            sb.append("0");
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        long initFails = job.getProcessInitFailureCount();
        if (initFails > 0L) {
            if (job.getSchedulingInfo().getLongSharesMax() < 0L) {
                switch (DuccCookies.getDisplayStyle(request)) {
                    default: {
                        sb.append(this.buildInitializeFailuresLink(job));
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<sup>");
                        sb.append("<small>");
                        sb.append("capped");
                        sb.append("</small>");
                        sb.append("<sup>");
                        sb.append("</span>");
                        sb.append("<br>");
                        break;
                    }
                    case Visual: {
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<img src=\"./opensources/images/propeller_hat_small.svg.png\">");
                        sb.append("</span>");
                        sb.append("<br>");
                        sb.append(this.buildInitializeFailuresLink(job));
                        break;
                    }
                }
            } else {
                sb.append(this.buildInitializeFailuresLink(job));
            }
        } else {
            sb.append("" + initFails);
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.buildRuntimeFailuresLink(job));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        long pgin = job.getPgInCount();
        sb.append("" + pgin);
        sb.append("</td>");
        DecimalFormat formatter = new DecimalFormat("###0.0");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        double swap = job.getSwapUsageGb();
        if (job.isCompleted()) {
            swap = job.getSwapUsageGbMax();
        }
        String displaySwapMax = formatter.format(swap);
        sb.append(displaySwapMax);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        String size = job.getSchedulingInfo().getShareMemorySize();
        IDuccUnits.MemoryUnits units = job.getSchedulingInfo().getShareMemoryUnits();
        sb.append(this.getProcessMemorySize(duccId, type, size, units));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsTotal());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        IDuccPerWorkItemStatistics perWorkItemStatistics = job.getSchedulingInfo().getPerWorkItemStatistics();
        String done = job.getSchedulingInfo().getWorkItemsCompleted();
        if (perWorkItemStatistics != null) {
            double max = (double)Math.round(perWorkItemStatistics.getMax() / 100.0) / 10.0;
            double min = (double)Math.round(perWorkItemStatistics.getMin() / 100.0) / 10.0;
            double avg = (double)Math.round(perWorkItemStatistics.getMean() / 100.0) / 10.0;
            double dev = (double)Math.round(perWorkItemStatistics.getStandardDeviation() / 100.0) / 10.0;
            done = "<span title=\"seconds-per-work-item Max:" + max + " " + "Min:" + min + " " + "Avg:" + avg + " " + "Dev:" + dev + "\"" + ">" + done + "</span>";
        }
        sb.append(done);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.buildErrorLink(job));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        if (duccData.isLive(duccId)) {
            int dispatch = 0;
            int unassigned = job.getSchedulingInfo().getCasQueuedMap().size();
            try {
                dispatch = Integer.parseInt(job.getSchedulingInfo().getWorkItemsDispatched()) - unassigned;
            }
            catch (Exception e) {
                // empty catch block
            }
            sb.append(dispatch);
        } else {
            sb.append("0");
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsRetry());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsPreempt());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        String description = this.stringNormalize(job.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void handleServletClassicJobs(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicJobs";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        long now = System.currentTimeMillis();
        int maxRecords = this.getJobsMax(request);
        ArrayList<String> users = this.getJobsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = duccData.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, (IDuccWork)job);
                if (!list) continue;
                sb.append(this.trGet(++counter));
                this.buildJobsListEntry(request, sb, job.getDuccId(), (IDuccWorkJob)job, duccData, now, servicesRegistry);
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no jobs"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void buildReservationsListEntry(HttpServletRequest request, StringBuffer sb, DuccId duccId, IDuccWork duccwork, DuccData duccData, long now) {
        String node;
        Integer count;
        String decoratedDuration;
        String duration;
        String type = "Reservation";
        String id = this.normalize(duccId);
        String reservationType = "Unmanaged";
        if (duccwork instanceof DuccWorkJob) {
            reservationType = "Managed";
        }
        sb.append("<td class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !duccwork.isCompleted()) {
            DuccPropertiesResolver dpr;
            String jdHostUser;
            String disabled = this.getDisabledWithHover(request, duccwork);
            String user = duccwork.getStandardInfo().getUser();
            if (user != null && user.equals(jdHostUser = (dpr = DuccPropertiesResolver.getInstance()).getCachedProperty("ducc.jd.host.user"))) {
                disabled = "disabled=\"disabled\"";
            }
            if (duccwork instanceof DuccWorkReservation) {
                sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_reservation(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
            } else if (duccwork instanceof DuccWorkJob) {
                sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_service(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
            }
        }
        sb.append("</td>");
        if (reservationType.equals("Managed")) {
            sb.append("<td valign=\"bottom\">");
            sb.append("<a href=\"reservation.details.html?id=" + id + "\">" + id + "</a>");
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append(id);
            sb.append("</td>");
        }
        sb.append("<td>");
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, duccwork.getDuccId(), duccwork.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            switch (reservation.getReservationState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)reservation);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)reservation, now);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
            }
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            switch (job.getJobState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)job);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)job, now);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                }
            }
        }
        sb.append("</td>");
        String title = "";
        String submitter = duccwork.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\"";
        }
        sb.append("<td " + title + ">");
        UserId userId = new UserId(duccwork.getStandardInfo().getUser());
        sb.append(userId.toString());
        sb.append("</td>");
        sb.append("<td>");
        sb.append(this.stringNormalize(duccwork.getSchedulingInfo().getSchedulingClass(), messages.fetch("default")));
        sb.append("</td>");
        sb.append("<td>");
        sb.append(reservationType);
        sb.append("</td>");
        sb.append("<td>");
        if (duccData.isLive(duccId)) {
            if (duccwork.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
        } else {
            sb.append("<span class=\"historic_state\">");
        }
        sb.append(duccwork.getStateObject().toString());
        if (duccData.isLive(duccId)) {
            sb.append("</span>");
        }
        sb.append("</td>");
        if (duccwork instanceof DuccWorkReservation) {
            sb.append("<td>");
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            switch (reservation.getCompletionType()) {
                case Undefined: {
                    break;
                }
                case CanceledByUser: 
                case CanceledByAdmin: {
                    IRationale rationale;
                    try {
                        String cancelUser = duccwork.getStandardInfo().getCancelUser();
                        if (cancelUser != null) {
                            sb.append("<span title=\"canceled by " + cancelUser + "\">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        rationale = reservation.getCompletionRationale();
                        if (rationale != null) {
                            sb.append("<span title=\"" + rationale + "\">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        sb.append(duccwork.getCompletionTypeObject().toString());
                    }
                    catch (Exception e) {
                        rationale = reservation.getCompletionRationale();
                        if (rationale != null) {
                            sb.append("<span title=\"" + rationale + "\">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        sb.append(duccwork.getCompletionTypeObject().toString());
                    }
                    break;
                }
                default: {
                    IRationale rationale = reservation.getCompletionRationale();
                    if (rationale != null) {
                        sb.append("<span title=\"" + rationale + "\">");
                        sb.append(duccwork.getCompletionTypeObject().toString());
                        sb.append("</span>");
                        break;
                    }
                    sb.append(duccwork.getCompletionTypeObject().toString());
                }
            }
            sb.append("</td>");
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            String reason = this.getReason((IDuccWorkJob)job, IDuccTypes.DuccType.Reservation).toString();
            sb.append("<td>");
            sb.append(reason);
            sb.append("</td>");
        }
        sb.append("<td align=\"right\">");
        sb.append(duccwork.getSchedulingInfo().getInstancesCount());
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        TreeMap<String, Integer> nodeMap = new TreeMap<String, Integer>();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            if (!reservation.getReservationMap().isEmpty()) {
                IDuccReservationMap map = reservation.getReservationMap();
                for (DuccId key : map.keySet()) {
                    IDuccReservation value = (IDuccReservation)reservation.getReservationMap().get((Object)key);
                    String node2 = value.getNodeIdentity().getName();
                    if (!nodeMap.containsKey(node2)) {
                        nodeMap.put(node2, new Integer(0));
                    }
                    Integer n = count = (Integer)nodeMap.get(node2);
                    Integer n2 = count = Integer.valueOf(count + 1);
                    nodeMap.put(node2, count);
                }
            }
            boolean qualify = false;
            if (!nodeMap.isEmpty() && nodeMap.keySet().size() > 1) {
                qualify = true;
            }
            ArrayList<String> qualifiedPids = new ArrayList<String>();
            if (duccwork.isOperational()) {
                DuccMachinesData machinesData = DuccMachinesData.getInstance();
                for (String node2 : nodeMap.keySet()) {
                    NodeId nodeId = new NodeId(node2);
                    List<String> nodePids = machinesData.getPids(nodeId, userId);
                    for (String pid : nodePids) {
                        if (qualify) {
                            qualifiedPids.add(node2 + ":" + pid);
                            continue;
                        }
                        qualifiedPids.add(pid);
                    }
                }
            }
            if (qualifiedPids.size() > 0) {
                String list = "";
                for (String entry : qualifiedPids) {
                    list = list + entry + " ";
                }
                sb.append("<span title=\"" + list.trim() + "\">");
                sb.append("" + qualifiedPids.size());
                sb.append("</span>");
            } else {
                sb.append("" + qualifiedPids.size());
            }
        } else {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            if (job.isOperational()) {
                sb.append(duccwork.getSchedulingInfo().getInstancesCount());
            } else {
                sb.append("0");
            }
            for (DuccId processId : job.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)job.getProcessMap().get((Object)processId);
                node = process.getNodeIdentity().getName();
                nodeMap.put(node, 1);
            }
        }
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        String size = duccwork.getSchedulingInfo().getShareMemorySize();
        IDuccUnits.MemoryUnits units = duccwork.getSchedulingInfo().getShareMemoryUnits();
        sb.append(this.getProcessMemorySize(duccId, type, size, units));
        sb.append("</td>");
        sb.append("<td>");
        if (!nodeMap.isEmpty()) {
            boolean useList = false;
            if (nodeMap.size() > 1) {
                useList = true;
            }
            if (useList) {
                sb.append("<select>");
            }
            Iterator i$ = nodeMap.keySet().iterator();
            while (i$.hasNext()) {
                String option = node = (String)i$.next();
                count = (Integer)nodeMap.get(node);
                if (count > 1) {
                    option = option + " [" + count + "]";
                }
                if (useList) {
                    sb.append("<option>");
                }
                sb.append(option);
                if (!useList) continue;
                sb.append("</option>");
            }
            if (useList) {
                sb.append("</select>");
            }
        }
        sb.append("</td>");
        sb.append("<td>");
        String description = this.stringNormalize(duccwork.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void handleServletClassicReservations(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicReservations";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        int maxRecords = this.getReservationsMax(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = duccData.getSortedCombinedReservations();
        ArrayList<String> users = this.getReservationsUsers(request);
        long now = System.currentTimeMillis();
        if (sortedCombinedReservations.size() > 0) {
            int counter = 0;
            Iterator<Map.Entry<Info, Info>> iR = sortedCombinedReservations.entrySet().iterator();
            while (iR.hasNext()) {
                Info info = iR.next().getValue();
                IDuccWork dw = info.getDuccWork();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, dw);
                if (!list) continue;
                ++counter;
                if (dw instanceof DuccWorkReservation) {
                    DuccWorkReservation reservation = (DuccWorkReservation)dw;
                    sb.append(this.trGet(counter));
                    this.buildReservationsListEntry(request, sb, reservation.getDuccId(), (IDuccWork)reservation, duccData, now);
                    continue;
                }
                if (!(dw instanceof DuccWorkJob)) continue;
                DuccWorkJob job = (DuccWorkJob)dw;
                sb.append(this.trGet(counter));
                this.buildReservationsListEntry(request, sb, job.getDuccId(), (IDuccWork)job, duccData, now);
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no reservations"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicServices(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicServices";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DuccDataHelper duccDataHelper = DuccDataHelper.getInstance();
        TreeMap<String, ArrayList<DuccId>> serviceToJobsMap = duccDataHelper.getServiceToJobsUsageMap();
        TreeMap<String, ArrayList<String>> serviceToServicesMap = duccDataHelper.getServiceToServicesUsageMap();
        TreeMap<String, ArrayList<DuccId>> serviceToReservationsMap = duccDataHelper.getServiceToReservationsUsageMap();
        int maxRecords = this.getServicesMax(request);
        ArrayList<String> users = this.getServicesUsers(request);
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        ServicesRegistryMap map = servicesRegistry.getMap();
        if (!map.isEmpty()) {
            int counter = 0;
            int nac = 0;
            for (Integer key : map.getDescendingKeySet()) {
                ArrayList<DuccId> duccIds;
                int size;
                ArrayList<String> duccIds2;
                int size2;
                ArrayList<DuccId> duccIds3;
                int size3;
                ServicesRegistryMapPayload entry = (ServicesRegistryMapPayload)map.get(key);
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, nac, entry);
                if (!list) continue;
                ++nac;
                Properties propertiesSvc = entry.get("svc");
                Properties propertiesMeta = entry.get("meta");
                String name = this.getValue(propertiesMeta, "endpoint", "");
                String user = this.getValue(propertiesMeta, "user", "");
                String sid = this.getValue(propertiesMeta, "numeric_id", "");
                String instances = this.getValue(propertiesMeta, "instances", "");
                String deployments = this.getDeployments(servicesRegistry, propertiesMeta);
                sb.append(this.trGet(++counter));
                boolean ping_only = false;
                boolean ping_active = false;
                String typeRegistered = "Registered";
                String type = "";
                if (propertiesMeta != null) {
                    String value;
                    if (propertiesMeta.containsKey("service-class") && (value = propertiesMeta.getProperty("service-class")) != null) {
                        type = value.trim();
                    }
                    if (propertiesMeta.containsKey("ping-only") && (value = propertiesMeta.getProperty("ping-only")) != null) {
                        ping_only = Boolean.valueOf(value.trim());
                    }
                    if (propertiesMeta.containsKey("ping-active") && (value = propertiesMeta.getProperty("ping-active")) != null) {
                        ping_active = Boolean.valueOf(value.trim());
                    }
                }
                sb.append("<td valign=\"bottom\" class=\"ducc-col-start\">");
                if (type.equals(typeRegistered) && this.buttonsEnabled) {
                    if (ping_only) {
                        if (!ping_active) {
                            sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_start(" + sid + ")\" value=\"Start\" " + this.getDisabledWithHover(request, user) + "/>");
                        }
                    } else {
                        try {
                            if (Long.parseLong(deployments) < Long.parseLong(instances)) {
                                sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_start(" + sid + ")\" value=\"Start\" " + this.getDisabledWithHover(request, user) + "/>");
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                sb.append("</td>");
                sb.append("<td valign=\"bottom\" class=\"ducc-col-stop\">");
                if (type.equals(typeRegistered) && this.buttonsEnabled) {
                    if (ping_only) {
                        if (ping_active) {
                            sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                        }
                    } else if (!deployments.equals("0")) {
                        sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                    }
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                String id = "<a href=\"service.details.html?name=" + name + "\">" + key + "</a>";
                sb.append(id);
                sb.append("</td>");
                sb.append("<td>");
                sb.append(name);
                sb.append("</td>");
                sb.append("<td>");
                sb.append(type);
                sb.append("</td>");
                sb.append("<td>");
                String state = DuccHandlerUtils.getUninterpreted(propertiesMeta, "service-state");
                sb.append(state);
                sb.append("</td>");
                sb.append("<td>");
                String pinging = DuccHandlerUtils.getInterpretedUpDown(state, propertiesMeta, "ping-active");
                String decoratedPinging = DuccHandlerUtils.getDecorated(pinging, null);
                sb.append(decoratedPinging);
                sb.append("</td>");
                sb.append("<td>");
                if (propertiesMeta.containsKey("submit_error")) {
                    String decoratedHealth = DuccHandlerUtils.getDecorated("Error", propertiesMeta.getProperty("submit_error"));
                    sb.append(decoratedHealth);
                } else {
                    String health = DuccHandlerUtils.getInterpretedGoodPoor(state, propertiesMeta, "service-healthy");
                    String statistics = null;
                    if (state.equalsIgnoreCase("Available") && (statistics = propertiesMeta.getProperty("service-statistics")) != null) {
                        statistics = statistics.trim();
                    }
                    String decoratedHealth = DuccHandlerUtils.getDecorated(health, statistics);
                    sb.append(decoratedHealth);
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                if (!ping_only) {
                    sb.append(instances);
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                if (!ping_only) {
                    sb.append(deployments);
                }
                sb.append("</td>");
                sb.append("<td>");
                sb.append(this.getValue(propertiesMeta, "user", ""));
                sb.append("</td>");
                sb.append("<td>");
                if (ping_only) {
                    sb.append("[ping-only]");
                } else {
                    sb.append(this.getValue(propertiesSvc, "scheduling_class", ""));
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                if (!ping_only) {
                    sb.append(this.getValue(propertiesSvc, "process_memory_size", ""));
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                String jobs = "0";
                if (serviceToJobsMap.containsKey(name) && (size3 = (duccIds3 = serviceToJobsMap.get(name)).size()) > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (DuccId duccId : duccIds3) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    String title = "active Job Id list: " + idList;
                    jobs = "<span title=\"" + title + "\">" + size3 + "</span>";
                }
                sb.append(jobs);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                String services = "0";
                if (serviceToServicesMap.containsKey(name) && (size2 = (duccIds2 = serviceToServicesMap.get(name)).size()) > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : duccIds2) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    String title = "active Service Id list: " + idList;
                    services = "<span title=\"" + title + "\">" + size2 + "</span>";
                }
                sb.append(services);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                String reservations = "0";
                if (serviceToReservationsMap.containsKey(name) && (size = (duccIds = serviceToReservationsMap.get(name)).size()) > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (DuccId duccId : duccIds) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    String title = "active Reservation Id list: " + idList;
                    reservations = "<span title=\"" + title + "\">" + size + "</span>";
                }
                sb.append(reservations);
                sb.append("</td>");
                sb.append("<td>");
                String description = this.getValue(propertiesSvc, "description", "");
                switch (DuccCookies.getDescriptionStyle(request)) {
                    default: {
                        sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                        sb.append(description);
                        sb.append("</span>");
                        break;
                    }
                    case Short: {
                        String shortDescription = this.getShortDescription(description);
                        if (shortDescription == null) {
                            sb.append("<span>");
                            sb.append(description);
                            sb.append("</span>");
                            break;
                        }
                        sb.append("<span title=\"" + description + "\">");
                        sb.append(shortDescription);
                        sb.append("</span>");
                    }
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no services"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemClasses(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletClassicSystemClasses";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DuccSchedulerClasses schedulerClasses = new DuccSchedulerClasses();
        Map clmap = schedulerClasses.getClasses();
        if (clmap != null) {
            DuccProperties[] class_set = clmap.values().toArray(new DuccProperties[clmap.size()]);
            Arrays.sort(class_set, new NodeConfiguration.ClassSorter());
            int i = 0;
            for (DuccProperties cl : class_set) {
                String v1;
                String class_name = cl.getProperty("name");
                sb.append(this.trGet(i + 1));
                sb.append("<td>");
                sb.append(class_name);
                sb.append("</td>");
                sb.append("<td>");
                String policy = cl.getProperty("policy");
                sb.append(policy);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(cl.getStringProperty("weight", "-"));
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(cl.getProperty("priority"));
                sb.append("</td>");
                String val = cl.getProperty("cap");
                if (val == null || val.equals("0") || Integer.parseInt(val) == Integer.MAX_VALUE) {
                    sb.append("<td align=\"right\">");
                    sb.append("-");
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append("-");
                    sb.append("</td>");
                } else if (val.endsWith("%")) {
                    sb.append("<td align=\"right\">");
                    sb.append(val);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append("-");
                    sb.append("</td>");
                } else {
                    sb.append("<td align=\"right\">");
                    sb.append("-");
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append(val);
                    sb.append("</td>");
                }
                if (policy.equals("FAIR_SHARE")) {
                    sb.append("<td align=\"right\">");
                    val = cl.getStringProperty("initialization-cap", System.getProperty("ducc.rm.initialization.cap"));
                    if (val == null) {
                        val = "2";
                    }
                    sb.append(val);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    String bval = cl.getStringProperty("expand-by-doubling", "-");
                    sb.append(bval);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    val = cl.getStringProperty("use-prediction", System.getProperty("ducc.rm.prediction"));
                    if (val == null) {
                        val = "-";
                    }
                    sb.append(val);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    val = cl.getStringProperty("prediction-fudge", System.getProperty("ducc.rm.prediction.fudge"));
                    if (val == null) {
                        val = "-";
                    }
                    sb.append(val);
                    sb.append("</td>");
                } else {
                    sb.append("<td align=\"right\">-</td>");
                    sb.append("<td align=\"right\">-</td>");
                    sb.append("<td align=\"right\">-</td>");
                    sb.append("<td align=\"right\">-</td>");
                }
                sb.append("<td align=\"right\">");
                if (policy.equals("RESERVE")) {
                    val = cl.getProperty("max-machines");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else if (policy.equals("FIXED_SHARE")) {
                    val = cl.getProperty("max-processes");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else {
                    val = "-";
                }
                if ((val = cl.getProperty("max-shares")) == null || val.equals("0")) {
                    val = "-";
                }
                sb.append(val);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                val = cl.getProperty("nodepool");
                sb.append(val);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                val = "-";
                if (schedulerClasses.isPreemptable(class_name) && !(v1 = cl.getStringProperty("debug", "")).equals("")) {
                    val = v1;
                }
                sb.append(val);
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemDaemons(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicSystemDaemons";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DuccDaemonsData duccDaemonsData = DuccDaemonsData.getInstance();
        int counter = 0;
        for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            String status = "";
            String heartbeat = "*";
            String heartmax = "*";
            Properties properties = DuccDaemonRuntimeProperties.getInstance().get(daemonName);
            switch (daemonName) {
                case Webserver: {
                    status = DuccHandlerUtils.up();
                    break;
                }
                default: {
                    status = DuccHandlerUtils.unknown();
                    if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                        String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                        String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                        String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                        status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                    }
                    heartbeat = DuccDaemonsData.getInstance().getHeartbeat(daemonName);
                    long timeout = this.getMillisMIA(daemonName) / 1000L;
                    if (timeout > 0L) {
                        try {
                            long overtime = timeout - Long.parseLong(heartbeat);
                            if (overtime < 0L) {
                                status = DuccHandlerUtils.down();
                                if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                    String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                    String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                    String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                    status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                                }
                            } else {
                                int jdCount;
                                status = DuccHandlerUtils.up();
                                if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && (jdCount = DuccData.getInstance().getLive().getJobDriverNodeCount()) == 0) {
                                    status = DuccHandlerUtils.up_provisional(", pending JD allocation");
                                }
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    heartmax = DuccDaemonsData.getInstance().getMaxHeartbeat(daemonName);
                }
            }
            sb.append(this.trGet(counter));
            sb.append("<td>");
            sb.append(status);
            sb.append("</td>");
            sb.append("<td>");
            sb.append(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyDaemonName, daemonName.toString()));
            sb.append("</td>");
            sb.append("<td>");
            sb.append(this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, "")));
            sb.append("</td>");
            sb.append("<td>");
            sb.append(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, ""));
            sb.append("</td>");
            sb.append("<td>");
            sb.append(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, ""));
            sb.append("</td>");
            sb.append("<td>");
            sb.append(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, ""));
            sb.append("</td>");
            sb.append("<td align=\"right\">");
            Long pubSize = duccDaemonsData.getEventSize(daemonName);
            sb.append("" + pubSize);
            sb.append("</td>");
            sb.append("<td align=\"right\">");
            Long pubSizeMax = duccDaemonsData.getEventSizeMax(daemonName);
            sb.append("" + pubSizeMax);
            sb.append("</td>");
            sb.append("<td align=\"right\">");
            sb.append(heartbeat);
            sb.append("</td>");
            sb.append("<td align=\"right\">");
            sb.append(heartmax);
            sb.append("</td>");
            sb.append("<td>");
            String heartmaxTOD = TimeStamp.simpleFormat((String)DuccDaemonsData.getInstance().getMaxHeartbeatTOD(daemonName));
            try {
                heartmaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), heartmaxTOD);
            }
            catch (Exception e) {
                // empty catch block
            }
            sb.append(heartmaxTOD);
            sb.append("</td>");
            sb.append("<td>");
            String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
            if (jmxUrl != null) {
                sb.append(this.buildjConsoleLink(jmxUrl));
            }
            sb.append("</td>");
            sb.append("</tr>");
            ++counter;
        }
        String cookie = DuccCookies.getCookie(request, "ducc:agents");
        if (cookie.equals("show")) {
            duccLogger.trace(methodName, jobid, new Object[]{"== show: " + cookie});
            ConcurrentSkipListMap<String, MachineInfo> machines = DuccMachinesData.getInstance().getMachines();
            for (String key : machines.keySet()) {
                MachineInfo machineInfo = machines.get(key);
                Properties properties = DuccDaemonRuntimeProperties.getInstance().getAgent(machineInfo.getName());
                sb.append(this.trGet(counter));
                StringBuffer status = new StringBuffer();
                String machineStatus = machineInfo.getStatus();
                if (machineStatus.equals("down")) {
                    status.append(DuccHandlerUtils.down());
                } else if (machineStatus.equals("up")) {
                    status.append(DuccHandlerUtils.up());
                } else {
                    status.append(DuccHandlerUtils.unknown());
                }
                sb.append("<td>");
                sb.append(status);
                sb.append("</td>");
                sb.append("</td>");
                String daemonName = "Agent";
                sb.append("<td>");
                sb.append(daemonName);
                sb.append("</td>");
                String bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                sb.append("<td>");
                sb.append(bootTime);
                sb.append("</td>");
                String hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                sb.append("<td>");
                sb.append(hostIP);
                sb.append("</td>");
                String hostName = machineInfo.getName();
                sb.append("<td>");
                sb.append(hostName);
                sb.append("</td>");
                String pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                sb.append("<td>");
                sb.append(pid);
                sb.append("</td>");
                String publicationSizeLast = machineInfo.getPublicationSizeLast();
                sb.append("<td align=\"right\">");
                sb.append(publicationSizeLast);
                sb.append("</td>");
                String publicationSizeMax = machineInfo.getPublicationSizeMax();
                sb.append("<td align=\"right\">");
                sb.append(publicationSizeMax);
                sb.append("</td>");
                String heartbeatLast = machineInfo.getHeartbeatLast();
                sb.append("<td align=\"right\">");
                sb.append(heartbeatLast);
                sb.append("</td>");
                long heartbeatMax = machineInfo.getHeartbeatMax();
                sb.append("<td align=\"right\">");
                if (heartbeatMax > 0L) {
                    sb.append(heartbeatMax);
                }
                sb.append("</td>");
                String fmtHeartbeatMaxTOD = "";
                long heartbeatMaxTOD = machineInfo.getHeartbeatMaxTOD();
                if (heartbeatMaxTOD > 0L) {
                    fmtHeartbeatMaxTOD = TimeStamp.simpleFormat((String)("" + heartbeatMaxTOD));
                    try {
                        fmtHeartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), fmtHeartbeatMaxTOD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                sb.append("<td>");
                sb.append(fmtHeartbeatMaxTOD);
                sb.append("</td>");
                sb.append("<td>");
                String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                if (jmxUrl != null) {
                    sb.append(this.buildjConsoleLink(jmxUrl));
                }
                sb.append("</td>");
                sb.append("</tr>");
                ++counter;
            }
        } else {
            duccLogger.trace(methodName, jobid, new Object[]{"!= show: " + cookie});
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemMachines(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicSystemMachines";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        int counter = 0;
        int sumReserve = 0;
        int sumMemory = 0;
        int sumSwap = 0;
        int sumAliens = 0;
        int sumSharesTotal = 0;
        int sumSharesInuse = 0;
        StringBuffer data = new StringBuffer();
        DuccMachinesData instance = DuccMachinesData.getInstance();
        MachineFactsList factsList = instance.getMachineFactsList();
        if (factsList.size() > 0) {
            ListIterator listIterator = factsList.listIterator();
            while (listIterator.hasNext()) {
                MachineFacts facts = (MachineFacts)listIterator.next();
                try {
                    sumReserve += Integer.parseInt(facts.reserve);
                    sumMemory += Integer.parseInt(facts.memory);
                    sumSwap += Integer.parseInt(facts.swap);
                    sumAliens += facts.aliens.size();
                    sumSharesTotal += Integer.parseInt(facts.sharesTotal);
                    sumSharesInuse += Integer.parseInt(facts.sharesInuse);
                }
                catch (Exception e) {
                    duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
                }
            }
            StringBuffer row = new StringBuffer();
            row.append("<tr>");
            row.append("<td>");
            String releaseAll = this.buildReleaseAll(request, factsList);
            row.append(releaseAll);
            row.append("</td>");
            row.append("<td>");
            row.append("Total");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumReserve);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumMemory);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumSwap);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumAliens);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumSharesTotal);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumSharesInuse);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("");
            row.append("</td>");
            row.append("</tr>");
            data.append(row);
            listIterator = factsList.listIterator();
            while (listIterator.hasNext()) {
                MachineFacts facts = (MachineFacts)listIterator.next();
                row = new StringBuffer();
                row.append(this.trGet(counter));
                row.append("<td>");
                String releaseMachine = this.buildReleaseMachine(request, facts);
                row.append(releaseMachine);
                row.append("</td>");
                StringBuffer sb = new StringBuffer();
                String status = facts.status;
                if (status.equals("down")) {
                    sb.append("<span class=\"health_red\">");
                    sb.append(status);
                    sb.append("</span>");
                } else if (status.equals("up")) {
                    sb.append("<span class=\"health_green\">");
                    sb.append(status);
                    sb.append("</span>");
                } else {
                    sb.append(status);
                }
                row.append("<td>");
                row.append(sb);
                row.append("</td>");
                row.append("<td>");
                row.append(facts.ip);
                row.append("</td>");
                row.append("<td>");
                row.append(facts.name);
                row.append("</td>");
                row.append("<td align=\"right\">");
                row.append(facts.reserve);
                row.append("</td>");
                row.append("<td align=\"right\">");
                row.append(facts.memory);
                row.append("</td>");
                sb = new StringBuffer();
                String swapping = facts.swap;
                if (swapping.equals("0")) {
                    sb.append(swapping);
                } else {
                    sb.append("<span class=\"health_red\">");
                    sb.append(swapping);
                    sb.append("</span>");
                }
                row.append("<td align=\"right\">");
                row.append(sb);
                row.append("</td>");
                sb = new StringBuffer();
                long aliens = facts.aliens.size();
                if (aliens == 0L) {
                    sb.append(aliens);
                } else {
                    sb.append("<span class=\"health_red\">");
                    sb.append(aliens);
                    sb.append("</span>");
                }
                row.append("<td align=\"right\">");
                row.append(sb);
                row.append("</td>");
                row.append("<td align=\"right\">");
                row.append(facts.sharesTotal);
                row.append("</td>");
                row.append("<td align=\"right\">");
                row.append(facts.sharesInuse);
                row.append("</td>");
                row.append("<td align=\"right\">");
                row.append(facts.heartbeat);
                row.append("</td>");
                row.append("</tr>");
                data.append(row);
                ++counter;
            }
        } else {
            StringBuffer row = new StringBuffer();
            row.append(this.trGet(counter));
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("</tr>");
            data.append(row);
        }
        duccLogger.debug(methodName, jobid, new Object[]{data});
        response.getWriter().println(data);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/classic-jobs-data")) {
            this.handleServletClassicJobs(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-reservations-data")) {
            this.handleServletClassicReservations(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-services-data")) {
            this.handleServletClassicServices(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-classes-data")) {
            this.handleServletClassicSystemClasses(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-daemons-data")) {
            this.handleServletClassicSystemDaemons(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-machines-data")) {
            this.handleServletClassicSystemMachines(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/classic")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

