/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.dgen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaAggregate;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaAggregateComponent;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaReferenceByName;
import org.apache.uima.util.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeployableGenerator {
    private String userLogDir = null;
    private Document doc;
    private String registryURL;

    public DeployableGenerator(String userLogDir) {
        this.setUserLogDir(userLogDir);
    }

    private void setUserLogDir(String value) {
        this.userLogDir = value;
    }

    public String generateAe(IDuccGeneratorUimaAggregate aggregateConfiguration, String jobId, boolean createUniqueFilename) throws Exception {
        ArrayList<String> descriptorPaths = new ArrayList<String>();
        ArrayList<List<String>> overrides = new ArrayList<List<String>>();
        for (IDuccGeneratorUimaAggregateComponent component : aggregateConfiguration.getComponents()) {
            descriptorPaths.add(component.getDescriptor());
            overrides.add(component.getOverrides());
        }
        String aed = DeployableGenerator.createAED(aggregateConfiguration.getFlowController(), aggregateConfiguration.getThreadCount(), this.userLogDir, createUniqueFilename ? null : jobId + "-" + "uima-ae-descriptor" + ".xml", overrides, descriptorPaths.toArray(new String[descriptorPaths.size()]));
        return aed;
    }

    private static String createAED(String flowController, int scaleup, String directory, String fname, List<List<String>> overrides, String ... aeDescriptors) throws Exception {
        AnalysisEngineDescription aed = UimaUtils.createAggregateDescription(flowController, scaleup > 1, overrides, aeDescriptors);
        aed.getMetaData().setName("DUCC.job");
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdir();
        }
        try (FileOutputStream fos = null;){
            File file = File.createTempFile("uima-ae-", ".xml", dir);
            fos = new FileOutputStream(file);
            aed.toXML((OutputStream)fos);
            if (fname == null) {
                DeployableGenerator.deleteOnExitCheck(file);
                String string = file.getAbsolutePath();
                return string;
            }
            Path source = file.toPath();
            Path target = source.resolveSibling(fname);
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            String string = target.toString();
            return string;
        }
    }

    public String generateDd(IDuccGeneratorUimaReferenceByName configuration, String jobId, Boolean createUniqueFilename) throws Exception {
        Element element;
        String location = configuration.getReferenceByName();
        XMLInputSource xmlin = UimaUtils.getXMLInputSource(location);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = db.parse(xmlin.getInputStream());
        boolean createDescriptor = !location.endsWith(".xml");
        NodeList nodes = this.doc.getElementsByTagName("inputQueue");
        if (nodes.getLength() > 0) {
            element = (Element)nodes.item(0);
            String expected = "${ducc.queue.name}";
            if (!element.getAttribute("endpoint").equals(expected)) {
                element.setAttribute("endpoint", expected);
                createDescriptor = true;
            }
            expected = "${ducc.broker.name}";
            if (!element.getAttribute("brokerURL").equals(expected)) {
                element.setAttribute("brokerURL", expected);
                createDescriptor = true;
            }
        } else {
            throw new Exception("Invalid DD-" + configuration.getReferenceByName() + ". Missing required element <inputQueue ...");
        }
        this.registryURL = element.getAttribute("registryURL");
        element.removeAttribute("registryURL");
        return createDescriptor ? this.writeDDFile(this.xml2String(this.doc), jobId, createUniqueFilename) : location;
    }

    public int getScaleout() {
        if (this.doc == null) {
            return 1;
        }
        String soValue = "";
        NodeList nodes = this.doc.getElementsByTagName("analysisEngine");
        if (nodes.getLength() > 0) {
            Element aeElement = (Element)nodes.item(0);
            String async = aeElement.getAttribute("async");
            if (async.isEmpty() && aeElement.getElementsByTagName("delegates").getLength() == 0) {
                async = "false";
            }
            if (async.equals("false") && (nodes = aeElement.getElementsByTagName("scaleout")).getLength() > 0) {
                Element soElement = (Element)nodes.item(0);
                soValue = soElement.getAttribute("numberOfInstances");
            }
        }
        if (soValue.isEmpty() && (nodes = this.doc.getElementsByTagName("casPool")).getLength() > 0) {
            Element cpElement = (Element)nodes.item(0);
            soValue = cpElement.getAttribute("numberOfCASes");
        }
        return soValue.isEmpty() ? 1 : Integer.parseInt(soValue);
    }

    public String getRegistryUrl() {
        return this.registryURL;
    }

    private String xml2String(Document xmlDoc) throws Exception {
        StringWriter writer = null;
        DOMSource domSource = new DOMSource(xmlDoc.getDocumentElement());
        writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(domSource, streamResult);
        StringBuffer serializedDD = writer.getBuffer();
        return serializedDD.toString();
    }

    private String writeDDFile(String content, String jobId, boolean createUniqueFilename) throws Exception {
        File dir = new File(this.userLogDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        try (BufferedWriter out = null;){
            File file = File.createTempFile("uima-as-dd-", ".xml", dir);
            out = new BufferedWriter(new FileWriter(file));
            out.write(content);
            if (createUniqueFilename) {
                DeployableGenerator.deleteOnExitCheck(file);
                String string = file.getAbsolutePath();
                return string;
            }
            Path source = file.toPath();
            Path target = source.resolveSibling(jobId + "-uima-as-dd.xml");
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            String string = target.toString();
            return string;
        }
    }

    private static void deleteOnExitCheck(File f) {
        if (System.getenv("DUCC_KEEP_TEMPORARY_DESCRIPTORS") == null) {
            f.deleteOnExit();
        }
    }
}

