/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.dgen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.ducc.user.common.Utils;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaAggregate;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaAggregateComponent;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaDeployableConfiguration;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaReferenceByName;
import org.apache.uima.util.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeployableGenerator {
    private String userLogDir = null;

    public DeployableGenerator(String userLogDir) {
        this.setUserLogDir(userLogDir);
    }

    private void setUserLogDir(String value) {
        this.userLogDir = value;
    }

    public String generate(IDuccGeneratorUimaDeployableConfiguration configuration, String jobId) throws Exception {
        String retVal = null;
        if (configuration != null) {
            if (configuration instanceof IDuccGeneratorUimaReferenceByName) {
                IDuccGeneratorUimaReferenceByName referrenceByNameConfiguration = (IDuccGeneratorUimaReferenceByName)configuration;
                retVal = this.generateDd(referrenceByNameConfiguration, jobId);
            } else if (configuration instanceof IDuccGeneratorUimaAggregate) {
                IDuccGeneratorUimaAggregate aggregateConfiguration = (IDuccGeneratorUimaAggregate)configuration;
                retVal = this.generateAe(aggregateConfiguration, jobId);
            }
        }
        return retVal;
    }

    private String generateAe(IDuccGeneratorUimaAggregate aggregateConfiguration, String jobId) throws Exception {
        ArrayList<String> descriptorPaths = new ArrayList<String>();
        ArrayList<List<String>> overrides = new ArrayList<List<String>>();
        for (IDuccGeneratorUimaAggregateComponent component : aggregateConfiguration.getComponents()) {
            descriptorPaths.add(component.getDescriptor());
            overrides.add(component.getOverrides());
        }
        String aed = DeployableGenerator.createAED(aggregateConfiguration.getName(), aggregateConfiguration.getDescription(), aggregateConfiguration.getBrokerURL(), aggregateConfiguration.getEndpoint(), aggregateConfiguration.getFlowController(), aggregateConfiguration.getThreadCount(), this.userLogDir, jobId + "-uima-ae-descriptor-" + Utils.getPID() + ".xml", overrides, descriptorPaths.toArray(new String[descriptorPaths.size()]));
        return aed;
    }

    private static String createAED(String name, String description, String brokerURL, String endpoint, String flowController, int scaleup, String directory, String fname, List<List<String>> overrides, String ... aeDescriptors) throws Exception {
        AnalysisEngineDescription aed = UimaUtils.createAggregateDescription(flowController, scaleup > 1, overrides, aeDescriptors);
        aed.getMetaData().setName(name);
        File file = null;
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdir();
        }
        try (FileOutputStream fos = null;){
            file = new File(dir, fname);
            fos = new FileOutputStream(file);
            aed.toXML((OutputStream)fos);
        }
        return file.getAbsolutePath();
    }

    private String generateDd(IDuccGeneratorUimaReferenceByName configuration, String jobId) throws Exception {
        Document doc = this.parse(configuration.getReferenceByName());
        NodeList nodes = doc.getElementsByTagName("inputQueue");
        if (nodes.getLength() <= 0) {
            throw new Exception("Invalid DD-" + configuration.getReferenceByName() + ". Missing required element <inputQueue ...");
        }
        Element element = (Element)nodes.item(0);
        element.setAttribute("endpoint", configuration.getEndpoint());
        element.setAttribute("brokerURL", configuration.getBrokerURL());
        return this.writeDDFile(this.xml2String(doc), jobId);
    }

    private Document parse(String location) throws Exception {
        XMLInputSource xmlin = UimaUtils.getXMLInputSource(location);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(xmlin.getInputStream());
    }

    private String xml2String(Document xmlDoc) throws Exception {
        StringWriter writer = null;
        DOMSource domSource = new DOMSource(xmlDoc.getDocumentElement());
        writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(domSource, streamResult);
        StringBuffer serializedDD = writer.getBuffer();
        return serializedDD.toString();
    }

    private String writeDDFile(String content, String jobId) throws Exception {
        File dir = new File(this.userLogDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        try (BufferedWriter out = null;){
            File file = new File(dir, jobId + "-uima-as-dd-" + Utils.getPID() + ".xml");
            out = new BufferedWriter(new FileWriter(file));
            out.write(content);
            out.flush();
            String string = file.getAbsolutePath();
            return string;
        }
    }
}

