/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jp;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.CasHelper;
import org.apache.uima.ducc.user.common.DuccUimaSerializer;
import org.apache.uima.ducc.user.jp.iface.IProcessContainer;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public abstract class DuccAbstractProcessContainer
implements IProcessContainer {
    protected AnalysisEngineMetaData analysisEngineMetadata;
    protected Throwable lastError = null;
    protected int scaleout = 1;
    protected static Map<Long, DuccUimaSerializer> serializerMap = new HashMap<Long, DuccUimaSerializer>();
    protected final boolean debug = System.getProperty("ducc.debug") != null;

    protected abstract void doDeploy() throws Exception;

    protected abstract int doInitialize(Properties var1, String[] var2) throws Exception;

    protected abstract void doStop() throws Exception;

    protected abstract List<Properties> doProcess(Object var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKey(String xmi) throws Exception {
        if (this.analysisEngineMetadata == null) {
            return null;
        }
        Properties props = new Properties();
        props.setProperty("cas_initial_heap_size", "1000");
        TypeSystemDescription tsd = this.analysisEngineMetadata.getTypeSystem();
        TypePriorities tp = this.analysisEngineMetadata.getTypePriorities();
        FsIndexDescription[] fsid = this.analysisEngineMetadata.getFsIndexes();
        Class<CasCreationUtils> clazz = CasCreationUtils.class;
        synchronized (CasCreationUtils.class) {
            CAS cas = CasCreationUtils.createCas((TypeSystemDescription)tsd, (TypePriorities)tp, (FsIndexDescription[])fsid, (Properties)props);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.getUimaSerializer().deserializeCasFromXmi(xmi, cas);
            String key = CasHelper.getId(cas);
            cas.release();
            return key;
        }
    }

    @Override
    public int getScaleout() {
        return this.scaleout;
    }

    protected DuccUimaSerializer getUimaSerializer() {
        return serializerMap.get(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initialize(Properties p, String[] arg) throws Exception {
        System.out.println("DuccAbstractProcessContainer.initialize() >>>>>>>>> Initializing User Container");
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            int n = this.doInitialize(p, arg);
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            System.out.println("DuccAbstractProcessContainer.initialize() <<<<<<<< User Container initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy() throws Exception {
        System.out.println("DuccAbstractProcessContainer.deploy() >>>>>>>>> Deploying User Container");
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.doDeploy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            serializerMap.put(Thread.currentThread().getId(), new DuccUimaSerializer());
            System.out.println("DuccAbstractProcessContainer.deploy() <<<<<<<< User Container deployed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Properties> process(Object xmi) throws Exception {
        if (this.debug) {
            System.out.println("DuccAbstractProcessContainer.process() >>>>>>>>> Processing User Container");
        }
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            List<Properties> list = this.doProcess(xmi);
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            if (this.debug) {
                System.out.println("DuccAbstractProcessContainer.process() <<<<<<<< User Container processed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this.debug) {
            System.out.println("DuccAbstractProcessContainer.stop() >>>>>>>>> Stopping User Container");
        }
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.doStop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            if (this.debug) {
                System.out.println("DuccAbstractProcessContainer.stop() <<<<<<<< User Container stopped");
            }
        }
    }

    protected byte[] serialize(Throwable t) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(t);
        }
        catch (Exception e) {
            e.printStackTrace();
            RuntimeException re = new RuntimeException("Unable to Serialize User Exception - Please Check JP Log File For More Details");
            oos.writeObject(re);
        }
        oos.close();
        return baos.toByteArray();
    }
}

