/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.QuotedOptions;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.IServiceMeta;
import org.apache.uima.ducc.sm.Ping;
import org.apache.uima.ducc.sm.Pong;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.sm.IService;

class PingDriver
implements IServiceMeta,
SmConstants {
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    String[] jvm_args;
    String endpoint;
    String ping_class;
    String ping_arguments;
    String classpath;
    boolean ping_ok;
    int max_instances;
    int missed_pings = 0;
    int errors = 0;
    int error_threshold = 5;
    ServiceSet sset;
    boolean test_mode = false;
    Process ping_main;
    StdioListener sin_listener = null;
    StdioListener ser_listener = null;
    PingThread pinger = null;
    int meta_ping_rate;
    int meta_ping_stability;
    long meta_ping_timeout;
    Thread ping_thread;
    boolean internal_ping = true;
    int failure_max;
    int failure_window;
    long service_statistics_timestamp = -1L;
    IServiceStatistics service_statistics = null;
    String user;
    String working_directory;
    String log_directory;
    String environment;
    boolean do_log = true;
    boolean shutdown = false;
    PingStopper pingStopper = null;
    Timer timer = null;
    IService.ServiceState pingState = IService.ServiceState.Waiting;
    DuccProperties meta_props;

    PingDriver(ServiceSet sset) {
        this.sset = sset;
        DuccProperties job_props = sset.getJobProperties();
        this.meta_props = sset.getMetaProperties();
        this.ping_class = System.getProperty("ducc.sm.default.monitor.class", "org.apache.uima.ducc.cli.UimaAsPing");
        this.ping_class = job_props.getStringProperty(IUiOptions.UiOption.ServicePingClass.pname(), this.ping_class);
        DuccProperties ping_props = this.findRegisteredPinger(this.ping_class);
        if (ping_props == null) {
            throw new IllegalStateException("Cannot start pinger.");
        }
        this.internal_ping = ping_props.getBooleanProperty("internal", false);
        String real_class = ping_props.getProperty("service_ping_class");
        if (real_class != null) {
            this.ping_class = real_class;
        }
        this.logger.info("<ctr>", sset.getId(), new Object[]{"Using ping class", this.ping_class});
        this.endpoint = this.meta_props.getStringProperty("endpoint");
        this.user = this.meta_props.getStringProperty("user");
        this.max_instances = Integer.parseInt(System.getProperty("ducc.sm.max.instances", "10"));
        this.ping_arguments = this.resolveStringProperty(IUiOptions.UiOption.ServicePingArguments.pname(), ping_props, job_props, null);
        String jvm_args_str = this.resolveStringProperty(IUiOptions.UiOption.ServicePingJvmArgs.pname(), ping_props, job_props, "");
        this.meta_ping_timeout = this.resolveIntProperty(IUiOptions.UiOption.ServicePingTimeout.pname(), ping_props, job_props, ServiceManagerComponent.meta_ping_timeout);
        this.do_log = this.resolveBooleanProperty(IUiOptions.UiOption.ServicePingDoLog.pname(), ping_props, job_props, false);
        this.classpath = this.resolveStringProperty(IUiOptions.UiOption.ServicePingClasspath.pname(), ping_props, job_props, System.getProperty("java.class.path"));
        this.working_directory = this.resolveStringProperty(IUiOptions.UiOption.WorkingDirectory.pname(), ping_props, job_props, null);
        this.log_directory = this.resolveStringProperty(IUiOptions.UiOption.LogDirectory.pname(), ping_props, job_props, null);
        this.failure_window = this.resolveIntProperty(IUiOptions.UiOption.InstanceFailureWindow.pname(), ping_props, job_props, ServiceManagerComponent.failure_window);
        this.failure_max = this.resolveIntProperty(IUiOptions.UiOption.InstanceFailureLimit.pname(), ping_props, job_props, ServiceManagerComponent.failure_max);
        this.environment = this.resolveStringProperty(IUiOptions.UiOption.Environment.pname(), ping_props, job_props, null);
        jvm_args_str = jvm_args_str.trim();
        this.jvm_args = jvm_args_str.equals("") ? null : jvm_args_str.split("\\s+");
        this.meta_ping_rate = ServiceManagerComponent.meta_ping_rate;
        this.meta_ping_stability = ServiceManagerComponent.meta_ping_stability;
    }

    protected DuccProperties findRegisteredPinger(String cls) {
        String methodName = "find RegisteredPinger";
        DuccProperties answer = new DuccProperties();
        File f = new File(System.getProperty("DUCC_HOME") + "/resources/service_monitors/" + cls);
        if (f.exists()) {
            try {
                answer.load(f.getCanonicalPath());
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Loading site-registered service monitor from", cls});
            }
            catch (Exception e) {
                this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load site-registered service monitor", f.getName(), e});
                return null;
            }
        }
        return answer;
    }

    protected String resolveStringProperty(String prop, DuccProperties ping_props, DuccProperties job_props, String deflt) {
        if (this.internal_ping && !prop.equals("service_ping_arguments")) {
            return ping_props.getStringProperty(prop, deflt);
        }
        String val = job_props.getProperty(prop = prop.trim());
        if (val == null) {
            val = ping_props.getProperty(prop);
        }
        if (val == null) {
            val = deflt;
        }
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    protected int resolveIntProperty(String prop, DuccProperties ping_props, DuccProperties job_props, int deflt) {
        String val = this.resolveStringProperty(prop, ping_props, job_props, null);
        return val == null ? deflt : Integer.parseInt(val);
    }

    protected boolean resolveBooleanProperty(String prop, DuccProperties ping_props, DuccProperties job_props, boolean deflt) {
        String val = this.resolveStringProperty(prop, ping_props, job_props, Boolean.toString(deflt));
        return val.equalsIgnoreCase("True") || val.equalsIgnoreCase("true");
    }

    @Override
    public IService.ServiceState getServiceState() {
        return this.pingState;
    }

    public long getId() {
        return 0L;
    }

    public IDuccState.JobState getState() {
        String methodName = "getState";
        switch (this.pingState) {
            case Available: {
                return IDuccState.JobState.Running;
            }
            case Stopped: {
                return IDuccState.JobState.Completed;
            }
            case Waiting: {
                return IDuccState.JobState.Initializing;
            }
        }
        this.logger.error(methodName, this.sset.getId(), new Object[]{"Unexpected state in Ping driver:", this.pingState});
        return IDuccState.JobState.Completed;
    }

    public void setState(IDuccState.JobState s) {
    }

    @Override
    public long getServiceStatisticsTimestamp() {
        return this.service_statistics_timestamp;
    }

    @Override
    public IServiceStatistics getServiceStatistics() {
        return this.service_statistics;
    }

    synchronized int getMetaPingRate() {
        return this.meta_ping_rate;
    }

    @Override
    public void run() {
        String methodName = "run";
        if (this.internal_ping) {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Starting INTERNAL ping."});
            this.runAsThread();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ending INTERNAL ping."});
        } else {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Starting EXTERNAL ping."});
            this.runAsProcess();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ending EXTERNAL ping."});
        }
    }

    void handleResponse(Pong response) {
        String methodName = "handleStatistics";
        String key = "ducc.sm.meta.ping.error.injection.missing.percentage";
        String value = DuccPropertiesResolver.getInstance().getFileProperty(key);
        long missingPercentage = 0L;
        try {
            missingPercentage = Long.parseLong(value);
        }
        catch (Exception e) {
            this.logger.trace(methodName, this.sset.getId(), (Throwable)e, new Object[0]);
        }
        this.logger.trace(methodName, this.sset.getId(), new Object[]{key + "=" + missingPercentage});
        if (missingPercentage > 0L && missingPercentage < 100L) {
            Random random = new Random();
            int n = random.nextInt(100);
            if ((long)n < missingPercentage) {
                this.logger.warn(methodName, this.sset.getId(), new Object[]{"skip pinger data"});
                return;
            }
            this.logger.warn(methodName, this.sset.getId(), new Object[]{"keep pinger data"});
        }
        this.service_statistics_timestamp = response.getTimestamp();
        this.service_statistics = response.getStatistics();
        if (this.service_statistics == null) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Service statics are null!"});
            ++this.errors;
            return;
        }
        if (this.service_statistics.isAlive()) {
            this.pingState = IService.ServiceState.Available;
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ping ok: ", this.endpoint, this.service_statistics.toString()});
            this.missed_pings = 0;
        } else {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Missed_pings ", ++this.missed_pings, "endpoint", this.endpoint, this.service_statistics.toString()});
            if (this.missed_pings > this.meta_ping_stability) {
                this.pingState = IService.ServiceState.Waiting;
            }
        }
        this.sset.setAutostart(response.isAutostart());
        this.sset.setLastUse(response.getLastUse());
        int additions = response.getAdditions();
        int instances = this.sset.countImplementors();
        if (additions + instances > this.max_instances) {
            additions = Math.max(0, this.max_instances - instances);
            this.logger.warn(methodName, this.sset.getId(), new Object[]{"Maximum services instances capped by installation limit of", this.max_instances, "at", additions});
        }
        Long[] deletions = response.getDeletions();
        int ndeletions = 0;
        if (deletions != null) {
            ndeletions = deletions.length;
        }
        this.sset.signalRebalance(additions, deletions, ndeletions, response.isExcessiveFailures());
    }

    void expand_wildcards(List<URL> in, String cp_entry) throws MalformedURLException {
        int ndx = cp_entry.lastIndexOf("/");
        File dir = new File(cp_entry.substring(0, ndx));
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (!f.isFile()) continue;
            in.add(new URL("file://" + f.getPath()));
        }
    }

    AServicePing loadInternalMonitor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        String methodName = "loadInternalMonitor";
        if (this.classpath == null) {
            Class<?> cl = Class.forName(this.ping_class);
            return (AServicePing)cl.newInstance();
        }
        String[] cp_elems = this.classpath.split(":");
        ArrayList<URL> cp_urls = new ArrayList<URL>();
        for (int i = 0; i < cp_elems.length; ++i) {
            if (cp_elems[i].endsWith("*")) {
                this.expand_wildcards(cp_urls, cp_elems[i]);
                continue;
            }
            cp_urls.add(new URL("file://" + cp_elems[i]));
        }
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, this.sset.getId(), new Object[]{"Loading internally with classpath:"});
            for (URL u : cp_urls) {
                this.logger.trace(methodName, this.sset.getId(), new Object[]{"    ", u.toString()});
            }
        }
        URLClassLoader l = new URLClassLoader(cp_urls.toArray(new URL[cp_urls.size()]));
        Class<?> loaded_class = l.loadClass(this.ping_class);
        l = null;
        return (AServicePing)loaded_class.newInstance();
    }

    String setCommonInitProperties(Map<String, Object> props) {
        props.put("monitor-rate", this.meta_ping_rate);
        props.put("service-id", this.sset.getId().getFriendly());
        props.put("failure-max", this.failure_max);
        props.put("failure-window", this.failure_window);
        props.put("do-log", this.do_log);
        props.put("autostart-enabled", this.sset.isAutostart());
        props.put("last-use", this.sset.getLastUse());
        StringBuffer buf = new StringBuffer();
        buf.append("monitor-rate=");
        buf.append(Integer.toString(this.meta_ping_rate));
        buf.append(",");
        buf.append("service-id=");
        buf.append(Long.toString(this.sset.getId().getFriendly()));
        buf.append(",");
        buf.append("failure-max=");
        buf.append(Integer.toString(this.failure_max));
        buf.append(",");
        buf.append("failure-window=");
        buf.append(Integer.toString(this.failure_window));
        buf.append(",");
        buf.append("do-log=");
        buf.append(Boolean.toString(this.do_log));
        buf.append(",");
        buf.append("autostart-enabled=");
        buf.append(Boolean.toString(this.sset.isAutostart()));
        buf.append(",");
        buf.append("last-use=");
        buf.append(Long.toString(this.sset.getLastUse()));
        return buf.toString();
    }

    void setCommonProperties(Map<String, Object> props) {
        Long[] instances = this.sset.getImplementors();
        props.put("all-instances", instances);
        props.put("registered-instances", this.sset.getNInstancesRegistered());
        String[] hosts = new String[instances.length];
        Long[] shares = new Long[instances.length];
        for (int i = 0; i < instances.length; ++i) {
            hosts[i] = this.sset.getHostFor(instances[i]);
            shares[i] = this.sset.getShareFor(instances[i]);
        }
        props.put("all-hosts", hosts);
        props.put("all-shares", shares);
        props.put("active-instances", this.sset.getActiveInstances());
        props.put("autostart-enabled", this.sset.isAutostart());
        DuccId[] references = this.sset.getReferences();
        Long[] refs = new Long[references.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = references[i].getFriendly();
        }
        props.put("references", refs);
        props.put("run-failures", this.sset.getRunFailures());
    }

    void runAsThread() {
        long tid = Thread.currentThread().getId();
        String methodName = "runAsThread[" + tid + "]";
        AServicePing pinger = null;
        HashMap<String, Object> initProps = new HashMap<String, Object>();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            pinger = this.loadInternalMonitor();
        }
        catch (ClassNotFoundException e1) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load pinger: ClassNotFoundException(", this.ping_class, ")"});
            return;
        }
        catch (IllegalAccessException e1) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load pinger: IllegalAccessException(", this.ping_class, ")"});
            return;
        }
        catch (InstantiationException e1) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load pinger: InstantiationException(", this.ping_class, ")"});
            return;
        }
        catch (MalformedURLException e1) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load pinger: Cannot form URLs from classpath entries(", this.ping_class, ")"});
            return;
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot load pinger for unknown reason:", this.ping_class, t});
            return;
        }
        try {
            this.setCommonInitProperties(initProps);
            pinger.setLogger(this.logger);
            pinger.init(this.ping_arguments, this.endpoint, initProps);
            while (!this.shutdown) {
                this.setCommonProperties(props);
                pinger.setSmState(props);
                Pong pr = new Pong();
                pr.setStatistics(pinger.getStatistics());
                pr.setAdditions(pinger.getAdditions());
                pr.setDeletions(pinger.getDeletions());
                pr.setExcessiveFailures(pinger.isExcessiveFailures());
                pr.setAutostart(pinger.isAutostart());
                pr.setLastUse(pinger.getLastUse());
                this.handleResponse(pr);
                if (this.errors > this.error_threshold) {
                    pinger.stop();
                    this.logger.warn(methodName, this.sset.getId(), new Object[]{"Ping exited because of excess errors: ", this.errors});
                    break;
                }
                try {
                    Thread.sleep(this.meta_ping_rate);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable t) {
            this.logger.warn(methodName, this.sset.getId(), t, new Object[0]);
        }
        pinger = null;
        this.sset.pingExited(this.errors, this);
    }

    public void runAsProcess() {
        Map envMap;
        long tid = Thread.currentThread().getId();
        String methodName = "runAsProcess[" + tid + "]";
        String cp = this.classpath;
        String dh = System.getProperty("DUCC_HOME");
        cp = cp + ":" + dh + "/lib/uima-ducc-cli.jar";
        File libdir = new File(dh + "/lib/uima-ducc");
        String[] jars = libdir.list();
        if (jars != null) {
            for (String j : jars) {
                if (j.contains("ducc-sm")) {
                    cp = cp + ":" + dh + "/lib/uima-ducc/" + j;
                    continue;
                }
                if (!j.contains("ducc-common")) continue;
                cp = cp + ":" + dh + "/lib/uima-ducc/" + j;
            }
        }
        try {
            this.pinger = new PingThread();
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot start listen socket, pinger not started.", t});
            this.pingState = IService.ServiceState.Stopped;
            return;
        }
        int port = this.pinger.getPort();
        this.ping_thread = new Thread(this.pinger);
        this.ping_thread.setName("XTrnPingMonitor-" + this.sset.getId());
        this.ping_thread.start();
        HashMap<String, Object> initProps = new HashMap<String, Object>();
        String serprops = this.setCommonInitProperties(initProps);
        ArrayList<String> arglist = new ArrayList<String>();
        if (!this.test_mode) {
            arglist.add(System.getProperty("ducc.agent.launcher.ducc_spawn_path"));
            arglist.add("-u");
            arglist.add(this.user);
            arglist.add("-w");
            arglist.add(this.working_directory);
            if (this.do_log) {
                arglist.add("-f");
                arglist.add(this.log_directory + "/services/ping/" + this.sset.getId());
            }
            arglist.add("--");
        }
        ArrayList envVarList = QuotedOptions.tokenizeList((String)this.environment, (boolean)true);
        try {
            envMap = QuotedOptions.parseAssignments((List)envVarList, (int)1);
        }
        catch (IllegalArgumentException e) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Invalid environment:", e});
            this.pingState = IService.ServiceState.Stopped;
            return;
        }
        String javaHome = (String)envMap.get("JAVA_HOME");
        if (javaHome != null) {
            arglist.add(javaHome + "/bin/java");
        } else {
            arglist.add(System.getProperty("ducc.jvm"));
        }
        arglist.add("-DSM_MONITOR=T");
        if (this.jvm_args != null) {
            for (String s : this.jvm_args) {
                arglist.add(s);
            }
        }
        arglist.add("-cp");
        arglist.add(cp);
        arglist.add("-Dcom.sun.management.jmxremote");
        arglist.add("org.apache.uima.ducc.sm.ServicePingMain");
        arglist.add("--class");
        arglist.add(this.ping_class);
        arglist.add("--endpoint");
        arglist.add(this.endpoint);
        arglist.add("--port");
        arglist.add(Integer.toString(port));
        arglist.add("--initprops");
        arglist.add(serprops);
        if (this.ping_arguments != null) {
            arglist.add("--arguments");
            arglist.add(this.ping_arguments);
        }
        int i = 0;
        for (String s : arglist) {
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i++, "]:  ", s});
        }
        ProcessBuilder pb = new ProcessBuilder(arglist);
        InputStream stdout = null;
        InputStream stderr = null;
        try {
            Map<String, String> env = pb.environment();
            env.clear();
            env.putAll(envMap);
            this.ping_main = pb.start();
            stdout = this.ping_main.getInputStream();
            stderr = this.ping_main.getErrorStream();
            this.sin_listener = new StdioListener(1, stdout);
            this.ser_listener = new StdioListener(2, stderr);
            Thread sol = new Thread(this.sin_listener);
            Thread sel = new Thread(this.ser_listener);
            sol.start();
            sel.start();
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot establish ping process:", t});
            this.pingState = IService.ServiceState.Stopped;
            return;
        }
        while (true) {
            try {
                int rc = this.ping_main.waitFor();
                this.ping_main = null;
                if (this.pingStopper != null) {
                    this.pingStopper.cancel();
                    this.pingStopper = null;
                    this.logger.info(methodName, this.sset.getId(), new Object[]{"Pinger returned, pingStopper is canceled."});
                }
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Pinger returns rc ", rc});
                this.sset.pingExited(rc, this);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.sin_listener.stop();
        this.ser_listener.stop();
    }

    @Override
    public void stop() {
        this.shutdown = true;
        if (!this.internal_ping) {
            if (this.pinger != null) {
                this.pinger.stop();
            }
            this.pingStopper = new PingStopper();
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.schedule((TimerTask)this.pingStopper, 60000L);
        }
    }

    class StdioListener
    implements Runnable {
        InputStream in;
        String tag;
        boolean done = false;

        StdioListener(int which, InputStream in) {
            this.in = in;
            switch (which) {
                case 1: {
                    this.tag = "STDOUT: ";
                    break;
                }
                case 2: {
                    this.tag = "STDERR: ";
                }
            }
        }

        void stop() {
            this.done = true;
        }

        @Override
        public void run() {
            if (this.done) {
                return;
            }
            long tid = Thread.currentThread().getId();
            String methodName = "StdioListener.run[" + tid + "]";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String s;
                do {
                    s = br.readLine();
                    if (PingDriver.this.test_mode) {
                        System.out.println(this.tag + s);
                        continue;
                    }
                    PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{this.tag, s});
                } while (s != null);
                String msg = this.tag + "closed, listener returns";
                if (PingDriver.this.test_mode) {
                    System.out.println(msg);
                } else {
                    PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{msg});
                }
                return;
            }
            catch (IOException e) {
                if (PingDriver.this.test_mode) {
                    e.printStackTrace();
                } else {
                    PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e, new Object[0]);
                }
                return;
            }
        }
    }

    class PingThread
    implements Runnable {
        ServerSocket server = new ServerSocket(0);
        int port = this.server.getLocalPort();
        boolean done = false;

        PingThread() throws IOException {
        }

        int getPort() {
            return this.port;
        }

        synchronized void stop() {
            String methodName = "stop";
            PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{"Pinger stopping: set done = true"});
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long tid = Thread.currentThread().getId();
            String methodName = "XtrnPingThread.run[" + tid + "]";
            try {
                Socket sock = this.server.accept();
                sock.setSoTimeout(PingDriver.this.meta_ping_rate);
                OutputStream outs = sock.getOutputStream();
                InputStream in = sock.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(in);
                ObjectOutputStream oos = new ObjectOutputStream(outs);
                HashMap<String, Object> props = new HashMap<String, Object>();
                PingDriver.this.ping_ok = false;
                while (true) {
                    PingThread pingThread = this;
                    synchronized (pingThread) {
                        if (this.done) {
                            try {
                                PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: send QUIT to pinger."});
                                oos.writeObject(new Ping(true, props));
                                oos.flush();
                            }
                            catch (IOException e1) {
                                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e1, new Object[0]);
                            }
                            PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: QUIT is sent and flushed; thread exits."});
                            return;
                        }
                    }
                    try {
                        PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: ping OUT"});
                        PingDriver.this.setCommonProperties(props);
                        oos.writeObject(new Ping(false, props));
                        oos.flush();
                        oos.reset();
                    }
                    catch (IOException e1) {
                        PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e1, new Object[0]);
                        ++PingDriver.this.errors;
                        return;
                    }
                    try {
                        Pong resp = (Pong)ois.readObject();
                        PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: ping RECEIVED"});
                        PingDriver.this.handleResponse(resp);
                        PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: ping HANDLED"});
                    }
                    catch (IOException e1) {
                        PingDriver.this.logger.warn(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: Error receiving ping:", e1});
                        ++PingDriver.this.errors;
                        return;
                    }
                    try {
                        PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: SLEEPING", PingDriver.this.meta_ping_rate, "ms", PingDriver.this.sset.toString()});
                        Thread.sleep(PingDriver.this.meta_ping_rate);
                        PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: SLEEP returns", PingDriver.this.sset.toString()});
                    }
                    catch (InterruptedException e) {
                        PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), (Throwable)e, new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: Error receiving ping", e});
                ++PingDriver.this.errors;
            }
            catch (ClassNotFoundException e) {
                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), new Object[]{"ExtrnPingDriver: Input garbled:", e});
                ++PingDriver.this.errors;
            }
        }
    }

    private class PingStopper
    extends TimerTask {
        PingStopper() {
            String methodName = "PingStopper.init";
            PingDriver.this.logger.debug(methodName, PingDriver.this.sset.getId(), new Object[]{"Wait for pinger to exit:", 60000});
        }

        @Override
        public void run() {
            String methodName = "PingStopper.run";
            PingDriver.this.logger.debug(methodName, PingDriver.this.sset.getId(), new Object[]{"PingStopper kills reluctant pinger"});
            if (PingDriver.this.ping_main != null) {
                PingDriver.this.ping_main.destroy();
            }
        }
    }
}

